/*****************************************************************************
*   "Irit" - the 3d (not only polygonal) solid modeller.		     *
*									     *
* Written by:  Gershon Elber				Ver 0.2, Mar. 1990   *
******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                *
******************************************************************************
*   Module to provide the required interfact for the cagd library for the    *
* free form surfaces and curves.					     *
*****************************************************************************/

#ifndef FREEFORM_H
#define FREEFORM_H

#define MIN_FREE_FORM_RES 2

CagdRType *GetKnotVector(IPObjectStruct *KntObjList,
			 int Order,
			 int *Length,
			 char **ErrStr);
int GetDrawCtlPt(void);
int GetFourPerFlat(void);
int GetPolyApproxOptimal(void);
int GetPolyApproxUV(void);
RealType GetPolyApproxTol(void);
IPObjectStruct *GenBezierSurfaceObject(IPObjectStruct *LstObjList);
IPObjectStruct *GenBezierCurveObject(IPObjectStruct *PtObjList);
IPObjectStruct *GenBsplineSurfaceObject(RealType *UOrder,
					RealType *VOrder,
					IPObjectStruct *LstObjList,
					IPObjectStruct *KntObjList);
IPObjectStruct *GenBsplineCurveObject(RealType *ROrder,
				      IPObjectStruct *PtObjList,
				      IPObjectStruct *KntObjList);
IPObjectStruct *GenSURFPREVObject(IPObjectStruct *Cross);
IPObjectStruct *DivideSurfaceObject(IPObjectStruct *SrfObj,
				    RealType *Dir,
				    RealType *ParamVal);
IPObjectStruct *RegionFromSurfaceObject(IPObjectStruct *SrfObj,
					RealType *RDir,
					RealType *ParamVal1,
					RealType *ParamVal2);
IPObjectStruct *DivideCurveObject(IPObjectStruct *CrvObj, RealType *ParamVal);
IPObjectStruct *RegionFromCurveObject(IPObjectStruct *CrvObj,
				      RealType *ParamVal1,
				      RealType *ParamVal2);
IPObjectStruct *RefineSurfaceObject(IPObjectStruct *SrfObj,
				    RealType *Dir,
				    RealType *Replace,
				    IPObjectStruct *KnotsObj);
IPObjectStruct *RefineCurveObject(IPObjectStruct *CrvObj,
				  RealType *Replace,
				  IPObjectStruct *KnotsObj);
IPObjectStruct *EvalSurfaceObject(IPObjectStruct *SrfObj,
				  RealType *u,
				  RealType *v);
IPObjectStruct *EvalCurveObject(IPObjectStruct *CrvObj, RealType *t);
IPObjectStruct *DeriveSurfaceObject(IPObjectStruct *SrfObj, RealType *Dir);
IPObjectStruct *DeriveCurveObject(IPObjectStruct *CrvObj);
IPObjectStruct *IntegrateCurveObject(IPObjectStruct *CrvObj);
IPObjectStruct *SurfaceNormalObject(IPObjectStruct *SrfObj);
IPObjectStruct *CurveNormalObject(IPObjectStruct *CrvObj);
IPObjectStruct *NormalSurfaceObject(IPObjectStruct *SrfObj,
				    RealType *u,
				    RealType *v);
IPObjectStruct *NormalCurveObject(IPObjectStruct *CrvObj, RealType *t);
IPObjectStruct *TangentSurfaceObject(IPObjectStruct *SrfObj,
				     RealType *Dir,
				     RealType *u,
				     RealType *v);
IPObjectStruct *TangentCurveObject(IPObjectStruct *CrvObj, RealType *t);
IPObjectStruct *CurveFromSrfMesh(IPObjectStruct *SrfObj,
				 RealType *Dir,
				 RealType *Index);
IPObjectStruct *CurveFromSurface(IPObjectStruct *SrfObj,
				 RealType *Dir,
				 RealType *ParamVal);
IPObjectStruct *CurveReverse(IPObjectStruct *CrvObj);
IPObjectStruct *SurfaceReverse(IPObjectStruct *SrfObj);
void ComputeSurfacePolygons(IPObjectStruct *PObj, int Normals);
void ComputeTrimSrfPolygons(IPObjectStruct *PObj, int Normals);
void ComputeTriSrfPolygons(IPObjectStruct *PObj, int Normals);
IPObjectStruct *Geometry2Polygons(IPObjectStruct *Obj, RealType *RNormals);
IPObjectStruct *Geometry2Polylines(IPObjectStruct *Obj, RealType *Optimal);
IPObjectStruct *ExtremumControlPointVals(IPObjectStruct *Obj, CagdRType *Min);
IPObjectStruct *GenCircleCurveObject(VectorType Position, RealType *Radius);
IPObjectStruct *GenPCircleCurveObject(VectorType Position, RealType *Radius);
IPObjectStruct *GenArcCurveObject(VectorType Start,
				  VectorType Center,
				  VectorType End);
IPObjectStruct *GenRuledSrfObject(IPObjectStruct *Crv1, IPObjectStruct *Crv2);
IPObjectStruct *GenBoolSumSrfObject(IPObjectStruct *Crv1,
				    IPObjectStruct *Crv2,
				    IPObjectStruct *Crv3,
				    IPObjectStruct *Crv4);
IPObjectStruct *GenBoolOneSrfObject(IPObjectStruct *BndryCrv);
IPObjectStruct *GenSrfFromCrvsObject(IPObjectStruct *CrvList,
				     RealType *OtherOrder);
IPObjectStruct *GenSweepScaleSrfObject(IPObjectStruct *CrossSection,
				       IPObjectStruct *Axis,
				       IPObjectStruct *Scale,
				       IPObjectStruct *Frame,
				       RealType *RRefine);
IPObjectStruct *GenSweepSrfObject(IPObjectStruct *CrossSection,
				  IPObjectStruct *Axis, 
				  IPObjectStruct *Frame);
IPObjectStruct *GenOffsetObject(IPObjectStruct *Obj,
				RealType *Offset,
				RealType *Tolerance,
				RealType *BezInterp);
IPObjectStruct *GenAOffsetObject(IPObjectStruct *Obj,
				 RealType *Offset,
				 RealType *Epsilon,
				 RealType *Trim,
				 RealType *BezInterp);
IPObjectStruct *GenLeastSqrOffsetObject(IPObjectStruct *Obj,
					RealType *Offset,
					RealType *NumOfSamples,
					RealType *NumOfDOF,
					RealType *Order);
IPObjectStruct *GenMatchingOffsetObject(IPObjectStruct *Obj,
					RealType *Offset,
					RealType *Tolerance);
IPObjectStruct *MergeSrfSrf(IPObjectStruct *Srf1,
			    IPObjectStruct *Srf2,
			    RealType *Dir,
			    RealType *SameEdge);
IPObjectStruct *MergeCurvesAndCtlPoints(IPObjectStruct *PObj1,
					IPObjectStruct *PObj2);
IPObjectStruct *EditCrvControlPoint(IPObjectStruct *PObjCrv,
				    CagdCtlPtStruct *Pt,
				    RealType *Index);
IPObjectStruct *EditSrfControlPoint(IPObjectStruct *PObjSrf,
				    CagdCtlPtStruct *Pt,
				    RealType *UIndex,
				    RealType *VIndex);
IPObjectStruct *EditTVControlPoint(IPObjectStruct *PObjTV,
				   CagdCtlPtStruct *Pt,
				   RealType *UIndex,
				   RealType *VIndex,
				   RealType *WIndex);
IPObjectStruct *RaiseCurveObject(IPObjectStruct *PObjCrv, RealType *Order);
IPObjectStruct *RaiseSurfaceObject(IPObjectStruct *PObjSrf,
				   RealType *RDir,
				   RealType *RNewOrder);
IPObjectStruct *RaiseTrivarObject(IPObjectStruct *PObjTV,
				  RealType *RDir,
				  RealType *RNewOrder);
void MakeFreeFormCompatible(IPObjectStruct *PObj1, IPObjectStruct *PObj2);
IPObjectStruct *TwoCrvsMorphing(IPObjectStruct *PObjCrv1,
				IPObjectStruct *PObjCrv2,
				RealType *Method,
				RealType *Blend);
IPObjectStruct *TwoSrfsMorphing(IPObjectStruct *PObjSrf1,
				IPObjectStruct *PObjSrf2,
				RealType *Blend);
IPObjectStruct *TwoTVsMorphing(IPObjectStruct *PObjTV1,
			       IPObjectStruct *PObjTV2,
			       RealType *Blend);
IPObjectStruct *CnvrtBezierToBspline(IPObjectStruct *PObj);
IPObjectStruct *CnvrtBsplineToBezier(IPObjectStruct *PObj);
IPObjectStruct *TwoCrvsSrfsProduct(IPObjectStruct *PObj1,
				   IPObjectStruct *PObj2);
IPObjectStruct *TwoCrvsSrfsDotProduct(IPObjectStruct *PObj1,
				      IPObjectStruct *PObj2);
IPObjectStruct *TwoCrvsSrfsCrossProduct(IPObjectStruct *PObj1,
					IPObjectStruct *PObj2);
IPObjectStruct *TwoCrvsSrfsSum(IPObjectStruct *PObj1, IPObjectStruct *PObj2);
IPObjectStruct *TwoCrvsSrfsDiff(IPObjectStruct *PObj1, IPObjectStruct *PObj2);
IPObjectStruct *CrvReparametrization(IPObjectStruct *Obj,
				     RealType *TMin,
				     RealType *TMax);
IPObjectStruct *SrfReparametrization(IPObjectStruct *Obj,
				     RealType *RDir,
				     RealType *TMin,
				     RealType *TMax);
IPObjectStruct *TrivReparametrization(IPObjectStruct *Obj,
				      RealType *RDir,
				      RealType *TMin,
				      RealType *TMax);
IPObjectStruct *CrvCurvaturePts(IPObjectStruct *PObj, RealType *Eps);
IPObjectStruct *SrfGaussCurvature(IPObjectStruct *PObj);
IPObjectStruct *SrfMeanSqrCurvature(IPObjectStruct *PObj);
IPObjectStruct *SrfCurvatureBounds(IPObjectStruct *PObj,
				   RealType *RPtType,
				   RealType *RDir);
IPObjectStruct *FreeformEvolute(IPObjectStruct *PObj);
IPObjectStruct *SrfIsoFocalSrf(IPObjectStruct *PObj, RealType *RDir);
IPObjectStruct *CrvInflectionPts(IPObjectStruct *PObj, RealType *Eps);
IPObjectStruct *CrvZeros(IPObjectStruct *PObj, RealType *Eps, RealType *Axis);
IPObjectStruct *CrvExtremes(IPObjectStruct *PObj,
			    RealType *Eps,
			    RealType *Axis);
IPObjectStruct *CrvCrvInter(IPObjectStruct *PObj1,
			    IPObjectStruct *PObj2,
			    RealType *Eps,
			    RealType *SelfInter);
IPObjectStruct *CrvPointDist(IPObjectStruct *PCrv,
			     PointType Point,
			     RealType *MinDist,
			     RealType *Eps);
IPObjectStruct *CrvLineDist(IPObjectStruct *PCrv,
			    PointType Point,
			    VectorType Vec,
			    RealType *MinDist,
			    RealType *Eps);
IPObjectStruct *CrvComposition(IPObjectStruct *PObj1, IPObjectStruct *PObj2);
IPObjectStruct *SrfsPrisa(IPObjectStruct *Srfs,
			  CagdRType *SamplesPerCurve,
			  CagdRType *Epsilon,
			  CagdRType *Dir,
			  CagdVType Space);
IPObjectStruct *SrfAdapIsoCurves(IPObjectStruct *Srf,
				 CagdRType *Dir,
				 CagdRType *Eps,
				 CagdRType *FullIso,
				 CagdRType *SinglePath);
IPObjectStruct *GetFreefromParamDomain(IPObjectStruct *FreeformObj);
IPObjectStruct *CrvLeastSquarePtData(IPObjectStruct *PtObjList,
				     CagdRType *Order,
				     CagdRType *CrvSize,
				     CagdRType *ParamType,
				     CagdRType *RPeriodic);
IPObjectStruct *SrfLeastSquarePtData(IPObjectStruct *LstObjList,
				     CagdRType *UOrder,
				     CagdRType *VOrder,
				     CagdRType *USize,
				     CagdRType *VSize,
				     CagdRType *ParamType);
int GetResolution(int ClipToMin);
IPObjectStruct *CurveMultiResDecomp(IPObjectStruct *CrvObj, RealType *Discont);
IPObjectStruct *GenTrimmedSurface(IPObjectStruct *SrfObj,
				  IPObjectStruct *TrimmedCrvsObj,
				  RealType *RHasTopLvlTrim);
IPObjectStruct *GetSrfFromTrimmedSrf(IPObjectStruct *TrimmedSrfObj);
IPObjectStruct *GetTrimCrvsFromTrimmedSrf(IPObjectStruct *TrimmedSrfObj,
					  RealType *RParamSpace);
IPObjectStruct *GenBezierTrivarObject(IPObjectStruct *LstLstObjList);
IPObjectStruct *GenBsplineTrivarObject(RealType *RUOrder,
				       RealType *RVOrder,
				       RealType *RWOrder,
				       IPObjectStruct *LstLstObjList,
				       IPObjectStruct *KntObjList);
IPObjectStruct *EvalTrivarObject(IPObjectStruct *TVObj,
				 RealType *u,
				 RealType *v,
				 RealType *w);
IPObjectStruct *SurfaceFromTrivar(IPObjectStruct *TVObj,
				  RealType *RDir,
				  RealType *ParamVal);
IPObjectStruct *DivideTrivarObject(IPObjectStruct *TVObj,
				    RealType *RDir,
				    RealType *ParamVal);
IPObjectStruct *RegionFromTrivarObject(IPObjectStruct *TVObj, 
					RealType *RDir,
					RealType *ParamVal1,
					RealType *ParamVal2);
IPObjectStruct *RefineTrivarObject(IPObjectStruct *TVObj,
				    RealType *RDir,
				    RealType *RReplace,
				    IPObjectStruct *KnotsObj);
IPObjectStruct *DeriveTrivarObject(IPObjectStruct *TVObj, RealType *Dir);
IPObjectStruct *InterpolateTrivar(IPObjectStruct *TVObj);
IPObjectStruct *ComputeCrvMoments(IPObjectStruct *CrvObj, RealType *RMoment);
IPObjectStruct *GenTVFromSrfsObject(IPObjectStruct *SrfList,
				    RealType *OtherOrder);
IPObjectStruct *GenHermiteObject(IPObjectStruct *Pos1,
				 IPObjectStruct *Pos2,
				 IPObjectStruct *Dir1,
				 IPObjectStruct *Dir);
IPObjectStruct *MatchTwoCurves(IPObjectStruct *PCrv1,
			       IPObjectStruct *PCrv2,
			       RealType *RReduce,
			       RealType *RSampleSet,
			       RealType *RReparamOrder,
			       RealType *RRotate,
			       RealType *RNorm);
IPObjectStruct *ContourFreeform(IPObjectStruct *PSrfObj,
				PlaneType Plane,
				IPObjectStruct *PSrfEvalObj);
IPObjectStruct *SurfaceRayIntersect(IPObjectStruct *PSrfObj,
				    PointType ReyPos,
				    VectorType RayDir);
IPObjectStruct *FreeFormSplitScalar(IPObjectStruct *FreeForm);
IPObjectStruct *FreeFormMergeScalar(IPObjectStruct *ScalarFreeFormList,
				    RealType *RPType);
IPObjectStruct *FreeFormPointType(IPObjectStruct *FreeForm);
IPObjectStruct *ComputeConvexHull(IPObjectStruct *Geom, RealType *RFineNess);
IPObjectStruct *CrvPointTangents(IPObjectStruct *Crv,
				 PointType Pt,
				 RealType *RFineNess);
IPObjectStruct *CrvTwoTangents(IPObjectStruct *Crv, RealType *RFineNess);
IPObjectStruct *FreeFormOrder(IPObjectStruct *FreeForm);
IPObjectStruct *FreeFormMeshSize(IPObjectStruct *FreeForm);
IPObjectStruct *FreeFormKnotVector(IPObjectStruct *FreeForm);
IPObjectStruct *FreeFormControlPoints(IPObjectStruct *FreeForm);
IPObjectStruct *VisibConeDecomposition(IPObjectStruct *SrfObj,
				       RealType *Resolution,
				       RealType *ConeSize);
IPObjectStruct *PointCoverOfHemiSphere(RealType *Size);
IPObjectStruct *FreeformPointDistrib(IPObjectStruct *FreeFormObj,
				     RealType *RParamUniform,
				     RealType *RNumOfPts);
IPObjectStruct *GenBezierTriSrfObject(RealType *RLength,
				      IPObjectStruct *PtObjList);
IPObjectStruct *GenBsplineTriSrfObject(RealType *RLength,
				       RealType *ROrder,
				       IPObjectStruct *PtObjList,
				       IPObjectStruct *KntObjList);
IPObjectStruct *EvalTriSrfObject(IPObjectStruct *TriSrfObj,
				 RealType *u,
				 RealType *v,
				 RealType *w);
IPObjectStruct *NormalTriSrfObject(IPObjectStruct *TriSrfObj,
				   RealType *u,
				   RealType *v,
				   RealType *w);
IPObjectStruct *DeriveTriSrfObject(IPObjectStruct *TriSrfObj, RealType *Dir);
IPObjectStruct *CurveEnvelopeOffset(IPObjectStruct *CrvObj,
				    RealType *Height,
				    RealType *Tolerance);
IPObjectStruct *CurveBisectorSkel(IPObjectStruct *CrvObj,
				  RealType *RUseNrmlTan,
				  RealType *Tolerance,
				  RealType *RNumerImprove,
				  RealType *RSameNormal);
IPObjectStruct *SurfaceBisectorSkel(IPObjectStruct *CrvObj, PointType Pt);
IPObjectStruct *FreeFormOrthotomic(IPObjectStruct *FreeForm,
				   PointType Pt,
				   RealType *K);
IPObjectStruct *FreeFormPoles(IPObjectStruct *FreeForm);
IPObjectStruct *TrivIsoContourCurvature(IPObjectStruct *TrivObj,
					PointType Pos,
					RealType *RCompute);
IPObjectStruct *MarchCubeVolume(IPObjectStruct *VolumeSpec,
				PointType CubeDim,
				RealType *RSkipFactor,
				RealType *RIsoVal);
IPObjectStruct *PointCoverPolyObj(IPObjectStruct *PolyObj,
				  RealType *Rn,
				  RealType *Dir);
IPObjectStruct *IsoCoverTVObj(IPObjectStruct *TVObj,
			      RealType *RNumStrokes,
			      RealType *RStrokeType,
			      VectorType MinMaxPwrLen,
			      RealType *RStepSize,
			      RealType *RIsoVal,
			      VectorType ViewDir);
IPObjectStruct *LoadVolumeIntoTV(char *FileName,
				 RealType *RDataType,
				 VectorType VolSize,
				 VectorType Orders);

#endif /* FREEFORM_H */
