/*****************************************************************************
* Entry point of the program. Configuration and global data variables.	     *
******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                *
******************************************************************************
* Written by:  Bassarab Dmitri & Plavnik Michael       Ver 0.2, Apr. 1995    *
*****************************************************************************/

#include "program.h"
#include "shadow.h"

static void InitOptions(void);
static void InitContext(void);

/* Contains all configuration options. Subject to change by config file and  */
/* and command line parameters.                                              */
GlobalOptionsStruct Options;

/* Contains algorithm specific parameters, used in inter algorithm coopera-  */
/* tion also. Subject to change by algorithm initialization routines.        */
GlobalContextStruct Context;

ColorType Colors[] =
{
    { 0,    0,    0 },                                  /*  0. Black.        */
    { 0,    0,    1 },                                  /*  1. Blue.         */
    { 0,    1,    0 },                                  /*  2. Green.        */
    { 0,    1,    1 },                                  /*  3. Cyan.         */
    { 1,    0,    0 },                                  /*  4. Red.          */
    { 1,    0,    1 },                                  /*  5. Magenta.      */
    { 0.5,  0.5,  0 },                                  /*  6. Brown.        */
    { 0.5,  0.5,  0.5 },                                /*  7. Lightgrey.    */
    { 0.25, 0.25, 0.25 },                               /*  8. Darkgray.     */
    { 0.25, 0.25, 1 },                                  /*  9. Lightblue.    */
    { 0.25, 1,    0.25 },                               /* 10. Lightgreen.   */
    { 0.25, 1,    1 },                                  /* 11. Lightcyan.    */
    { 1,    0.25, 0.25 },                               /* 12. Lightred.     */
    { 1,    0.25, 1 },                                  /* 13. Lightmagenta. */
    { 1,    1,    0.25 },                               /* 14. Yellow.       */
    { 1,    1,    1 }                                   /* 15. White.        */
};

ProcTextureStruct ProcTextures[] =
{
    { "wood",    WoodTexture },
    { "marble",  MarbleTexture },
    { "contour", ContourTexture },
    { "ncontour",ContourNormalTexture },
    { NULL,     NULL}
};

/*****************************************************************************
* DESCRIPTION:                                                               *
*   Initialize global options with default values.                           *
*                                                                            *
* PARAMETERS:                                                                *
*   None                                                                     *
*                                                                            *
* RETURN VALUE:                                                              *
*   void                                                                     *
*****************************************************************************/
static void InitOptions(void)
{
    Options.XSize = 512;
    Options.YSize = 512;
    Options.Ambient = AMBIENT_DEFAULT;
    Options.BackGround[R] =
	Options.BackGround[G] =
	    Options.BackGround[B] = 0.0; 
    Options.BackFace = FALSE;
    Options.ShadeModel = PHONG;
    Options.Polylines = FALSE;
    Options.Shadows = FALSE;
    Options.Transp = FALSE;
    Options.HasTime = FALSE;
    Options.FilterName = "None";
    Options.ZDepth = FALSE;
    Options.NormalReverse = FALSE;
    Options.Srf2PlgOptimal = 0;
    Options.Srf2PlgFineness = IG_DEFAULT_POLYGON_FINENESS;
    Options.Crv2PllMethod = SYMB_CRV_APPROX_UNIFORM;
    Options.Crv2PllSamples = IG_DEFAULT_SAMPLES_PER_CURVE;
    Options.Verbose = FALSE;
}

/*****************************************************************************
* DESCRIPTION:                                                               *
*   Initialize algorithms context data with default values. Subject to       *
*   change by algorithm initialization routines.                             *
*                                                                            *
* PARAMETERS:                                                                *
*   None                                                                     *
*                                                                            *
* RETURN VALUE:                                                              *
*   void                                                                     *
*****************************************************************************/
static void InitContext(void)
{
    /* Context.ViewMat, Context.InvMat -- initialized in map.c:<Map()>. */
    /* Context.Lights -- initlaized in lights.c:<GatherLights()>. */
    Context.MaxEdges = 0;

    /* Parallel projection is default. */
    Context.Viewer[X] = 0;
    Context.Viewer[Y] = 0;
    Context.Viewer[Z] = VIEWER_SIGHT;
}

/*****************************************************************************
* DESCRIPTION:                                                               M
*   Performs configuration management, preprocesses data files and renderes. M
*                                                                            *
* PARAMETERS:                                                                M
*   argc:    IN, command line parameters number.                             M
*   argv:    IN, command line parameters.                                    M
*                                                                            *
* RETURN VALUE:                                                              M
*   int:    exit reason code.                                                M
*                                                                            *
* KEYWORDS:                                                                  M
*   main                                                                     M
*****************************************************************************/
int main(int argc, char *argv[])
{
    InitOptions();
    InitContext();
    GetConfig(argv);
    GetOptions(argc, argv);
    ImageOpenFile(argv, Options.XSize, Options.YSize);
    if (Options.Verbose)
        PrintOptions();
    SetupAntialias();

    Shader(
        BucketSortFlats(
            GatherShadows(
                GatherFlats(
                    GatherLights(&Context.Lights,
                                 Map(ParseFiles(Options.NFiles,
						Options.Files)))))));
    ImageCloseFile();
    
    return 0;
}
