/*****************************************************************************
* Debug version of the program make use of usefull diagnostic defined here.  *
******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                *
******************************************************************************
* Written by:  Bassarab Dmitri & Plavnik Michael       Ver 0.2, Apr. 1995    *
*****************************************************************************/

#ifndef _DEBUG_H
#define _DEBUG_H

#include <assert.h>

#ifdef DEBUG_IRENDER
#define ASSERT(cond) assert(cond)
#else
#define ASSERT(cond)
#endif /*  DEBUG_IRENDER */

#ifdef DEBUG_IRENDER
#define MAPPING_MESSAGE()         fprintf(stderr, "\nMapping polygons\n")
#define GATHERING_FLATS_MESSAGE() fprintf(stderr, "Gathering flats\n")
#define SORTING_MESSAGE()         fprintf(stderr, "Sorting into buckets\n")
#define PREPROCESSING_MESSAGE()   fprintf(stderr, "  preprocessing\n")
#define PAIRING_MESSAGE()         fprintf(stderr, "  pairing\n");
#define GATHERING_SHADOWS_MESSAGE() fprintf(stderr, "Gathering shadows data\n")
#define RENDERING_MESSAGE()       fprintf(stderr, "Rendering\n")
#define SCANLINE_MESSAGE(y)       fprintf(stderr, "\rY: %5d", y)
#define FINAL_MESSAGE()           fprintf(stderr, "\n")
#else 
#define MAPPING_MESSAGE() \
    if (Options.Verbose) \
	fprintf(stderr, "\nMapping polygons\n")
#define GATHERING_FLATS_MESSAGE() \
    if (Options.Verbose) \
	fprintf(stderr, "Gathering flats\n")
#define SORTING_MESSAGE() \
    if (Options.Verbose) \
	fprintf(stderr, "Sorting into buckets\n")
#define PREPROCESSING_MESSAGE() \
    if (Options.Verbose) \
	fprintf(stderr,  "  preprocessing\n")
#define PAIRING_MESSAGE() \
    if (Options.Verbose) \
	fprintf(stderr, "  pairing\n");
#define GATHERING_SHADOWS_MESSAGE() \
    if (Options.Verbose) \
	fprintf(stderr, "Gathering shadows data\n")
#define RENDERING_MESSAGE() \
    if (Options.Verbose) \
	fprintf(stderr, "Rendering\n")
#define SCANLINE_MESSAGE(y) \
    if (Options.Verbose) \
	fprintf(stderr, "\rY: %5d", y)
#define FINAL_MESSAGE() \
    if (Options.Verbose) \
	fprintf(stderr, "\n")
#endif /*  DEBUG_IRENDER */

#endif /* _DEBUG_H */
