/******************************************************************************
* User_lib.h - Header file for the User Interaction library.		      *
* This header is also the interface header to the world.		      *
*******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                 *
*******************************************************************************
* Written by Gershon Elber, Mar. 90.					      *
******************************************************************************/

#ifndef USER_LIB_H
#define USER_LIB_H

#include "cagd_lib.h"
#include "iritprsr.h"

typedef enum {
    USER_ERR_WRONG_SRF,
    USER_ERR_MISSING_ATTRIB,
    USER_ERR_WRONG_ANGLE,

    USER_ERR_UNDEFINE_ERR
} UserFatalErrorType;

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

VoidPtr IntrSrfRayPreprocessSrf(CagdSrfStruct *Srf, int FineNess);
void IntrSrfRayFreePreprocess(VoidPtr Handle);
CagdBType IntrSrfRayTestRay(VoidPtr Handle,
			    CagdPType RayOrigin,
			    CagdVType RayDir,
			    CagdUVType InterUV);
IPPolygonStruct *UserCntrSrfWithPlane(CagdSrfStruct *Srf,
                                      PlaneType Plane,
                                      RealType FineNess);

CagdCrvStruct *UserPolyline2LinBsplineCrv(IPPolygonStruct *Poly);
CagdCrvStruct *UserPolylines2LinBsplineCrvs(IPPolygonStruct *Poly);

IPObjectStruct *UserSrfVisibConeDecomp(CagdSrfStruct *Srf,
				       CagdRType Resolution,
				       CagdRType ConeSize);
TrimSrfStruct *UserVisibilityClassify(IPObjectStruct *SclrSrf,
					  TrimSrfStruct *TrimmedSrfs);
IPObjectStruct *UserViewingConeSrfDomains(CagdSrfStruct *Srf,
					      CagdSrfStruct *NSrf,
					      IPPolygonStruct *ConeDirs,
					      CagdRType Resolution,
					      CagdRType ConeSize,
					      CagdRType Euclidean);

/******************************************************************************
* Error handling.							      *
******************************************************************************/
char *UserDescribeError(UserFatalErrorType ErrorNum);
void UserFatalError(UserFatalErrorType ErrID);

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

#endif /* USER_LIB_H */
