/******************************************************************************
* Line plane sweep algorithm implementation - header file.		      *
*******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                 *
*******************************************************************************
* Written by:  Gershon Elber                              Ver 1.0, June 1993  *
******************************************************************************/

#ifndef LN_SWEEP_H
#define LN_SWEEP_H

#include "irit_sm.h"

typedef RealType LsPoint[3];      /* The Z component is pretty much ignored. */

typedef struct LsLineSegStruct {
    struct LsLineSegStruct *Pnext;
    LsPoint Pts[2];
    long Id;			    /* Lines with unique ID never intersect. */
    VoidPtr PAux;	    /* Auxiliary backpointer - not used by ln_sweep. */
    struct LsIntersectStruct *Inters;
    LsPoint _MinVals;			         /* Bounding box on the line */
    LsPoint _MaxVals;
    LsPoint _Vec;		     /* A vector from first point to second. */
    RealType _ABC[3];			    /* Line equation as Ax + By + C. */
} LsLineSegStruct;

typedef struct LsIntersectStruct {
    struct LsIntersectStruct *Pnext;
    RealType t;
    RealType OtherT;
    struct LsLineSegStruct *OtherSeg;
    long Id;				       /* Unique ID of intersection. */
} LsIntersectStruct;

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

void LineSweep(LsLineSegStruct **Lines);

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

#endif /* LN_SWEEP_H */
