/*****************************************************************************
* Conversion routines from curvesand surfaces to polygons and polylines.     *
******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                *
******************************************************************************
* Written by:  Gershon Elber				Ver 1.0, Apr 1992    *
*****************************************************************************/

#ifndef IP_CONVRT_H
#define IP_CONVRT_H

#include "iritprsr.h"
#include "cagd_lib.h"
#include "symb_lib.h"
#include "attribut.h"

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

IPPolygonStruct *IritCurve2Polylines(CagdCrvStruct *Crv,
				     CagdRType TolSamples,
				     SymbCrvApproxMethodType Method);
IPPolygonStruct *IritCurve2CtlPoly(CagdCrvStruct *Crv);
IPPolygonStruct *IritSurface2Polylines(CagdSrfStruct *Srf,
				       int NumOfIsolines[2],
				       CagdRType TolSamples,
				       SymbCrvApproxMethodType Method);
IPPolygonStruct *IritSurface2CtlMesh(CagdSrfStruct *Srf);
SymbPlErrorFuncType IritSrf2OptPolysSetUserTolFunc(SymbPlErrorFuncType Func);
IPPolygonStruct *IritSurface2Polygons(CagdSrfStruct *Srf,
				      int FourPerFlat,
				      RealType FineNess,
				      int ComputeUV,
				      int ComputeNrml,
				      int Optimal);
IPPolygonStruct *IritTrimSrf2Polylines(TrimSrfStruct *TrimSrf,
				       int NumOfIsolines[2],
				       CagdRType TolSamples,
				       SymbCrvApproxMethodType Method,
				       int TrimmingCurves,
				       int IsoParamCurves);
IPPolygonStruct *IritTrimSrf2CtlMesh(TrimSrfStruct *TrimSrf);
IPPolygonStruct *IritTrimSrf2Polygons(TrimSrfStruct *TrimSrf,
				      int FourPerFlat,
				      RealType FineNess,
				      int ComputeUV,
				      int ComputeNrml,
				      int Optimal);
IPPolygonStruct *IritTrivar2Polygons(TrivTVStruct *Trivar,
				     int FourPerFlat,
				     RealType FineNess,
				     int ComputeUV,
				     int ComputeNrml,
				     int Optimal);
IPPolygonStruct *IritTrivar2Polylines(TrivTVStruct *Trivar,
				      int NumOfIsolines[3],
				      CagdRType TolSamples,
				      SymbCrvApproxMethodType Method);
IPPolygonStruct *IritTrivar2CtlMesh(TrivTVStruct *Trivar);
IPPolygonStruct *IritTriSrf2Polygons(TrngTriangSrfStruct *TriSrf,
				     RealType FineNess,
				     int ComputeUV,
				     int ComputeNrml,
				     int Optimal);
IPPolygonStruct *IritTriSrf2Polylines(TrngTriangSrfStruct *TriSrf,
				      int NumOfIsolines[3],
				      int SamplesPerCurve,
				      int Optimal);
IPPolygonStruct *IritTriSrf2CtlMesh(TrngTriangSrfStruct *TriSrf);
void IritSetCurvesToCubicBzrTol(RealType Tolerance);
CagdCrvStruct *IritCurvesToCubicBzrCrvs(CagdCrvStruct *Crvs,
					IPPolygonStruct **CtlPolys,
					CagdBType DrawCurve,
					CagdBType DrawCtlPoly,
					CagdRType MaxArcLen);
CagdCrvStruct *IritSurfacesToCubicBzrCrvs(CagdSrfStruct *Srfs,
					  IPPolygonStruct **CtlMeshes,
					  CagdBType DrawSurface,
					  CagdBType DrawMesh,
					  int NumOfIsolines[2],
					  CagdRType MaxArcLen);
CagdCrvStruct *IritTrimSrfsToCubicBzrCrvs(TrimSrfStruct *TrimSrfs,
					  IPPolygonStruct **CtlMeshes,
					  CagdBType DrawTrimSrf,
					  CagdBType DrawMesh,
					  int NumOfIsolines[2],
					  CagdRType MaxArcLen);
CagdCrvStruct *IritTrivarToCubicBzrCrvs(TrivTVStruct *Trivar,
					  IPPolygonStruct **CtlMeshes,
					  CagdBType DrawSurface,
					  CagdBType DrawMesh,
					  int NumOfIsolines[2],
					  CagdRType MaxArcLen);
CagdCrvStruct *IritTriSrfsToCubicBzrCrvs(TrngTriangSrfStruct *TriSrfs,
					 IPPolygonStruct **CtlMeshes,
					 CagdBType DrawSurface,
					 CagdBType DrawMesh,
					 int NumOfIsolines[3],
					 CagdRType MaxArcLen);
CagdSrfStruct *IritSurfacesToCubicBzrSrfs(CagdSrfStruct *Srfs,
					  CagdSrfStruct **NoConvertionSrfs);
void IritClosedPolysToOpen(IPPolygonStruct *Pls);
void IritOpenPolysToClosed(IPPolygonStruct *Pls);

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

#endif /* IP_CONVRT_H */
