/******************************************************************************
* All mallocs from irit modules should be piped through this allocator.       *
*******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                 *
*******************************************************************************
*					 Written by Gershon Elber, April 1993 *
******************************************************************************/

#ifndef IMALLOC_H
#define IMALLOC_H

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

#ifdef MALLOC_DEBUG_INFO
VoidPtr IritMalloc(unsigned Size, char *ObjType, char *FileName, int LineNum);
#define IritMalloc(x)	IritMalloc((x), #x, __FILE__, __LINE__)
#else
VoidPtr IritMalloc(unsigned Size);
#endif /* MALLOC_DEBUG_INFO */

void IritTestAllDynMemory(int PrintAllAlloc);
VoidPtr IritRealloc(VoidPtr p, unsigned size);
void IritFree(VoidPtr p);
void IritDebugMallocReset(void);
void IritDebugMallocSearchPtr(VoidPtr p, int Abort);
void IritDebugMallocAllocated(void);

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

#endif /* IMALLOC_H */
