/******************************************************************************
* GeoMat3d.h - Trans. Matrices , Vector computation, and Comp.geom.	      *
*******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                 *
*******************************************************************************
* Written by Gershon Elber, March 1990.					      *
******************************************************************************/

#ifndef	GEOMAT_3D_H
#define GEOMAT_3D_H

#include "iritprsr.h"

/* Used by the Ray & Polygon intersection (Jordan theorem): */
#define BELOW_RAY	1
#define ON_RAY		2
#define ABOVE_RAY	3

typedef RealType (*GMPolyOffsetAmountFuncType)(RealType *Coord);

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

/* And prototypes of the functions: */

void GMVecCopy(VectorType Vdst, VectorType Vsrc);
void GMVecNormalize(VectorType V);
RealType GMVecLength(VectorType V);
void GMVecCrossProd(VectorType Vres, VectorType V1, VectorType V2);
int GMColinear3Pts(PointType Pt1, PointType Pt2, PointType Pt3);
RealType GMVecDotProd(VectorType V1, VectorType V2);

IPObjectStruct *GMGenMatObjectRotX(RealType *Degree);
IPObjectStruct *GMGenMatObjectRotY(RealType *Degree);
IPObjectStruct *GMGenMatObjectRotZ(RealType *Degree);
IPObjectStruct *GMGenMatObjectTrans(VectorType Vec);
IPObjectStruct *GMGenMatObjectScale(VectorType Vec);
IPObjectStruct *GMGetMatTransPortion(IPObjectStruct *MatObj, int *TransPortion);
IPObjectStruct *GMGenMatObjectGeneric(IPObjectStruct *LstObjList);
IPObjectStruct *GMTransformObject(IPObjectStruct *PObj, MatrixType Mat);
IPObjectStruct *GMTransformObjectList(IPObjectStruct *PObj, MatrixType Mat);
IPObjectStruct *GMGenMatObjectZ2Dir(VectorType Dir);
IPObjectStruct *GMGenMatObjectZ2Dir2(VectorType Dir, VectorType Dir2);
IPObjectStruct *GMGenMatObjectRotVec(VectorType Vec, RealType *Degree);

RealType GMPolyOffsetAmountDepth(RealType *Coord);
IPPolygonStruct *GMPolyOffset(IPPolygonStruct *Poly,
			      int IsPolygon,
			      RealType Ofst,
			      GMPolyOffsetAmountFuncType AmountFunc);

/* And the computational geometry routines: */
RealType CGDistPointPoint(PointType P1, PointType P2);
int CGPlaneFrom3Points(PlaneType Plane,
		       PointType Pt1,
		       PointType Pt2,
		       PointType Pt3);
void CGPointFromPointLine(PointType Point,
			  PointType Pl,
			  PointType Vl,
			  PointType ClosestPoint);
RealType CGDistPointLine(PointType Point, PointType Pl, PointType Vl);
RealType CGDistPointPlane(PointType Point, RealType Plane[4]);
int CGPointFromLinePlane(PointType Pl,
			 PointType Vl,
			 RealType Plane[4],
			 PointType InterPoint,
			 RealType *t);
int CGPointFromLinePlane01(PointType Pl,
			   PointType Vl,
			   RealType Plane[4],
			   PointType InterPoint,
			   RealType *t);
int CG2PointsFromLineLine(PointType Pl1,
			  PointType Vl1,
			  PointType Pl2,
			  PointType Vl2,
			  PointType Pt1,
			  RealType *t1,
			  PointType Pt2,
			  RealType *t2);
RealType CGDistLineLine(PointType Pl1,
			PointType Vl1,
			PointType Pl2,
			PointType Vl2);

int CGPolygonRayInter(IPPolygonStruct *Pl, PointType PtRay, int RayAxes);
int CGPolygonRayInter3D(IPPolygonStruct *Pl, PointType PtRay, int RayAxes);
void CGGenTransMatrixZ2Dir(MatrixType Mat,
			   VectorType Trans,
			   VectorType Dir,
			   RealType Scale);
void CGGenMatrixZ2Dir(MatrixType Mat, VectorType Dir);
void CGGenTransMatrixZ2Dir2(MatrixType Mat,
			    VectorType Trans,
			    VectorType Dir,
			    VectorType Dir2,
			    RealType Scale);
void CGGenMatrixZ2Dir2(MatrixType Mat, VectorType Dir, VectorType Dir2);
void CGGenMatrixRotVec(MatrixType Mat, VectorType Vec, RealType Angle);
RealType *CGBaryCentric3Pts(PointType Pt1,
			    PointType Pt2,
			    PointType Pt3,
			    PointType Pt);

IPObjectStruct *CGPointCoverOfUnitHemiSphere(RealType HoneyCombSize);
IPObjectStruct *CGPointCoverOfPolyObj(IPObjectStruct *PolyObj,
				      int n,
				      RealType *Dir);
IPObjectStruct *CGConvertPolysToTriangles(IPObjectStruct *PolyObj);

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

#endif	/* GEOMAT_3D_H */
