/*****************************************************************************
*   "Irit" - the 3d polygonal solid modeller.				     *
******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                *
******************************************************************************
* Extra functions from external, public domain, sources.		     *
*****************************************************************************/

#ifndef	EXTRA_FN_H
#define	EXTRA_FN_H

typedef struct ConvexHullPoint {
     RealType Pt[2];
} ConvexHullPoint;

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

RealType SvdLeastSqr(RealType *A, RealType *x, RealType *b, int NData, int Nx);
void BzrCrvInterp(RealType *Result, RealType *Input, int Size);
int ConvexHull(ConvexHullPoint *DTPts, int *NumOfPoints);

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

#endif /* EXTRA_FN_H */
