/******************************************************************************
* Convex.h - test convexity and converts polygons to convex ones.	      *
*******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                 *
*******************************************************************************
* Written by Gershon Elber, March 1990.					      *
******************************************************************************/

#ifndef CONVEX_GH
#define CONVEX_GH

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

/* Prototypes of global functions of CONVEX module: */
IPObjectStruct *ConvexPolyObjectN(IPObjectStruct *PObj);
void ConvexPolyObject(IPObjectStruct *PObj);
int ConvexPolygon(IPPolygonStruct *Pl);
IPPolygonStruct *SplitNonConvexPoly(IPPolygonStruct *Pl);
void GenRotateMatrix(MatrixType Mat, VectorType Dir);
void ReverseVrtxList(IPPolygonStruct *Pl);

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

#endif /* CONVEX_GH */
