/*****************************************************************************
*   General definitions for the configuration file reading routines	     *
******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                *
******************************************************************************
* Written by:  Gershon Elber			       Ver 0.2, Jan. 1989    *
*****************************************************************************/

#ifndef CONFIG_H				       /* Defined Only once. */
#define CONFIG_H

#define	SU_BOOLEAN_TYPE	1
#define SU_INTEGER_TYPE	2
#define SU_REAL_TYPE	3
#define SU_STRING_TYPE	4

typedef struct ConfigStruct {
    char *VarName;
    char *SomeInfo;
    VoidPtr VarData;
    int   VarType;
} ConfigStruct;

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

/* And finally the prototype of the configuration routines: */
void Config(char *PrgmName, ConfigStruct *SetUp, int NumVar);
void ConfigPrint(ConfigStruct *SetUp, int NumVar);

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

#endif	/* CONFIG_H */
