/*****************************************************************************
*   "Irit" - the 3d polygonal solid modeller.				     *
*									     *
* Written by:  Gershon Elber				Ver 1.0, Jan. 1992   *
******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                *
******************************************************************************
* Global definitions of	Animation module.  			             *
*****************************************************************************/

#ifndef	ANIMATE_H	/* Define only once */
#define	ANIMATE_H

#include "attribut.h"

#define ANIM_DEFAULT_ANIM_FILE_NAME	"IAnim"

/* The "_isvisible" will be set in each object having "animation" attribute. */
#define ANIM_IS_VISIBLE(PObj)	(!ATTR_OBJ_IS_INVISIBLE(PObj) && \
				 AttrGetObjectIntAttrib((PObj), "_isvisible"))

typedef struct AnimationStruct {
    RealType
	StartT,		                     /* Starting time of animation. */
	FinalT,		                  /* Termination time of animation. */
	Dt,		                         /* Step size pf animation. */
	RunTime;		              /* Current time of animation. */
    int TwoWaysAnimation,   /* Should the animation bounce back and forth!? */
	SaveAnimation,               /* Save animation sequence in a file!? */
	BackToOrigin,	           /* Should we terminate at the beginning? */
	NumOfRepeat,			            /* How many iterations? */
	StopAnim,		   /* If TRUE, must stop the animation now. */
	SingleStep,			     /* Are we in single step mode? */
	TextInterface,		/* Are we communicating using a textual UI? */
	MiliSecSleep,	   /* How many miliseconds to sleep between frames. */
	_Count;						/* Used internally. */
    char
	*ExecEachStep,		      /* Program to execute each iteration. */
	BaseFileName[LINE_LEN];      /* Base name of animation files saved. */
} AnimationStruct;

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

void AnimResetAnimStruct(AnimationStruct *Anim);
void AnimGetAnimInfoText(AnimationStruct *Anim);
void AnimFindAnimationTime(AnimationStruct *Anim, IPObjectStruct *PObjs);
void AnimSaveIterationsToFiles(AnimationStruct *Anim, IPObjectStruct *PObjs);
void AnimDoAnimation(AnimationStruct *Anim, IPObjectStruct *PObjs);
void AnimEvalAnimation(RealType t, IPObjectStruct *PObjs);
void AnimDoSingleStep(AnimationStruct *Anim, IPObjectStruct *PObjs);
int AnimCheckInterrupt(AnimationStruct *Anim);

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

#endif /* ANIMATE_H */

