/****************************************************************************
*   "Irit" - the 3d polygonal solid modeller.				    *
*****************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology               *
*****************************************************************************
* Written by:  Gershon Elber				Ver 1.0, Jan. 1992  *
*****************************************************************************
* Global definitions of	os2drvs interface.			            *
****************************************************************************/

#ifndef	OS2DRVS_H	/* Define only once */
#define	OS2DRVS_H

#define ID_OS2DRVS		1984

#define IDM_FILE		1
#define IDM_FILE_SAVE		11
#define IDM_FILE_SAVE_AS	12
#define IDM_FILE_QUIT		13

#define IDM_MOUSE		2
#define IDM_MOUSE_MORE		21
#define IDM_MOUSE_LESS		22

#define IDM_STATE		3
#define IDM_STATE_MORE_ISO	31
#define IDM_STATE_LESS_ISO	32
#define IDM_STATE_FINER_APPROX	33
#define IDM_STATE_COARSER_APPROX 34
#define IDM_STATE_SHORTER_VEC	35
#define IDM_STATE_LONGER_VEC	36
#define IDM_STATE_WIDE_LINES	37
#define IDM_STATE_THIN_LINES	38
#define IDM_STATE_WIDE_POINTS	39
#define IDM_STATE_THIN_POINTS	40

#define IDM_TOGGLE		5
#define IDM_TGLS_SCREEN		51
#define IDM_TGLS_PERSP		52
#define IDM_TGLS_DEPTH_CUE	53
#define IDM_TGLS_DOUBLE_BUFFER	54
#define IDM_TGLS_DRAW_SOLID	55
#define IDM_TGLS_BFACE_CULL	56
#define IDM_TGLS_SHADING_MODES	57
#define IDM_TGLS_INTERNAL	58
#define IDM_TGLS_VRTX_NRML	59
#define IDM_TGLS_POLY_NRML	60
#define IDM_TGLS_CTL_MESH	61
#define IDM_TGLS_SRF_POLYS	62
#define IDM_TGLS_4_PER_FLAT	63

#define	IDM_VIEWS		7
#define	IDM_VIEW_FRONT		70
#define IDM_VIEW_SIDE		71
#define IDM_VIEW_TOP		72
#define IDM_VIEW_ISOMETRY	73

#define IDM_ANIM		10
#define IDM_ANIM_ACTIVE		100

/* Animation's dialog box constants. */
#define ID_ANIM_SLIDER		101
#define ID_ANIM_SAVE_FILE	102
#define ID_ANIM_MIN_TIME	103
#define ID_ANIM_MAX_TIME	104
#define ID_ANIM_TIME_STEP	105
#define ID_ANIM_BEGIN		106
#define ID_ANIM_STOP		107
#define ID_ANIM_DISMISS		108

#define ID_ANIM_GET_TIME	12
#define ID_ANIM_GOT_TIME	121
#define ID_ANIM_GET_TIME_ENT	122
#define ID_ANIM_GET_TIME_CAN	123

#define ID_ANIM_SLIDER_FONT	"8.Courier"

#endif /* OS2DRVS_H */
