/*****************************************************************************
*   Default surface drawing routine common to graphics drivers.		     *
******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                *
******************************************************************************
* Written by:  Gershon Elber				Ver 0.1, June 1993.  *
*****************************************************************************/

#include "irit_sm.h"
#include "iritprsr.h"
#include "allocate.h"
#include "attribut.h"
#include "cagd_lib.h"
#include "symb_lib.h"
#include "ip_cnvrt.h"
#include "iritgrap.h"

/*****************************************************************************
* DESCRIPTION:                                                               M
* Draw a single trivariate function object using current modes and 	     M
* transformations.							     M
*   Piecewise linear approximation is cashed under "_isoline" and "_ctlmesh" M
* attributes of PObj. Polygonal approximation is saved under "_polygons".    M
*                                                                            *
* PARAMETERS:                                                                M
*   PObj:     A trivariate function object to draw.                          M
*                                                                            *
* RETURN VALUE:                                                              M
*   void                                                                     M
*                                                                            *
* KEYWORDS:                                                                  M
*   IGDrawTrivar                                                             M
*****************************************************************************/
void IGDrawTrivar(IPObjectStruct *PObj)
{
    IPObjectStruct *PObjPolylines, *PObjCtlMesh, *PObjPolygons;
    IPPolygonStruct *PPolylines, *PCtlMesh, *PPolygons, *PPolygonTemp;
    RealType RelativeFineNess;

    if ((RelativeFineNess = AttrGetObjectRealAttrib(PObj,
					   "resolution")) > IP_ATTR_BAD_REAL)
	RelativeFineNess = 1.0;
		
    if ((PObjPolylines = AttrGetObjectObjAttrib(PObj, "_isoline")) == NULL &&
	IGGlblNumOfIsolines > 0) {
	TrivTVStruct *TV,
	    *TVs = PObj -> U.Trivars;

	PObjPolylines = IPAllocObject("", IP_OBJ_POLY, NULL);
	PObjPolylines -> Attrs = AttrCopyAttributes(PObj -> Attrs);
	IP_SET_POLYLINE_OBJ(PObjPolylines);
	for (TV = TVs; TV != NULL; TV = TV -> Pnext) {
	    int NumOfIso[3],
		Res = MAX(IGGlblNumOfIsolines / 2, 2);

	    NumOfIso[0] = -Res;
	    NumOfIso[1] = -Res;
	    NumOfIso[2] = -Res;
	    PPolylines = IritTrivar2Polylines(TV, NumOfIso,
					      IGGlblSamplesPerCurve,
					      IGGlblPolylineOptiApprox);

	    if (PPolylines != NULL) {
		for (PPolygonTemp = PPolylines;
		     PPolygonTemp -> Pnext;
		     PPolygonTemp = PPolygonTemp -> Pnext);
		PPolygonTemp -> Pnext = PObjPolylines -> U.Pl;
		PObjPolylines -> U.Pl = PPolylines;
	    }
	}
	AttrSetObjectObjAttrib(PObj, "_isoline", PObjPolylines, FALSE);
    }

    if (IGGlblDrawSurfacePoly || IGGlblDrawSolid) {
	if ((PObjPolygons = AttrGetObjectObjAttrib(PObj, "_polygons"))
								    == NULL) {
	    TrivTVStruct *TV,
		*TVs = PObj -> U.Trivars;


	    PObjPolygons = IPAllocObject("", IP_OBJ_POLY, NULL);
	    PObjPolygons -> Attrs = AttrCopyAttributes(PObj -> Attrs);
	    IP_SET_POLYGON_OBJ(PObjPolygons);

	    for (TV = TVs; TV != NULL; TV = TV -> Pnext) {
		PPolygons = IritTrivar2Polygons(TV, IGGlblFourPerFlat,
						IGGlblFineNess *
						    RelativeFineNess,
						FALSE, TRUE,
						IGGlblPolygonOptiApprox);

		if (PPolygons != NULL) {
		    if (PPolygons) {
			for (PPolygonTemp = PPolygons;
			     PPolygonTemp -> Pnext;
			     PPolygonTemp = PPolygonTemp -> Pnext);
			PPolygonTemp -> Pnext = PObjPolygons -> U.Pl;
			PObjPolygons -> U.Pl = PPolygons;
		    }
		}
	    }
	    AttrSetObjectObjAttrib(PObj, "_polygons", PObjPolygons, FALSE);
	}

	IGDrawPoly(PObjPolygons);
    }
    else if (PObjPolylines != NULL)
        IGDrawPoly(PObjPolylines);

    if (IGGlblDrawSurfaceMesh) {
	if ((PObjPolylines = AttrGetObjectObjAttrib(PObj, "_ctlmesh"))
								== NULL) {
	    TrivTVStruct *TV,
		*TVs = PObj -> U.Trivars;

	    PObjCtlMesh = IPAllocObject("", IP_OBJ_POLY, NULL);
	    PObjCtlMesh -> Attrs = AttrCopyAttributes(PObj -> Attrs);
	    IP_SET_POLYLINE_OBJ(PObjCtlMesh);
	    for (TV = TVs; TV != NULL; TV = TV -> Pnext) {
		PCtlMesh = IritTrivar2CtlMesh(TV);

		for (PPolygonTemp = PCtlMesh;
		     PPolygonTemp -> Pnext;
		     PPolygonTemp = PPolygonTemp -> Pnext);
		PPolygonTemp -> Pnext = PObjCtlMesh -> U.Pl;
		PObjCtlMesh -> U.Pl = PCtlMesh;
	    }
	    AttrSetObjectObjAttrib(PObj, "_ctlmesh", PObjCtlMesh, FALSE);
	}

	IGDrawPoly(AttrGetObjectObjAttrib(PObj, "_ctlmesh"));
    }
}
