
#
# Makefile for the iritfltr subdirectory (IRIT solid modeller).
#

include ../makeflag.sas

ALL_EXE = irit2ray irit2pov irit2ps irit2xfg irit2nff dat2irit \
	dxf2irit irit2dxf irit2scn irit2plg irit2iv irit2hgl \
	dat2bin obj2irit skeletn1

all: $(ALL_EXE)


IRIT2RAY_OBJS	= irit2ray.o ffcnvrt.o

IRIT2POV_OBJS	= irit2pov.o ffcnvrt.o

IRIT2PS_OBJS	= irit2ps.o ffcnvrt.o

IRIT2XFG_OBJS	= irit2xfg.o ffcnvrt.o

IRIT2HGL_OBJS	= irit2hgl.o ffcnvrt.o

IRIT2NFF_OBJS	= irit2nff.o ffcnvrt.o

DAT2IRIT_OBJS	= dat2irit.o ffcnvrt.o

DXF2IRIT_OBJS	= dxf2irit.o

IRIT2DXF_OBJS	= irit2dxf.o ffcnvrt.o

IRIT2SCN_OBJS	= irit2scn.o ffcnvrt.o

IRIT2PLG_OBJS	= irit2plg.o ffcnvrt.o

IRIT2IV_OBJS	= irit2iv.o ffcnvrt.o

DAT2BIN_OBJS	= dat2bin.o

OBJ2IRIT_OBJS	= obj2irit.o

SKELETN1_OBJS	= skeletn1.o ffcnvrt.o

irit2ray:	$(IRIT2RAY_OBJS)
	slink from lib:c.o $(IRIT2RAY_OBJS) to irit2ray sc $(SYMS)\
lib $(LIBS) $(MORELIBS) $(MATHLIB) lib:scnb.lib

irit2pov:	$(IRIT2POV_OBJS)
	slink from lib:c.o $(IRIT2POV_OBJS) to irit2pov sc $(SYMS)\
lib $(LIBS) $(MORELIBS) $(MATHLIB) lib:scnb.lib

irit2ps:	$(IRIT2PS_OBJS)
	slink from lib:c.o $(IRIT2PS_OBJS) to irit2ps sc $(SYMS)\
lib $(LIBS) $(MORELIBS) $(MATHLIB) lib:scnb.lib

irit2xfg:	$(IRIT2XFG_OBJS)
	slink from lib:c.o $(IRIT2XFG_OBJS) to irit2xfg sc $(SYMS)\
lib $(LIBS) $(MORELIBS) $(MATHLIB) lib:scnb.lib

irit2hgl:	$(IRIT2HGL_OBJS)
	slink from lib:c.o $(IRIT2HGL_OBJS) to irit2hgl sc $(SYMS)\
lib $(LIBS) $(MORELIBS) $(MATHLIB) lib:scnb.lib

irit2nff:	$(IRIT2NFF_OBJS)
	slink from lib:c.o $(IRIT2NFF_OBJS) to irit2nff sc $(SYMS)\
lib $(LIBS) $(MORELIBS) $(MATHLIB) lib:scnb.lib

dat2irit:	$(DAT2IRIT_OBJS)
	slink from lib:c.o $(DAT2IRIT_OBJS) to dat2irit sc $(SYMS)\
lib $(LIBS) $(MORELIBS) $(MATHLIB) lib:scnb.lib

dxf2irit:	$(DXF2IRIT_OBJS)
	slink from lib:c.o $(DXF2IRIT_OBJS) to dxf2irit sc $(SYMS)\
lib $(LIBS) $(MORELIBS) $(MATHLIB) lib:scnb.lib

irit2dxf:	$(IRIT2DXF_OBJS)
	slink from lib:c.o $(IRIT2DXF_OBJS) to irit2dxf sc $(SYMS)\
lib $(LIBS) $(MORELIBS) $(MATHLIB) lib:scnb.lib

irit2scn:	$(IRIT2SCN_OBJS)
	slink from lib:c.o $(IRIT2SCN_OBJS) to irit2scn sc $(SYMS)\
lib $(LIBS) $(MORELIBS) $(MATHLIB) lib:scnb.lib

irit2plg:	$(IRIT2PLG_OBJS)
	slink from lib:c.o $(IRIT2PLG_OBJS) to irit2plg sc $(SYMS)\
lib $(LIBS) $(MORELIBS) $(MATHLIB) lib:scnb.lib

irit2iv:	$(IRIT2IV_OBJS)
	slink from lib:c.o $(IRIT2IV_OBJS) to irit2iv sc $(SYMS)\
lib $(LIBS) $(MORELIBS) $(MATHLIB) lib:scnb.lib

dat2bin:	$(DAT2BIN_OBJS)
	slink from lib:c.o $(DAT2BIN_OBJS) to dat2bin sc $(SYMS)\
lib $(LIBS) $(MORELIBS) $(MATHLIB) lib:scnb.lib

obj2irit:	$(OBJ2IRIT_OBJS)
	slink from lib:c.o $(OBJ2IRIT_OBJS) to obj2irit sc $(SYMS)\
lib $(LIBS) $(MORELIBS) $(MATHLIB) lib:scnb.lib

skeletn1:	$(SKELETN1_OBJS)
	slink from lib:c.o $(SKELETN1_OBJS) to skeletn1 sc $(SYMS)\
lib $(LIBS) $(MORELIBS) $(MATHLIB) lib:scnb.lib

install: all
	mv -f $(ALL_EXE) $(BIN_DIR)


# DO NOT DELETE THIS LINE -- make depend depends on it.

dat2bin.o: ../include/irit_sm.h ../include/iritprsr.h ../include/cagd_lib.h
dat2bin.o: ../include/imalloc.h ../include/miscattr.h ../include/genmat.h
dat2bin.o: ../include/symb_lib.h ../include/trim_lib.h ../include/triv_lib.h
dat2bin.o: ../include/attribut.h ../include/allocate.h ../include/iritgrap.h
dat2bin.o: ../include/getarg.h ffcnvrt.h ../include/ip_cnvrt.h
dat2irit.o: ../include/irit_sm.h ../include/iritprsr.h ../include/cagd_lib.h
dat2irit.o: ../include/imalloc.h ../include/miscattr.h ../include/genmat.h
dat2irit.o: ../include/symb_lib.h ../include/trim_lib.h ../include/triv_lib.h
dat2irit.o: ../include/attribut.h ../include/getarg.h
dxf2irit.o: ../include/irit_sm.h ../include/iritprsr.h ../include/cagd_lib.h
dxf2irit.o: ../include/imalloc.h ../include/miscattr.h ../include/genmat.h
dxf2irit.o: ../include/symb_lib.h ../include/trim_lib.h ../include/triv_lib.h
dxf2irit.o: ../include/allocate.h ../include/attribut.h ../include/getarg.h
ffcnvrt.o: ../include/irit_sm.h ../include/iritprsr.h ../include/cagd_lib.h
ffcnvrt.o: ../include/imalloc.h ../include/miscattr.h ../include/genmat.h
ffcnvrt.o: ../include/symb_lib.h ../include/trim_lib.h ../include/triv_lib.h
ffcnvrt.o: ../include/allocate.h ffcnvrt.h ../include/attribut.h
ffcnvrt.o: ../include/ip_cnvrt.h
irit2dxf.o: ../include/irit_sm.h ../include/iritprsr.h ../include/cagd_lib.h
irit2dxf.o: ../include/imalloc.h ../include/miscattr.h ../include/genmat.h
irit2dxf.o: ../include/symb_lib.h ../include/trim_lib.h ../include/triv_lib.h
irit2dxf.o: ../include/allocate.h ../include/attribut.h ../include/iritgrap.h
irit2dxf.o: ../include/getarg.h ffcnvrt.h ../include/ip_cnvrt.h
irit2iv.o: ../include/irit_sm.h ../include/iritprsr.h ../include/cagd_lib.h
irit2iv.o: ../include/imalloc.h ../include/miscattr.h ../include/genmat.h
irit2iv.o: ../include/symb_lib.h ../include/trim_lib.h ../include/triv_lib.h
irit2iv.o: ../include/allocate.h ../include/attribut.h ../include/iritgrap.h
irit2iv.o: ../include/geomat3d.h ../include/getarg.h ffcnvrt.h
irit2iv.o: ../include/ip_cnvrt.h
irit2nff.o: ../include/irit_sm.h ../include/iritprsr.h ../include/cagd_lib.h
irit2nff.o: ../include/imalloc.h ../include/miscattr.h ../include/genmat.h
irit2nff.o: ../include/symb_lib.h ../include/trim_lib.h ../include/triv_lib.h
irit2nff.o: ../include/allocate.h ../include/attribut.h ../include/iritgrap.h
irit2nff.o: ../include/getarg.h ffcnvrt.h ../include/ip_cnvrt.h
irit2plg.o: ../include/irit_sm.h ../include/iritprsr.h ../include/cagd_lib.h
irit2plg.o: ../include/imalloc.h ../include/miscattr.h ../include/genmat.h
irit2plg.o: ../include/symb_lib.h ../include/trim_lib.h ../include/triv_lib.h
irit2plg.o: ../include/allocate.h ../include/attribut.h ../include/iritgrap.h
irit2plg.o: ../include/getarg.h ffcnvrt.h ../include/ip_cnvrt.h
irit2ps.o: ../include/irit_sm.h ../include/iritprsr.h ../include/cagd_lib.h
irit2ps.o: ../include/imalloc.h ../include/miscattr.h ../include/genmat.h
irit2ps.o: ../include/symb_lib.h ../include/trim_lib.h ../include/triv_lib.h
irit2ps.o: ../include/allocate.h ../include/attribut.h ../include/iritgrap.h
irit2ps.o: ../include/geomat3d.h ../include/getarg.h ../include/bbox.h
irit2ps.o: ffcnvrt.h ../include/ip_cnvrt.h
irit2ray.o: ../include/irit_sm.h ../include/iritprsr.h ../include/cagd_lib.h
irit2ray.o: ../include/imalloc.h ../include/miscattr.h ../include/genmat.h
irit2ray.o: ../include/symb_lib.h ../include/trim_lib.h ../include/triv_lib.h
irit2ray.o: ../include/allocate.h ../include/attribut.h ../include/iritgrap.h
irit2ray.o: ../include/getarg.h ffcnvrt.h ../include/ip_cnvrt.h
irit2scn.o: ../include/irit_sm.h ../include/iritprsr.h ../include/cagd_lib.h
irit2scn.o: ../include/imalloc.h ../include/miscattr.h ../include/genmat.h
irit2scn.o: ../include/symb_lib.h ../include/trim_lib.h ../include/triv_lib.h
irit2scn.o: ../include/allocate.h ../include/attribut.h ../include/iritgrap.h
irit2scn.o: ../include/getarg.h ffcnvrt.h ../include/ip_cnvrt.h
irit2xfg.o: ../include/irit_sm.h ../include/iritprsr.h ../include/cagd_lib.h
irit2xfg.o: ../include/imalloc.h ../include/miscattr.h ../include/genmat.h
irit2xfg.o: ../include/symb_lib.h ../include/trim_lib.h ../include/triv_lib.h
irit2xfg.o: ../include/allocate.h ../include/attribut.h ../include/iritgrap.h
irit2xfg.o: ../include/getarg.h ffcnvrt.h
skeletn1.o: ../include/irit_sm.h ../include/iritprsr.h ../include/cagd_lib.h
skeletn1.o: ../include/imalloc.h ../include/miscattr.h ../include/genmat.h
skeletn1.o: ../include/symb_lib.h ../include/trim_lib.h ../include/triv_lib.h
skeletn1.o: ../include/attribut.h ../include/allocate.h ../include/iritgrap.h
skeletn1.o: ../include/getarg.h ffcnvrt.h ../include/ip_cnvrt.h
