#include "irit_sm.h"
#include "allocate.h"
#include "iritprsr.h"
#include "geomat3d.h"
#include "genmat.h"
#include "getarg.h"

static char *CtrlStr =
#ifdef DOUBLE
    "Transfrm x%-Degs!F y%-Degs!F z%-Degs!F t%-X|Y|Z!F!F!F s%-Scale!F h%- DFiles!*s";
#else
    "Transfrm x%-Degs!f y%-Degs!f z%-Degs!f t%-X|Y|Z!f!f!f s%-Scale!f h%- DFiles!*s";
#endif /* DOUBLE */

void main(int argc, char **argv)
{
    int NumFiles, Error,
	RotXFlag = FALSE,
	RotYFlag = FALSE,
	RotZFlag = FALSE,
	TransFlag = FALSE,
	ScaleFlag = FALSE,
	HelpFlag = FALSE;
    char **FileNames;
    RealType RotXDegrees, RotYDegrees, RotZDegrees, TransX, TransY, TransZ,
	Scale;
    MatrixType Mat1, TransMat;
    IPObjectStruct *PObjs, *PObjsTrans, *PObj;

    if ((Error = GAGetArgs(argc, argv, CtrlStr,
			   &RotXFlag, &RotXDegrees,
			   &RotYFlag, &RotYDegrees,
			   &RotZFlag, &RotZDegrees,
			   &TransFlag, &TransX, &TransY, &TransZ,
			   &ScaleFlag, &Scale,
			   &HelpFlag,
			   &NumFiles, &FileNames)) != 0) {
	GAPrintErrMsg(Error);
	GAPrintHowTo(CtrlStr);
	exit(1);
    }

    if (HelpFlag) {
	fprintf(stderr, "This is Transform...\n");
	GAPrintHowTo(CtrlStr);
	exit(0);
    }

    if (NumFiles == 0) {
	fprintf(stderr, "No data files to process.\n");
	exit(2);
    }

    /* Construct the transformation matrix: */
    MatGenUnitMat(TransMat);
    if (RotXFlag) {
	MatGenMatRotX1(DEG2RAD(RotXDegrees), Mat1);
	MatMultTwo4by4(TransMat, TransMat, Mat1);
    }
    if (RotYFlag) {
	MatGenMatRotY1(DEG2RAD(RotYDegrees), Mat1);
	MatMultTwo4by4(TransMat, TransMat, Mat1);
    }
    if (RotZFlag) {
	MatGenMatRotZ1(DEG2RAD(RotZDegrees), Mat1);
	MatMultTwo4by4(TransMat, TransMat, Mat1);
    }
    if (TransFlag) {
	MatGenMatTrans(TransX, TransY, TransZ, Mat1);
	MatMultTwo4by4(TransMat, TransMat, Mat1);
    }
    if (ScaleFlag) {
	MatGenMatUnifScale(Scale, Mat1);
	MatMultTwo4by4(TransMat, TransMat, Mat1);
    }

    /* Get all the data from all the input files. */
    PObjs = IritPrsrGetDataFiles(FileNames, NumFiles, TRUE, TRUE);

    /* Apply the transformation to all geometry in input file(s) and dump */
    /* the transformed geometry to stdout.				  */

    PObjsTrans = GMTransformObjectList(PObjs, TransMat);
    for (PObj = PObjsTrans; PObj != NULL; PObj = PObj -> Pnext)
        IritPrsrStdoutObject(PObj);

    IPFreeObjectList(PObjs);
    IPFreeObjectList(PObjsTrans);

    exit(0);
}
