/******************************************************************************
* Cagd_loc.h - header file for the CAGD library.			      *
* This header is local to the library - it is NOT external.		      *
*******************************************************************************
* (C) Gershon Elber, Technion, Israel Institute of Technology                 *
*******************************************************************************
* Written by Gershon Elber, Mar. 90.					      *
******************************************************************************/

#ifndef CAGD_LOC_H
#define CAGD_LOC_H

#include <math.h>

#define IRIT_INFNTY 1e6

#define W 0	 /* Positions of points in Points array (see structs below). */
#define X 1
#define Y 2
#define Z 3

#include "iritprsr.h"
#include "cagd_lib.h"		     /* Include the extrenal header as well. */

typedef struct CagdSrfEvalCashStruct {
    CagdCrvStruct *IsoSubCrv;
} CagdSrfEvalCashStruct;

/* Declaration of extrenal variables local to the cagd library only. */
extern CagdLin2PolyType _CagdLin2Poly;    /* Linear srf convertion to polys. */

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

/* Declarations of functions local to the Cagd library only. */
CagdPolygonStruct *_CagdMakePolygon(CagdBType ComputeNormals,
				    CagdBType ComputeUV,
			            CagdPtStruct *Pt1,
				    CagdPtStruct *Pt2,
				    CagdPtStruct *Pt3,
				    CagdVecStruct *Nl1,
				    CagdVecStruct *Nl2,
			            CagdVecStruct *Nl3,
				    CagdUVStruct *UV1,
				    CagdUVStruct *UV2,
			            CagdUVStruct *UV3);

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

#endif /* CAGD_LOC_H */
