/*****************************************************************************
* Skeleton for an interface to a parser to read IRIT data files.	     *
*									     *
* Written by:  Gershon Elber				Ver 1.0, Feb 1993    *
*****************************************************************************/


#include <stdio.h>
#include "irit_sm.h"
#include "cagd_lib.h"
#include "symb_lib.h"
#include "iritprsr.h"
#include "attribut.h"
#include "allocate.h"

/*****************************************************************************
* DESCRIPTION:                                                               M
* Main module of skel - Read command line and do what is needed...	     M
*                                                                            *
* PARAMETERS:                                                                M
*   argc, argv:  Command line.                                               M
*                                                                            *
* RETURN VALUE:                                                              M
*   void                                                                     M
*                                                                            *
* KEYWORDS:                                                                  M
*   main                                                                     M
*****************************************************************************/
void main(int argc, char **argv)
{
    int Handler;
    IPObjectStruct *PObjects, *PObj;

    /* Get the data from the input stream: */
    if ((Handler = IritPrsrOpenStreamFromFile(stdin, TRUE,
					      FALSE, FALSE)) >= 0) {
	PObjects = IritPrsrGetObjects(Handler);
	IritPrsrCloseStream(Handler, TRUE);
    }
    else
        exit(1);

    /* Print the read geometry to stdout. */
    for (PObj = PObjects; PObj != NULL; PObj = PObj -> Pnext)
	IritPrsrStdoutObject(PObj);

    /* Do some symbolic manipulation of curves: */
    for (PObj = PObjects; PObj != NULL; PObj = PObj -> Pnext) {
	if (IP_IS_CRV_OBJ(PObj)) {
	    char *Err;
	    CagdCrvStruct
	        *DerivCrv = CagdCrvDerive(PObj -> U.Crvs),
		*DegreeRaiseCrv = CagdCrvDegreeRaise(PObj -> U.Crvs),
		*TanMagSqr = SymbCrvDotProd(DerivCrv, DerivCrv),
	        *DiffZero = SymbCrvSub(PObj -> U.Crvs, DegreeRaiseCrv);
	    CagdSrfStruct
	        *SrfOfRev = CagdSurfaceRev(PObj -> U.Crvs),
		*SweepSrf = CagdSweepSrf(PObj -> U.Crvs, PObj -> U.Crvs,
					 NULL, 1.0, NULL, FALSE);

	    CagdCrvWriteToFile3(DiffZero, stdout, 0, "A Zero Curve", &Err);
	    CagdCrvWriteToFile3(TanMagSqr, stdout, 0,
				"Magnitude of Tangent Square", &Err);
	    CagdCrvFree(DiffZero);
	    CagdCrvFree(TanMagSqr);
	    CagdCrvFree(DegreeRaiseCrv);

	    CagdSrfWriteToFile3(SrfOfRev, stdout, 0, "A Surface of revolution",
				&Err);
	    CagdSrfWriteToFile3(SweepSrf, stdout, 0, "A Sweep Surface",
				&Err);

	    CagdSrfFree(SrfOfRev);
	    CagdSrfFree(SweepSrf);
	}
    }
}
