#include <stdio.h>
#include "vogle.h"

/*
 * This should match the Pascal type 'varying [n] of char'
 */

typedef struct {
	int	n;
	char	s[1];	/* SO compiler doesn't bitch about zero length */
} Vstring;

#define COPYANDTERMINATE(buf, s, l)	strncpy(buf, s, l); buf[l] = '\0';

/*
 * Font
 */
void
Font(s)
	Vstring	s;
{
	char	*p = (char *)s.s;
	char	buf[BUFSIZ];

	COPYANDTERMINATE(buf, p, s.n);
	font(buf);
}

/*
 * TextSize
 */
void
TextSize(width, height)
	float	width, height;
{
	textsize(width, height);
}

/*
 * BoxText
 */
BoxText(x, y, l, h, s)
	float	x, y, l, h;
	Vstring	s;
{
	char	*p = (char *)s.s;
	char	buf[BUFSIZ];

	COPYANDTERMINATE(buf, p, s.n);
	boxtext(x, y, l, h, buf);
}

/*
 * BoxFit
 */
BoxFit(l, h, nchars)
	float	l, h;
	int	nchars;
{
	boxfit(l, h, nchars);
}

/*
 * TextAng
 */
void
TextAng(ang)
	float	ang;
{
	textang(ang);
}

/*
 * DrawChar
 */
DrawChar(s)
	char	s;
{
	drawchar(s);
}

/*
 * DrawStr
 */
DrawStr(s)
	Vstring	s;
{
	char	*p = (char *)s.s;
	char	buf[BUFSIZ];

	COPYANDTERMINATE(buf, p, s.n);
	drawstr(buf);
}

/*
 * GetFontSize
 */
void
GetFontSize(cw, ch)
	double 	*cw, *ch;
{
	getfontsize(cw, ch);
}

/*
 * GetCharSize
 */
void
GetCharSize(c, cw, ch)
	char	c;
	double 	*cw, *ch;
{
	getcharsize(c, cw, ch);
}

/*
 * FixedWidth
 */
void
FixedWidth(i)
	int	i;
{
	fixedwidth(i);
}

/*
 * CenterText
 */
void
CenterText(i)
	int	i;
{
	centertext(i);
}

/*
 * TextJustify
 */
void
TextJustify(i)
	int	i;
{
	textjustify(i);
}

/*
 * LeftJustify
 */
void
LeftJustify()
{
	leftjustify();
}

/*
 * RightJustify
 */
void
RightJustify()
{
	rightjustify();
}

/*
 * TopJustify
 */
void
TopJustify()
{
	topjustify();
}

/*
 * BottomJustify
 */
void
BottomJustify()
{
	bottomjustify();
}

/*
 * XcenterText
 */
void
XcenterText()
{
	xcentertext();
}

/*
 * YcenterText
 */
void
YcenterText()
{
	ycentertext();
}

/*
 * NumChars
 */
int
NumChars()
{
	return(numchars());
}

/*
 * StrLength
 */
float
StrLength(s)
	Vstring	s;
{
	char	*p = (char *)s.s;
	char	buf[BUFSIZ];

	COPYANDTERMINATE(buf, p, s.n);
	return(strlength(buf));
}
