/*******************************************************************************

			Optimized Bitmap Scaling Routines
				by Dale Schumacher

*******************************************************************************/

typedef struct {
	int		xsize;		/* length of each scanline in pixels */
	int		ysize;		/* number of scanlines in the image */
	int		yspan;		/* byte offset between scanlines */
	unsigned char *	data;		/* pointer to bitmap data */
} Bitmap;

static unsigned char
redux_6_of_8[256] = {
0x00,0x01,0x02,0x03,0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x04,0x05,0x06,0x07,
0x08,0x09,0x0a,0x0b,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,0x0c,0x0d,0x0e,0x0f,
0x10,0x11,0x12,0x13,0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x14,0x15,0x16,0x17,
0x18,0x19,0x1a,0x1b,0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,0x1c,0x1d,0x1e,0x1f,
0x00,0x01,0x02,0x03,0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x04,0x05,0x06,0x07,
0x08,0x09,0x0a,0x0b,0x08,0x09,0x0a,0x0b,0x0c,0x0d,0x0e,0x0f,0x0c,0x0d,0x0e,0x0f,
0x10,0x11,0x12,0x13,0x10,0x11,0x12,0x13,0x14,0x15,0x16,0x17,0x14,0x15,0x16,0x17,
0x18,0x19,0x1a,0x1b,0x18,0x19,0x1a,0x1b,0x1c,0x1d,0x1e,0x1f,0x1c,0x1d,0x1e,0x1f,
0x20,0x21,0x22,0x23,0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x24,0x25,0x26,0x27,
0x28,0x29,0x2a,0x2b,0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,0x2c,0x2d,0x2e,0x2f,
0x30,0x31,0x32,0x33,0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x34,0x35,0x36,0x37,
0x38,0x39,0x3a,0x3b,0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,0x3c,0x3d,0x3e,0x3f,
0x20,0x21,0x22,0x23,0x20,0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x24,0x25,0x26,0x27,
0x28,0x29,0x2a,0x2b,0x28,0x29,0x2a,0x2b,0x2c,0x2d,0x2e,0x2f,0x2c,0x2d,0x2e,0x2f,
0x30,0x31,0x32,0x33,0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x34,0x35,0x36,0x37,
0x38,0x39,0x3a,0x3b,0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f,0x3c,0x3d,0x3e,0x3f
};

void
scale_bitmap_6_of_8(dst, src)
Bitmap *dst, *src;
{
	register int bitbuf = 0, bits;
	register int x, y, j, xbytes;
	unsigned char *p, *pp, *q, *qq;

	xbytes = src->xsize / 8;
	qq = src->data;
	pp = dst->data;
	for(y = 0; y < src->ysize; ++y) {
		bits = 0;
		p = pp;
		q = qq;
		qq += src->yspan;
		j = y & 0x03;
		if(j == 2) {
			continue;	/* skip scanline */
		}
		pp += dst->yspan;
		for(x = 0; x < xbytes; ++x) {
			bitbuf <<= 6;
			bitbuf |= redux_6_of_8[*q++];
			bits += 6;
			if(bits >= 8) {
				*p++ = bitbuf >> (bits - 8);
				bits -= 8;
			}
		}
	}
}

static unsigned char
redux_3_of_8[256] = {
0x00,0x00,0x00,0x01,0x00,0x01,0x01,0x01,0x00,0x01,0x00,0x01,0x02,0x03,0x03,0x03,
0x00,0x00,0x00,0x01,0x02,0x03,0x03,0x03,0x02,0x03,0x02,0x03,0x02,0x03,0x03,0x03,
0x00,0x00,0x00,0x01,0x00,0x01,0x01,0x01,0x02,0x03,0x02,0x03,0x02,0x03,0x03,0x03,
0x02,0x02,0x02,0x03,0x02,0x03,0x03,0x03,0x02,0x03,0x02,0x03,0x02,0x03,0x03,0x03,
0x00,0x00,0x00,0x01,0x00,0x01,0x01,0x01,0x00,0x01,0x00,0x01,0x02,0x03,0x03,0x03,
0x04,0x04,0x04,0x05,0x06,0x07,0x07,0x07,0x06,0x07,0x06,0x07,0x06,0x07,0x07,0x07,
0x04,0x04,0x04,0x05,0x04,0x05,0x05,0x05,0x06,0x07,0x06,0x07,0x06,0x07,0x07,0x07,
0x06,0x06,0x06,0x07,0x06,0x07,0x07,0x07,0x06,0x07,0x06,0x07,0x06,0x07,0x07,0x07,
0x00,0x00,0x00,0x01,0x00,0x01,0x01,0x01,0x00,0x01,0x00,0x01,0x02,0x03,0x03,0x03,
0x00,0x00,0x00,0x01,0x02,0x03,0x03,0x03,0x02,0x03,0x02,0x03,0x02,0x03,0x03,0x03,
0x04,0x04,0x04,0x05,0x04,0x05,0x05,0x05,0x06,0x07,0x06,0x07,0x06,0x07,0x07,0x07,
0x06,0x06,0x06,0x07,0x06,0x07,0x07,0x07,0x06,0x07,0x06,0x07,0x06,0x07,0x07,0x07,
0x04,0x04,0x04,0x05,0x04,0x05,0x05,0x05,0x04,0x05,0x04,0x05,0x06,0x07,0x07,0x07,
0x04,0x04,0x04,0x05,0x06,0x07,0x07,0x07,0x06,0x07,0x06,0x07,0x06,0x07,0x07,0x07,
0x04,0x04,0x04,0x05,0x04,0x05,0x05,0x05,0x06,0x07,0x06,0x07,0x06,0x07,0x07,0x07,
0x06,0x06,0x06,0x07,0x06,0x07,0x07,0x07,0x06,0x07,0x06,0x07,0x06,0x07,0x07,0x07
};

void
scale_bitmap_3_of_8(dst, src)
Bitmap *dst, *src;
{
	register int bitbuf = 0, bits;
	register int x, y, j, xbytes;
	unsigned char *p, *pp, *q, *qq;

	xbytes = src->xsize / 8;
	qq = src->data;
	pp = dst->data;
	for(y = 0; y < src->ysize; ++y) {
		bits = 0;
		p = pp;
		q = qq;
		qq += src->yspan;
		j = y & 7;
		if(!((j == 1) || (j == 4) || (j == 7))) {
			continue;	/* skip scanline */
		}
		pp += dst->yspan;
		for(x = 0; x < xbytes; ++x) {
			bitbuf <<= 3;
			bitbuf |= redux_3_of_8[*q++];
			bits += 3;
			if(bits >= 8) {
				*p++ = bitbuf >> (bits - 8);
				bits -= 8;
			}
		}
	}
}

static unsigned short redux_7_of_16[0x10000];

void
scale_bitmap_7_of_16(dst, src)
Bitmap *dst, *src;
{
	static init_flag = 0;
	register long bitbuf = 0;
	register int bits;
	register int x, y, i, j, xwords;
	unsigned char *pp, *qq;
	unsigned short *dp, *dq;

	if(init_flag == 0) {	/* compute table at run time, but only once! */
#define	BIT(b)	((i >> (b)) & 1)	/* extract bit 'b' from int 'i' */
		for(i = 0; i < 0x10000; ++i) {
			redux_7_of_16[i] = (BIT(14) << 6)
					 | (BIT(12) << 5)
					 | (BIT(10) << 4)
					 | ((BIT(8) | BIT(7)) << 3)
					 | (BIT(5) << 2)
					 | (BIT(3) << 1)
					 | (BIT(1) | BIT(0));
		}
		init_flag = 1;
#undef BIT
	}
	xwords = src->xsize / 16;
	qq = src->data;
	pp = dst->data;
	for(y = 0; y < src->ysize; ++y) {
		bits = 0;
		dp = (unsigned short *)pp;
		dq = (unsigned short *)qq;
		qq += src->yspan;
		j = y & 0xF;
		if(!(j==1||j==3||j==5||j==8||j==10||j==12||j==14)) {
			continue;	/* skip scanline */
		}
		pp += dst->yspan;
		for(x = 0; x < xwords; ++x) {
			bitbuf <<= 7;
			bitbuf |= redux_7_of_16[*dq++];
			bits += 7;
			if(bits >= 16) {
				*dp++ = bitbuf >> (bits - 16);
				bits -= 16;
			}
		}
	}
}

static unsigned char
bit_reverse_byte[256] = {
0x00,0x80,0x40,0xc0,0x20,0xa0,0x60,0xe0,0x10,0x90,0x50,0xd0,0x30,0xb0,0x70,0xf0,
0x08,0x88,0x48,0xc8,0x28,0xa8,0x68,0xe8,0x18,0x98,0x58,0xd8,0x38,0xb8,0x78,0xf8,
0x04,0x84,0x44,0xc4,0x24,0xa4,0x64,0xe4,0x14,0x94,0x54,0xd4,0x34,0xb4,0x74,0xf4,
0x0c,0x8c,0x4c,0xcc,0x2c,0xac,0x6c,0xec,0x1c,0x9c,0x5c,0xdc,0x3c,0xbc,0x7c,0xfc,
0x02,0x82,0x42,0xc2,0x22,0xa2,0x62,0xe2,0x12,0x92,0x52,0xd2,0x32,0xb2,0x72,0xf2,
0x0a,0x8a,0x4a,0xca,0x2a,0xaa,0x6a,0xea,0x1a,0x9a,0x5a,0xda,0x3a,0xba,0x7a,0xfa,
0x06,0x86,0x46,0xc6,0x26,0xa6,0x66,0xe6,0x16,0x96,0x56,0xd6,0x36,0xb6,0x76,0xf6,
0x0e,0x8e,0x4e,0xce,0x2e,0xae,0x6e,0xee,0x1e,0x9e,0x5e,0xde,0x3e,0xbe,0x7e,0xfe,
0x01,0x81,0x41,0xc1,0x21,0xa1,0x61,0xe1,0x11,0x91,0x51,0xd1,0x31,0xb1,0x71,0xf1,
0x09,0x89,0x49,0xc9,0x29,0xa9,0x69,0xe9,0x19,0x99,0x59,0xd9,0x39,0xb9,0x79,0xf9,
0x05,0x85,0x45,0xc5,0x25,0xa5,0x65,0xe5,0x15,0x95,0x55,0xd5,0x35,0xb5,0x75,0xf5,
0x0d,0x8d,0x4d,0xcd,0x2d,0xad,0x6d,0xed,0x1d,0x9d,0x5d,0xdd,0x3d,0xbd,0x7d,0xfd,
0x03,0x83,0x43,0xc3,0x23,0xa3,0x63,0xe3,0x13,0x93,0x53,0xd3,0x33,0xb3,0x73,0xf3,
0x0b,0x8b,0x4b,0xcb,0x2b,0xab,0x6b,0xeb,0x1b,0x9b,0x5b,0xdb,0x3b,0xbb,0x7b,0xfb,
0x07,0x87,0x47,0xc7,0x27,0xa7,0x67,0xe7,0x17,0x97,0x57,0xd7,0x37,0xb7,0x77,0xf7,
0x0f,0x8f,0x4f,0xcf,0x2f,0xaf,0x6f,0xef,0x1f,0x9f,0x5f,0xdf,0x3f,0xbf,0x7f,0xff
};

void
rotate_bitmap_180(dst, src)
Bitmap *dst, *src;
{
	register int x, y, xbytes;
	unsigned char *p, *pp, *q, *qq;

	xbytes = src->xsize / 8;
	qq = dst->data;
	pp = src->data;
	pp += (src->yspan * src->ysize);
	for(y = 0; y < src->ysize; ++y) {
		q = qq;
		qq += dst->yspan;
		pp -= src->yspan;
		p = pp + xbytes;
		for(x = 0; x < xbytes; ++x) {
			*q++ = bit_reverse_byte[*--p];
		}
	}
}
