/****************************************************************/
/**                       dislin_r.c                           **/
/**                                                            **/
/** Dislin interface for R.                                    **/
/**                                                            **/
/** Date     : 15.03.2022                                      **/
/** Version  : 11.5 / Unix, Windows, 32- and 64-bit            **/
/****************************************************************/


#include <stdio.h>
#include <stdlib.h>
#include <R.h>
#include <Rdefines.h>
#include <Rinternals.h>
#include "dislin_d.h"

#define MAX_CB 200
 
static double *qqtmat  (double *zmat, int n, int m);
static int    *qqitmat (int *izmat, int n, int m);
static double *qqtmat3 (double *zmat, int nx, int ny, int nz);
static long   *qqlong  (int *iray, int n);
static const char *qqcptr  (SEXP chars);

double SurfcpCB (double x, double y, int iopt); 
double SurfunCB (double x, double y); 
void   SwgcbkCB (int id); 
void   Swgcb2CB (int id, int irow, int icol); 
void   Swgcb3CB (int id, int ival); 
void   WincbkCB (int id, int i1, int i2, int i3, int i4); 

static SEXP SurfcpSEXP, SurfunSEXP, WincbkSEXP, SwgcbkSEXP[MAX_CB];
static int icbray[MAX_CB];
static int ncbray = 0;
static int imgop = 0;

SEXP abs3pt_r (SEXP x, SEXP y, SEXP z)
{ double xp, yp;
  SEXP vec;

  abs3pt (asReal (x), asReal (y), asReal (z), &xp, &yp);
  PROTECT (vec = allocVector (REALSXP, 2));
  REAL (vec)[0] = xp;
  REAL (vec)[1] = yp;
  UNPROTECT (1);
  return vec;
}

SEXP  addlab_r (SEXP s1, SEXP x, SEXP itic, SEXP s2)
{ addlab (qqcptr (s1), asReal (x), asInteger (itic), qqcptr (s2));
  return R_NilValue;
}

SEXP angle_r (SEXP n)
{ angle (asInteger (n));
  return R_NilValue;
}

SEXP arcell_r (SEXP i1, SEXP i2, SEXP i3, SEXP i4, SEXP x1, SEXP x2, SEXP x3)
{ arcell (asInteger (i1), asInteger (i2), asInteger (i3), asInteger (i4), 
          asReal (x1), asReal (x2), asReal (x3));
  return R_NilValue;
}  

SEXP areaf_r (SEXP nxray, SEXP nyray, SEXP n)
{ areaf (INTEGER (nxray), INTEGER (nyray), asInteger (n));
  return R_NilValue;
}

SEXP autres_r (SEXP i1, SEXP i2)
{ autres (asInteger (i1), asInteger (i2));
  return R_NilValue;
}

SEXP autres3d_r (SEXP i1, SEXP i2, SEXP i3)
{ autres3d (asInteger (i1), asInteger (i2), asInteger (i3));
  return R_NilValue;
}

SEXP ax2grf_r ()
{ ax2grf ();
  return R_NilValue;
}

SEXP ax3len_r (SEXP i1, SEXP i2, SEXP i3)
{ ax3len (asInteger (i1), asInteger (i2), asInteger (i3));
  return R_NilValue;
}

SEXP axclrs_r (SEXP n, SEXP s1, SEXP s2)
{ axclrs (asInteger (n), qqcptr (s1), qqcptr (s2));
  return R_NilValue;
}

SEXP axends_r (SEXP s1, SEXP s2)
{ axends (qqcptr (s1), qqcptr (s2));
  return R_NilValue;
}

SEXP axgit_r ()
{ axgit ();
  return R_NilValue;
}

SEXP axis3d_r (SEXP x1, SEXP x2, SEXP x3)
{ axis3d (asReal (x1), asReal (x2), asReal (x3));
  return R_NilValue;
}

SEXP axsbgd_r (SEXP n)
{ axsbgd (asInteger (n));
  return R_NilValue;
}

SEXP axsers_r ()
{ axsers ();
  return R_NilValue;
}

SEXP axslen_r (SEXP i1, SEXP i2)
{ axslen (asInteger (i1), asInteger (i2));
  return R_NilValue;
}

SEXP axsorg_r (SEXP i1, SEXP i2)
{ axsorg (asInteger (i1), asInteger (i2));
  return R_NilValue;
}

SEXP axspos_r (SEXP i1, SEXP i2)
{ axspos (asInteger (i1), asInteger (i2));
  return R_NilValue;
}

SEXP axsscl_r (SEXP s1, SEXP s2)
{ axsscl (qqcptr (s1), qqcptr (s2));
  return R_NilValue;
}

SEXP axstyp_r (SEXP s)
{ axstyp (qqcptr (s));
  return R_NilValue;
}

SEXP barbor_r (SEXP n)
{ barbor (asInteger (n));
  return R_NilValue;
}

SEXP barclr_r (SEXP i1, SEXP i2, SEXP i3)
{ barclr (asInteger (i1), asInteger (i2), asInteger (i3));
  return R_NilValue;
}

SEXP bargrp_r (SEXP n, SEXP x)
{ bargrp (asInteger (n), asReal (x));
  return R_NilValue;
}

SEXP barmod_r (SEXP s1, SEXP s2)
{ barmod (qqcptr (s1), qqcptr (s2));
  return R_NilValue;
}

SEXP baropt_r (SEXP x1, SEXP x2)
{ baropt (asReal (x1), asReal (x2));
  return R_NilValue;
}

SEXP barpos_r (SEXP s)
{ barpos (qqcptr (s));
  return R_NilValue;
}

SEXP bars_r (SEXP xray, SEXP y1ray, SEXP y2ray, SEXP n)
{ bars (REAL (xray), REAL (y1ray), REAL (y2ray), asInteger (n));
  return R_NilValue;
}

SEXP bars3d_r (SEXP xray, SEXP yray, SEXP z1ray, SEXP z2ray, SEXP xwray,
               SEXP ywray, SEXP icray, SEXP n)
{ bars3d (REAL (xray), REAL (yray), REAL (z1ray), REAL (z2ray), REAL (xwray),
          REAL (ywray), INTEGER (icray), asInteger (n));
  return R_NilValue;
}

SEXP bartyp_r (SEXP s)
{ bartyp (qqcptr (s));
  return R_NilValue;
}

SEXP barwth_r (SEXP x)
{ barwth (asReal (x));
  return R_NilValue;
}

SEXP basalf_r (SEXP s)
{ basalf (qqcptr (s));
  return R_NilValue;
}

SEXP basdat_r (SEXP i1, SEXP i2, SEXP i3)
{ basdat (asInteger (i1), asInteger (i2), asInteger (i3));
  return R_NilValue;
}

SEXP bezier_r (SEXP xray, SEXP yray, SEXP n1, SEXP xpray, SEXP ypray, SEXP n2)
{ bezier (REAL (xray), REAL (yray), asInteger (n2),
          REAL (xpray), REAL (ypray), asInteger (n2));
  return R_NilValue;
}

SEXP bitsi4_r (SEXP i1, SEXP i2, SEXP i3, SEXP i4, SEXP i5)
{ int n;
  SEXP vec; 
  n = bitsi4 (asInteger (i1), asInteger (i2), asInteger (i3), asInteger (i4),
              asInteger (i5));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP bmpfnt_r (SEXP s)
{ bmpfnt (qqcptr (s));
  return R_NilValue;
}

SEXP bmpmod_r (SEXP n, SEXP s1, SEXP s2)
{ bmpmod (asInteger (n), qqcptr (s1), qqcptr (s2));
  return R_NilValue;
}

SEXP box2d_r ()
{ box2d ();
  return R_NilValue;
}

SEXP box3d_r ()
{ box3d ();
  return R_NilValue;
}

SEXP bufmod_r (SEXP s1, SEXP s2)
{ bufmod (qqcptr (s1), qqcptr (s2));
  return R_NilValue;
}

SEXP center_r ()
{ center ();
  return R_NilValue;
}

SEXP cgmbgd_r (SEXP x1, SEXP x2, SEXP x3)
{ cgmbgd (asReal (x1), asReal (x2), asReal (x3));
  return R_NilValue;
}

SEXP cgmpic_r (SEXP s)
{ cgmpic (qqcptr (s));
  return R_NilValue;
}

SEXP cgmver_r (SEXP n)
{ cgmver (asInteger (n));
  return R_NilValue;
}

SEXP chaang_r (SEXP x)
{ chaang (asReal (x));
  return R_NilValue;
}

SEXP chacod_r (SEXP s)
{ chacod (qqcptr (s));
  return R_NilValue;
}

SEXP chaspc_r (SEXP x)
{ chaspc (asReal (x));
  return R_NilValue;
}

SEXP chawth_r (SEXP x)
{ chawth (asReal (x));
  return R_NilValue;
}

SEXP chnatt_r ()
{ chnatt ();
  return R_NilValue;
}

SEXP chncrv_r (SEXP s)
{ chncrv (qqcptr (s));
  return R_NilValue;
}

SEXP chndot_r ()
{ chndot ();
  return R_NilValue;
}

SEXP chndsh_r ()
{ chndsh ();
  return R_NilValue;
}

SEXP chnbar_r (SEXP s)
{ chnbar (qqcptr (s));
  return R_NilValue;
}

SEXP chnpie_r (SEXP s)
{ chnpie (qqcptr (s));
  return R_NilValue;
}

SEXP circ3p_r (SEXP x1, SEXP x2, SEXP x3, SEXP x4, SEXP x5, SEXP x6)
{ double x7, x8, x9;
  SEXP vec;

  circ3p (asReal (x1), asReal (x2), asReal (x3), asReal (x4), 
          asReal (x5), asReal (x6), &x7, &x8, &x9);
  PROTECT (vec = allocVector (REALSXP, 3));
  REAL (vec)[0] = x7;
  REAL (vec)[1] = x8;
  REAL (vec)[2] = x9;
  UNPROTECT (1);
  return vec;
}

SEXP circle_r (SEXP i1, SEXP i2, SEXP i3)
{ circle (asInteger (i1), asInteger (i2), asInteger (i3));
  return R_NilValue;
}

SEXP circsp_r (SEXP n)
{ circsp (asInteger (n));
  return R_NilValue;
}

SEXP clip3d_r (SEXP s)
{ clip3d (qqcptr (s));
  return R_NilValue;
}

SEXP closfl_r (SEXP i)
{ int n;
  SEXP vec; 
  n = closfl (asInteger (i));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP clpbor_r (SEXP s)
{ clpbor (qqcptr (s));
  return R_NilValue;
}

SEXP clpmod_r (SEXP s)
{ clpmod (qqcptr (s));
  return R_NilValue;
}

SEXP clpwin_r (SEXP i1, SEXP i2, SEXP i3, SEXP i4)
{ clpwin (asInteger (i1), asInteger (i2), asInteger (i3), asInteger (i4));
  return R_NilValue;
}

SEXP clrcyc_r (SEXP i1, SEXP i2)
{ clrcyc (asInteger (i1), asInteger (i2));
  return R_NilValue;
}

SEXP clrmod_r (SEXP s)
{ clrmod (qqcptr (s));
  return R_NilValue;
}

SEXP clswin_r (SEXP n)
{ clswin (asInteger (n));
  return R_NilValue;
}

SEXP color_r (SEXP s)
{ color (qqcptr (s));
  return R_NilValue;
}

SEXP colran_r (SEXP i1, SEXP i2)
{ colran (asInteger (i1), asInteger (i2));
  return R_NilValue;
}

SEXP colray_r (SEXP zray, SEXP iray, SEXP n)
{ colray (REAL (zray), INTEGER (iray), asInteger (n));
  return R_NilValue;
}

SEXP complx_r ()
{ complx ();
  return R_NilValue;
}

SEXP conclr_r (SEXP nxray, SEXP n)
{ conclr (INTEGER (nxray), asInteger (n));
  return R_NilValue;
}

SEXP concrv_r (SEXP xray, SEXP yray, SEXP n, SEXP zlev)
{ concrv (REAL (xray), REAL (yray), asInteger (n), asReal (zlev));
  return R_NilValue;
}

SEXP cone3d_r (SEXP x1, SEXP x2, SEXP x3, SEXP x4, SEXP x5, SEXP x6, 
               SEXP i1, SEXP i2)
{ cone3d (asReal (x1), asReal (x2), asReal (x3), asReal (x4), asReal (x5), 
          asReal (x6), asInteger (i1), asInteger (i2));
  return R_NilValue;
}

SEXP confll_r (SEXP xray, SEXP yray, SEXP zray, SEXP n1, SEXP i1ray,
               SEXP i2ray, SEXP i3ray, SEXP n2, SEXP zlray, SEXP n3)
{ confll (REAL (xray), REAL (yray), REAL (zray), asInteger (n1), 
          INTEGER (i1ray), INTEGER (i2ray), INTEGER (i3ray), asInteger (n2),
          REAL (zlray), asInteger (n3));
  return R_NilValue;
}

SEXP congap_r (SEXP x)
{ congap (asReal (x));
  return R_NilValue;
}

SEXP conlab_r (SEXP s)
{ conlab (qqcptr (s));
  return R_NilValue;
}

SEXP conmat_r (SEXP zmat, SEXP nx, SEXP ny, SEXP zlev)
{ double *p;
  p = qqtmat (REAL (zmat), asInteger (nx), asInteger (ny));
  if (p != NULL)
  { conmat (p, asInteger (nx), asInteger (ny), asReal (zlev)); 
    free (p);
  }
  return R_NilValue;
}

SEXP conmod_r (SEXP x1, SEXP x2)
{ conmod (asReal (x1), asReal (x2));
  return R_NilValue;
}

SEXP conn3d_r (SEXP x, SEXP y, SEXP z)
{ conn3d (asReal (x), asReal (y), asReal (z));
  return R_NilValue;
}

SEXP connpt_r (SEXP x, SEXP y)
{ connpt (asReal (x), asReal (y));
  return R_NilValue;
}

SEXP conpts_r (SEXP xray, SEXP nx, SEXP yray, SEXP ny, SEXP zmat, SEXP zlev,
               SEXP xpts, SEXP ypts, SEXP maxpts, SEXP nray, SEXP maxray)
{ double *p;
  int n = 0;
  SEXP vec; 

  p = qqtmat (REAL (zmat), asInteger (nx), asInteger (ny));
  if (p != NULL)
  { conpts (REAL (xray), asInteger (nx), REAL (yray), asInteger (ny), p, 
            asReal (zlev), REAL (xpts), REAL (ypts), asInteger (maxpts),
            INTEGER (nray), asInteger (maxray), &n); 
    free (p);
  }
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP conshd_r (SEXP xray, SEXP nx, SEXP yray, SEXP ny, SEXP zmat, 
               SEXP zlray, SEXP n)
{ double *p;
  p = qqtmat (REAL (zmat), asInteger (nx), asInteger (ny));
  if (p != NULL)
  { conshd (REAL (xray), asInteger (nx), REAL (yray), asInteger (ny), p, 
            REAL (zlray), asInteger (n)); 
    free (p);
  }
  return R_NilValue;
}

SEXP conshd2_r (SEXP xmat, SEXP ymat, SEXP zmat, SEXP nx, SEXP ny, 
               SEXP zlray, SEXP n)
{ double *p1, *p2, *p3;
  p1 = qqtmat (REAL (xmat), asInteger (nx), asInteger (ny));
  p2 = qqtmat (REAL (ymat), asInteger (nx), asInteger (ny));
  p3 = qqtmat (REAL (zmat), asInteger (nx), asInteger (ny));
  if (p1 != NULL && p2 != NULL && p3 != NULL)
  { conshd2 (p1, p2, p3, asInteger (nx), asInteger (ny), 
             REAL (zlray), asInteger (n)); 
  }
  free (p1);
  free (p2);
  free (p3);
  return R_NilValue;
}

SEXP conshd3d_r (SEXP xray, SEXP nx, SEXP yray, SEXP ny, SEXP zmat, 
               SEXP zlray, SEXP n)
{ double *p;
  p = qqtmat (REAL (zmat), asInteger (nx), asInteger (ny));
  if (p != NULL)
  { conshd3d (REAL (xray), asInteger (nx), REAL (yray), asInteger (ny), p, 
            REAL (zlray), asInteger (n)); 
    free (p);
  }
  return R_NilValue;
}

SEXP contri_r (SEXP xray, SEXP yray, SEXP zray, SEXP n1, SEXP i1ray,
               SEXP i2ray, SEXP i3ray, SEXP n2, SEXP zlev)
{ contri (REAL (xray), REAL (yray), REAL (zray), asInteger (n1), 
          INTEGER (i1ray), INTEGER (i2ray), INTEGER (i3ray), asInteger (n2),
          asReal (zlev));
  return R_NilValue;
}

SEXP contur_r (SEXP xray, SEXP nx, SEXP yray, SEXP ny, SEXP zmat, SEXP zlev)
{ double *p;
  p = qqtmat (REAL (zmat), asInteger (nx), asInteger (ny));
  if (p != NULL)
  { contur (REAL (xray), asInteger (nx), REAL (yray), asInteger (ny), p, 
            asReal (zlev)); 
    free (p);
  }
  return R_NilValue;
}

SEXP contur2_r (SEXP xmat, SEXP ymat, SEXP zmat, SEXP nx, SEXP ny, SEXP zlev)
{ double *p1, *p2, *p3;
  p1 = qqtmat (REAL (xmat), asInteger (nx), asInteger (ny));
  p2 = qqtmat (REAL (ymat), asInteger (nx), asInteger (ny));
  p3 = qqtmat (REAL (zmat), asInteger (nx), asInteger (ny));
  if (p1 != NULL && p2 != NULL && p3 != NULL)
  { contur2 (p1, p2, p3, asInteger (nx), asInteger (ny), asReal (zlev)); 
  }
  free (p1);
  free (p2);
  free (p3);
  return R_NilValue;
}

SEXP cross_r ()
{ cross ();
  return R_NilValue;
}

SEXP crvmat_r (SEXP zmat, SEXP nx, SEXP ny, SEXP ixpts, SEXP iypts)
{ double *p;
  p = qqtmat (REAL (zmat), asInteger (nx), asInteger (ny));
  if (p != NULL)
  { crvmat (p, asInteger (nx), asInteger (ny), asInteger (ixpts), 
            asInteger (iypts));
    free (p);
  }
  return R_NilValue;
}

SEXP crvqdr_r (SEXP xray, SEXP yray, SEXP zray, SEXP n)
{ crvqdr (REAL (xray), REAL (yray), REAL (zray), asInteger (n));
  return R_NilValue;
}

SEXP crvt3d_r (SEXP xray, SEXP yray, SEXP zray, SEXP wray, SEXP iray, SEXP n)
{ crvt3d (REAL (xray), REAL (yray), REAL (zray), REAL (wray), INTEGER (iray),
          asInteger (n));
  return R_NilValue;
}

SEXP crvtri_r (SEXP xray, SEXP yray, SEXP zray, SEXP n1, SEXP i1ray,
               SEXP i2ray, SEXP i3ray, SEXP n2)
{ crvtri (REAL (xray), REAL (yray), REAL (zray), asInteger (n1), 
          INTEGER (i1ray), INTEGER (i2ray), INTEGER (i3ray), asInteger (n2));
  return R_NilValue;
}

SEXP csrkey_r ()
{ int n;
  SEXP vec; 
  n = csrkey ();
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP csrlin_r ()
{ int i1, i2, i3, i4;
  SEXP vec; 

  csrlin (&i1, &i2, &i3, &i4);
  PROTECT (vec = allocVector (INTSXP, 4));
  INTEGER (vec)[0] = i1;
  INTEGER (vec)[1] = i2;
  INTEGER (vec)[2] = i3;
  INTEGER (vec)[3] = i4;
  UNPROTECT (1);
  return vec;
}

SEXP csrmod_r (SEXP s1, SEXP s2)
{ csrmod (qqcptr (s1), qqcptr (s2));
  return R_NilValue;
}

SEXP csrpol_r (SEXP ixray, SEXP iyray, SEXP nmax)
{ int n, iret;
  SEXP vec; 

  csrpol (INTEGER (ixray), INTEGER (iyray), asInteger (nmax), &n, &iret);
  PROTECT (vec = allocVector (INTSXP, 2));
  INTEGER (vec)[0] = n;
  INTEGER (vec)[1] = iret;
  UNPROTECT (1);
  return vec;
}

SEXP csrpos_r (SEXP ix, SEXP iy)
{ int n, i1, i2;
  SEXP vec; 

  i1 = asInteger (ix);
  i2 = asInteger (iy);
  n = csrpos (&i1, &i2);
  PROTECT (vec = allocVector (INTSXP, 3));
  INTEGER (vec)[0] = i1;
  INTEGER (vec)[1] = i2;
  INTEGER (vec)[2] = n;
  UNPROTECT (1);
  return vec;
}

SEXP csrpt1_r ()
{ int i1, i2;
  SEXP vec; 

  csrpt1 (&i1, &i2);
  PROTECT (vec = allocVector (INTSXP, 2));
  INTEGER (vec)[0] = i1;
  INTEGER (vec)[1] = i2;
  UNPROTECT (1);
  return vec;
}

SEXP csrpts_r (SEXP ixray, SEXP iyray, SEXP nmax)
{ int n, iret;
  SEXP vec; 

  csrpts (INTEGER (ixray), INTEGER (iyray), asInteger (nmax), &n, &iret);
  PROTECT (vec = allocVector (INTSXP, 2));
  INTEGER (vec)[0] = n;
  INTEGER (vec)[1] = iret;
  UNPROTECT (1);
  return vec;
}

SEXP csrmov_r (SEXP ixray, SEXP iyray, SEXP nmax)
{ int n, iret;
  SEXP vec; 

  csrmov (INTEGER (ixray), INTEGER (iyray), asInteger (nmax), &n, &iret);
  PROTECT (vec = allocVector (INTSXP, 2));
  INTEGER (vec)[0] = n;
  INTEGER (vec)[1] = iret;
  UNPROTECT (1);
  return vec;
}

SEXP csrrec_r ()
{ int i1, i2, i3, i4;
  SEXP vec; 

  csrrec (&i1, &i2, &i3, &i4);
  PROTECT (vec = allocVector (INTSXP, 4));
  INTEGER (vec)[0] = i1;
  INTEGER (vec)[1] = i2;
  INTEGER (vec)[2] = i3;
  INTEGER (vec)[3] = i4;
  UNPROTECT (1);
  return vec;
}

SEXP csrtyp_r (SEXP s)
{ csrtyp (qqcptr (s));
  return R_NilValue;
}

SEXP csruni_r (SEXP s)
{ csruni (qqcptr (s));
  return R_NilValue;
}

SEXP curv3d_r (SEXP xray, SEXP yray, SEXP zray, SEXP n)
{ curv3d (REAL (xray), REAL (yray), REAL (zray), asInteger (n));
  return R_NilValue;
}

SEXP curv4d_r (SEXP xray, SEXP yray, SEXP zray, SEXP wray, SEXP n)
{ curv4d (REAL (xray), REAL (yray), REAL (zray), REAL (wray), asInteger (n));
  return R_NilValue;
}

SEXP curve_r (SEXP xray, SEXP yray, SEXP n)
{ curve (REAL (xray), REAL (yray), asInteger (n));
  return R_NilValue;
}

SEXP curve3_r (SEXP xray, SEXP yray, SEXP zray, SEXP n)
{ curve3 (REAL (xray), REAL (yray), REAL (zray), asInteger (n));
  return R_NilValue;
}

SEXP curvmp_r (SEXP xray, SEXP yray, SEXP n)
{ curvmp (REAL (xray), REAL (yray), asInteger (n));
  return R_NilValue;
}

SEXP curvx3_r (SEXP xray, SEXP y, SEXP zray, SEXP n)
{ curvx3 (REAL (xray), asReal (y), REAL (zray), asInteger (n));
  return R_NilValue;
}

SEXP curvy3_r (SEXP x, SEXP yray, SEXP zray, SEXP n)
{ curvy3 (asReal (x), REAL (yray), REAL (zray), asInteger (n));
  return R_NilValue;
}

SEXP cyli3d_r (SEXP x1, SEXP x2, SEXP x3, SEXP x4, SEXP x5, 
               SEXP i1, SEXP i2)
{ cyli3d (asReal (x1), asReal (x2), asReal (x3), asReal (x4), asReal (x5), 
          asInteger (i1), asInteger (i2));
  return R_NilValue;
}

SEXP dash_r ()
{ dash ();
  return R_NilValue;
}

SEXP dashl_r ()
{ dashl ();
  return R_NilValue;
}

SEXP dashm_r ()
{ dashm ();
  return R_NilValue;
}

SEXP dbffin_r ()
{ dbffin ();
  return R_NilValue;
}

SEXP dbfini_r ()
{ int n;
  SEXP vec; 
  n = dbfini ();
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP dbfmod_r (SEXP s)
{ dbfmod (qqcptr (s));
  return R_NilValue;
}

SEXP delglb_r ()
{ delglb ();
  return R_NilValue;
}

SEXP digits_r (SEXP n, SEXP s)
{ digits (asInteger (n), qqcptr (s));
  return R_NilValue;
}

SEXP disalf_r ()
{ disalf ();
  return R_NilValue;
}

SEXP disenv_r (SEXP s)
{ disenv (qqcptr (s));
  return R_NilValue;
}

SEXP disfin_r ()
{ disfin ();
  return R_NilValue;
}

SEXP disini_r ()
{ disini ();
  return R_NilValue;
}

SEXP disk3d_r (SEXP x1, SEXP x2, SEXP x3, SEXP x4, SEXP x5, 
               SEXP i1, SEXP i2)
{ disk3d (asReal (x1), asReal (x2), asReal (x3), asReal (x4), asReal (x5), 
          asInteger (i1), asInteger (i2));
  return R_NilValue;
}

SEXP doevnt_r ()
{ doevnt ();
  return R_NilValue;
}

SEXP dot_r ()
{ dot ();
  return R_NilValue;
}

SEXP dotl_r ()
{ dotl ();
  return R_NilValue;
}

SEXP duplx_r ()
{ duplx ();
  return R_NilValue;
}

SEXP dwgbut_r (SEXP s, SEXP i)
{ int n;
  SEXP vec; 
  n = dwgbut (qqcptr (s), asInteger (i));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP dwgerr_r ()
{ int n;
  SEXP vec; 
  n = dwgerr ();
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP dwgfil_r (SEXP s1, SEXP s2, SEXP s3)
{ char *p;
  SEXP vec;
  p = dwgfil (qqcptr (s1), qqcptr (s2), qqcptr (s3));
  PROTECT (vec = allocVector (STRSXP, 1));
  SET_STRING_ELT (vec, 0, mkChar (p));
  free (p); 
  UNPROTECT (1);
  return vec;
}

SEXP dwglis_r (SEXP s1, SEXP s2, SEXP i)
{ int n;
  SEXP vec; 
  n = dwglis (qqcptr (s1), qqcptr (s2), asInteger (i));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP dwgmsg_r (SEXP s)
{ dwgmsg (qqcptr (s));
  return R_NilValue;
}

SEXP dwgtxt_r (SEXP s1, SEXP s2)
{ char *p;
  SEXP vec;
  p = dwgtxt (qqcptr (s1), qqcptr (s2));
  PROTECT (vec = allocVector (STRSXP, 1));
  SET_STRING_ELT (vec, 0, mkChar (p));
  free (p); 
  UNPROTECT (1);
  return vec;
}

SEXP ellips_r (SEXP i1, SEXP i2, SEXP i3, SEXP i4)
{ ellips (asInteger (i1), asInteger (i2), asInteger (i3), asInteger (i4));
  return R_NilValue;
}

SEXP endgrf_r ()
{ endgrf ();
  return R_NilValue;
}

SEXP erase_r ()
{ erase ();
  return R_NilValue;
}

SEXP errbar_r (SEXP xray, SEXP yray, SEXP e1ray, SEXP e2ray, SEXP n)
{ errbar (REAL (xray), REAL (yray), REAL (e1ray), REAL (e2ray), asInteger (n));
  return R_NilValue;
}

SEXP errdev_r (SEXP s)
{ errdev (qqcptr (s));
  return R_NilValue;
}

SEXP errfil_r (SEXP s)
{ errfil (qqcptr (s));
  return R_NilValue;
}

SEXP errmod_r (SEXP s1, SEXP s2)
{ errmod (qqcptr (s1), qqcptr (s2));
  return R_NilValue;
}

SEXP eushft_r (SEXP s1, SEXP s2)
{ eushft (qqcptr (s1), qqcptr (s2));
  return R_NilValue;
}

SEXP expimg_r (SEXP s1, SEXP s2)
{ expimg (qqcptr (s1), qqcptr (s2));
  return R_NilValue;
}

SEXP expzlb_r (SEXP s)
{ expzlb (qqcptr (s));
  return R_NilValue;
}

SEXP fbars_r (SEXP x1, SEXP x2, SEXP x3, SEXP x4, SEXP x5, SEXP n)
{ fbars (REAL (x1), REAL (x2), REAL (x3), REAL (x4), REAL (x5), 
         asInteger (n));
  return R_NilValue;
}

SEXP fcha_r (SEXP x, SEXP idig)
{ char s[80];
  int n;
  SEXP vec;
  n = fcha (asReal (x), asInteger (idig), s);
  PROTECT (vec = allocVector (STRSXP, 1));
  SET_STRING_ELT (vec, 0, mkChar (s));
  UNPROTECT (1);
  return vec;
}

SEXP field_r (SEXP x1, SEXP x2, SEXP x3, SEXP x4, SEXP n, SEXP ivec)
{ field (REAL (x1), REAL (x2), REAL (x3), REAL (x4), asInteger (n),
         asInteger (ivec));
  return R_NilValue;
}

SEXP field3d_r (SEXP x1, SEXP x2, SEXP x3, SEXP x4, SEXP x5, SEXP x6, SEXP n,
                SEXP ivec)
{ field3d (REAL (x1), REAL (x2), REAL (x3), REAL (x4), REAL (x5), REAL (x6),
           asInteger (n), asInteger (ivec));
  return R_NilValue;
}

SEXP filbox_r (SEXP i1, SEXP i2, SEXP i3, SEXP i4)
{ filbox (asInteger (i1), asInteger (i2), asInteger (i3), asInteger (i4));
  return R_NilValue;
}

SEXP filclr_r (SEXP s)
{ filclr (qqcptr (s));
  return R_NilValue;
}

SEXP filmod_r (SEXP s)
{ filmod (qqcptr (s));
  return R_NilValue;
}

SEXP filopt_r (SEXP s1, SEXP s2)
{ filopt (qqcptr (s1), qqcptr (s2));
  return R_NilValue;
}

SEXP filsiz_r (SEXP s)
{ int i1, i2, n;
  SEXP vec; 

  n = filsiz (qqcptr (s), &i1, &i2);
  PROTECT (vec = allocVector (INTSXP, 3));
  INTEGER (vec)[0] = i1;
  INTEGER (vec)[1] = i2;
  INTEGER (vec)[2] = n;
  UNPROTECT (1);
  return vec;
}

SEXP filtyp_r (SEXP s)
{ int n;
  SEXP vec; 
  n = filtyp (qqcptr (s));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP filwin_r (SEXP i1, SEXP i2, SEXP i3, SEXP i4)
{ filwin (asInteger (i1), asInteger (i2), asInteger (i3), asInteger (i4));
  return R_NilValue;
}

SEXP fitscls_r ()
{ fitscls ();
  return R_NilValue;
}

SEXP fitsflt_r (SEXP s)
{ double xp;
  SEXP vec; 
  xp = fitsflt (qqcptr (s));
  PROTECT (vec = allocVector (REALSXP, 1));
  REAL (vec)[0] = xp;
  UNPROTECT (1);
  return vec;
}

SEXP fitshdu_r (SEXP i)
{ int n;
  SEXP vec; 
  n = fitshdu (asInteger (i));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP fitsimg_r (SEXP rray, SEXP i1)
{ int n;
  SEXP vec;

  n = fitsimg ((unsigned char *) RAW (rray), asInteger (i1));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP fitsopn_r (SEXP s)
{ int n;
  SEXP vec; 
  n = fitsopn (qqcptr (s));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP fitsstr_r (SEXP s)
{ char cstr[257];
  SEXP vec; 
  fitsstr (qqcptr (s), cstr, 257);
  PROTECT (vec = allocVector (STRSXP, 1));
  SET_STRING_ELT (vec, 0, mkChar (cstr));
  UNPROTECT (1);
  return vec;
}


SEXP fitstyp_r (SEXP s)
{ int n;
  SEXP vec; 
  n = fitstyp (qqcptr (s));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP fitsval_r (SEXP s)
{ int n;
  SEXP vec; 
  n = fitsval (qqcptr (s));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP fixspc_r (SEXP x)
{ fixspc (asReal (x));
  return R_NilValue;
}

SEXP flab3d_r ()
{ flab3d ();
  return R_NilValue;
}

SEXP flen_r (SEXP x, SEXP idig)
{ int n;
  SEXP vec; 
  n = flen (asReal (x), asInteger (idig));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP frame_r (SEXP n)
{ frame (asInteger (n));
  return R_NilValue;
}

SEXP frmbar_r (SEXP n)
{ frmbar (asInteger (n));
  return R_NilValue;
}

SEXP frmclr_r (SEXP n)
{ frmclr (asInteger (n));
  return R_NilValue;
}

SEXP frmess_r (SEXP n)
{ frmess (asInteger (n));
  return R_NilValue;
}

SEXP gapcrv_r (SEXP x)
{ gapcrv (asReal (x));
  return R_NilValue;
}

SEXP gapsiz_r (SEXP x, SEXP s)
{ gapsiz (asReal (x), qqcptr (s));
  return R_NilValue;
}

SEXP gaxpar_r (SEXP x1, SEXP x2, SEXP s1, SEXP s2)
{ double x3, x4, x5, x6;
  int i;
  SEXP vec1, vec2, list; 

  gaxpar (asReal (x1), asReal (x2), qqcptr (s1), qqcptr (s2), &x3, &x4,
          &x5, &x6, &i);
  PROTECT (list = allocVector (VECSXP, 2));
  PROTECT (vec1 = allocVector (REALSXP, 4));
  PROTECT (vec2 = allocVector (INTSXP, 1));
  REAL (vec1)[0] = x3;
  REAL (vec1)[1] = x4;
  REAL (vec1)[2] = x5;
  REAL (vec1)[3] = x6;
  INTEGER (vec2)[0] = i;
  SET_VECTOR_ELT (list, 0, vec1);
  SET_VECTOR_ELT (list, 1, vec2);
  UNPROTECT (3);
  return list;
}

SEXP getalf_r ()
{ char *p;
  SEXP vec;
  p = getalf ();
  PROTECT (vec = allocVector (STRSXP, 1));
  SET_STRING_ELT (vec, 0, mkChar (p));
  UNPROTECT (1);
  return vec;
}

SEXP getang_r ()
{ int n;
  SEXP vec; 
  n = getang ();
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP getbpp_r ()
{ int n;
  SEXP vec; 
  n = getbpp ();
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP getclp_r ()
{ int i1, i2, i3, i4;
  SEXP vec; 

  getclp (&i1, &i2, &i3, &i4);
  PROTECT (vec = allocVector (INTSXP, 4));
  INTEGER (vec)[0] = i1;
  INTEGER (vec)[1] = i2;
  INTEGER (vec)[2] = i3;
  INTEGER (vec)[3] = i4;
  UNPROTECT (1);
  return vec;
}

SEXP getclr_r ()
{ int n;
  SEXP vec; 
  n = getclr ();
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP getdig_r ()
{ int i1, i2, i3;
  SEXP vec; 

  getdig (&i1, &i2, &i3);
  PROTECT (vec = allocVector (INTSXP, 3));
  INTEGER (vec)[0] = i1;
  INTEGER (vec)[1] = i2;
  INTEGER (vec)[2] = i3;
  UNPROTECT (1);
  return vec;
}

SEXP getdsp_r ()
{ char *p;
  SEXP vec;
  p = getdsp ();
  PROTECT (vec = allocVector (STRSXP, 1));
  SET_STRING_ELT (vec, 0, mkChar (p));
  UNPROTECT (1);
  return vec;
}

SEXP getfil_r ()
{ char *p;
  SEXP vec;
  p = getfil ();
  PROTECT (vec = allocVector (STRSXP, 1));
  SET_STRING_ELT (vec, 0, mkChar (p));
  UNPROTECT (1);
  return vec;
}

SEXP getgrf_r (SEXP s)
{ double x1, x2, x3, x4;
  SEXP vec; 

  getgrf (&x1, &x2, &x3, &x4, qqcptr (s));
  PROTECT (vec = allocVector (REALSXP, 4));
  REAL (vec)[0] = x1;
  REAL (vec)[1] = x2;
  REAL (vec)[2] = x3;
  REAL (vec)[3] = x4;
  UNPROTECT (1);
  return vec;
}

SEXP gethgt_r ()
{ int n;
  SEXP vec; 
  n = gethgt ();
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP gethnm_r ()
{ int n;
  SEXP vec; 
  n = gethnm ();
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP getico_r (SEXP x, SEXP y)
{ double xp, yp;
  SEXP vec;

  getico (asReal (x), asReal (y), &xp, &yp);
  PROTECT (vec = allocVector (REALSXP, 2));
  REAL (vec)[0] = xp;
  REAL (vec)[1] = yp;
  UNPROTECT (1);
  return vec;
}

SEXP getind_r (SEXP n)
{ double x1, x2, x3;
  SEXP vec; 

  getind (asInteger (n), &x1, &x2, &x3);
  PROTECT (vec = allocVector (REALSXP, 3));
  REAL (vec)[0] = x1;
  REAL (vec)[1] = x2;
  REAL (vec)[2] = x3;
  UNPROTECT (1);
  return vec;
}

SEXP getlab_r ()
{ char s1[5], s2[5], s3[5];
  SEXP vec;
  getlab (s1, s2, s3);
  PROTECT (vec = allocVector (STRSXP, 3));
  SET_STRING_ELT (vec, 0, mkChar (s1));
  SET_STRING_ELT (vec, 1, mkChar (s2));
  SET_STRING_ELT (vec, 2, mkChar (s3));
  UNPROTECT (1);
  return vec;
}

SEXP getlen_r ()
{ int i1, i2, i3;
  SEXP vec; 

  getlen (&i1, &i2, &i3);
  PROTECT (vec = allocVector (INTSXP, 3));
  INTEGER (vec)[0] = i1;
  INTEGER (vec)[1] = i2;
  INTEGER (vec)[2] = i3;
  UNPROTECT (1);
  return vec;
}

SEXP getlev_r ()
{ int n;
  SEXP vec; 
  n = getlev ();
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP getlin_r ()
{ int n;
  SEXP vec; 
  n = getlin ();
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP getlit_r (SEXP x1, SEXP x2, SEXP x3, SEXP x4, SEXP x5, SEXP x6)
{ int n;
  SEXP vec; 
  n = getlit (asReal (x1), asReal (x2), asReal (x3), asReal (x4), 
              asReal (x5), asReal (x6));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP getmat_r (SEXP xray, SEXP yray, SEXP zray, SEXP n, SEXP zmat, SEXP nx,
               SEXP ny, SEXP zval)
{ double *p1, *q1, *q2;
  int *p2, nn, i;
  
  nn = asInteger (nx) * asInteger (ny);
  p1 = (double *) calloc (nn, sizeof (double));
  p2 = (int *) calloc (nn, sizeof (int));
  if (p1 == NULL || p2 == NULL)
  { error ("Not enough memory!");
    if (p1 != NULL) free (p1);
    if (p2 != NULL) free (p2);
    return R_NilValue;
  }
  q2 = REAL (zmat);
  getmat (REAL (xray), REAL (yray), REAL (zray), asInteger (n), q2,
                asInteger (nx), asInteger (ny), asReal (zval), p2, p1);
 
  free (p1);
  free (p2);

  q1 = qqtmat (q2, asInteger (nx), asInteger (ny));
  if (q1 != NULL)
  { for (i = 0; i < nn; i++)
      q2[i] = q1[i];
    free (q1);
  }
  return R_NilValue;
}

SEXP getmfl_r ()
{ char *p;
  SEXP vec;
  p = getmfl ();
  PROTECT (vec = allocVector (STRSXP, 1));
  SET_STRING_ELT (vec, 0, mkChar (p));
  UNPROTECT (1);
  return vec;
}

SEXP getmix_r (SEXP s)
{ char *p;
  SEXP vec;
  p = getmix (qqcptr (s));
  PROTECT (vec = allocVector (STRSXP, 1));
  SET_STRING_ELT (vec, 0, mkChar (p));
  UNPROTECT (1);
  return vec;
}

SEXP getor_r ()
{ int i1, i2;
  SEXP vec; 

  getor (&i1, &i2);
  PROTECT (vec = allocVector (INTSXP, 2));
  INTEGER (vec)[0] = i1;
  INTEGER (vec)[1] = i2;
  UNPROTECT (1);
  return vec;
}

SEXP getpag_r ()
{ int i1, i2;
  SEXP vec; 

  getpag (&i1, &i2);
  PROTECT (vec = allocVector (INTSXP, 2));
  INTEGER (vec)[0] = i1;
  INTEGER (vec)[1] = i2;
  UNPROTECT (1);
  return vec;
}

SEXP getpat_r ()
{ int n;
  SEXP vec; 
  n = getpat ();
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP getplv_r ()
{ int n;
  SEXP vec; 
  n = getplv ();
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP getpos_r ()
{ int i1, i2;
  SEXP vec; 

  getpos (&i1, &i2);
  PROTECT (vec = allocVector (INTSXP, 2));
  INTEGER (vec)[0] = i1;
  INTEGER (vec)[1] = i2;
  UNPROTECT (1);
  return vec;
}

SEXP getran_r ()
{ int i1, i2;
  SEXP vec; 

  getran (&i1, &i2);
  PROTECT (vec = allocVector (INTSXP, 2));
  INTEGER (vec)[0] = i1;
  INTEGER (vec)[1] = i2;
  UNPROTECT (1);
  return vec;
}

SEXP getrco_r (SEXP x, SEXP y)
{ double xp, yp;
  SEXP vec;

  getrco (asReal (x), asReal (y), &xp, &yp);
  PROTECT (vec = allocVector (REALSXP, 2));
  REAL (vec)[0] = xp;
  REAL (vec)[1] = yp;
  UNPROTECT (1);
  return vec;
}

SEXP getres_r ()
{ int i1, i2;
  SEXP vec; 

  getres (&i1, &i2);
  PROTECT (vec = allocVector (INTSXP, 2));
  INTEGER (vec)[0] = i1;
  INTEGER (vec)[1] = i2;
  UNPROTECT (1);
  return vec;
}

SEXP getrgb_r ()
{ double x1, x2, x3;
  SEXP vec; 

  getrgb (&x1, &x2, &x3);
  PROTECT (vec = allocVector (REALSXP, 3));
  REAL (vec)[0] = x1;
  REAL (vec)[1] = x2;
  REAL (vec)[2] = x3;
  UNPROTECT (1);
  return vec;
}

SEXP getscl_r ()
{ int i1, i2, i3;
  SEXP vec; 

  getscl (&i1, &i2, &i3);
  PROTECT (vec = allocVector (INTSXP, 3));
  INTEGER (vec)[0] = i1;
  INTEGER (vec)[1] = i2;
  INTEGER (vec)[2] = i3;
  UNPROTECT (1);
  return vec;
}

SEXP getscm_r ()
{ int i1, i2, i3;
  SEXP vec; 

  getscm (&i1, &i2, &i3);
  PROTECT (vec = allocVector (INTSXP, 3));
  INTEGER (vec)[0] = i1;
  INTEGER (vec)[1] = i2;
  INTEGER (vec)[2] = i3;
  UNPROTECT (1);
  return vec;
}

SEXP getscr_r ()
{ int i1, i2;
  SEXP vec; 

  getscr (&i1, &i2);
  PROTECT (vec = allocVector (INTSXP, 2));
  INTEGER (vec)[0] = i1;
  INTEGER (vec)[1] = i2;
  UNPROTECT (1);
  return vec;
}

SEXP getshf_r (SEXP s)
{ char *p;
  SEXP vec;
  p = getshf (qqcptr (s));
  PROTECT (vec = allocVector (STRSXP, 1));
  SET_STRING_ELT (vec, 0, mkChar (p));
  UNPROTECT (1);
  return vec;
}

SEXP getsp1_r ()
{ int i1, i2, i3;
  SEXP vec; 

  getsp1 (&i1, &i2, &i3);
  PROTECT (vec = allocVector (INTSXP, 3));
  INTEGER (vec)[0] = i1;
  INTEGER (vec)[1] = i2;
  INTEGER (vec)[2] = i3;
  UNPROTECT (1);
  return vec;
}

SEXP getsp2_r ()
{ int i1, i2, i3;
  SEXP vec; 

  getsp2 (&i1, &i2, &i3);
  PROTECT (vec = allocVector (INTSXP, 3));
  INTEGER (vec)[0] = i1;
  INTEGER (vec)[1] = i2;
  INTEGER (vec)[2] = i3;
  UNPROTECT (1);
  return vec;
}

SEXP getsym_r ()
{ int i1, i2;
  SEXP vec; 

  getsym (&i1, &i2);
  PROTECT (vec = allocVector (INTSXP, 2));
  INTEGER (vec)[0] = i1;
  INTEGER (vec)[1] = i2;
  UNPROTECT (1);
  return vec;
}

SEXP gettcl_r ()
{ int i1, i2;
  SEXP vec; 

  gettcl (&i1, &i2);
  PROTECT (vec = allocVector (INTSXP, 2));
  INTEGER (vec)[0] = i1;
  INTEGER (vec)[1] = i2;
  UNPROTECT (1);
  return vec;
}

SEXP gettic_r ()
{ int i1, i2, i3;
  SEXP vec; 

  gettic (&i1, &i2, &i3);
  PROTECT (vec = allocVector (INTSXP, 3));
  INTEGER (vec)[0] = i1;
  INTEGER (vec)[1] = i2;
  INTEGER (vec)[2] = i3;
  UNPROTECT (1);
  return vec;
}

SEXP gettyp_r ()
{ int n;
  SEXP vec; 
  n = gettyp ();
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP getuni_r ()
{ int n;
  SEXP vec; 
  FILE *fp;

  fp = (FILE *) getuni ();
  if (fp == NULL) 
    n = 0;
  else 
    n = 6;
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP getver_r ()
{ double x;
  SEXP vec; 
  x = getver ();
  PROTECT (vec = allocVector (REALSXP, 1));
  REAL (vec)[0] = x;
  UNPROTECT (1);
  return vec;
}

SEXP getvk_r ()
{ int i1, i2, i3;
  SEXP vec; 

  getvk (&i1, &i2, &i3);
  PROTECT (vec = allocVector (INTSXP, 3));
  INTEGER (vec)[0] = i1;
  INTEGER (vec)[1] = i2;
  INTEGER (vec)[2] = i3;
  UNPROTECT (1);
  return vec;
}

SEXP getvlt_r ()
{ char *p;
  SEXP vec;
  p = getvlt ();
  PROTECT (vec = allocVector (STRSXP, 1));
  SET_STRING_ELT (vec, 0, mkChar (p));
  UNPROTECT (1);
  return vec;
}

SEXP getwid_r ()
{ int n;
  SEXP vec; 
  n = getwid ();
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP getwin_r ()
{ int i1, i2, i3, i4;
  SEXP vec; 

  getwin (&i1, &i2, &i3, &i4);
  PROTECT (vec = allocVector (INTSXP, 4));
  INTEGER (vec)[0] = i1;
  INTEGER (vec)[1] = i2;
  INTEGER (vec)[2] = i3;
  INTEGER (vec)[3] = i4;
  UNPROTECT (1);
  return vec;
}

SEXP getxid_r (SEXP s)
{ int n;
  SEXP vec; 
  n = getxid (qqcptr (s));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP gifmod_r (SEXP s1, SEXP s2)
{ gifmod (qqcptr (s1), qqcptr (s2));
  return R_NilValue;
}

SEXP gmxalf_r (SEXP s)
{ char c1[5], c2[5];
  int n;
  SEXP vec1, vec2, list; 

  c1[0] = '\0';
  c2[0] = '\0';
  n = gmxalf (qqcptr (s), c1, c2);
  PROTECT (list = allocVector (VECSXP, 2));
  PROTECT (vec1 = allocVector (STRSXP, 2));
  PROTECT (vec2 = allocVector (INTSXP, 1));
  SET_STRING_ELT (vec1, 0, mkChar (c1));
  SET_STRING_ELT (vec1, 1, mkChar (c2));
  INTEGER (vec2)[0] = n;
  SET_VECTOR_ELT (list, 0, vec1);
  SET_VECTOR_ELT (list, 1, vec2);
  UNPROTECT (3);
  return list;
}

SEXP gothic_r ()
{ gothic ();
  return R_NilValue;
}

SEXP grace_r (SEXP n)
{ grace (asInteger (n));
  return R_NilValue;
}

SEXP graf_r (SEXP x1, SEXP x2, SEXP x3, SEXP x4,
             SEXP x5, SEXP x6, SEXP x7, SEXP x8)
{ graf (asReal (x1), asReal (x2), asReal (x3), asReal (x4), 
        asReal (x5), asReal (x6), asReal (x7), asReal (x8));
  return R_NilValue;
}

SEXP graf3_r (SEXP x1, SEXP x2, SEXP x3, SEXP x4,
              SEXP x5, SEXP x6, SEXP x7, SEXP x8,
              SEXP x9, SEXP x10, SEXP x11, SEXP x12)
{ graf3 (asReal (x1), asReal (x2), asReal (x3), asReal (x4), 
         asReal (x5), asReal (x6), asReal (x7), asReal (x8),
         asReal (x9), asReal (x10), asReal (x11), asReal (x12));
  return R_NilValue;
}

SEXP graf3d_r (SEXP x1, SEXP x2, SEXP x3, SEXP x4,
               SEXP x5, SEXP x6, SEXP x7, SEXP x8,
               SEXP x9, SEXP x10, SEXP x11, SEXP x12)
{ graf3d (asReal (x1), asReal (x2), asReal (x3), asReal (x4), 
          asReal (x5), asReal (x6), asReal (x7), asReal (x8),
          asReal (x9), asReal (x10), asReal (x11), asReal (x12));
  return R_NilValue;
}

SEXP grafmp_r (SEXP x1, SEXP x2, SEXP x3, SEXP x4,
             SEXP x5, SEXP x6, SEXP x7, SEXP x8)
{ grafmp (asReal (x1), asReal (x2), asReal (x3), asReal (x4), 
          asReal (x5), asReal (x6), asReal (x7), asReal (x8));
  return R_NilValue;
}

SEXP grafp_r (SEXP x1, SEXP x2, SEXP x3, SEXP x4, SEXP x5)
{ grafp (asReal (x1), asReal (x2), asReal (x3), asReal (x4), asReal (x5));
  return R_NilValue;
}

SEXP grafr_r (SEXP xray, SEXP n, SEXP yray, SEXP m)
{ grafr (REAL (xray), asInteger (n), REAL (yray), asInteger (m));
  return R_NilValue;
}

SEXP grdpol_r (SEXP i1, SEXP i2)
{ grdpol (asInteger (i1), asInteger (i2));
  return R_NilValue;
}

SEXP grffin_r ()
{ grffin ();
  return R_NilValue;
}

SEXP grfimg_r (SEXP s)
{ grfimg (qqcptr (s));
  return R_NilValue;
}

SEXP grfini_r (SEXP x1, SEXP x2, SEXP x3, SEXP x4,
               SEXP x5, SEXP x6, SEXP x7, SEXP x8, SEXP x9)
{ grfini (asReal (x1), asReal (x2), asReal (x3), asReal (x4), 
          asReal (x5), asReal (x6), asReal (x7), asReal (x8), asReal (x9));
  return R_NilValue;
}

SEXP grid_r (SEXP i1, SEXP i2)
{ grid (asInteger (i1), asInteger (i2));
  return R_NilValue;
}

SEXP grid3d_r (SEXP i1, SEXP i2, SEXP s)
{ grid3d (asInteger (i1), asInteger (i2), qqcptr (s));
  return R_NilValue;
}

SEXP gridim_r (SEXP x1, SEXP x2, SEXP x3, SEXP i)
{ gridim (asReal (x1), asReal (x2), asReal (x3), asInteger (i));
  return R_NilValue;
}

SEXP gridmp_r (SEXP i1, SEXP i2)
{ gridmp (asInteger (i1), asInteger (i2));
  return R_NilValue;
}

SEXP gridre_r (SEXP x1, SEXP x2, SEXP x3, SEXP i)
{ gridre (asReal (x1), asReal (x2), asReal (x3), asInteger (i));
  return R_NilValue;
}

SEXP gwgatt_r (SEXP i, SEXP s)
{ int n;
  SEXP vec; 
  n = gwgatt (asInteger (i), qqcptr (s));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP gwgbox_r (SEXP i)
{ int n;
  SEXP vec; 
  n = gwgbox (asInteger (i));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP gwgbut_r (SEXP i)
{ int n;
  SEXP vec; 
  n = gwgbut (asInteger (i));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP gwgfil_r (SEXP i)
{ char cfl[257];
  SEXP vec;
  gwgfil (asInteger (i), cfl);
  PROTECT (vec = allocVector (STRSXP, 1));
  SET_STRING_ELT (vec, 0, mkChar (cfl));
  UNPROTECT (1);
  return vec;
}

SEXP gwgflt_r (SEXP i)
{ double x;
  SEXP vec; 
  x = gwgflt (asInteger (i));
  PROTECT (vec = allocVector (REALSXP, 1));
  REAL (vec)[0] = x;
  UNPROTECT (1);
  return vec;
}

SEXP gwggui_r ()
{ int n;
  SEXP vec; 
  n = gwggui ();
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP gwgint_r (SEXP i)
{ int n;
  SEXP vec; 
  n = gwgint (asInteger (i));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP gwglis_r (SEXP i)
{ int n;
  SEXP vec; 
  n = gwglis (asInteger (i));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP gwgscl_r (SEXP i)
{ double x;
  SEXP vec; 
  x = gwgscl (asInteger (i));
  PROTECT (vec = allocVector (REALSXP, 1));
  REAL (vec)[0] = x;
  UNPROTECT (1);
  return vec;
}

SEXP gwgsiz_r (SEXP i1)
{ int i2, i3;
  SEXP vec; 
  gwgsiz (asInteger (i1), &i2, &i3);
  PROTECT (vec = allocVector (INTSXP, 2));
  INTEGER (vec)[0] = i2;
  INTEGER (vec)[1] = i3;
  UNPROTECT (1);
  return vec;
}

SEXP gwgtbf_r (SEXP i1, SEXP i2, SEXP i3)
{ double x;
  SEXP vec; 
  x = gwgtbf (asInteger (i1), asInteger (i2), asInteger (i3));
  PROTECT (vec = allocVector (REALSXP, 1));
  REAL (vec)[0] = x;
  UNPROTECT (1);
  return vec;
}

SEXP gwgtbi_r (SEXP i1, SEXP i2, SEXP i3)
{ int n;
  SEXP vec; 
  n = gwgtbi (asInteger (i1), asInteger (i2), asInteger (i3));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP  gwgtbl_r (SEXP i1, SEXP xray, SEXP n, SEXP i2, SEXP s)
{ gwgtbl (asInteger (i1), REAL (xray), asInteger (n), asInteger (i2), 
          qqcptr (s));
  return R_NilValue;
} 

SEXP gwgtbs_r (SEXP i1, SEXP i2, SEXP i3)
{ char s[81];
  SEXP vec;
  s[0]= '\0';
  gwgtbs (asInteger (i1), asInteger (i2), asInteger (i3), s);
  PROTECT (vec = allocVector (STRSXP, 1));
  SET_STRING_ELT (vec, 0, mkChar (s));
  UNPROTECT (1);
  return vec;
}

SEXP gwgtxt_r (SEXP i)
{ char cfl[257];
  SEXP vec;
  gwgtxt (asInteger (i), cfl);
  PROTECT (vec = allocVector (STRSXP, 1));
  SET_STRING_ELT (vec, 0, mkChar (cfl));
  UNPROTECT (1);
  return vec;
}

SEXP gwgxid_r (SEXP i)
{ int n;
  SEXP vec; 
  n = gwgxid (asInteger (i));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP height_r (SEXP n)
{ height (asInteger (n));
  return R_NilValue;
}

SEXP helve_r ()
{ helve ();
  return R_NilValue;
}

SEXP helves_r ()
{ helves ();
  return R_NilValue;
}

SEXP helvet_r ()
{ helvet ();
  return R_NilValue;
}

SEXP hidwin_r (SEXP n, SEXP s)
{ hidwin (asInteger (n), qqcptr (s));
  return R_NilValue;
}

SEXP histog_r (SEXP xray, SEXP nn, SEXP xhray, SEXP yhray)
{ int n;
  SEXP vec; 
  histog (REAL (xray), asInteger (nn), REAL (xhray), REAL (yhray), &n);
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP hname_r (SEXP n)
{ hname (asInteger (n));
  return R_NilValue;
}

SEXP hpgmod_r (SEXP s1, SEXP s2)
{ hpgmod (qqcptr (s1), qqcptr (s2));
  return R_NilValue;
}

SEXP hsvrgb_r (SEXP x1, SEXP x2, SEXP x3)
{ double x4, x5, x6;
  SEXP vec;

  hsvrgb (asReal (x1), asReal (x2), asReal (x3), &x4, &x5, &x6);
  PROTECT (vec = allocVector (REALSXP, 3));
  REAL (vec)[0] = x4;
  REAL (vec)[1] = x5;
  REAL (vec)[2] = x6;
  UNPROTECT (1);
  return vec;
}

SEXP hsym3d_r (SEXP x)
{ hsym3d (asReal (x));
  return R_NilValue;
}

SEXP hsymbl_r (SEXP n)
{ hsymbl (asInteger (n));
  return R_NilValue;
}

SEXP htitle_r (SEXP n)
{ htitle (asInteger (n));
  return R_NilValue;
}

SEXP hwfont_r ()
{ hwfont ();
  return R_NilValue;
}

SEXP hwmode_r (SEXP s1, SEXP s2)
{ hwmode (qqcptr (s1), qqcptr (s2));
  return R_NilValue;
}

SEXP hworig_r (SEXP i1, SEXP i2)
{ hworig (asInteger (i1), asInteger (i2));
  return R_NilValue;
}

SEXP hwpage_r (SEXP i1, SEXP i2)
{ hwpage (asInteger (i1), asInteger (i2));
  return R_NilValue;
}

SEXP hwscal_r (SEXP x)
{ hwscal (asReal (x));
  return R_NilValue;
}

SEXP imgbox_r (SEXP i1, SEXP i2, SEXP i3, SEXP i4)
{ imgbox (asInteger (i1), asInteger (i2), asInteger (i3), asInteger (i4));
  return R_NilValue;
}

SEXP imgclp_r (SEXP i1, SEXP i2, SEXP i3, SEXP i4)
{ imgclp (asInteger (i1), asInteger (i2), asInteger (i3), asInteger (i4));
  return R_NilValue;
}

SEXP imgfin_r ()
{ imgfin ();
  return R_NilValue;
}

SEXP imgfmt_r (SEXP s)
{ imgfmt (qqcptr (s));
  return R_NilValue;
}

SEXP imgini_r ()
{ imgini ();
  return R_NilValue;
}

SEXP imgmod_r (SEXP s)
{ const char *p;
  p = qqcptr (s);
  imgop = 0;
  if (p[0] == 'r' || p[0] == 'R') imgop = 1;
  imgmod (p);
  return R_NilValue;
}

SEXP imgsiz_r (SEXP i1, SEXP i2)
{ imgsiz (asInteger (i1), asInteger (i2));
  return R_NilValue;
}

SEXP imgtpr_r (SEXP n)
{ imgtpr (asInteger (n));
  return R_NilValue;
}

SEXP inccrv_r (SEXP n)
{ inccrv (asInteger (n));
  return R_NilValue;
}

SEXP incdat_r (SEXP i1, SEXP i2, SEXP i3)
{ int n;
  SEXP vec; 
  n = incdat (asInteger (i1), asInteger (i2), asInteger (i3));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP incfil_r (SEXP s)
{ incfil (qqcptr (s));
  return R_NilValue;
}

SEXP incmrk_r (SEXP n)
{ incmrk (asInteger (n));
  return R_NilValue;
}

SEXP indrgb_r (SEXP x1, SEXP x2, SEXP x3)
{ int n;
  SEXP vec; 
  n = indrgb (asReal (x1), asReal (x2), asReal (x3));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP intax_r ()
{ intax ();
  return R_NilValue;
}

SEXP intcha_r (SEXP i)
{ char s[80];
  int n;
  SEXP vec;
  n = intcha (asInteger (i), s);
  PROTECT (vec = allocVector (STRSXP, 1));
  SET_STRING_ELT (vec, 0, mkChar (s));
  UNPROTECT (1);
  return vec;
}

SEXP intlen_r (SEXP i)
{ int n;
  SEXP vec; 
  n = intlen (asInteger (i));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP intrgb_r (SEXP x1, SEXP x2, SEXP x3)
{ int n;
  SEXP vec; 
  n = intrgb (asReal (x1), asReal (x2), asReal (x3));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP intutf_r (SEXP iray, SEXP n)
{ char *p;
  SEXP vec;
  int nn, nl;
  
  nn = asInteger (n);
  nn = nn * 4;
  p = (char *) malloc (nn + 1);
  if (p == NULL)
  { error ("Not enough memory!");
    return R_NilValue;
  }

  nl = intutf (INTEGER (iray), asInteger (n), p, nn);
  PROTECT (vec = allocVector (STRSXP, 1));
  SET_STRING_ELT (vec, 0, mkChar (p));
  UNPROTECT (1);
  free (p);
  return vec;
}

SEXP isopts_r (SEXP xray, SEXP nx, SEXP yray, SEXP ny, SEXP zray, SEXP nz,
               SEXP wmat, SEXP wlev, SEXP xtri, SEXP ytri, SEXP ztri, 
               SEXP nmax)
{ int n = 0;
  SEXP vec; 
  double *p;

  p = qqtmat3 (REAL (wmat), asInteger (nx), asInteger (ny), 
               asInteger (nz));
  if (p != NULL)
  { isopts (REAL (xray), asInteger (nx), REAL (yray), asInteger (ny),
            REAL (zray), asInteger (nz), p, asReal (wlev), REAL (xtri), 
            REAL (ytri), REAL (ztri), asInteger (nmax), &n);
    free (p);
  }
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP itmcat_r (SEXP s1, SEXP s2)
{ char *p, *q;
  SEXP vec;
  int n1, n2;

  n1 = trmlen (qqcptr (s1));
  n2 = trmlen (qqcptr (s2));
  p = (char *) malloc (n1 + n2 + 1);
  if (p == NULL)
  { error ("Not enough memory!");
    q = (char *) qqcptr (s1);
  }
  else 
  { strcpy (p, qqcptr (s1));
    itmcat (p, qqcptr (s2));
    q = p;
  }
  PROTECT (vec = allocVector (STRSXP, 1));
  SET_STRING_ELT (vec, 0, mkChar (q));
  UNPROTECT (1);
  if (p != NULL) free (p);
  return vec;
}

SEXP itmcnt_r (SEXP s)
{ int n;
  SEXP vec; 
  n = itmcnt (qqcptr (s));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP itmncat_r (SEXP s1, SEXP i, SEXP s2)
{ char *p, *q;
  SEXP vec;
  int n1, n2;

  n1 = trmlen (qqcptr (s1));
  n2 = trmlen (qqcptr (s2));
  p = (char *) malloc (n1 + n2 + 1);
  if (p == NULL)
  { error ("Not enough memory!");
    q = (char *) qqcptr (s1);
  }
  else 
  { strcpy (p, qqcptr (s1));
    itmncat (p, asInteger (i), qqcptr (s2));
    q = p;
  }
  PROTECT (vec = allocVector (STRSXP, 1));
  SET_STRING_ELT (vec, 0, mkChar (q));
  UNPROTECT (1);
  if (p != NULL) free (p);
  return vec;
}

SEXP itmstr_r (SEXP s, SEXP n)
{ char *p;
  SEXP vec;
  p = itmstr (qqcptr (s), asInteger (n));
  PROTECT (vec = allocVector (STRSXP, 1));
  SET_STRING_ELT (vec, 0, mkChar (p));
  UNPROTECT (1);
  free (p);
  return vec;
}

SEXP jusbar_r (SEXP s)
{ jusbar (qqcptr (s));
  return R_NilValue;
}

SEXP labclr_r (SEXP n, SEXP s)
{ labclr (asInteger (n), qqcptr (s));
  return R_NilValue;
}

SEXP labdig_r (SEXP n, SEXP s)
{ labdig (asInteger (n), qqcptr (s));
  return R_NilValue;
}

SEXP labdis_r (SEXP n, SEXP s)
{ labdis (asInteger (n), qqcptr (s));
  return R_NilValue;
}

SEXP labels_r (SEXP s1, SEXP s2)
{ labels (qqcptr (s1), qqcptr (s2));
  return R_NilValue;
}

SEXP labjus_r (SEXP s1, SEXP s2)
{ labjus (qqcptr (s1), qqcptr (s2));
  return R_NilValue;
}

SEXP labl3d_r (SEXP s)
{ labl3d (qqcptr (s));
  return R_NilValue;
}

SEXP labmod_r (SEXP s1, SEXP s2, SEXP s3)
{ labmod (qqcptr (s1), qqcptr (s2), qqcptr (s3));
  return R_NilValue;
}

SEXP labpos_r (SEXP s1, SEXP s2)
{ labpos (qqcptr (s1), qqcptr (s2));
  return R_NilValue;
}

SEXP labtyp_r (SEXP s1, SEXP s2)
{ labtyp (qqcptr (s1), qqcptr (s2));
  return R_NilValue;
}

SEXP ldimg_r (SEXP s, SEXP rray, SEXP nmax, SEXP nc)
{ int n;
  SEXP vec; 
  n = ldimg (qqcptr (s), (unsigned short *) RAW (rray), asInteger (nmax) / 2,
             asInteger (nc));
  n *= 2;
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP legbgd_r (SEXP n)
{ legbgd (asInteger (n));
  return R_NilValue;
}

SEXP legclr_r ()
{ legclr ();
  return R_NilValue;
}

SEXP legend_r (SEXP iray, SEXP i)
{ legend ((const char *) RAW (iray), asInteger (i));
  return R_NilValue;
}

SEXP legini_r (SEXP iray, SEXP i1, SEXP i2)
{ int nlin, nmaxln;
  nlin   = asInteger (i1);
  nmaxln = asInteger (i2);

  legini ((char *) RAW (iray), nlin, nmaxln);
  return R_NilValue;
}

SEXP leglin_r (SEXP iray, SEXP s2, SEXP i)
{ leglin ((char *) RAW (iray), qqcptr (s2), asInteger (i));
  return R_NilValue;
}

SEXP legopt_r (SEXP x1, SEXP x2, SEXP x3)
{ legopt (asReal (x1), asReal (x2), asReal (x3));
  return R_NilValue;
}

SEXP legpat_r (SEXP i1, SEXP i2, SEXP i3, SEXP i4, SEXP i5, SEXP i6)
{ legpat (asInteger (i1), asInteger (i2), asInteger (i3), asInteger (i4),
          asInteger (i5), asInteger (i6));
  return R_NilValue;
}

SEXP legpos_r (SEXP i1, SEXP i2)
{ legpos (asInteger (i1), asInteger (i2));
  return R_NilValue;
}

SEXP legsel_r (SEXP nxray, SEXP n)
{ legsel (INTEGER (nxray), asInteger (n));
  return R_NilValue;
}

SEXP legtbl_r (SEXP n, SEXP s)
{ legtbl (asInteger (n), qqcptr (s));
  return R_NilValue;
}

SEXP legtit_r (SEXP s)
{ legtit (qqcptr (s));
  return R_NilValue;
}

SEXP legtyp_r (SEXP s)
{ legtyp (qqcptr (s));
  return R_NilValue;
}

SEXP legval_r (SEXP x, SEXP s)
{ legval (asReal (x), qqcptr (s));
  return R_NilValue;
}

SEXP lfttit_r ()
{ lfttit ();
  return R_NilValue;
}

SEXP licmod_r (SEXP s1, SEXP s2)
{ licmod (qqcptr (s1), qqcptr (s2));
  return R_NilValue;
}

SEXP licpts_r (SEXP xvmat, SEXP yvmat, SEXP nx, SEXP ny, SEXP itmat, 
               SEXP iwmat, SEXP wmat)
{ double *p1, *p2, *p5, *q5;
  int n, m, i, *p3, *p4, *q4;

  n = asInteger (nx);
  m = asInteger (ny);
  p1 = qqtmat (REAL (xvmat), n, m);
  p2 = qqtmat (REAL (yvmat), n, m);
  p3 = qqitmat (INTEGER (itmat), n, m);

  q4 = INTEGER (iwmat);
  q5 = REAL (wmat);
 
  if (p1 != NULL && p2 != NULL && p3 != NULL)
  { licpts (p1, p2, n, m, p3, q4, q5);
    p4 = qqitmat (q4, n, m);
    p5 = qqtmat (q5, n, m);

    if (p4 != NULL && p5 != NULL)    
    { for (i = 0; i < n * m; i++) 
      { q4[i] = p4[i];
        q5[i] = p5[i];
      }
    }
    free (p4);
    free (p5);
  }
 
  free (p1);
  free (p2);
  free (p3);
  return R_NilValue;
}

SEXP light_r (SEXP s)
{ light (qqcptr (s));
  return R_NilValue;
}

SEXP linclr_r (SEXP nxray, SEXP n)
{ linclr (INTEGER (nxray), asInteger (n));
  return R_NilValue;
}

SEXP lincyc_r (SEXP i1, SEXP i2)
{ lincyc (asInteger (i1), asInteger (i2));
  return R_NilValue;
}

SEXP line_r (SEXP i1, SEXP i2, SEXP i3, SEXP i4)
{ line (asInteger (i1), asInteger (i2), asInteger (i3), asInteger (i4));
  return R_NilValue;
}

SEXP linesp_r (SEXP x)
{ linesp (asReal (x));
  return R_NilValue;
}

SEXP linfit_r (SEXP xray, SEXP yray, SEXP n, SEXP s1)
{ double a, b, r;
  SEXP vec;
  linfit (REAL (xray), REAL (yray), asInteger (n), &a, &b, &r, qqcptr (s1));
  PROTECT (vec = allocVector (REALSXP, 3));
  REAL (vec)[0] = a;
  REAL (vec)[1] = b;
  REAL (vec)[2] = r;
  UNPROTECT (1);
  return vec;
}

SEXP linmod_r (SEXP s1, SEXP s2)
{ linmod (qqcptr (s1), qqcptr (s2));
  return R_NilValue;
}

SEXP lintyp_r (SEXP n)
{ lintyp (asInteger (n));
  return R_NilValue;
}

SEXP linwid_r (SEXP n)
{ linwid (asInteger (n));
  return R_NilValue;
}

SEXP litmod_r (SEXP n, SEXP s)
{ litmod (asInteger (n), qqcptr (s));
  return R_NilValue;
}

SEXP litop3_r (SEXP n, SEXP x1, SEXP x2, SEXP x3, SEXP s)
{ litop3 (asInteger (n), asReal (x1), asReal (x2), asReal (x3), qqcptr (s));
  return R_NilValue;
}

SEXP litopt_r (SEXP n, SEXP x, SEXP s)
{ litopt (asInteger (n), asReal (x), qqcptr (s));
  return R_NilValue;
}

SEXP litpos_r (SEXP n, SEXP x1, SEXP x2, SEXP x3, SEXP s)
{ litpos (asInteger (n), asReal (x1), asReal (x2), asReal (x3), qqcptr (s));
  return R_NilValue;
}

SEXP lncap_r (SEXP s)
{ lncap (qqcptr (s));
  return R_NilValue;
}

SEXP lnjoin_r (SEXP s)
{ lnjoin (qqcptr (s));
  return R_NilValue;
}

SEXP lnmlt_r (SEXP x)
{ lnmlt (asReal (x));
  return R_NilValue;
}

SEXP logtic_r (SEXP s)
{ logtic (qqcptr (s));
  return R_NilValue;
}

SEXP mapbas_r (SEXP s)
{ mapbas (qqcptr (s));
  return R_NilValue;
}

SEXP mapfil_r (SEXP s1, SEXP s2)
{ mapfil (qqcptr (s1), qqcptr (s2));
  return R_NilValue;
}

SEXP mapimg_r (SEXP s, SEXP x1, SEXP x2, SEXP x3, SEXP x4, SEXP x5, SEXP x6)
{ mapimg (qqcptr (s), asReal (x1), asReal (x2), asReal (x3),
          asReal (x4), asReal (x5), asReal (x6));
  return R_NilValue;
}

SEXP maplab_r (SEXP s1, SEXP s2)
{ maplab (qqcptr (s1), qqcptr (s2));
  return R_NilValue;
}

SEXP maplev_r (SEXP s)
{ maplev (qqcptr (s));
  return R_NilValue;
}

SEXP mapmod_r (SEXP s)
{ mapmod (qqcptr (s));
  return R_NilValue;
}

SEXP mappol_r (SEXP x1, SEXP x2)
{ mappol (asReal (x1), asReal (x2));
  return R_NilValue;
}

SEXP mapopt_r (SEXP s1, SEXP s2)
{ mapopt (qqcptr (s1), qqcptr (s2));
  return R_NilValue;
}

SEXP mapref_r (SEXP x1, SEXP x2)
{ mapref (asReal (x1), asReal (x2));
  return R_NilValue;
}

SEXP mapsph_r (SEXP x)
{ mapsph (asReal (x));
  return R_NilValue;
}

SEXP marker_r (SEXP n)
{ marker (asInteger (n));
  return R_NilValue;
}

SEXP matop3_r (SEXP x1, SEXP x2, SEXP x3, SEXP s)
{ matop3 (asReal (x1), asReal (x2), asReal (x3), qqcptr (s));
  return R_NilValue;
}

SEXP matopt_r (SEXP x, SEXP s)
{ matopt (asReal (x), qqcptr (s));
  return R_NilValue;
}

SEXP mdfmat_r (SEXP i1, SEXP i2, SEXP x)
{ mdfmat (asInteger (i1), asInteger (i2), asReal (x));
  return R_NilValue;
}

SEXP messag_r (SEXP s, SEXP i1, SEXP i2)
{ messag (qqcptr (s), asInteger (i1), asInteger (i2));
  return R_NilValue;
}

SEXP metafl_r (SEXP s)
{ metafl (qqcptr (s));
  return R_NilValue;
}

SEXP mixalf_r ()
{ mixalf ();
  return R_NilValue;
}

SEXP mixleg_r ()
{ mixleg ();
  return R_NilValue;
}

SEXP mpaepl_r (SEXP n)
{ mpaepl (asInteger (n));
  return R_NilValue;
}

SEXP mplang_r (SEXP x)
{ mplang (asReal (x));
  return R_NilValue;
}

SEXP mplclr_r (SEXP i1, SEXP i2)
{ mplclr (asInteger (i1), asInteger (i2));
  return R_NilValue;
}

SEXP mplpos_r (SEXP i1, SEXP i2)
{ mplpos (asInteger (i1), asInteger (i2));
  return R_NilValue;
}

SEXP mplsiz_r (SEXP n)
{ mplsiz (asInteger (n));
  return R_NilValue;
}

SEXP mpslogo_r (SEXP i1, SEXP i2, SEXP i3, SEXP s)
{ mpslogo (asInteger (i1), asInteger (i2), asInteger (i3), qqcptr (s));
  return R_NilValue;
}

SEXP mrkclr_r (SEXP n)
{ mrkclr (asInteger (n));
  return R_NilValue;
}

SEXP msgbox_r (SEXP s)
{ msgbox (qqcptr (s));
  return R_NilValue;
}

SEXP mshclr_r (SEXP n)
{ mshclr (asInteger (n));
  return R_NilValue;
}

SEXP mshcrv_r (SEXP n)
{ mshcrv (asInteger (n));
  return R_NilValue;
}

SEXP mylab_r (SEXP s1, SEXP n, SEXP s2)
{ mylab (qqcptr (s1), asInteger (n), qqcptr (s2));
  return R_NilValue;
}

SEXP myline_r (SEXP nxray, SEXP n)
{ myline (INTEGER (nxray), asInteger (n));
  return R_NilValue;
}

SEXP mypat_r (SEXP i1, SEXP i2, SEXP i3, SEXP i4)
{ mypat (asInteger (i1), asInteger (i2), asInteger (i3), asInteger (i4));
  return R_NilValue;
}

SEXP mysymb_r (SEXP xray, SEXP yray, SEXP n, SEXP i1, SEXP i2)
{ mysymb (REAL (xray), REAL (yray), asInteger (n), asInteger (i1),
          asInteger (i2));
  return R_NilValue;
}

SEXP myvlt_r (SEXP xray, SEXP yray, SEXP zray, SEXP n)
{ myvlt (REAL (xray), REAL (yray), REAL (zray), asInteger (n));
  return R_NilValue;
}

SEXP namdis_r (SEXP n, SEXP s)
{ namdis (asInteger (n), qqcptr (s));
  return R_NilValue;
}

SEXP name_r (SEXP s1, SEXP s2)
{ name (qqcptr (s1), qqcptr (s2));
  return R_NilValue;
}

SEXP namjus_r (SEXP s1, SEXP s2)
{ namjus (qqcptr (s1), qqcptr (s2));
  return R_NilValue;
}

SEXP nancrv_r (SEXP s)
{ nancrv (qqcptr (s));
  return R_NilValue;
}

SEXP neglog_r (SEXP x)
{ neglog (asReal (x));
  return R_NilValue;
}

SEXP newmix_r ()
{ newmix ();
  return R_NilValue;
}

SEXP newpag_r ()
{ newpag ();
  return R_NilValue;
}

SEXP nlmess_r (SEXP s)
{ int n;
  SEXP vec; 
  n = nlmess (qqcptr (s));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP nlnumb_r (SEXP x, SEXP idig)
{ int n;
  SEXP vec; 
  n = nlnumb (asReal (x), asInteger (idig));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP noarln_r ()
{ noarln ();
  return R_NilValue;
}

SEXP nobar_r ()
{ nobar ();
  return R_NilValue;
}

SEXP nobgd_r ()
{ nobgd ();
  return R_NilValue;
}

SEXP nochek_r ()
{ nochek ();
  return R_NilValue;
}

SEXP noclip_r ()
{ noclip ();
  return R_NilValue;
}

SEXP nofill_r ()
{ nofill ();
  return R_NilValue;
}

SEXP nograf_r ()
{ nograf ();
  return R_NilValue;
}

SEXP nohide_r ()
{ nohide ();
  return R_NilValue;
}

SEXP noline_r (SEXP s)
{ noline (qqcptr (s));
  return R_NilValue;
}

SEXP number_r (SEXP x, SEXP i1, SEXP i2, SEXP i3)
{ number (asReal (x), asInteger (i1), asInteger (i2), asInteger (i3));
  return R_NilValue;
}

SEXP numfmt_r (SEXP s)
{ numfmt (qqcptr (s));
  return R_NilValue;
}

SEXP numode_r (SEXP s1, SEXP s2, SEXP s3, SEXP s4)
{ numode (qqcptr (s1), qqcptr (s2), qqcptr (s3), qqcptr (s4));
  return R_NilValue;
}

SEXP nwkday_r (SEXP i1, SEXP i2, SEXP i3)
{ int n;
  SEXP vec; 
  n = nwkday (asInteger (i1), asInteger (i2), asInteger (i3));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP nxlegn_r (SEXP rray)
{ int n;
  SEXP vec; 
  n = nxlegn ((char *) RAW (rray));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP nxpixl_r (SEXP i1, SEXP i2)
{ int n;
  SEXP vec; 
  n = nxpixl (asInteger (i1), asInteger (i2));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP nxposn_r (SEXP x)
{ int n;
  SEXP vec; 
  n = nxposn (asReal (x));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP nylegn_r (SEXP rray)
{ int n;
  SEXP vec; 
  n = nylegn ((char *) RAW (rray));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP nypixl_r (SEXP i1, SEXP i2)
{ int n;
  SEXP vec; 
  n = nypixl (asInteger (i1), asInteger (i2));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP nyposn_r (SEXP x)
{ int n;
  SEXP vec; 
  n = nyposn (asReal (x));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP nzposn_r (SEXP x)
{ int n;
  SEXP vec; 
  n = nzposn (asReal (x));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP openfl_r (SEXP s, SEXP i1, SEXP i2)
{ int n;
  SEXP vec; 
  n = openfl (qqcptr (s), asInteger (i1), asInteger (i2));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP opnwin_r (SEXP n)
{ opnwin (asInteger (n));
  return R_NilValue;
}

SEXP origin_r (SEXP i1, SEXP i2)
{ origin (asInteger (i1), asInteger (i2));
  return R_NilValue;
}

SEXP page_r (SEXP i1, SEXP i2)
{ page (asInteger (i1), asInteger (i2));
  return R_NilValue;
}

SEXP pagera_r ()
{ pagera ();
  return R_NilValue;
}

SEXP pagfll_r (SEXP n)
{ pagfll (asInteger (n));
  return R_NilValue;
}

SEXP paghdr_r (SEXP s1, SEXP s2, SEXP i1, SEXP i2)
{ paghdr (qqcptr (s1), qqcptr (s2), asInteger (i1), asInteger (i2));
  return R_NilValue;
}

SEXP pagmod_r (SEXP s)
{ pagmod (qqcptr (s));
  return R_NilValue;
}

SEXP pagorg_r (SEXP s)
{ pagorg (qqcptr (s));
  return R_NilValue;
}

SEXP pagwin_r (SEXP i1, SEXP i2)
{ pagwin (asInteger (i1), asInteger (i2));
  return R_NilValue;
}

SEXP patcyc_r (SEXP i1, SEXP i2)
{ patcyc (asInteger (i1), asInteger (i2));
  return R_NilValue;
}

SEXP pdfbuf_r (SEXP rray, SEXP i1)
{ int n;
  SEXP vec;

  n = pdfbuf ((char *) RAW (rray), asInteger (i1));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP pdfmod_r (SEXP s1, SEXP s2)
{ pdfmod (qqcptr (s1), qqcptr (s2));
  return R_NilValue;
}

SEXP pdfmrk_r (SEXP s1, SEXP s2)
{ pdfmrk (qqcptr (s1), qqcptr (s2));
  return R_NilValue;
}

SEXP penwid_r (SEXP x)
{ penwid (asReal (x));
  return R_NilValue;
}

SEXP pie_r (SEXP i1, SEXP i2, SEXP i3, SEXP x1, SEXP x2)
{ pie (asInteger (i1), asInteger (i2), asInteger (i3), asReal (x1),
          asReal (x2));
  return R_NilValue;
}

SEXP piebor_r (SEXP n)
{ piebor (asInteger (n));
  return R_NilValue;
}

//void  piecbk (void (*callbck) (int iseg, double xdat, double xper, int *nrad,
//      //        int *noff, double *angle, int *nvx, int *nvy, int *idrw, 
//      //        int *iann));

SEXP pieclr_r (SEXP nxray, SEXP nyray, SEXP n)
{ pieclr (INTEGER (nxray), INTEGER (nyray), asInteger (n));
  return R_NilValue;
}

SEXP pieexp_r ()
{ pieexp ();
  return R_NilValue;
}

SEXP piegrf_r (SEXP rray, SEXP n1, SEXP xray, SEXP n2)
{ piegrf ((char *) RAW (rray), asInteger (n1), REAL (xray), asInteger (n2));
  return R_NilValue;
}

SEXP pielab_r (SEXP s1, SEXP s2)
{ pielab (qqcptr (s1), qqcptr (s2));
  return R_NilValue;
}

SEXP pieopt_r (SEXP x1, SEXP x2)
{ pieopt (asReal (x1), asReal (x2));
  return R_NilValue;
}

SEXP pierot_r (SEXP x)
{ pierot (asReal (x));
  return R_NilValue;
}

SEXP pietyp_r (SEXP s)
{ pietyp (qqcptr (s));
  return R_NilValue;
}

SEXP pieval_r (SEXP x, SEXP s)
{ pieval (asReal (x), qqcptr (s));
  return R_NilValue;
}

SEXP pievec_r (SEXP n, SEXP s)
{ pievec (asInteger (n), qqcptr (s));
  return R_NilValue;
}

SEXP pike3d_r (SEXP x1, SEXP x2, SEXP x3, SEXP x4, SEXP x5, SEXP x6, SEXP x7,  
               SEXP i1, SEXP i2)
{ pike3d (asReal (x1), asReal (x2), asReal (x3), asReal (x4), asReal (x5), 
          asReal (x6), asReal (x7), asInteger (i1), asInteger (i2));
  return R_NilValue;
}

SEXP plat3d_r (SEXP x1, SEXP x2, SEXP x3, SEXP x4, SEXP s) 
{ plat3d (asReal (x1), asReal (x2), asReal (x3), asReal (x4), qqcptr (s));
  return R_NilValue;
}

SEXP plyfin_r (SEXP s1, SEXP s2)
{ plyfin (qqcptr (s1), qqcptr (s2));
  return R_NilValue;
}

SEXP plyini_r (SEXP s)
{ plyini (qqcptr (s));
  return R_NilValue;
}

SEXP pngmod_r (SEXP s1, SEXP s2)
{ pngmod (qqcptr (s1), qqcptr (s2));
  return R_NilValue;
}

SEXP point_r (SEXP i1, SEXP i2, SEXP i3, SEXP i4, SEXP i5)
{ point (asInteger (i1), asInteger (i2), asInteger (i3), asInteger (i4),
          asInteger (i5));
  return R_NilValue;
}

SEXP polar_r (SEXP x1, SEXP x2, SEXP x3, SEXP x4, SEXP x5)
{ polar (asReal (x1), asReal (x2), asReal (x3), asReal (x4), asReal (x5));
  return R_NilValue;
}

SEXP polcrv_r (SEXP s)
{ polcrv (qqcptr (s));
  return R_NilValue;
}

SEXP polclp_r (SEXP xray, SEXP yray, SEXP nn, SEXP xray2, SEXP yray2, 
               SEXP nmax, SEXP xv, SEXP s)
{ int n;
  SEXP vec; 
  n = polclp (REAL (xray), REAL (yray), asInteger (nn), REAL (xray2),
              REAL (yray2), asInteger (nmax), asReal (xv), qqcptr (s));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP polmod_r (SEXP s1, SEXP s2)
{ polmod (qqcptr (s1), qqcptr (s2));
  return R_NilValue;
}

SEXP pos2pt_r (SEXP x, SEXP y)
{ double xp, yp;
  SEXP vec;

  pos2pt (asReal (x), asReal (y), &xp, &yp);
  PROTECT (vec = allocVector (REALSXP, 2));
  REAL (vec)[0] = xp;
  REAL (vec)[1] = yp;
  UNPROTECT (1);
  return vec;
}

SEXP pos3pt_r (SEXP x, SEXP y, SEXP z)
{ double xp, yp, zp;
  SEXP vec;

  pos3pt (asReal (x), asReal (y), asReal (z), &xp, &yp, &zp);
  PROTECT (vec = allocVector (REALSXP, 3));
  REAL (vec)[0] = xp;
  REAL (vec)[1] = yp;
  REAL (vec)[2] = zp;
  UNPROTECT (1);
  return vec;
}

SEXP posbar_r (SEXP s)
{ posbar (qqcptr (s));
  return R_NilValue;
}

SEXP posifl_r (SEXP i1, SEXP i2)
{ int n;
  SEXP vec; 
  n = posifl (asInteger (i1), asInteger (i2));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP proj3d_r (SEXP s)
{ proj3d (qqcptr (s));
  return R_NilValue;
}

SEXP projct_r (SEXP s)
{ projct (qqcptr (s));
  return R_NilValue;
}

SEXP psfont_r (SEXP s)
{ psfont (qqcptr (s));
  return R_NilValue;
}

SEXP psmode_r (SEXP s)
{ psmode (qqcptr (s));
  return R_NilValue;
}

SEXP pt2pos_r (SEXP x, SEXP y)
{ double xp, yp;
  SEXP vec;

  pt2pos (asReal (x), asReal (y), &xp, &yp);
  PROTECT (vec = allocVector (REALSXP, 2));
  REAL (vec)[0] = xp;
  REAL (vec)[1] = yp;
  UNPROTECT (1);
  return vec;
}

SEXP pyra3d_r (SEXP x1, SEXP x2, SEXP x3, SEXP x4, SEXP x5, SEXP x6, SEXP i1)
{ pyra3d (asReal (x1), asReal (x2), asReal (x3), asReal (x4), asReal (x5), 
          asReal (x6), asInteger (i1));
  return R_NilValue;
}

SEXP qplbar_r (SEXP xray, SEXP n)
{ qplbar (REAL (xray), asInteger (n));
  return R_NilValue;
}

SEXP qplclr_r (SEXP zmat, SEXP nx, SEXP ny)
{ double *p;
  p = qqtmat (REAL (zmat), asInteger (nx), asInteger (ny));
  if (p != NULL)
  { qplclr (p, asInteger (nx), asInteger (ny));
    free (p);
  }
  return R_NilValue;
}

SEXP qplcon_r (SEXP zmat, SEXP nx, SEXP ny, SEXP i)
{ double *p;
  p = qqtmat (REAL (zmat), asInteger (nx), asInteger (ny));
  if (p != NULL)
  { qplcon (p, asInteger (nx), asInteger (ny), asInteger (i));
    free (p);
  }
  return R_NilValue;
}

SEXP qplcrv_r (SEXP xray, SEXP yray, SEXP n, SEXP s)
{ qplcrv (REAL (xray), REAL (yray), asInteger (n), qqcptr (s));
  return R_NilValue;
}

SEXP qplot_r (SEXP xray, SEXP yray, SEXP n)
{ qplot (REAL (xray), REAL (yray), asInteger (n));
  return R_NilValue;
}

SEXP qplpie_r (SEXP xray, SEXP n)
{ qplpie (REAL (xray), asInteger (n));
  return R_NilValue;
}

SEXP qplsca_r (SEXP xray, SEXP yray, SEXP n)
{ qplsca (REAL (xray), REAL (yray), asInteger (n));
  return R_NilValue;
}

SEXP qplscl_r (SEXP x1, SEXP x2, SEXP x3, SEXP x4, SEXP s)
{ qplscl (asReal (x1), asReal (x2), asReal (x3), asReal (x4), qqcptr (s));
  return R_NilValue;
}

SEXP qplsur_r (SEXP zmat, SEXP nx, SEXP ny)
{ double *p;
  p = qqtmat (REAL (zmat), asInteger (nx), asInteger (ny));
  if (p != NULL)
  { qplsur (p, asInteger (nx), asInteger (ny));
    free (p);
  }
  return R_NilValue;
}

SEXP quad3d_r (SEXP x1, SEXP x2, SEXP x3, SEXP x4, SEXP x5, SEXP x6)
{ quad3d (asReal (x1), asReal (x2), asReal (x3), asReal (x4), asReal (x5), 
          asReal (x6));
  return R_NilValue;
}

SEXP rbfpng_r (SEXP rray, SEXP i1)
{ int n;
  SEXP vec;

  n = rbfpng ((char *) RAW (rray), asInteger (i1));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP rbmp_r (SEXP s)
{ rbmp (qqcptr (s));
  return R_NilValue;
}

SEXP readfl_r (SEXP i1, SEXP rray, SEXP i2)
{ int n;
  SEXP vec;

  n = readfl (asInteger (i1), RAW (rray), asInteger (i2));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP reawgt_r ()
{ reawgt ();
  return R_NilValue;
}

SEXP recfll_r (SEXP i1, SEXP i2, SEXP i3, SEXP i4, SEXP i5)
{ recfll (asInteger (i1), asInteger (i2), asInteger (i3), asInteger (i4),
          asInteger (i5));
  return R_NilValue;
}

SEXP rectan_r (SEXP i1, SEXP i2, SEXP i3, SEXP i4)
{ rectan (asInteger (i1), asInteger (i2), asInteger (i3), asInteger (i4));
  return R_NilValue;
}

SEXP rel3pt_r (SEXP x, SEXP y, SEXP z)
{ double xp, yp;
  SEXP vec;

  rel3pt (asReal (x), asReal (y), asReal (z), &xp, &yp);
  PROTECT (vec = allocVector (REALSXP, 2));
  REAL (vec)[0] = xp;
  REAL (vec)[1] = yp;
  UNPROTECT (1);
  return vec;
}

SEXP resatt_r ()
{ resatt ();
  return R_NilValue;
}

SEXP reset_r (SEXP s)
{ reset (qqcptr (s));
  return R_NilValue;
}

SEXP revscr_r ()
{ revscr ();
  return R_NilValue;
}

SEXP rgbhsv_r (SEXP x1, SEXP x2, SEXP x3)
{ double x4, x5, x6;
  SEXP vec;

  rgbhsv (asReal (x1), asReal (x2), asReal (x3), &x4, &x5, &x6);
  PROTECT (vec = allocVector (REALSXP, 3));
  REAL (vec)[0] = x4;
  REAL (vec)[1] = x5;
  REAL (vec)[2] = x6;
  UNPROTECT (1);
  return vec;
}

SEXP rgif_r (SEXP s)
{ rgif (qqcptr (s));
  return R_NilValue;
}

SEXP rgtlab_r ()
{ rgtlab ();
  return R_NilValue;
}

SEXP rimage_r (SEXP s)
{ rimage (qqcptr (s));
  return R_NilValue;
}

SEXP rlarc_r (SEXP x1, SEXP x2, SEXP x3, SEXP x4,
              SEXP x5, SEXP x6, SEXP x7)
{ rlarc (asReal (x1), asReal (x2), asReal (x3), asReal (x4), 
         asReal (x5), asReal (x6), asReal (x7));
  return R_NilValue;
}

SEXP rlarea_r (SEXP xray, SEXP yray, SEXP n)
{ rlarea (REAL (xray), REAL (yray), asInteger (n));
  return R_NilValue;
}

SEXP rlcirc_r (SEXP x1, SEXP x2, SEXP x3)
{ rlcirc (asReal (x1), asReal (x2), asReal (x3));
  return R_NilValue;
}

SEXP rlconn_r (SEXP x, SEXP y)
{ rlconn (asReal (x), asReal (y));
  return R_NilValue;
}

SEXP rlell_r (SEXP x1, SEXP x2, SEXP x3, SEXP x4)
{ rlell (asReal (x1), asReal (x2), asReal (x3), asReal (x4));
  return R_NilValue;
}

SEXP rline_r (SEXP x1, SEXP x2, SEXP x3, SEXP x4)
{ rline (asReal (x1), asReal (x2), asReal (x3), asReal (x4));
  return R_NilValue;
}

SEXP rlmess_r (SEXP s, SEXP x1, SEXP x2)
{ rlmess (qqcptr (s), asReal (x1), asReal (x2));
  return R_NilValue;
}

SEXP rlnumb_r (SEXP x1, SEXP i, SEXP x2, SEXP x3)
{ rlnumb (asReal (x1), asInteger (i), asReal (x2), asReal (x3));
  return R_NilValue;
}

SEXP rlpie_r (SEXP x1, SEXP x2, SEXP x3, SEXP x4, SEXP x5)
{ rlpie (asReal (x1), asReal (x2), asReal (x3), asReal (x4), asReal (x5));
  return R_NilValue;
}

SEXP rlpoin_r (SEXP x1, SEXP x2, SEXP i1, SEXP i2, SEXP i3)
{ rlpoin (asReal (x1), asReal (x2), asInteger (i1), asInteger (i2),
          asInteger (i3));
  return R_NilValue;
}

SEXP rlrec_r (SEXP x1, SEXP x2, SEXP x3, SEXP x4)
{ rlrec (asReal (x1), asReal (x2), asReal (x3), asReal (x4));
  return R_NilValue;
}

SEXP rlrnd_r (SEXP x1, SEXP x2, SEXP x3, SEXP x4, SEXP i)
{ rlrnd (asReal (x1), asReal (x2), asReal (x3), asReal (x4), asInteger (i));
  return R_NilValue;
}

SEXP rlsec_r (SEXP x1, SEXP x2, SEXP x3, SEXP x4, SEXP x5, SEXP x6, SEXP i)
{ rlsec (asReal (x1), asReal (x2), asReal (x3), asReal (x4), asReal (x5),
         asReal (x6), asInteger (i));
  return R_NilValue;
}

SEXP rlstrt_r (SEXP x, SEXP y)
{ rlstrt (asReal (x), asReal (y));
  return R_NilValue;
}

SEXP rlsymb_r (SEXP i, SEXP x1, SEXP x2)
{ rlsymb (asInteger (i), asReal (x1), asReal (x2));
  return R_NilValue;
}

SEXP rlvec_r (SEXP x1, SEXP x2, SEXP x3, SEXP x4, SEXP i)
{ rlvec (asReal (x1), asReal (x2), asReal (x3), asReal (x4), asInteger (i));
  return R_NilValue;
}

SEXP rlwind_r (SEXP x1, SEXP x2, SEXP x3, SEXP i, SEXP x4)
{ rlwind (asReal (x1), asReal (x2), asReal (x3), asInteger (i), asReal (x4));
  return R_NilValue;
}

SEXP rndrec_r (SEXP i1, SEXP i2, SEXP i3, SEXP i4, SEXP i5)
{ rndrec (asInteger (i1), asInteger (i2), asInteger (i3), asInteger (i4),
        asInteger (i5));
  return R_NilValue;
}

SEXP rot3d_r (SEXP x1, SEXP x2, SEXP x3)
{ rot3d (asReal (x1), asReal (x2), asReal (x3));
  return R_NilValue;
}

SEXP rpixel_r (SEXP ix, SEXP iy)
{ int n;
  SEXP vec; 
  rpixel (asInteger (ix), asInteger (iy), &n);
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP rpixls_r (SEXP rray, SEXP i1, SEXP i2, SEXP i3, SEXP i4)
{ rpixls (RAW (rray), asInteger (i1), asInteger (i2), asInteger (i3),
          asInteger (i4));
  return R_NilValue;
}

SEXP rpng_r (SEXP s)
{ rpng (qqcptr (s));
  return R_NilValue;
}

SEXP rppm_r (SEXP s)
{ rppm (qqcptr (s));
  return R_NilValue;
}

SEXP rpxrow_r (SEXP rray, SEXP i1, SEXP i2, SEXP i3)
{ rpxrow (RAW (rray), asInteger (i1), asInteger (i2), asInteger (i3));
  return R_NilValue;
}

SEXP rtiff_r (SEXP s)
{ rtiff (qqcptr (s));
  return R_NilValue;
}

SEXP rvynam_r ()
{ rvynam ();
  return R_NilValue;
}

SEXP scale_r (SEXP s1, SEXP s2)
{ scale (qqcptr (s1), qqcptr (s2));
  return R_NilValue;
}

SEXP sclfac_r (SEXP x)
{ sclfac (asReal (x));
  return R_NilValue;
}

SEXP sclmod_r (SEXP s)
{ sclmod (qqcptr (s));
  return R_NilValue;
}

SEXP scrmod_r (SEXP s)
{ scrmod (qqcptr (s));
  return R_NilValue;
}

SEXP sector_r (SEXP i1, SEXP i2, SEXP i3, SEXP i4, SEXP x1, SEXP x2, SEXP i5)
{ sector (asInteger (i1), asInteger (i2), asInteger (i3), asInteger (i4),
          asReal (x1), asReal (x2), asInteger (i5));
  return R_NilValue;
}

SEXP selwin_r (SEXP n)
{ selwin (asInteger (n));
  return R_NilValue;
}

SEXP sendbf_r ()
{ sendbf ();
  return R_NilValue;
}

SEXP sendmb_r ()
{ sendmb ();
  return R_NilValue;
}

SEXP sendok_r ()
{ sendok ();
  return R_NilValue;
}

SEXP serif_r ()
{ serif ();
  return R_NilValue;
}

SEXP setbas_r (SEXP x)
{ setbas (asReal (x));
  return R_NilValue;
}

//void  setcbk (void (*callbck) (double *x, double *y), const char *copt);

SEXP setclr_r (SEXP n)
{ setclr (asInteger (n));
  return R_NilValue;
}

SEXP setexp_r (SEXP x)
{ setexp (asReal (x));
  return R_NilValue;
}

SEXP setfce_r (SEXP s)
{ setfce (qqcptr (s));
  return R_NilValue;
}

SEXP setfil_r (SEXP s)
{ setfil (qqcptr (s));
  return R_NilValue;
}

SEXP setgrf_r (SEXP s1, SEXP s2, SEXP s3, SEXP s4)
{ setgrf (qqcptr (s1), qqcptr (s2), qqcptr (s3), qqcptr (s4));
  return R_NilValue;
}

SEXP setind_r (SEXP i, SEXP x1, SEXP x2, SEXP x3)
{ setind (asInteger (i), asReal (x1), asReal (x2), asReal (x3));
  return R_NilValue;
}

SEXP setmix_r (SEXP s1, SEXP s2)
{ setmix (qqcptr (s1), qqcptr (s2));
  return R_NilValue;
}

SEXP setpag_r (SEXP s)
{ setpag (qqcptr (s));
  return R_NilValue;
}

SEXP setres_r (SEXP i1, SEXP i2)
{ setres (asInteger (i1), asInteger (i2));
  return R_NilValue;
}

SEXP setres3d_r (SEXP x1, SEXP x2, SEXP x3)
{ setres3d (asReal (x1), asReal (x2), asReal (x3));
  return R_NilValue;
}

SEXP setrgb_r (SEXP x1, SEXP x2, SEXP x3)
{ setrgb (asReal (x1), asReal (x2), asReal (x3));
  return R_NilValue;
}

SEXP setscl_r (SEXP xray, SEXP n, SEXP s)
{ setscl (REAL (xray), asInteger (n), qqcptr (s));
  return R_NilValue;
}

SEXP setvlt_r (SEXP s)
{ setvlt (qqcptr (s));
  return R_NilValue;
}

SEXP setxid_r (SEXP i, SEXP s)
{ setxid (asInteger (i), qqcptr (s));
  return R_NilValue;
}

SEXP shdafr_r (SEXP i1, SEXP i2, SEXP i3, SEXP n)
{ long *p;
  p = qqlong (INTEGER (i2), asInteger (n));
  if (p != NULL)
  { shdafr (INTEGER (i1), p, INTEGER (i3), asInteger (n));
    free (p);
  }
  return R_NilValue;
}

SEXP shdasi_r (SEXP i1, SEXP i2, SEXP i3, SEXP n)
{ long *p;
  p = qqlong (INTEGER (i2), asInteger (n));
  if (p != NULL)
  { shdasi (INTEGER (i1), p, INTEGER (i3), asInteger (n));
    free (p);
  }
  return R_NilValue;
}

SEXP shdaus_r (SEXP i1, SEXP i2, SEXP i3, SEXP n)
{ long *p;
  p = qqlong (INTEGER (i2), asInteger (n));
  if (p != NULL)
  { shdaus (INTEGER (i1), p, INTEGER (i3), asInteger (n));
    free (p);
  }
  return R_NilValue;
}

SEXP shdcha_r ()
{ shdcha ();
  return R_NilValue;
}

SEXP shdcrv_r (SEXP xray, SEXP yray, SEXP n1, SEXP x2ray, SEXP y2ray, SEXP n2)
{ shdcrv (REAL (xray), REAL (yray), asInteger (n1), REAL (x2ray), REAL (y2ray),
          asInteger (n2));
  return R_NilValue;
}

SEXP shdeur_r (SEXP i1, SEXP i2, SEXP i3, SEXP n)
{ long *p;
  p = qqlong (INTEGER (i2), asInteger (n));
  if (p != NULL)
  { shdeur (INTEGER (i1), p, INTEGER (i3), asInteger (n));
    free (p);
  }
  return R_NilValue;
}

SEXP shdfac_r (SEXP x)
{ shdfac (asReal (x));
  return R_NilValue;
}

SEXP shdmap_r (SEXP s)
{ shdmap (qqcptr (s));
  return R_NilValue;
}

SEXP shdmod_r (SEXP s1, SEXP s2)
{ shdmod (qqcptr (s1), qqcptr (s2));
  return R_NilValue;
}

SEXP shdnor_r (SEXP i1, SEXP i2, SEXP i3, SEXP n)
{ long *p;
  p = qqlong (INTEGER (i2), asInteger (n));
  if (p != NULL)
  { shdnor (INTEGER (i1), p, INTEGER (i3), asInteger (n));
    free (p);
  }
  return R_NilValue;
}

SEXP shdpat_r (SEXP n)
{ shdpat (asInteger (n));
  return R_NilValue;
}

SEXP shdsou_r (SEXP i1, SEXP i2, SEXP i3, SEXP n)
{ long *p;
  p = qqlong (INTEGER (i2), asInteger (n));
  if (p != NULL)
  { shdsou (INTEGER (i1), p, INTEGER (i3), asInteger (n));
    free (p);
  }
  return R_NilValue;
}

SEXP shdusa_r (SEXP i1, SEXP i2, SEXP i3, SEXP n)
{ long *p;
  p = qqlong (INTEGER (i2), asInteger (n));
  if (p != NULL)
  { shdusa (INTEGER (i1), p, INTEGER (i3), asInteger (n));
    free (p);
  }
  return R_NilValue;
}

SEXP shield_r (SEXP s1, SEXP s2)
{ shield (qqcptr (s1), qqcptr (s2));
  return R_NilValue;
}

SEXP shlcir_r (SEXP i1, SEXP i2, SEXP i3)
{ shlcir (asInteger (i1), asInteger (i2), asInteger (i3));
  return R_NilValue;
}

SEXP shldel_r (SEXP n)
{ shldel (asInteger (n));
  return R_NilValue;
}

SEXP shlell_r (SEXP i1, SEXP i2, SEXP i3, SEXP i4, SEXP x)
{ shlell (asInteger (i1), asInteger (i2), asInteger (i3), asInteger (i4),
          asReal (x));
  return R_NilValue;
}

SEXP shlind_r ()
{ int n;
  SEXP vec; 
  n = shlind ();
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP shlpie_r (SEXP i1, SEXP i2, SEXP i3, SEXP x1, SEXP x2)
{ shlpie (asInteger (i1), asInteger (i2), asInteger (i3), asReal (x1),
          asReal (x2));
  return R_NilValue;
}

SEXP shlpol_r (SEXP nxray, SEXP nyray, SEXP n)
{ shlpol (INTEGER (nxray), INTEGER (nyray), asInteger (n));
  return R_NilValue;
}

SEXP shlrct_r (SEXP i1, SEXP i2, SEXP i3, SEXP i4, SEXP x)
{ shlrct (asInteger (i1), asInteger (i2), asInteger (i3), asInteger (i4),
          asReal (x));
  return R_NilValue;
}

SEXP shlrec_r (SEXP i1, SEXP i2, SEXP i3, SEXP i4)
{ shlrec (asInteger (i1), asInteger (i2), asInteger (i3), asInteger (i4));
  return R_NilValue;
}

SEXP shlres_r (SEXP n)
{ shlres (asInteger (n));
  return R_NilValue;
}

SEXP shlsur_r ()
{ shlsur ();
  return R_NilValue;
}

SEXP shlvis_r (SEXP n, SEXP s)
{ shlvis (asInteger (n), qqcptr (s));
  return R_NilValue;
}

SEXP simplx_r ()
{ simplx ();
  return R_NilValue;
}

SEXP skipfl_r (SEXP i1, SEXP i2)
{ int n;
  SEXP vec; 
  n = skipfl (asInteger (i1), asInteger (i2));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP smxalf_r (SEXP s1, SEXP s2, SEXP s3, SEXP i)
{ smxalf (qqcptr (s1), qqcptr (s2), qqcptr (s3), asInteger (i));
  return R_NilValue;
}

SEXP solid_r ()
{ solid ();
  return R_NilValue;
}

SEXP  sortr1_r (SEXP xray, SEXP n, SEXP s)
{ sortr1 (REAL (xray), asInteger (n), qqcptr (s));
  return R_NilValue;
} 

SEXP  sortr2_r (SEXP xray, SEXP yray, SEXP n, SEXP s)
{ sortr2 (REAL (xray), REAL (yray), asInteger (n), qqcptr (s));
  return R_NilValue;
} 

SEXP spcbar_r (SEXP n)
{ spcbar (asInteger (n));
  return R_NilValue;
}

SEXP sphe3d_r (SEXP x1, SEXP x2, SEXP x3, SEXP x4, SEXP i1, SEXP i2)
{ sphe3d (asReal (x1), asReal (x2), asReal (x3), asReal (x4),  
          asInteger (i1), asInteger (i2));
  return R_NilValue;
}

SEXP spline_r (SEXP xray, SEXP yray, SEXP n, SEXP xsray, SEXP ysray)
{ int nspl;
  SEXP vec; 
  spline (REAL (xray), REAL (yray), asInteger (n), REAL (xsray), REAL (ysray),
         &nspl);
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = nspl;
  UNPROTECT (1);
  return vec;
}

SEXP splmod_r (SEXP i1, SEXP i2)
{ splmod (asInteger (i1), asInteger (i2));
  return R_NilValue;
}

SEXP stmmod_r (SEXP s1, SEXP s2)
{ stmmod (qqcptr (s1), qqcptr (s2));
  return R_NilValue;
}

SEXP stmopt_r (SEXP n, SEXP s)
{ stmopt (asInteger (n), qqcptr (s));
  return R_NilValue;
}

SEXP stmpts_r (SEXP xmat, SEXP ymat, SEXP nx, SEXP ny, SEXP xpray, SEXP ypray,
               SEXP x0, SEXP y0, SEXP xray, SEXP yray, SEXP nmax)
{ int n = 0;
  SEXP vec; 
  double *p1, *p2;
  
  p1 = qqtmat (REAL (xmat), asInteger (nx), asInteger (ny));
  p2 = qqtmat (REAL (ymat), asInteger (nx), asInteger (ny));
  if (p1 != NULL && p2 != NULL)
  { stmpts (p1, p2, asInteger (nx), asInteger (ny), REAL (xpray), REAL (ypray),
            asReal (x0), asReal (y0), REAL (xray), REAL (yray), 
            asInteger (nmax), &n);
  }
  free (p1);
  free (p2);
  
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP stmpts3d_r (SEXP xmat, SEXP ymat, SEXP zmat, SEXP nx, SEXP ny, SEXP nz,
                 SEXP xpray, SEXP ypray, SEXP zpray, SEXP x0, SEXP y0, SEXP z0,
                 SEXP xray, SEXP yray, SEXP zray, SEXP nmax)
{ int n = 0;
  SEXP vec; 
  double *p1, *p2, *p3;
  
  p1 = qqtmat (REAL (xmat), asInteger (nx), asInteger (ny));
  p2 = qqtmat (REAL (ymat), asInteger (nx), asInteger (ny));
  p3 = qqtmat (REAL (zmat), asInteger (nx), asInteger (ny));
  if (p1 != NULL && p2 != NULL && p3 != NULL)
  { stmpts3d (p1, p2, p3, asInteger (nx), asInteger (ny), asInteger (nz),
              REAL (xpray), REAL (ypray), REAL (zpray), asReal (x0), 
              asReal (y0), asReal (z0), REAL (xray), REAL (yray), REAL (zray), 
              asInteger (nmax), &n);
  }
  free (p1);
  free (p2);
  free (p3);
  
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP stmtri_r (SEXP xvray, SEXP yvray, SEXP xpray, SEXP ypray, SEXP n1,
               SEXP i1ray, SEXP i2ray, SEXP i3ray, SEXP ntri,
               SEXP xsray, SEXP ysray, SEXP n2)
{ stmtri (REAL (xvray), REAL (yvray), REAL (xpray), REAL (ypray), 
                asInteger (n1), INTEGER (i1ray), INTEGER (i2ray),
                INTEGER (i3ray), asInteger (ntri),  REAL (xsray),
	        REAL (ysray), asInteger (n2));
  return R_NilValue;
}

SEXP stmval_r (SEXP x, SEXP s)
{ stmval (asReal (x), qqcptr (s));
  return R_NilValue;
}

SEXP stream_r (SEXP xmat, SEXP ymat, SEXP nx, SEXP ny, SEXP xpray, SEXP ypray,
               SEXP xsray, SEXP ysray, SEXP n)
{ double *p1, *p2;

  p1 = qqtmat (REAL (xmat), asInteger (nx), asInteger (ny));
  p2 = qqtmat (REAL (ymat), asInteger (nx), asInteger (ny));
  if (p1 != NULL && p2 != NULL)
    stream (p1, p2, asInteger (nx), asInteger (ny), REAL (xpray), REAL (ypray),
            REAL (xsray), REAL (ysray), asInteger (n));
  free (p1);
  free (p2);  
  return R_NilValue;
}

SEXP stream3d_r (SEXP xmat, SEXP ymat, SEXP zmat, SEXP nx, SEXP ny, SEXP nz,
                 SEXP xpray, SEXP ypray, SEXP zpray, SEXP xsray, SEXP ysray, 
                 SEXP zsray, SEXP n)
{ double *p1, *p2, *p3;

  p1 = qqtmat3 (REAL (xmat), asInteger (nx), asInteger (ny), asInteger (nz));
  p2 = qqtmat3 (REAL (ymat), asInteger (nx), asInteger (ny), asInteger (nz));
  p3 = qqtmat3 (REAL (ymat), asInteger (nx), asInteger (ny), asInteger (nz));
  if (p1 != NULL && p2 != NULL && p3 != NULL)
    stream3d (p1, p2, p3, asInteger (nx), asInteger (ny), asInteger (nz),
              REAL (xpray), REAL (ypray), REAL (zpray), REAL (xsray), 
              REAL (ysray), REAL (zsray), asInteger (n));
  free (p1);
  free (p2);  
  free (p3);  
  return R_NilValue;
}

SEXP strt3d_r (SEXP x, SEXP y, SEXP z)
{ strt3d (asReal (x), asReal (y), asReal (z));
  return R_NilValue;
}

SEXP strtpt_r (SEXP x, SEXP y)
{ strtpt (asReal (x), asReal (y));
  return R_NilValue;
}

SEXP surclr_r (SEXP i1, SEXP i2)
{ surclr (asInteger (i1), asInteger (i2));
  return R_NilValue;
}

SEXP surfce_r (SEXP xray, SEXP nx, SEXP yray, SEXP ny, SEXP zmat)
{ double *p;
  p = qqtmat (REAL (zmat), asInteger (nx), asInteger (ny));
  if (p != NULL)
  { surfce (REAL (xray), asInteger (nx), REAL (yray), asInteger (ny), p);
    free (p);
  }
  return R_NilValue;
}

SEXP  surfcp_r (SEXP func, SEXP x1, SEXP x2, SEXP x3, SEXP x4, 
                SEXP x5, SEXP x6)

{ if (!isFunction (func))
    error ("func must be a function");
  else
  { SurfcpSEXP = func;
    surfcp (SurfcpCB, asReal (x1), asReal (x2), asReal (x3), asReal (x4), 
            asReal (x5), asReal (x6));
  }
  return R_NilValue; 
}

double SurfcpCB (double x, double y, int iopt)
{ SEXP fcall, result, a, b, opt;
  double *v;
  
  PROTECT (a = allocVector (REALSXP, 1));
  PROTECT (b = allocVector (REALSXP, 1));
  PROTECT (opt = allocVector (INTSXP, 1));
  REAL (a)[0] = x;
  REAL (b)[0] = y;
  INTEGER (opt)[0] = iopt;
  PROTECT (fcall = lang4 (SurfcpSEXP, a, b, opt)); 
  PROTECT (result = eval (fcall, R_GlobalEnv));
  v = REAL (result);
  UNPROTECT (5);
  return *v;
} 

SEXP  surfun_r (SEXP func, SEXP ixpts, SEXP xdel, SEXP iypts, SEXP ydel) 
{ if (!isFunction (func))
    error ("func must be a function");
  else
  { SurfunSEXP = func;
    surfun (SurfunCB, asInteger (ixpts), asReal (xdel), asInteger (iypts), 
            asReal (ydel));
  }
  return R_NilValue; 
}

double SurfunCB (double x, double y)
{ SEXP fcall, result, a, b;
  double *v;
  
  PROTECT (a = allocVector (REALSXP, 1));
  PROTECT (b = allocVector (REALSXP, 1));
  REAL (a)[0] = x;
  REAL (b)[0] = y;
  PROTECT (fcall = lang3 (SurfunSEXP, a, b)); 
  PROTECT (result = eval (fcall, R_GlobalEnv));
  v = REAL (result);
  UNPROTECT (5);
  return *v;
} 

SEXP suriso_r (SEXP xray, SEXP nx, SEXP yray, SEXP ny, SEXP zray, SEXP nz,
               SEXP wmat, SEXP wlev)
{ double *p;
  p = qqtmat3 (REAL (wmat), asInteger (nx), asInteger (ny), asInteger (nz));
  if (p != NULL)
  { suriso (REAL (xray), asInteger (nx), REAL (yray), asInteger (ny), 
            REAL (zray), asInteger (nz), p, asReal (wlev));
    free (p);
  }
  return R_NilValue;
}

SEXP surmat_r (SEXP zmat, SEXP nx, SEXP ny, SEXP ixpts, SEXP iypts)
{ double *p;
  p = qqtmat (REAL (zmat), asInteger (nx), asInteger (ny));
  if (p != NULL)
  { surmat (p, asInteger (nx), asInteger (ny), asInteger (ixpts), 
            asInteger (iypts));
    free (p);
  }
  return R_NilValue;
}

SEXP surmsh_r (SEXP s)
{ surmsh (qqcptr (s));
  return R_NilValue;
}

SEXP suropt_r (SEXP s)
{ suropt (qqcptr (s));
  return R_NilValue;
}

SEXP surshc_r (SEXP xray, SEXP nx, SEXP yray, SEXP ny, SEXP zmat, SEXP wmat)
{ double *p1, *p2;
  p1 = qqtmat (REAL (zmat), asInteger (nx), asInteger (ny));
  p2 = qqtmat (REAL (wmat), asInteger (nx), asInteger (ny));
  if (p1 != NULL && p2 != NULL)
    surshc (REAL (xray), asInteger (nx), REAL (yray), asInteger (ny), p1, p2);
  if (p1 != NULL) free (p1);
  if (p2 != NULL) free (p2);
  return R_NilValue;
}

SEXP surshd_r (SEXP xray, SEXP nx, SEXP yray, SEXP ny, SEXP zmat)
{ double *p;
  p = qqtmat (REAL (zmat), asInteger (nx), asInteger (ny));
  if (p != NULL)
  { surshd (REAL (xray), asInteger (nx), REAL (yray), asInteger (ny), p);
    free (p);
  }
  return R_NilValue;
}

SEXP sursze_r (SEXP x1, SEXP x2, SEXP x3, SEXP x4)
{ sursze (asReal (x1), asReal (x2), asReal (x3), asReal (x4));
  return R_NilValue;
}

SEXP surtri_r (SEXP xray, SEXP yray, SEXP zray, SEXP n1, SEXP i1ray,
               SEXP i2ray, SEXP i3ray, SEXP n2)
{ surtri (REAL (xray), REAL (yray), REAL (zray), asInteger (n1), 
          INTEGER (i1ray), INTEGER (i2ray), INTEGER (i3ray), asInteger (n2));
  return R_NilValue;
}

SEXP survis_r (SEXP s)
{ survis (qqcptr (s));
  return R_NilValue;
}

SEXP swapi4_r (SEXP nray, SEXP n)
{ swapi4(INTEGER (nray), asInteger (n));
  return R_NilValue;
}

SEXP swgatt_r (SEXP i, SEXP s1, SEXP s2)
{ swgatt (asInteger (i), qqcptr (s1), qqcptr (s2));
  return R_NilValue;
}

SEXP swgbgd_r (SEXP i, SEXP xr, SEXP xg, SEXP xb)
{ swgbgd (asInteger (i), asReal (xr), asReal (xg), asReal (xb));
  return R_NilValue;
}

SEXP swgbox_r (SEXP i1, SEXP i2)
{ swgbox (asInteger (i1), asInteger (i2));
  return R_NilValue;
}

SEXP swgbut_r (SEXP i1, SEXP i2)
{ swgbut (asInteger (i1), asInteger (i2));
  return R_NilValue;
}

SEXP  swgcb2_r (SEXP i1, SEXP func)
{ int *id;

  id = INTEGER (i1);
  if (ncbray < MAX_CB)
  { icbray[ncbray] = *id;
    SwgcbkSEXP[ncbray] = func;
    ncbray++;
  }
  else
  { error ("Too many callback routines"); 
    return R_NilValue; 
  }
  swgcb2 (*id, Swgcb2CB);
  return R_NilValue; 
}

void Swgcb2CB (int id, int irow, int icol)
{ SEXP fcall, result, opt1, opt2, opt3;
  int i, j;
  
  j = -1;
  for (i = 0; i < ncbray; i++)
  { if (id == icbray[i])  
    { j = i;
      break;
    }
  }
  if (j == -1) return;
  PROTECT (opt1 = allocVector (INTSXP, 1));
  PROTECT (opt2 = allocVector (INTSXP, 1));
  PROTECT (opt3 = allocVector (INTSXP, 1));
  INTEGER (opt1)[0] = id;
  INTEGER (opt2)[0] = irow;
  INTEGER (opt3)[0] = icol;
  PROTECT (fcall = lang4 (SwgcbkSEXP[j], opt1, opt2, opt3)); 
  PROTECT (result = eval (fcall, R_GlobalEnv));
  UNPROTECT (5);
} 

SEXP  swgcb3_r (SEXP i1, SEXP func)
{ int *id;

  id = INTEGER (i1);
  if (ncbray < MAX_CB)
  { icbray[ncbray] = *id;
    SwgcbkSEXP[ncbray] = func;
    ncbray++;
  }
  else
  { error ("Too many callback routines"); 
    return R_NilValue; 
  }
  swgcb3 (*id, Swgcb3CB);
  return R_NilValue; 
}

void Swgcb3CB (int id, int ival)
{ SEXP fcall, result, opt1, opt2;
  int i, j;
  
  j = -1;
  for (i = 0; i < ncbray; i++)
  { if (id == icbray[i])  
    { j = i;
      break;
    }
  }
  if (j == -1) return;
  PROTECT (opt1 = allocVector (INTSXP, 1));
  PROTECT (opt2 = allocVector (INTSXP, 1));
  INTEGER (opt1)[0] = id;
  INTEGER (opt2)[0] = ival;
  PROTECT (fcall = lang3 (SwgcbkSEXP[j], opt1, opt2)); 
  PROTECT (result = eval (fcall, R_GlobalEnv));
  UNPROTECT (4);
} 

SEXP  swgcbk_r (SEXP i1, SEXP func)
{ int *id;

  id = INTEGER (i1);
  if (ncbray < MAX_CB)
  { icbray[ncbray] = *id;
    SwgcbkSEXP[ncbray] = func;
    ncbray++;
  }
  else
  { error ("Too many callback routines"); 
    return R_NilValue; 
  }
  swgcbk (*id, SwgcbkCB);
  return R_NilValue; 
}

void SwgcbkCB (int id)
{ SEXP fcall, result, opt;
  int i, j;
  
  j = -1;
  for (i = 0; i < ncbray; i++)
  { if (id == icbray[i])  
    { j = i;
      break;
    }
  }
  if (j == -1) return;
  PROTECT (opt = allocVector (INTSXP, 1));
  INTEGER (opt)[0] = id;
  PROTECT (fcall = lang2 (SwgcbkSEXP[j], opt)); 
  PROTECT (result = eval (fcall, R_GlobalEnv));
  UNPROTECT (3);
} 

SEXP swgclr_r (SEXP xr, SEXP xg, SEXP xb, SEXP s)
{ swgclr (asReal (xr), asReal (xg), asReal (xb), qqcptr (s));
  return R_NilValue;
}

SEXP swgdrw_r (SEXP x)
{ swgdrw (asReal (x));
  return R_NilValue;
}

SEXP swgfgd_r (SEXP i, SEXP xr, SEXP xg, SEXP xb)
{ swgfgd (asInteger (i), asReal (xr), asReal (xg), asReal (xb));
  return R_NilValue;
}

SEXP swgfil_r (SEXP n, SEXP s)
{ swgfil (asInteger (n), qqcptr (s));
  return R_NilValue;
}

SEXP swgflt_r (SEXP i1, SEXP x, SEXP i2)
{ swgflt (asInteger (i1), asReal (x), asInteger (i2));
  return R_NilValue;
}

SEXP swgfnt_r (SEXP s, SEXP n)
{ swgfnt (qqcptr (s), asInteger (n));
  return R_NilValue;
}

SEXP swgfoc_r (SEXP n)
{ swgfoc (asInteger (n));
  return R_NilValue;
}

SEXP swghlp_r (SEXP s)
{ swghlp (qqcptr (s));
  return R_NilValue;
}

SEXP swgint_r (SEXP i1, SEXP i2)
{ swgint (asInteger (i1), asInteger (i2));
  return R_NilValue;
}

SEXP swgiop_r (SEXP n, SEXP s)
{ swgiop (asInteger (n), qqcptr (s));
  return R_NilValue;
}

SEXP swgjus_r (SEXP s1, SEXP s2)
{ swgjus (qqcptr (s1), qqcptr (s2));
  return R_NilValue;
}

SEXP swglis_r (SEXP i1, SEXP i2)
{ swglis (asInteger (i1), asInteger (i2));
  return R_NilValue;
}

SEXP swgmix_r (SEXP s1, SEXP s2)
{ swgmix (qqcptr (s1), qqcptr (s2));
  return R_NilValue;
}

SEXP swgmrg_r (SEXP n, SEXP s)
{ swgmrg (asInteger (n), qqcptr (s));
  return R_NilValue;
}

SEXP swgoff_r (SEXP i1, SEXP i2)
{ swgoff (asInteger (i1), asInteger (i2));
  return R_NilValue;
}

SEXP swgopt_r (SEXP s1, SEXP s2)
{ swgopt (qqcptr (s1), qqcptr (s2));
  return R_NilValue;
}

SEXP swgpop_r (SEXP s)
{ swgpop (qqcptr (s));
  return R_NilValue;
}

SEXP swgpos_r (SEXP i1, SEXP i2)
{ swgpos (asInteger (i1), asInteger (i2));
  return R_NilValue;
}

SEXP swgray_r (SEXP xray, SEXP n, SEXP s)
{ swgray (REAL (xray), asInteger (n), qqcptr (s));
  return R_NilValue;
}

SEXP swgscl_r (SEXP i, SEXP x)
{ swgscl (asInteger (i), asReal (x));
  return R_NilValue;
}

SEXP swgsiz_r (SEXP i1, SEXP i2)
{ swgsiz (asInteger (i1), asInteger (i2));
  return R_NilValue;
}

SEXP swgspc_r (SEXP x1, SEXP x2)
{ swgspc (asReal (x1), asReal (x2));
  return R_NilValue;
}

SEXP swgstp_r (SEXP x)
{ swgstp (asReal (x));
  return R_NilValue;
}

SEXP swgtbf_r (SEXP i1, SEXP x, SEXP i2, SEXP i3, SEXP i4, SEXP s)
{ swgtbf (asInteger (i1), asReal (x), asInteger (i2), asInteger (i3),
          asInteger (i4), qqcptr (s));
  return R_NilValue;
}

SEXP swgtbi_r (SEXP i1, SEXP i2, SEXP i3, SEXP i4, SEXP s)
{ swgtbi (asInteger (i1), asInteger (i2), asInteger (i3),
          asInteger (i4), qqcptr (s));
  return R_NilValue;
}

SEXP swgtbl_r (SEXP i1, SEXP xray, SEXP n, SEXP i2, SEXP i3, SEXP s)
{ swgtbl (asInteger (i1), REAL (xray), asInteger (n), asInteger (i2),
          asInteger (i3), qqcptr (s));
  return R_NilValue;
}

SEXP swgtbs_r (SEXP i1, SEXP s1, SEXP i2, SEXP i3, SEXP s2)
{ swgtbs (asInteger (i1), qqcptr (s1), asInteger (i2), asInteger (i3),
          qqcptr (s2));
  return R_NilValue;
}

SEXP swgtit_r (SEXP s)
{ swgtit (qqcptr (s));
  return R_NilValue;
}

SEXP swgtxt_r (SEXP n, SEXP s)
{ swgtxt (asInteger (n), qqcptr (s));
  return R_NilValue;
}

SEXP swgtyp_r (SEXP s1, SEXP s2)
{ swgtyp (qqcptr (s1), qqcptr (s2));
  return R_NilValue;
}

SEXP swgval_r (SEXP i, SEXP x)
{ swgval (asInteger (i), asReal (x));
  return R_NilValue;
}

SEXP swgwin_r (SEXP i1, SEXP i2, SEXP i3, SEXP i4)
{ swgwin (asInteger (i1), asInteger (i2), asInteger (i3), asInteger (i4));
  return R_NilValue;
}

SEXP swgwth_r (SEXP i)
{ swgwth (asInteger (i));
  return R_NilValue;
}

SEXP symb3d_r (SEXP i, SEXP x1, SEXP x2, SEXP x3)
{ symb3d (asInteger (i), asReal (x1), asReal (x2), asReal (x3));
  return R_NilValue;
}

SEXP symbol_r (SEXP i1, SEXP i2, SEXP i3)
{ symbol (asInteger (i1), asInteger (i2), asInteger (i3));
  return R_NilValue;
}

SEXP symfil_r (SEXP s1, SEXP s2)
{ symfil (qqcptr (s1), qqcptr (s2));
  return R_NilValue;
}

SEXP symrot_r (SEXP x)
{ symrot (asReal (x));
  return R_NilValue;
}

SEXP tellfl_r (SEXP i)
{ int n;
  SEXP vec; 
  n = tellfl (asInteger (i));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP texmod_r (SEXP s)
{ texmod (qqcptr (s));
  return R_NilValue;
}

SEXP texopt_r (SEXP s1, SEXP s2)
{ texopt (qqcptr (s1), qqcptr (s2));
  return R_NilValue;
}

SEXP texval_r (SEXP x, SEXP s)
{ texval (asReal (x), qqcptr (s));
  return R_NilValue;
}

SEXP thkc3d_r (SEXP x)
{ thkc3d (asReal (x));
  return R_NilValue;
}

SEXP thkcrv_r (SEXP n)
{ thkcrv (asInteger (n));
  return R_NilValue;
}

SEXP thrfin_r ()
{ thrfin ();
  return R_NilValue;
}

SEXP thrini_r (SEXP n)
{ thrini (asInteger (n));
  return R_NilValue;
}

SEXP ticks_r (SEXP n, SEXP s)
{ ticks (asInteger (n), qqcptr (s));
  return R_NilValue;
}

SEXP ticlen_r (SEXP i1, SEXP i2)
{ ticlen (asInteger (i1), asInteger (i2));
  return R_NilValue;
}

SEXP ticmod_r (SEXP s1, SEXP s2)
{ ticmod (qqcptr (s1), qqcptr (s2));
  return R_NilValue;
}

SEXP ticpos_r (SEXP s1, SEXP s2)
{ ticpos (qqcptr (s1), qqcptr (s2));
  return R_NilValue;
}

SEXP tifmod_r (SEXP n, SEXP s1, SEXP s2)
{ tifmod (asInteger (n), qqcptr (s1), qqcptr (s2));
  return R_NilValue;
}

SEXP tiforg_r (SEXP i1, SEXP i2)
{ tiforg (asInteger (i1), asInteger (i2));
  return R_NilValue;
}

SEXP tifwin_r (SEXP i1, SEXP i2, SEXP i3, SEXP i4)
{ tifwin (asInteger (i1), asInteger (i2), asInteger (i3), asInteger (i4));
  return R_NilValue;
}

SEXP timopt_r ()
{ timopt ();
  return R_NilValue;
}

SEXP titjus_r (SEXP s)
{ titjus (qqcptr (s));
  return R_NilValue;
}

SEXP title_r ()
{ title ();
  return R_NilValue;
}

SEXP titlin_r (SEXP s, SEXP n)
{ titlin (qqcptr (s), asInteger (n));
  return R_NilValue;
}

SEXP titpos_r (SEXP s)
{ titpos (qqcptr (s));
  return R_NilValue;
}

SEXP torus3d_r (SEXP x1, SEXP x2, SEXP x3, SEXP x4, SEXP x5, SEXP x6, 
                SEXP x7, SEXP x8, SEXP i1, SEXP i2)
{ torus3d (asReal (x1), asReal (x2), asReal (x3), asReal (x4), asReal (x5), 
           asReal (x6), asReal (x7), asReal (x8), asInteger (i1), 
           asInteger (i2));
  return R_NilValue;
}

SEXP tprfin_r ()
{ tprfin ();
  return R_NilValue;
}

SEXP tprini_r ()
{ tprini ();
  return R_NilValue;
}

SEXP tprmod_r (SEXP s1, SEXP s2)
{ tprmod (qqcptr (s1), qqcptr (s2));
  return R_NilValue;
}

SEXP tprval_r (SEXP x)
{ tprval (asReal (x));
  return R_NilValue;
}

SEXP tr3axs_r (SEXP x1, SEXP x2, SEXP x3, SEXP x4)
{ tr3axs (asReal (x1), asReal (x2), asReal (x3), asReal (x4));
  return R_NilValue;
}

SEXP tr3res_r ()
{ tr3res ();
  return R_NilValue;
}

SEXP tr3rot_r (SEXP x1, SEXP x2, SEXP x3)
{ tr3rot (asReal (x1), asReal (x2), asReal (x3));
  return R_NilValue;
}

SEXP tr3scl_r (SEXP x1, SEXP x2, SEXP x3)
{ tr3scl (asReal (x1), asReal (x2), asReal (x3));
  return R_NilValue;
}

SEXP tr3shf_r (SEXP x1, SEXP x2, SEXP x3)
{ tr3shf (asReal (x1), asReal (x2), asReal (x3));
  return R_NilValue;
}

SEXP trfco1_r (SEXP xray, SEXP n, SEXP s1, SEXP s2)
{ trfco1 (REAL (xray), asInteger (n), qqcptr (s1), qqcptr (s2));
  return R_NilValue;
} 

SEXP trfco2_r (SEXP xray, SEXP yray, SEXP n, SEXP s1, SEXP s2)
{ trfco2 (REAL (xray), REAL (yray), asInteger (n), qqcptr (s1), qqcptr (s2));
  return R_NilValue;
} 

SEXP trfco3_r (SEXP xray, SEXP yray, SEXP zray, SEXP n, SEXP s1, SEXP s2)
{ trfco3 (REAL (xray), REAL (yray), REAL (zray), asInteger (n), 
          qqcptr (s1), qqcptr (s2));
  return R_NilValue;
} 

SEXP trfdat_r (SEXP i)
{ int i1, i2, i3;
  SEXP vec; 

  trfdat (asInteger (i), &i1, &i2, &i3);
  PROTECT (vec = allocVector (INTSXP, 3));
  INTEGER (vec)[0] = i1;
  INTEGER (vec)[1] = i2;
  INTEGER (vec)[2] = i3;
  UNPROTECT (1);
  return vec;
}

SEXP trfmat_r (SEXP zmat, SEXP nx, SEXP ny, SEXP zmat2, SEXP nx2, SEXP ny2)
{ double *p1, *p2, *q;
  int n, m, i;
  n = asInteger (nx2);
  m = asInteger (ny2);

  p1 = qqtmat (REAL (zmat), asInteger (nx), asInteger (ny));
  q = REAL (zmat2);
  if (p1 != NULL)
  { trfmat (p1, asInteger (nx), asInteger (ny), q, n, m);
    p2 = qqtmat (q, n, m);
    if (p2 != NULL)
    { for (i = 0; i < n * m; i++)
        q[i] = p2[i];
    }
    free (p2);
  }
  free (p1);
  return R_NilValue;
}

SEXP trfrel_r (SEXP xray, SEXP yray, SEXP n)
{ trfrel (REAL (xray), REAL (yray), asInteger (n));
  return R_NilValue;
}

SEXP trfres_r ()
{ trfres ();
  return R_NilValue;
}

SEXP trfrot_r (SEXP x, SEXP i1, SEXP i2)
{ trfrot (asReal (x), asInteger (i1), asInteger (i2));
  return R_NilValue;
}

SEXP trfscl_r (SEXP x1, SEXP x2)
{ trfscl (asReal (x1), asReal (x2));
  return R_NilValue;
}

SEXP trfshf_r (SEXP x1, SEXP x2)
{ trfshf (asReal (x1), asReal (x2));
  return R_NilValue;
}

SEXP tria3d_r (SEXP xray, SEXP yray, SEXP zray)
{ tria3d (REAL (xray), REAL (yray), REAL (zray));
  return R_NilValue;
}

SEXP triang_r (SEXP xray, SEXP yray, SEXP nn, SEXP i1ray, SEXP i2ray, 
               SEXP i3ray, SEXP nmax)
{ int n;
  SEXP vec; 
  n = triang (REAL (xray), REAL (yray), asInteger (nn), INTEGER (i1ray),
              INTEGER (i2ray), INTEGER (i3ray), asInteger (nmax));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP triflc_r (SEXP xray, SEXP yray, SEXP icray, SEXP n)
{ triflc (REAL (xray), REAL (yray), INTEGER (icray), asInteger (n));
  return R_NilValue;
}

SEXP trifll_r (SEXP xray, SEXP yray)
{ trifll (REAL (xray), REAL (yray));
  return R_NilValue;
}

SEXP triplx_r ()
{ triplx ();
  return R_NilValue;
}

SEXP tripts_r (SEXP xray, SEXP yray, SEXP zray, SEXP nn, SEXP i1ray, 
               SEXP i2ray, SEXP i3ray, SEXP ntri, SEXP zlev, SEXP xpray,
               SEXP ypray, SEXP maxpts, SEXP nptray, SEXP maxray)
{ int n;
  SEXP vec; 
  tripts (REAL (xray), REAL (yray), REAL (zray), asInteger (nn), 
          INTEGER (i1ray), INTEGER (i2ray), INTEGER (i3ray), 
          asInteger (ntri), asReal (zlev), REAL (xpray), REAL (ypray),
          asInteger (maxpts), INTEGER (nptray), asInteger (maxray), &n);
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP trmlen_r (SEXP s)
{ int n;
  SEXP vec; 
  n = trmlen (qqcptr (s));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP ttfont_r (SEXP s)
{ ttfont (qqcptr (s));
  return R_NilValue;
}

SEXP tube3d_r (SEXP x1, SEXP x2, SEXP x3, SEXP x4, SEXP x5, SEXP x6, SEXP x7,
               SEXP i1, SEXP i2)
{ tube3d (asReal (x1), asReal (x2), asReal (x3), asReal (x4), asReal (x5), 
          asReal (x6), asReal (x7), asInteger (i1), asInteger (i2));
  return R_NilValue;
}

SEXP txtbgd_r (SEXP n)
{ txtbgd (asInteger (n));
  return R_NilValue;
}

SEXP txtjus_r (SEXP s)
{ txtjus (qqcptr (s));
  return R_NilValue;
}

SEXP txture_r (SEXP itmat, SEXP nx, SEXP ny)
{ int *p, *q, n, m, i;

  n = asInteger (nx);
  m = asInteger (ny);
  q = INTEGER (itmat);
  txture (q, n, m);
  p = qqitmat (q, n, m);
  if (p != NULL)
  { for (i = 0; i < n * m; i++)
      q[i] = p[i];
  }
  free (p);
  return R_NilValue;
}

SEXP unit_r (SEXP n)
{ int i;
  i = asInteger (n);
  if (i == 0)
    unit (NULL);
  else
    unit ((void *) stdout); 
  return R_NilValue;
}

SEXP units_r (SEXP s)
{ units (qqcptr (s));
  return R_NilValue;
}

SEXP upstr_r (SEXP s)
{ char *p, *q;
  int n;
  
  p = (char *) qqcptr (s);
  n = strlen (p);
  q = (char *) malloc (n + 1);
  if (q == NULL)
  { error ("Not enough memory!");
    return R_NilValue;
  }

  SEXP vec;
  upstr (q);
  PROTECT (vec = allocVector (STRSXP, 1));
  SET_STRING_ELT (vec, 0, mkChar (q));
  UNPROTECT (1);
  free (q);
  return vec;
}

SEXP utfint_r (SEXP s, SEXP iray, SEXP nmax)
{ int n;
  SEXP vec; 
  n = utfint (qqcptr (s), INTEGER (iray), asInteger (nmax));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP vang3d_r (SEXP x)
{ vang3d (asReal (x));
  return R_NilValue;
}

SEXP vclp3d_r (SEXP x1, SEXP x2)
{ vclp3d (asReal (x1), asReal (x2));
  return R_NilValue;
}

SEXP vecclr_r (SEXP n)
{ vecclr (asInteger (n));
  return R_NilValue;
}

SEXP vecf3d_r (SEXP xvray, SEXP yvray, SEXP zvray, SEXP xpray, SEXP ypray,
               SEXP zpray, SEXP n, SEXP ivec)
{ vecf3d (REAL (xvray), REAL (yvray), REAL (zvray), REAL (xpray),
          REAL (ypray), REAL (zpray), asInteger (n), asInteger (ivec));
  return R_NilValue;
}

SEXP vecfld_r (SEXP xvray, SEXP yvray, SEXP xpray, SEXP ypray, SEXP n,
               SEXP ivec)
{ vecfld (REAL (xvray), REAL (yvray), REAL (xpray), REAL (ypray), 
          asInteger (n), asInteger (ivec));
  return R_NilValue;
}

SEXP vecmat_r (SEXP xmat, SEXP ymat, SEXP nx, SEXP ny, SEXP xpray, SEXP ypray,
               SEXP ivec)
{ int n, m;
  double *p1, *p2;

  n = asInteger (nx);
  m = asInteger (ny);
  p1 = qqtmat (REAL (xmat), n, m);
  p2 = qqtmat (REAL (ymat), n, m);
  if (p1 != NULL && p2 != NULL)
    vecmat (p1, p2, n, m, REAL (xpray), REAL (ypray), asInteger (ivec));
  free (p1);
  free (p2);
  return R_NilValue;
}

SEXP vecmat3d_r (SEXP xmat, SEXP ymat, SEXP zmat, SEXP nx, SEXP ny, SEXP nz,
                 SEXP xpray, SEXP ypray, SEXP zpray, SEXP ivec)
{ int n, m, k;
  double *p1, *p2, *p3;

  n = asInteger (nx);
  m = asInteger (ny);
  k = asInteger (nz);
  p1 = qqtmat3 (REAL (xmat), n, m, k);
  p2 = qqtmat3 (REAL (ymat), n, m, k);
  p3 = qqtmat3 (REAL (zmat), n, m, k);
  if (p1 != NULL && p2 != NULL && p3 != NULL)
    vecmat3d (p1, p2, p3, n, m, k, REAL (xpray), REAL (ypray), REAL (zpray),
              asInteger (ivec));
  free (p1);
  free (p2);
  free (p3);
  return R_NilValue;
}

SEXP vecopt_r (SEXP x, SEXP s)
{ vecopt (asReal (x), qqcptr (s));
  return R_NilValue;
}

SEXP vector_r (SEXP i1, SEXP i2, SEXP i3, SEXP i4, SEXP i5)
{ vector (asInteger (i1), asInteger (i2), asInteger (i3), asInteger (i4),
          asInteger (i5));
  return R_NilValue;
}

SEXP vectr3_r (SEXP x1, SEXP x2, SEXP x3, SEXP x4, SEXP x5, SEXP x6, SEXP ivec)
{ vectr3 (asReal (x1), asReal (x2), asReal (x3), asReal (x4), asReal (x5),
          asReal (x6), asInteger (ivec));
  return R_NilValue;
}

SEXP vfoc3d_r (SEXP x, SEXP y, SEXP z, SEXP s)
{ vfoc3d (asReal (x), asReal (y), asReal (z), qqcptr (s));
  return R_NilValue;
}

SEXP view3d_r (SEXP x, SEXP y, SEXP z, SEXP s)
{ view3d (asReal (x), asReal (y), asReal (z), qqcptr (s));
  return R_NilValue;
}

SEXP vkxbar_r (SEXP n)
{ vkxbar (asInteger (n));
  return R_NilValue;
}

SEXP vkybar_r (SEXP n)
{ vkybar (asInteger (n));
  return R_NilValue;
}

SEXP vkytit_r (SEXP n)
{ vkytit (asInteger (n));
  return R_NilValue;
}

SEXP vltfil_r (SEXP s1, SEXP s2)
{ vltfil (qqcptr (s1), qqcptr (s2));
  return R_NilValue;
}

SEXP vscl3d_r (SEXP x)
{ vscl3d (asReal (x));
  return R_NilValue;
}

SEXP vtx3d_r (SEXP xray, SEXP yray, SEXP zray, SEXP n, SEXP s)
{ vtx3d (REAL (xray), REAL (yray), REAL (zray), asInteger (n), qqcptr (s));
  return R_NilValue;
}

SEXP vtxc3d_r (SEXP xray, SEXP yray, SEXP zray, SEXP icray, SEXP n, SEXP s)
{ vtxc3d (REAL (xray), REAL (yray), REAL (zray), INTEGER (icray), 
          asInteger (n), qqcptr (s));
  return R_NilValue;
}

SEXP vtxn3d_r (SEXP xray, SEXP yray, SEXP zray, SEXP xnray, SEXP ynray,
               SEXP znray, SEXP n, SEXP s)
{ vtxn3d (REAL (xray), REAL (yray), REAL (zray), REAL (xnray), REAL (ynray),
                REAL (znray), asInteger (n), qqcptr (s));
  return R_NilValue;
}

SEXP vup3d_r (SEXP x)
{ vup3d (asReal (x));
  return R_NilValue;
}

SEXP wgapp_r (SEXP i, SEXP s)
{ int n;
  SEXP vec; 
  n = wgapp (asInteger (i), qqcptr (s));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP wgappb_r (SEXP i1, SEXP iray, SEXP i2, SEXP i3)
{ int n;
  SEXP vec; 
  n = wgappb (asInteger (i1), RAW (iray), asInteger (i2), asInteger (i3));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP wgbas_r (SEXP i, SEXP s)
{ int n;
  SEXP vec; 
  n = wgbas (asInteger (i), qqcptr (s));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP wgbox_r (SEXP i1, SEXP s, SEXP i2)
{ int n;
  SEXP vec; 
  n = wgbox (asInteger (i1), qqcptr (s), asInteger (i2));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP wgbut_r (SEXP i1, SEXP s, SEXP i2)
{ int n;
  SEXP vec; 
  n = wgbut (asInteger (i1), qqcptr (s), asInteger (i2));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP wgcmd_r (SEXP i, SEXP s1, SEXP s2)
{ int n;
  SEXP vec; 
  n = wgcmd (asInteger (i), qqcptr (s1), qqcptr (s2));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP wgdlis_r (SEXP i1, SEXP s, SEXP i2)
{ int n;
  SEXP vec; 
  n = wgdlis (asInteger (i1), qqcptr (s), asInteger (i2));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP wgdraw_r (SEXP i)
{ int n;
  SEXP vec; 
  n = wgdraw (asInteger (i));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP wgfil_r (SEXP i, SEXP s1, SEXP s2, SEXP s3)
{ int n;
  SEXP vec; 
  n = wgfil (asInteger (i), qqcptr (s1), qqcptr (s2), qqcptr (s3));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP wgfin_r ()
{ wgfin ();
  return R_NilValue;
}

SEXP wgicon_r (SEXP i1, SEXP s1, SEXP i2, SEXP i3, SEXP s2)
{ int n;
  SEXP vec; 
  n = wgicon (asInteger (i1), qqcptr (s1), asInteger (i2), asInteger (i3),
              qqcptr (s2));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP wgimg_r (SEXP i1, SEXP s, SEXP iray, SEXP i2, SEXP i3)
{ int n;
  SEXP vec; 
  n = wgimg (asInteger (i1), qqcptr (s), RAW (iray), asInteger (i2), 
             asInteger (i3));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP wgini_r (SEXP s)
{ int n;
  SEXP vec; 
  n = wgini (qqcptr (s));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP wglab_r (SEXP i, SEXP s)
{ int n;
  SEXP vec; 
  n = wglab (asInteger (i), qqcptr (s));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP wglis_r (SEXP i1, SEXP s, SEXP i2)
{ int n;
  SEXP vec; 
  n = wglis (asInteger (i1), qqcptr (s), asInteger (i2));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP wgltxt_r (SEXP i1, SEXP s1, SEXP s2, SEXP i2)
{ int n;
  SEXP vec; 
  n = wgltxt (asInteger (i1), qqcptr (s1), qqcptr (s2), asInteger (i2));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP wgok_r (SEXP i)
{ int n;
  SEXP vec; 
  n = wgok (asInteger (i));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP wgpbar_r (SEXP i, SEXP x1, SEXP x2, SEXP x3)
{ int n;
  SEXP vec; 
  n = wgpbar (asInteger (i), asReal (x1), asReal (x2), asReal (x3));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP wgpbut_r (SEXP i, SEXP s)
{ int n;
  SEXP vec; 
  n = wgpbut (asInteger (i), qqcptr (s));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP wgpicon_r (SEXP i1, SEXP s1, SEXP i2, SEXP i3, SEXP s2)
{ int n;
  SEXP vec; 
  n = wgpicon (asInteger (i1), qqcptr (s1), asInteger (i2), asInteger (i3),
              qqcptr (s2));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP wgpimg_r (SEXP i1, SEXP s, SEXP iray, SEXP i2, SEXP i3)
{ int n;
  SEXP vec; 
  n = wgpimg (asInteger (i1), qqcptr (s), RAW (iray), asInteger (i2), 
              asInteger (i3));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP wgpop_r (SEXP i, SEXP s)
{ int n;
  SEXP vec; 
  n = wgpop (asInteger (i), qqcptr (s));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP wgpopb_r (SEXP i1, SEXP iray, SEXP i2, SEXP i3)
{ int n;
  SEXP vec; 
  n = wgpopb (asInteger (i1), RAW (iray), asInteger (i2), asInteger (i3));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP wgquit_r (SEXP i)
{ int n;
  SEXP vec; 
  n = wgquit (asInteger (i));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP wgscl_r (SEXP i1, SEXP s, SEXP x1, SEXP x2, SEXP x3, SEXP i2)
{ int n;
  SEXP vec; 
  n = wgscl (asInteger (i1), qqcptr (s), asReal (x1), asReal (x2), asReal (x3),
             asInteger (i2));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP wgsep_r (SEXP i)
{ int n;
  SEXP vec; 
  n = wgsep (asInteger (i));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP wgstxt_r (SEXP i1, SEXP i2, SEXP i3)
{ int n;
  SEXP vec; 
  n = wgstxt (asInteger (i1), asInteger (i2), asInteger (i3));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP wgtbl_r (SEXP i1, SEXP i2, SEXP i3)
{ int n;
  SEXP vec; 
  n = wgtbl (asInteger (i1), asInteger (i2), asInteger (i3));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP wgtxt_r (SEXP i, SEXP s)
{ int n;
  SEXP vec; 
  n = wgtxt (asInteger (i), qqcptr (s));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP widbar_r (SEXP n)
{ widbar (asInteger (n));
  return R_NilValue;
}

SEXP wimage_r (SEXP s)
{ wimage (qqcptr (s));
  return R_NilValue;
}

SEXP winapp_r (SEXP s)
{ winapp (qqcptr (s));
  return R_NilValue;
}

SEXP  wincbk_r (SEXP func, SEXP s) 
{ if (!isFunction (func))
    error ("func must be a function");
  else
  { WincbkSEXP = func;
    wincbk (WincbkCB, qqcptr (s));
  }
  return R_NilValue; 
}

void WincbkCB (int id, int i1, int i2, int i3, int i4)
{ SEXP fcall, result, a;
  
  PROTECT (a = allocVector (INTSXP, 5));
  INTEGER (a)[0] = id;
  INTEGER (a)[1] = i1;
  INTEGER (a)[2] = i2;
  INTEGER (a)[3] = i3;
  INTEGER (a)[4] = i4;
  PROTECT (fcall = lang2 (WincbkSEXP, a)); 
  PROTECT (result = eval (fcall, R_GlobalEnv));
  UNPROTECT (3);
} 

SEXP windbr_r (SEXP x1, SEXP i1, SEXP i2, SEXP i3, SEXP x2)
{ windbr (asReal (x1), asInteger (i1), asInteger (i2), asInteger (i3), 
          asReal (x2));
  return R_NilValue;
}

SEXP window_r (SEXP i1, SEXP i2, SEXP i3, SEXP i4)
{ window (asInteger (i1), asInteger (i2), asInteger (i3), asInteger (i4));
  return R_NilValue;
}

SEXP winfin_r (SEXP n)
{ winfin (asInteger (n));
  return R_NilValue;
}

SEXP winfnt_r (SEXP s)
{ winfnt (qqcptr (s));
  return R_NilValue;
}

SEXP winico_r (SEXP s)
{ winico (qqcptr (s));
  return R_NilValue;
}

SEXP winid_r ()
{ int n;
  SEXP vec; 
  n = winid ();
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP winjus_r (SEXP s)
{ winjus (qqcptr (s));
  return R_NilValue;
}

SEXP winkey_r (SEXP s)
{ winkey (qqcptr (s));
  return R_NilValue;
}

SEXP winmod_r (SEXP s)
{ winmod (qqcptr (s));
  return R_NilValue;
}

SEXP winopt_r (SEXP n, SEXP s)
{ winopt (asInteger (n), qqcptr (s));
  return R_NilValue;
}

SEXP winsiz_r (SEXP i1, SEXP i2)
{ winsiz (asInteger (i1), asInteger (i2));
  return R_NilValue;
}

SEXP wintit_r (SEXP s)
{ wintit (qqcptr (s));
  return R_NilValue;
}

SEXP wintyp_r (SEXP s)
{ wintyp (qqcptr (s));
  return R_NilValue;
}

SEXP wmfmod_r (SEXP s1, SEXP s2)
{ wmfmod (qqcptr (s1), qqcptr (s2));
  return R_NilValue;
}

SEXP world_r ()
{ world ();
  return R_NilValue;
}

SEXP wpixel_r (SEXP i1, SEXP i2, SEXP i3)
{ wpixel (asInteger (i1), asInteger (i2), asInteger (i3));
  return R_NilValue;
}

SEXP wpixls_r (SEXP iray, SEXP i1, SEXP i2, SEXP i3, SEXP i4)
{ wpixls (RAW (iray), asInteger (i1), asInteger (i2), asInteger (i3),
          asInteger (i4));
  return R_NilValue;
}

SEXP wpxrow_r (SEXP iray, SEXP i1, SEXP i2, SEXP i3)
{ wpxrow (RAW (iray), asInteger (i1), asInteger (i2), asInteger (i3));
  return R_NilValue;
}

SEXP writfl_r (SEXP i1, SEXP iray, SEXP i2)
{ int n;
  SEXP vec; 
  n = writfl (asInteger (i1), RAW (iray), asInteger (i2));
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP wtiff_r (SEXP s)
{ wtiff (qqcptr (s));
  return R_NilValue;
}

SEXP x11fnt_r (SEXP s1, SEXP s2)
{ x11fnt (qqcptr (s1), qqcptr (s2));
  return R_NilValue;
}

SEXP x11mod_r (SEXP s)
{ x11mod (qqcptr (s));
  return R_NilValue;
}

SEXP x2dpos_r (SEXP x, SEXP y)
{ double xp;
  SEXP vec;

  xp = x2dpos (asReal (x), asReal (y));
  PROTECT (vec = allocVector (REALSXP, 1));
  REAL (vec)[0] = xp;
  UNPROTECT (1);
  return vec;
}

SEXP x3dabs_r (SEXP x, SEXP y, SEXP z)
{ double xp;
  SEXP vec;

  xp = x3dabs (asReal (x), asReal (y), asReal (z));
  PROTECT (vec = allocVector (REALSXP, 1));
  REAL (vec)[0] = xp;
  UNPROTECT (1);
  return vec;
}

SEXP x3dpos_r (SEXP x, SEXP y, SEXP z)
{ double xp;
  SEXP vec;

  xp = x3dpos (asReal (x), asReal (y), asReal (z));
  PROTECT (vec = allocVector (REALSXP, 1));
  REAL (vec)[0] = xp;
  UNPROTECT (1);
  return vec;
}

SEXP x3drel_r (SEXP x, SEXP y, SEXP z)
{ double xp;
  SEXP vec;

  xp = x3drel (asReal (x), asReal (y), asReal (z));
  PROTECT (vec = allocVector (REALSXP, 1));
  REAL (vec)[0] = xp;
  UNPROTECT (1);
  return vec;
}

SEXP xaxgit_r ()
{ xaxgit ();
  return R_NilValue;
}

SEXP xaxis_r (SEXP x1, SEXP x2, SEXP x3, SEXP x4, SEXP i1, SEXP s,
              SEXP i2, SEXP i3, SEXP i4)
{ xaxis (asReal (x1), asReal (x2), asReal (x3), asReal (x4), asInteger (i1),
         qqcptr (s), asInteger (i2), asInteger (i3), asInteger (i4));
  return R_NilValue;
} 

SEXP xaxlg_r (SEXP x1, SEXP x2, SEXP x3, SEXP x4, SEXP i1, SEXP s,
              SEXP i2, SEXP i3, SEXP i4)
{ xaxlg (asReal (x1), asReal (x2), asReal (x3), asReal (x4), asInteger (i1),
         qqcptr (s), asInteger (i2), asInteger (i3), asInteger (i4));
  return R_NilValue;
} 

SEXP xaxmap_r (SEXP x1, SEXP x2, SEXP x3, SEXP x4, SEXP s, SEXP i1, SEXP i2)
{ xaxmap (asReal (x1), asReal (x2), asReal (x3), asReal (x4), qqcptr (s), 
          asInteger (i1), asInteger (i1));
  return R_NilValue;
} 

SEXP xcross_r ()
{ xcross ();
  return R_NilValue;
}

SEXP xdraw_r (SEXP x, SEXP y)
{ xdraw (asReal (x), asReal (y));
  return R_NilValue;
}

SEXP xinvrs_r (SEXP i)
{ double xp;
  SEXP vec;

  xp = xinvrs (asInteger (i));
  PROTECT (vec = allocVector (REALSXP, 1));
  REAL (vec)[0] = xp;
  UNPROTECT (1);
  return vec;
}

SEXP xmove_r (SEXP x, SEXP y)
{ xmove (asReal (x), asReal (y));
  return R_NilValue;
}

SEXP xposn_r (SEXP x)
{ double xp;
  SEXP vec;

  xp = xposn (asReal (x));
  PROTECT (vec = allocVector (REALSXP, 1));
  REAL (vec)[0] = xp;
  UNPROTECT (1);
  return vec;
}

SEXP y2dpos_r (SEXP x, SEXP y)
{ double yp;
  SEXP vec;

  yp = y2dpos (asReal (x), asReal (y));
  PROTECT (vec = allocVector (REALSXP, 1));
  REAL (vec)[0] = yp;
  UNPROTECT (1);
  return vec;
}

SEXP y3dabs_r (SEXP x, SEXP y, SEXP z)
{ double yp;
  SEXP vec;

  yp = y3dabs (asReal (x), asReal (y), asReal (z));
  PROTECT (vec = allocVector (REALSXP, 1));
  REAL (vec)[0] = yp;
  UNPROTECT (1);
  return vec;
}

SEXP y3dpos_r (SEXP x, SEXP y, SEXP z)
{ double yp;
  SEXP vec;

  yp = y3dpos (asReal (x), asReal (y), asReal (z));
  PROTECT (vec = allocVector (REALSXP, 1));
  REAL (vec)[0] = yp;
  UNPROTECT (1);
  return vec;
}

SEXP y3drel_r (SEXP x, SEXP y, SEXP z)
{ double yp;
  SEXP vec;

  yp = y3drel (asReal (x), asReal (y), asReal (z));
  PROTECT (vec = allocVector (REALSXP, 1));
  REAL (vec)[0] = yp;
  UNPROTECT (1);
  return vec;
}

SEXP yaxgit_r ()
{ yaxgit ();
  return R_NilValue;
}

SEXP yaxis_r (SEXP x1, SEXP x2, SEXP x3, SEXP x4, SEXP i1, SEXP s,
              SEXP i2, SEXP i3, SEXP i4)
{ yaxis (asReal (x1), asReal (x2), asReal (x3), asReal (x4), asInteger (i1),
         qqcptr (s), asInteger (i2), asInteger (i3), asInteger (i4));
  return R_NilValue;
} 

SEXP yaxlg_r (SEXP x1, SEXP x2, SEXP x3, SEXP x4, SEXP i1, SEXP s,
              SEXP i2, SEXP i3, SEXP i4)
{ yaxlg (asReal (x1), asReal (x2), asReal (x3), asReal (x4), asInteger (i1),
         qqcptr (s), asInteger (i2), asInteger (i3), asInteger (i4));
  return R_NilValue;
} 

SEXP yaxmap_r (SEXP x1, SEXP x2, SEXP x3, SEXP x4, SEXP s, SEXP i1, SEXP i2)
{ yaxmap (asReal (x1), asReal (x2), asReal (x3), asReal (x4), qqcptr (s), 
          asInteger (i1), asInteger (i1));
  return R_NilValue;
} 

SEXP ycross_r ()
{ ycross ();
  return R_NilValue;
}

SEXP yinvrs_r (SEXP i)
{ double yp;
  SEXP vec;

  yp = yinvrs (asInteger (i));
  PROTECT (vec = allocVector (REALSXP, 1));
  REAL (vec)[0] = yp;
  UNPROTECT (1);
  return vec;
}

SEXP ypolar_r (SEXP x1, SEXP x2, SEXP x3, SEXP x4, SEXP s, SEXP i1)
{ ypolar (asReal (x1), asReal (x2), asReal (x3), asReal (x4),
         qqcptr (s), asInteger (i1));
  return R_NilValue;
} 

SEXP yposn_r (SEXP x)
{ double yp;
  SEXP vec;

  yp = yposn (asReal (x));
  PROTECT (vec = allocVector (REALSXP, 1));
  REAL (vec)[0] = yp;
  UNPROTECT (1);
  return vec;
}

SEXP z3dpos_r (SEXP x, SEXP y, SEXP z)
{ double zp;
  SEXP vec;

  zp = z3dpos (asReal (x), asReal (y), asReal (z));
  PROTECT (vec = allocVector (REALSXP, 1));
  REAL (vec)[0] = zp;
  UNPROTECT (1);
  return vec;
}

SEXP zaxis_r (SEXP x1, SEXP x2, SEXP x3, SEXP x4, SEXP i1, SEXP s,
              SEXP i2, SEXP i3, SEXP i4, SEXP i5)
{ zaxis (asReal (x1), asReal (x2), asReal (x3), asReal (x4), asInteger (i1),
         qqcptr (s), asInteger (i2), asInteger (i3), asInteger (i4),
         asInteger (i5));
  return R_NilValue;
} 

SEXP zaxlg_r (SEXP x1, SEXP x2, SEXP x3, SEXP x4, SEXP i1, SEXP s,
              SEXP i2, SEXP i3, SEXP i4, SEXP i5)
{ zaxlg (asReal (x1), asReal (x2), asReal (x3), asReal (x4), asInteger (i1),
         qqcptr (s), asInteger (i2), asInteger (i3), asInteger (i4),
         asInteger (i5));
  return R_NilValue;
} 

SEXP zbfers_r ()
{ zbfers ();
  return R_NilValue;
}

SEXP zbffin_r ()
{ zbffin ();
  return R_NilValue;
}

SEXP zbfini_r ()
{ int n;
  SEXP vec; 
  n = zbfini ();
  PROTECT (vec = allocVector (INTSXP, 1));
  INTEGER (vec)[0] = n;
  UNPROTECT (1);
  return vec;
}

SEXP zbflin_r (SEXP x1, SEXP x2, SEXP x3, SEXP x4, SEXP x5, SEXP x6)
{ zbflin (asReal (x1), asReal (x2), asReal (x3), asReal (x4), asReal (x5),
          asReal (x6));
  return R_NilValue;
}

SEXP zbfmod_r (SEXP s)
{ zbfmod (qqcptr (s));
  return R_NilValue;
}

SEXP zbfres_r ()
{ zbfres ();
  return R_NilValue;
}

SEXP zbfscl_r (SEXP x)
{ zbfscl (asReal (x));
  return R_NilValue;
}

SEXP zbftri_r (SEXP xray, SEXP yray, SEXP zray, SEXP iray)
{ zbftri (REAL (xray), REAL (yray), REAL (zray), INTEGER (iray));
  return R_NilValue;
}

SEXP zscale_r (SEXP x1, SEXP x2)
{ zscale (asReal (x1), asReal (x2));
  return R_NilValue;
}

/* >>>>>>>>>> QQLONG <<<<<<<<<< */
static long *qqlong (int *iray, int n)
{ int i;
  long *q;

  if ((q = (long *) calloc (n, sizeof (long))) == NULL)
  { error ("Not enough memory!");
    return NULL;
  }  

  for (i = 0; i < n; i++)
    q[i] = (long) iray[i];
  return q;
}

/* >>>>>>>>>> QQTMAT <<<<<<<<<< */
static double *qqtmat (double *zmat, int n, int m)
{ int nn = n * m, i, j, k = 0;
  double *q;

  if ((q = (double *) calloc (nn, sizeof (double))) == NULL)
  { error ("Not enough memory!");
    return NULL;
  }  

  for (i = 0; i < n; i++)
    for (j = 0; j < m; j++)
      q[k++] = zmat[i+j*n];

  return q;
}

/* >>>>>>>>>> QQITMAT <<<<<<<<<< */
static int *qqitmat (int *izmat, int n, int m)
{ int nn = n * m, i, j, k = 0;
  int *ip;

  if ((ip = (int *) calloc (nn, sizeof (int))) == NULL)
  { error ("Not enough memory!");
    return NULL;
  }  

  for (i = 0; i < n; i++)
    for (j = 0; j < m; j++)
      ip[k++] = izmat[i+j*n];

  return ip;
}

/* >>>>>>>>>> QQTMAT3 <<<<<<<<<< */
static double *qqtmat3 (double *zmat, int nx, int ny, int nz)
{ int nn = nx * ny * nz, nyz = ny * nz, i, j, k, kk = 0, jj;
  double *q;

  if ((q = (double *) calloc (nn, sizeof (double))) == NULL)
  { error ("Not enough memory!");
    return NULL;
  }  

  for (i = 0; i < nx; i++)
  { for (j = 0; j < ny; j++)
    { jj = j * nz;
      for (k = 0; k < nz; k++)
      { q[kk++] = zmat[i+jj+k*nyz];
      }
    }
  } 
  return q;
}

/* >>>>>>>>>> QQCPTR <<<<<<<<<< */
static const char *qqcptr  (SEXP str)
{ 
  return CHAR (STRING_ELT (str, 0));
} 
