source  ("dislin.R")

ctit1 <- "Contour Plot"
ctit2 <- "F (X,Y) = 2 * SIN (X) * SIN (Y)"

n <- 50
m <- 50
xray <- double (n)
yray <- double (m)
zmat <- matrix (0, n, m)

fpi <- 3.1415926 / 180
stpx <- 360.0 / (n - 1)
stpy <- 360.0 / (m - 1)

for (i in 1:n)
{ xray[i] <- (i - 1) * stpx
}

for (i in 1:m)
{ yray[i] <- (i - 1) * stpy
}
  
for (i in 1:n)
{ x <- (i - 1) * stpx
  for (j in 1:m)
  { y <- (j - 1) * stpy
    zmat [i,j] <- 2 * sin (x * fpi) * sin (y * fpi)
  }
}

Dislin.metafl ("cons")
Dislin.setpag ("da4p")
Dislin.disini ()
Dislin.pagera ()
Dislin.complx ()

Dislin.titlin (ctit1, 1)
Dislin.titlin (ctit2, 3)

Dislin.intax ()
Dislin.axspos (450, 2650)

Dislin.name ("X-axis", "X")
Dislin.name ("Y-axis", "Y")

Dislin.graf (0.0, 360.0, 0.0, 90.0, 0.0, 360.0, 0.0, 90.0)
Dislin.height (50)
Dislin.title ()

Dislin.height (30)
for (i in 0:8)
{ zlev <- -2.0 + i * 0.5
  if (i == 4)
  { Dislin.labels ("NONE", "CONTUR")
  }
  else
  { Dislin.labels ("FLOAT", "CONTUR")
  }

  Dislin.setclr ( (i+1) * 28)
  Dislin.contur (xray, n, yray, m, zmat, zlev)
}

Dislin.disfin ()





