********************************************************************
**                                                                **
**               IBM-PC Installation of DISLIN                    **
**                                                                **
**  Contents:  1.)  Introduction                                  **
**             2.)  Installation of DISLIN                        **
**             3.)  Getting DISLIN Support                        **
**                                                                **
**  Date   :   15.03.2022                                         **
**  Version:   11.5  /  Windows, GCC/G++/G77/G95-MINGW/GFortran   **
**  Author :   Helmut Michels                                     **
**             Dislin Software                                    **
**             Am Hachweg 10                                      **
**             37083 Gttingen, Germany                           **
**  Email  :   michels@dislin.de                                  **
********************************************************************

1.)  Introduction

     This file describes the  installation  of the  data  plotting
     software DISLIN on IBM-PCs   for the operating system Windows
     and the Mingw compilers gcc, g++, g95 and GFortran.

2.)  Installation of DISLIN

     The DISLIN version for the Mingw32 compilers GCC, G77 and G95
     is distributed in the  zipped  file  dl_11_mg.zip.  A utility
     for unpacking the  DISLIN  files is available  from the  same
     location where you have downloaded  dl_11_mg.zip, or from the
     DISLIN CD-ROM. 

     To install DISLIN, make the following steps:

  a) Create a temporary directory and copy the files dl_11_mg.zip
     and unzip.exe to it:

     for example:   md  c:\temp
                    cd  c:\temp
                    copy e:\dislin\windows\unzip.exe    *.*
                    copy e:\dislin\windows\dl_11_mg.zip *.*

  b) Extract the DISLIN files with the command:

                 unzip  -o dl_11_mg.zip

  c) Run the setup program with the command

                  setup

     -  Choose OK

     -  Give the Installation Directory where  DISLIN  should be in-
        stalled. The default directory is C:\DISLIN.

  d) Reconfigure the System

     Set the DISLIN environment variable to c:\dislin and include
     c:\dislin\win in your path. If you have installed DISLIN in a
     different directory, you have to use that directory for the 
     environment variables above.

     The environment variables can be set or modified with the Control
     Panel 
    
     (see Control Panel -> System -> Advanced -> Environment
      Variables).
   
  e) Now you can compile,  link and run the example programs in the
     DISLIN subdirectory examples with the commands

                    clink    -a  exa_c     (gcc) 
                    cpplink  -a  exa_cpp   (g++) 
                    dlink    -a  exa_f77   (gfortran 77)
                    mg95link -a  exa_f90   (g95)
                    f90link  -a  exa_f90   (gfortran)
     and
                    clink    -a  map_c     (gcc) 
                    cpplink  -a  map_cpp   (g++) 
                    dlink    -a  map_f77   (gfortran 77)
                    mg95link -a  map_f90   (gfortran)
                    f90link  -a  map_f90   (gfortran)

     Notes:
 
        -  The utilities above link by default with the single precision 
           library dismg.a. A double precision version of the library is
           also included (dismg_d.a). The C++ library of Dislin (discpp.a)
           is only implemented as a double precision library.  

        -  The Dislin library discpp.a for C++ programs is not compatible
           to newer versions of g++ such as 4.9.x or 5.1.x. For that case
           you have to link with the library discpp51.a instead of discpp.a.

        -  If the pre-compiled DISLIN Fortran 90 module file 
           'dislin.mod' is not compatible to the version of your Fortran
           compiler, you have to recompile the file 'dislin.f90' in the 
           directories DISLIN\mg95 and DISLIN\gf with the commands
           'g95 -c dislin.f90' and 'gfortran -c dislin.f90'.

3.)  Getting DISLIN Support

     The DISLIN distributions can be used freely without any restriction.
     Access to the source code is availabe via a support contract from the
     site www.dislin.de.
