# /****************************************************************/
# /**                        DISLIN.JL                           **/
# /**                                                            **/
# /** Module file of DISLIN for Julia.                           **/
# /**                                                            **/
# /** Date     : 15.03.2022                                      **/
# /** Functions: 799                                             **/
# /** Version  : 11.5, 32-bit                                    **/
# /****************************************************************/

module Dislin

function abs3pt(x1::Float64, x2::Float64, x3::Float64)
  xp1 = Cdouble[0]
  xp2 = Cdouble[0]
  ccall((:axs3pt, "dislnc_d.dll"), Cvoid, (Float64, Float64, Float64,
          Ptr{Cdouble}, Ptr{Cdouble}), x1, x2, x3, xp1, xp2)
  return xp1[1], xp2[1]
end

function addlab(s1::String, x::Float64, i::Int32, s2::String)
  ccall((:aaddlab, "dislnc_d.dll"), Cvoid, 
           (Ptr{UInt8}, Float64, Int32, Ptr{UInt8}), s1, x, i, s2)
end

function angle(i::Int32)
  ccall((:angle, "dislnc_d.dll"), Cvoid, (Int32,), i)
end

function arcell(i1::Int32, i2::Int32, i3::Int32, i4::Int32, x1::Float64,
                x2::Float64, x3::Float64)
  ccall((:arcell, "dislnc_d.dll"), Cvoid, (Int32, Int32, Int32, Int32,
           Float64, Float64, Float64), i1, i2, i3, i4, x1, x2, x3)
end

function areaf(ixray::Vector{Int32}, iyray::Vector{Int32}, n::Int32)
  ccall((:areaf, "dislnc_d.dll"), Cvoid, 
         (Ptr{Int32}, Ptr{Int32}, Int32), ixray, iyray, n)
end

function autres(i1::Int32, i2::Int32)
  ccall((:autres, "dislnc_d.dll"), Cvoid, (Int32, Int32), i1, i2)
end

function autres3d(i1::Int32, i2::Int32, i3::Int32)
  ccall((:autres3d, "dislnc_d.dll"), Cvoid, (Int32, Int32, Int32), i1, i2, i3)
end

function ax2grf()
  ccall((:ax2grf, "dislnc_d.dll"), Cvoid, ())
end

function ax3len(i1::Int32, i2::Int32, i3::Int32)
  ccall((:ax3len, "dislnc_d.dll"), Cvoid, (Int32, Int32, Int32), i1, i2, i3)
end

function axclrs(i::Int32, s1::String, s2::String)
  ccall((:axclrs, "dislnc_d.dll"), Cvoid, (Int32, Ptr{UInt8}, Ptr{UInt8}), 
           i, s1, s2)
end

function axends(s1::String, s2::String)
  ccall((:axends, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Ptr{UInt8}), s1, s2)
end

function axgit()
  ccall((:axgit, "dislnc_d.dll"), Cvoid, ())
end

function axis3d(x1::Float64, x2::Float64, x3::Float64)
  ccall((:axis3d, "dislnc_d.dll"), Cvoid, (Float64, Float64, Float64), 
          x1, x2, x3)
end

function axsbgd(i::Int32)
  ccall((:axsbgd, "dislnc_d.dll"), Cvoid, (Int32,), i)
end

function axsers()
  ccall((:axsres, "dislnc_d.dll"), Cvoid, ())
end

function axslen(i1::Int32, i2::Int32)
  ccall((:axslen, "dislnc_d.dll"), Cvoid, (Int32, Int32), i1, i2)
end

function axsorg(i1::Int32, i2::Int32)
  ccall((:axsorg, "dislnc_d.dll"), Cvoid, (Int32, Int32), i1, i2)
end

function axspos(i1::Int32, i2::Int32)
  ccall((:axspos, "dislnc_d.dll"), Cvoid, (Int32, Int32), i1, i2)
end

function axsscl(s1::String, s2::String)
  ccall((:axsscl, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Ptr{UInt8}), s1, s2)
end

function axstyp(s::String)
  ccall((:axstyp, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function barbor(i::Int32)
  ccall((:barbor, "dislnc_d.dll"), Cvoid, (Int32,), i)
end

function barclr(i1::Int32, i2::Int32, i3::Int32)
  ccall((:barclr, "dislnc_d.dll"), Cvoid, (Int32, Int32, Int32), i1, i2, i3)
end

function bargrp(i::Int32, x::Float64)
  ccall((:bargrp, "dislnc_d.dll"), Cvoid, (Int32, Float64), i, x)
end

function barmod(s1::String, s2::String)
  ccall((:barmod, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Ptr{UInt8}), s1, s2)
end

function baropt(x1::Float64, x2::Float64)
  ccall((:baropt, "dislnc_d.dll"), Cvoid, (Float64, Float64), x1, x2)
end

function barpos(s::String)
  ccall((:barpos, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function bars(xray::Vector{Float64}, yray::Vector{Float64}, 
                zray::Vector{Float64}, n::Int32)
  ccall((:bars, "dislnc_d.dll"), Cvoid, (Ptr{Float64}, Ptr{Float64}, 
          Ptr{Float64}, Int32), xray, yray, zray, n)
end

function bars3d(xray::Vector{Float64}, yray::Vector{Float64}, 
                z1ray::Vector{Float64}, z2ray::Vector{Float64},
                xwray::Vector{Float64}, ywray::Vector{Float64},
                icray::Vector{Int32}, n::Int32)
  ccall((:bars3d, "dislnc_d.dll"), Cvoid, (Ptr{Float64}, Ptr{Float64}, 
          Ptr{Float64}, Ptr{Float64}, Ptr{Float64}, Ptr{Float64},
          Ptr{Int32}, Int32), xray, yray, z1ray, z2ray, xwray, ywray, icray, n)
end

function bartyp(s::String)
  ccall((:bartyp, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function barwth(x::Float64)
  ccall((:barwth, "dislnc_d.dll"), Cvoid, (Float64,), x)
end

function basalf(s::String)
  ccall((:basalf, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function basdat(i1::Int32, i2::Int32, i3::Int32)
  ccall((:basdat, "dislnc_d.dll"), Cvoid, (Int32, Int32, Int32), i1, i2, i3)
end

function bezier(xray::Vector{Float64}, yray::Vector{Float64}, nray::Int32,
                x::Vector{Float64},y::Vector{Float64}, n::Int32)
  ccall((:bezier, "dislnc_d.dll"), Cvoid, (Ptr{Float64}, Ptr{Float64}, Int32,
          Ptr{Float64}, Ptr{Float64}, Int32), xray, yray, nray, x, y, n)
end

function bfcclr(i::Int32)
  ccall((:bfcclr, "dislnc_d.dll"), Cvoid, (Int32,), i)
end

function bfcmsh(i::Int32)
  ccall((:bfcmsh, "dislnc_d.dll"), Cvoid, (Int32,), i)
end

function bitsi2(i1::Int32, i2::Int16, i3::Int32, i4::Int16, i5::Int32)
  n = ccall((:bitsi2, "dislnc_d.dll"), Int16, 
              (Int32, Int16, Int32, Int16, Int32), i1, i2, i3, i4, i5)
  return n
end

function bitsi4(i1::Int32, i2::Int32, i3::Int32, i4::Int32, i5::Int32)
  n = ccall((:bitsi2, "dislnc_d.dll"), Int32, 
              (Int32, Int32, Int32, Int32, Int32), i1, i2, i3, i4, i5)
  return n
end

function bmpfnt(s::String)
  ccall((:bmpfnt, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function bmpmod(i::Int32, s1::String, s2::String)
  ccall((:bmpmod, "dislnc_d.dll"), Cvoid, (Int32, Ptr{UInt8}, Ptr{UInt8}), 
           i, s1, s2)
end

function box2d()
  ccall((:box2d, "dislnc_d.dll"), Cvoid, ())
end

function box3d()
  ccall((:box3d, "dislnc_d.dll"), Cvoid, ())
end

function bufmod(s1::String, s2::String)
  ccall((:bufmod, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Ptr{UInt8}), s1, s2)
end

function center()
  ccall((:center, "dislnc_d.dll"), Cvoid, ())
end

function cgmbgd(x1::Float64, x2::Float64, x3::Float64)
  ccall((:cgmbgd, "dislnc_d.dll"), Cvoid, (Float64, Float64, Float64), 
          x1, x2, x3)
end

function cgmpic(s::String)
  ccall((:cgmpic, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function cmgver(i::Int32)
  ccall((:cmgver, "dislnc_d.dll"), Cvoid, (Int32,), i)
end

function chaang(x::Float64)
  ccall((:chaang, "dislnc_d.dll"), Cvoid, (Float64,), x)
end

function chacod(s::String)
  ccall((:chacod, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function chaspc(x::Float64)
  ccall((:chaspc, "dislnc_d.dll"), Cvoid, (Float64,), x)
end

function chawth(x::Float64)
  ccall((:chawth, "dislnc_d.dll"), Cvoid, (Float64,), x)
end

function chnatt()
  ccall((:chnatt, "dislnc_d.dll"), Cvoid, ())
end

function chncrv(s::String)
  ccall((:chncrv, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function chndot()
  ccall((:chndot, "dislnc_d.dll"), Cvoid, ())
end

function chndsh()
  ccall((:chndsh, "dislnc_d.dll"), Cvoid, ())
end

function chnbar(s::String)
  ccall((:chnbar, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function chnpie(s::String)
  ccall((:chnpie, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function circ3p(x1::Float64, x2::Float64, x3::Float64, 
                x4::Float64, x5::Float64, x6::Float64)
  xp1 = Cdouble[0]
  xp2 = Cdouble[0]
  xp3 = Cdouble[0]
  ccall((:circ3p, "dislnc_d.dll"), Cvoid, (Float64, Float64, Float64,
          Float64, Float64, Float64, Ptr{Cdouble}, Ptr{Cdouble}, Ptr{Cdouble}),
          x1, x2, x3, x4, x5, x6, xp1, xp2, xp3)
  return xp1[1], xp2[1], xp3[1] 
end

function circle(i1::Int32, i2::Int32, i3::Int32)
  ccall((:circle, "dislnc_d.dll"), Cvoid, (Int32, Int32, Int32), i1, i2, i3)
end

function circsp(i::Int32)
  ccall((:circsp, "dislnc_d.dll"), Cvoid, (Int32,), i)
end

function clip3d(s::String)
  ccall((:clip3d, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function closfl(i::Int32)
  n = ccall((:closfl, "dislnc_d.dll"), Int32, (Int32, ), i)
  return n
end

function clpbor(s::String)
  ccall((:clpbor, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function clpmod(s::String)
  ccall((:clpmod, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function clpwin(i1::Int32, i2::Int32, i3::Int32, i4::Int32)
  ccall((:clpwin, "dislnc_d.dll"), Cvoid, (Int32, Int32, Int32, Int32), 
           i1, i2, i3, i4)
end

function clrcyc(i1::Int32, i2::Int32)
  ccall((:clrcyc, "dislnc_d.dll"), Cvoid, (Int32, Int32), i1, i2)
end

function clrmod(s::String)
  ccall((:clrmod, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function clswin(i::Int32)
  ccall((:clswin, "dislnc_d.dll"), Cvoid, (Int32,), i)
end

function color(s::String)
  ccall((:color, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function colran(i1::Int32, i2::Int32)
  ccall((:colran, "dislnc_d.dll"), Cvoid, (Int32, Int32), i1, i2)
end

function conray(zray::Vector{Float64}, nray::Vector{Int32}, n::Int32)
  ccall((:colray, "dislnc_d.dll"), Cvoid, 
          (Ptr{Float64}, Ptr{Int32}, Int32), zray, nray, n)
end

function complx()
  ccall((:complx, "dislnc_d.dll"), Cvoid, ())
end

function conclr(nray::Vector{Int32}, n::Int32)
  ccall((:conclr, "dislnc_d.dll"), Cvoid, (Ptr{Int32}, Int32), nray, n)
end

function concrv(xray::Vector{Float64}, yray::Vector{Float64}, n::Int32,
                zlev::Float64)
  ccall((:concrv, "dislnc_d.dll"), Cvoid, 
          (Ptr{Float64}, Ptr{Float64}, Int32, Float64), xray, yray, n, zlev)
end

function cone3d(x1::Float64, x2::Float64, x3::Float64, x4::Float64,
           x5::Float64, x6::Float64, i1::Int32, i2::Int32)
  ccall((:cone3d, "dislnc_d.dll"), Cvoid, (Float64, Float64, Float64,
          Float64, Float64, Float64, Int32, Int32), 
          x1, x2, x3, x4, x5, x6, i1, i2)
end
 
function confll(xray::Vector{Float64}, yray::Vector{Float64}, 
                zray::Vector{Float64}, n::Int32, i1ray::Vector{Int32}, 
                i2ray::Vector{Int32}, i3ray::Vector{Int32}, ntri::Int32,
                zlev::Vector{Float64}, nlev::Int32)
  ccall((:confll, "dislnc_d.dll"), Cvoid, (Ptr{Float64}, Ptr{Float64}, 
          Ptr{Float64}, Int32, Ptr{Int32}, Ptr{Int32}, Ptr{Int32}, Int32,
          Ptr{Float64}, Int32), xray, yray, zray, n, i1ray, i2ray, i3ray,
          ntri, zlev, nlev)
end

function congap(x::Float64)
  ccall((:congap, "dislnc_d.dll"), Cvoid, (Float64,), x)
end

function conlab(s::String)
  ccall((:conlab, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function conmat(zmat::Array{Float64, 2}, n::Int32, m::Int32, zlev::Float64)
  z = transpose(zmat)
  ccall((:conmat, "dislnc_d.dll"), Cvoid, (Ptr{Float64}, Int32, Int32, 
          Float64), z, n, m, zlev)
  z = 0  # free z
end

function conmod(x1::Float64, x2::Float64)
  ccall((:conmod, "dislnc_d.dll"), Cvoid, (Float64, Float64), x1, x2)
end

function conn3d(x1::Float64, x2::Float64, x3::Float64)
  ccall((:conn3d, "dislnc_d.dll"), Cvoid, (Float64, Float64, Float64), 
          x1, x2, x3)
end

function connpt(x1::Float64, x2::Float64)
  ccall((:connpt, "dislnc_d.dll"), Cvoid, (Float64, Float64), x1, x2)
end

function conpts(xray::Vector{Float64}, n::Int32, yray::Vector{Float64},
                m::Int32, zmat::Array{Float64, 2}, zlev::Float64,
                xpts::Vector{Float64}, ypts::Vector{Float64}, maxpts::Int32,
                nray::Vector{Int32}, maxray::Int32)
  z = transpose(zmat)
  nlines = Cint[0]
  ccall((:conpts, "dislnc_d.dll"), Cvoid, (Ptr{Float64}, Int32, Ptr{Float64}, 
          Int32, Ptr{Float64}, Float64, Ptr{Float64}, Ptr{Float64}, Int32,
          Ptr{Int32}, Int32, Ptr{Cint}), xray, n, yray, m, z, zlev, xpts, ypts,
          maxpts, nray, maxray, nlines)
  z = 0
  return convert(Int32, nlines[1])
end

function conshd(xray::Vector{Float64}, n::Int32, yray::Vector{Float64},
                m::Int32, zmat::Array{Float64, 2}, zlev::Vector{Float64},
                nlev::Int32)
  z = transpose(zmat)
  ccall((:conshd, "dislnc_d.dll"), Cvoid, (Ptr{Float64}, Int32, Ptr{Float64}, 
          Int32, Ptr{Float64}, Ptr{Float64}, Int32), xray, n, yray, m, z, 
          zlev, nlev)
  z = 0  # free z
end

function conshd2(xmat::Array{Float64, 2}, ymat::Array{Float64, 2},
                zmat::Array{Float64, 2}, n::Int32, m::Int32, 
                zlev::Vector{Float64}, nlev::Int32)
  x = transpose(xmat)
  y = transpose(ymat)
  z = transpose(zmat)
  ccall((:conshd2, "dislnc_d.dll"), Cvoid, (Ptr{Float64}, Ptr{Float64}, 
          Ptr{Float64}, Int32, Int32, Ptr{Float64}, Int32), x, y, z, n, m, 
          zlev, nlev)
  x = 0 
  y = 0 
  z = 0 
end

function conshd3d(xray::Vector{Float64}, n::Int32, yray::Vector{Float64},
                m::Int32, zmat::Array{Float64, 2}, zlev::Vector{Float64},
                nlev::Int32)
  z = transpose(zmat)
  ccall((:conshd3d, "dislnc_d.dll"), Cvoid, (Ptr{Float64}, Int32, Ptr{Float64},
          Int32, Ptr{Float64}, Ptr{Float64}, Int32), xray, n, yray, m, z, 
          zlev, nlev)
  z = 0  # free z
end

function contri(xray::Vector{Float64}, yray::Vector{Float64}, 
                zray::Vector{Float64}, n::Int32, i1ray::Vector{Int32}, 
                i2ray::Vector{Int32}, i3ray::Vector{Int32}, ntri::Int32,
                zlev::Float64)
  ccall((:contri, "dislnc_d.dll"), Cvoid, (Ptr{Float64}, Ptr{Float64}, 
          Ptr{Float64}, Int32, Ptr{Int32}, Ptr{Int32}, Ptr{Int32}, Int32,
          Float64), xray, yray, zray, n, i1ray, i2ray, i3ray, ntri, zlev)
end

function contur(xray::Vector{Float64}, n::Int32, yray::Vector{Float64},
                m::Int32, zmat::Array{Float64, 2}, zlev::Float64)
  z = transpose(zmat)
  ccall((:contur, "dislnc_d.dll"), Cvoid, (Ptr{Float64}, Int32, Ptr{Float64}, 
          Int32, Ptr{Float64}, Float64), xray, n, yray, m, z, zlev)
  z = 0  # free z
end

function contur2(xmat::Array{Float64, 2}, ymat::Array{Float64, 2},
                zmat::Array{Float64, 2}, n::Int32, m::Int32, zlev::Float64)
  x = transpose(xmat)
  y = transpose(ymat)
  z = transpose(zmat)
  ccall((:contur2, "dislnc_d.dll"), Cvoid, (Ptr{Float64}, Ptr{Float64}, 
          Ptr{Float64}, Int32, Int32, Float64), x, y, z, n, m, zlev)
  x = 0 
  y = 0 
  z = 0 
end

function cross()
  ccall((:cross, "dislnc_d.dll"), Cvoid, ())
end

function crvmat(zmat::Array{Float64, 2}, n::Int32, m::Int32, ixpts::Int32, 
                iypts::Int32)
  z = transpose(zmat)
  ccall((:crvmat, "dislnc_d.dll"), Cvoid, (Ptr{Float64}, Int32, Int32, Int32, 
           Int32), z, n, m, ixpts, iypts)
  z = 0  # free z
end

function crvqdr(xray::Vector{Float64}, yray::Vector{Float64}, 
                zray::Vector{Float64}, n::Int32)
  ccall((:crvqdr, "dislnc_d.dll"), Cvoid, (Ptr{Float64}, Ptr{Float64}, 
          Ptr{Float64}, Int32), xray, yray, zray, n)
end

function crvt3d(xray::Vector{Float64}, yray::Vector{Float64}, 
                zray::Vector{Float64}, rray::Vector{Float64},
                icray::Vector{Int32}, n::Int32)
  ccall((:crvt3d, "dislnc_d.dll"), Cvoid, (Ptr{Float64}, Ptr{Float64}, 
          Ptr{Float64}, Ptr{Float64}, Ptr{Int32}, Int32), 
          xray, yray, zray, rray, icray, n)
end

function crvtri(xray::Vector{Float64}, yray::Vector{Float64}, 
                zray::Vector{Float64}, n::Int32, i1ray::Vector{Int32},
                i2ray::Vector{Int32}, i3ray::Vector{Int32}, ntri::Int32)
  ccall((:crvtri, "dislnc_d.dll"), Cvoid, (Ptr{Float64}, Ptr{Float64}, 
          Ptr{Float64}, Int32, Ptr{Int32}, Ptr{Int32}, Ptr{Int32}, Int32), 
          xray, yray, zray, n, i1ray, i2ray, i3ray, ntri)
end

function csrkey()
  n = ccall((:csrkey, "dislnc_d.dll"), Int32, ())
  return n
end

function csrlin()
  i1 = Cint[0]
  i2 = Cint[0]
  i3 = Cint[0]
  i4 = Cint[0]
  ccall((:csrlin, "dislnc_d.dll"), Cvoid, (Ptr{Cint}, Ptr{Cint}, Ptr{Cint},
           Ptr{Cint}), i1, i2, i3, i4)
  return convert(Int32, i1[1]), convert(Int32, i2[1]), convert(Int32, i3[1]),
         convert(Int32, i4[1])
end

function csrmod(s1::String, s2::String)
  ccall((:csrmod, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Ptr{UInt8}), s1, s2)
end

function csrpol(ixray::Vector{Int32}, iyray::Vector{Int32}, nmax::Int32)
  i1 = Cint[0]
  i2 = Cint[0]
  ccall((:csrpol, "dislnc_d.dll"), Cvoid, 
          (Ptr{Int32}, Ptr{Int32}, Int32, Ptr{Cint}, Ptr{Cint}), 
          ixray, iyray, nmax, i1, i2)
  return convert(Int32, i1[1])
end

function csrpos()
  i1 = Cint[0]
  i2 = Cint[0]
  n = ccall((:csrpos, "dislnc_d.dll"), Int32, (Ptr{Cint}, Ptr{Cint}), i1, i2)
  return convert(Int32, i1[1]), convert(Int32, i2[1]), n
end

function csrpt1()
  i1 = Cint[0]
  i2 = Cint[0]
  ccall((:csrpt1, "dislnc_d.dll"), Cvoid, (Ptr{Cint}, Ptr{Cint}), i1, i2)
  return convert(Int32, i1[1]), convert(Int32, i2[1])
end

function csrpts(ixray::Vector{Int32}, iyray::Vector{Int32}, nmax::Int32)
  i1 = Cint[0]
  i2 = Cint[0]
  ccall((:csrpts, "dislnc_d.dll"), Cvoid, 
          (Ptr{Int32}, Ptr{Int32}, Int32, Ptr{Cint}, Ptr{Cint}), 
          ixray, iyray, nmax, i1, i2)
  return convert(Int32, i1[1])
end

function csrmov(ixray::Vector{Int32}, iyray::Vector{Int32}, nmax::Int32)
  i1 = Cint[0]
  i2 = Cint[0]
  ccall((:csrmov, "dislnc_d.dll"), Cvoid, 
          (Ptr{Int32}, Ptr{Int32}, Int32, Ptr{Cint}, Ptr{Cint}), 
          ixray, iyray, nmax, i1, i2)
  return convert(Int32, i1[1])
end

function csrrec()
  i1 = Cint[0]
  i2 = Cint[0]
  i3 = Cint[0]
  i4 = Cint[0]
  ccall((:csrreg, "dislnc_d.dll"), Cvoid, (Ptr{Cint}, Ptr{Cint}, Ptr{Cint},
           Ptr{Cint}), i1, i2, i3, i4)
  return convert(Int32, i1[1]), convert(Int32, i2[1]), convert(Int32, i3[1]),
         convert(Int32, i4[1])
end

function csrtyp(s::String)
  ccall((:csrtyp, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function csruni(s::String)
  ccall((:csruni, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function curv3d(xray::Vector{Float64}, yray::Vector{Float64}, 
                zray::Vector{Float64}, n::Int32)
  ccall((:curv3d, "dislnc_d.dll"), Cvoid, (Ptr{Float64}, Ptr{Float64}, 
          Ptr{Float64}, Int32), xray, yray, zray, n)
end

function curve(xray::Vector{Float64}, yray::Vector{Float64}, n::Int32)
  ccall((:curve, "dislnc_d.dll"), Cvoid, 
          (Ptr{Float64}, Ptr{Float64}, Int32), xray, yray, n)
end

function curve3(xray::Vector{Float64}, yray::Vector{Float64}, 
                zray::Vector{Float64}, n::Int32)
  ccall((:curve3, "dislnc_d.dll"), Cvoid, (Ptr{Float64}, Ptr{Float64}, 
          Ptr{Float64}, Int32), xray, yray, zray, n)
end

function curvmp(xray::Vector{Float64}, yray::Vector{Float64}, n::Int32)
  ccall((:curvmp, "dislnc_d.dll"), Cvoid, 
         (Ptr{Float64}, Ptr{Float64}, Int32), xray, yray, n)
end

function curvx3(xray::Vector{Float64}, y::Float64, 
                zray::Vector{Float64}, n::Int32)
  ccall((:curvx3, "dislnc_d.dll"), Cvoid, (Ptr{Float64}, Float64, 
          Ptr{Float64}, Int32), xray, y, zray, n)
end

function curvy3(x::Float64, yray::Vector{Float64}, 
                zray::Vector{Float64}, n::Int32)
  ccall((:curvy3, "dislnc_d.dll"), Cvoid, (Float64, Ptr{Float64}, 
          Ptr{Float64}, Int32), x, yray, zray, n)
end

function cyli3d(x1::Float64, x2::Float64, x3::Float64, x4::Float64,
           x5::Float64, i1::Int32, i2::Int32)
  ccall((:cyli3d, "dislnc_d.dll"), Cvoid, (Float64, Float64, Float64,
          Float64, Float64, Int32, Int32), 
          x1, x2, x3, x4, x5, i1, i2)
end

function dash()
  ccall((:dash, "dislnc_d.dll"), Cvoid, ())
end

function dasl()
  ccall((:dashl, "dislnc_d.dll"), Cvoid, ())
end

function dashm()
  ccall((:dashm, "dislnc_d.dll"), Cvoid, ())
end

function dbffin()
  ccall((:dbffin, "dislnc_d.dll"), Cvoid, ())
end

function dbfini()
  n = ccall((:dbfini, "dislnc_d.dll"), Int32, ())
  return n
end

function dbfmod(s::String)
  ccall((:dbfmod, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function delglb()
  ccall((:delglb, "dislnc_d.dll"), Cvoid, ())
end

function digits(i::Int32, s::String)
  ccall((:digits, "dislnc_d.dll"), Cvoid, (Int32, Ptr{UInt8}), i, s)
end

function disalf()
  ccall((:disalf, "dislnc_d.dll"), Cvoid, ())
end

function disenv(s::String)
  ccall((:disenv, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function disfin()
  ccall((:disfin, "dislnc_d.dll"), Cvoid, ())
end

function disini()
  ccall((:disini, "dislnc_d.dll"), Cvoid, ())
end

function disk3d(x1::Float64, x2::Float64, x3::Float64, x4::Float64,
           x5::Float64, i1::Int32, i2::Int32)
  ccall((:disk3d, "dislnc_d.dll"), Cvoid, (Float64, Float64, Float64,
          Float64, Float64, Int32, Int32), 
          x1, x2, x3, x4, x5, i1, i2)
end

function doevnt()
  ccall((:doevnt, "dislnc_d.dll"), Cvoid, ())
end

function dot()
  ccall((:dot, "dislnc_d.dll"), Cvoid, ())
end

function dotl()
  ccall((:dotl, "dislnc_d.dll"), Cvoid, ())
end

function duplx()
  ccall((:duplx, "dislnc_d.dll"), Cvoid, ())
end

function dwgbut(s::String, i::Int32)
  n = ccall((:dwgbut, "dislnc_d.dll"), Int32, (Ptr{UInt8}, Int32), s, i)
  return n
end

function dwgerr()
  n = ccall((:dwgerr, "dislnc_d.dll"), Int32, ())
  return n
end

function dwgfil(s1::String, s2::String, s3::String)
  p = ccall((:dwgfil, "dislnc_d.dll"), Cstring, (Ptr{UInt8}, Ptr{UInt8},
              Ptr{UInt8}), s1, s2, s3)
  return bytestring(p)
end

function dwglis(s1::String, s2::String, i::Int32)
  n = ccall((:dwglis, "dislnc_d.dll"), Int32, (Ptr{UInt8}, Ptr{UInt8},
              Int32), s1, s2, i)
  return n
end

function dwgmsg(s::String)
  ccall((:dwgmsg, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function dwgtxt(s1::String, s2::String)
  p = ccall((:dwgtxt, "dislnc_d.dll"), Cstring, (Ptr{UInt8}, Ptr{UInt8}),
              s1, s2)
  return bytestring(p)
end

function ellips(i1::Int32, i2::Int32, i3::Int32, i4::Int32)
  ccall((:ellips, "dislnc_d.dll"), Cvoid, (Int32, Int32, Int32, Int32), 
           i1, i2, i3, i4)
end

function endgrf()
  ccall((:endgrf, "dislnc_d.dll"), Cvoid, ())
end

function erase()
  ccall((:erase, "dislnc_d.dll"), Cvoid, ())
end

function errbar(xray::Vector{Float64}, yray::Vector{Float64}, 
                err1::Vector{Float64}, err2::Vector{Float64}, n::Int32)
  ccall((:errbar, "dislnc_d.dll"), Cvoid, (Ptr{Float64}, Ptr{Float64}, 
          Ptr{Float64}, Ptr{Float64}, Int32), xray, yray, err1, err2, n)
end

function errdev(s::String)
  ccall((:errdev, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function errfil(s::String)
  ccall((:errfil, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function errmod(s1::String, s2::String)
  ccall((:errmod, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Ptr{UInt8}), s1, s2)
end

function eushft(s1::String, s2::String)
  ccall((:eushft, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Ptr{UInt8}), s1, s2)
end

function expimg(s1::String, s2::String)
  ccall((:expimg, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Ptr{UInt8}), s1, s2)
end

function expzlb(s::String)
  ccall((:expzlb, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function fbars(xray::Vector{Float64}, y1ray::Vector{Float64}, 
                y2ray::Vector{Float64}, y3ray::Vector{Float64}, 
                y4ray::Vector{Float64}, n::Int32)
  ccall((:fbars, "dislnc_d.dll"), Cvoid, (Ptr{Float64}, Ptr{Float64}, 
          Ptr{Float64}, Ptr{Float64}, Ptr{Float64}, Int32), xray, y1ray, 
          y2ray, y3ray, y4ray, n)
end

function fcha(x::Float64, i::Int32)
  s = Array{UInt8}(undef, 80)
  n = ccall((:fcha, "dislnc_d.dll"), Cvoid, (Float64, Int32, Ptr{UInt8}), 
              x, i, s)
  n = ccall((:trmlen, "dislnc_d.dll"), Int32, (Ptr{UInt8}, ), s)
  resize!(s, n)
  GC.@preserve s
  return unsafe_string(pointer(s))
end

function field(xray::Vector{Float64}, yray::Vector{Float64}, 
               uray::Vector{Float64}, vray::Vector{Float64}, 
               n::Int32, nvec::Int32)
  ccall((:field, "dislnc_d.dll"), Cvoid, (Ptr{Float64}, Ptr{Float64}, 
          Ptr{Float64}, Ptr{Float64}, Int32, Int32), xray, yray, 
          uray, vray, n, nvec)
end

function field3d(x1ray::Vector{Float64}, y1ray::Vector{Float64}, 
                 z1ray::Vector{Float64}, x2ray::Vector{Float64}, 
                 y2ray::Vector{Float64}, z2ray::Vector{Float64}, 
                 n::Int32, nvec::Int32)
  ccall((:field3d, "dislnc_d.dll"), Cvoid, (Ptr{Float64}, Ptr{Float64}, 
          Ptr{Float64}, Ptr{Float64}, Ptr{Float64}, Ptr{Float64},
          Int32, Int32), x1ray, y1ray, z1ray, x2ray, y2ray, z2ray, n, nvec)
end

function filbox(i1::Int32, i2::Int32, i3::Int32, i4::Int32)
  ccall((:filbox, "dislnc_d.dll"), Cvoid, (Int32, Int32, Int32, Int32), 
           i1, i2, i3, i4)
end

function filclr(s::String)
  ccall((:filclr, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function filmod(s::String)
  ccall((:filmod, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function filopt(s1::String, s2::String)
  ccall((:filopt, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Ptr{UInt8}), s1, s2)
end

function filsiz(s::String)
  i1 = Cint[0]
  i2 = Cint[0]
  n = ccall((:filsiz, "dislnc_d.dll"), Int32, (Ptr{UInt8}, Ptr{Cint}, 
              Ptr{Cint}), s, i1, i2)
  return n, convert(Int32, i1[1]), convert(Int32, i2[1])
end

function filtyp(s::String)
  n = ccall((:filtyp, "dislnc_d.dll"), Int32, (Ptr{UInt8}, ), s)
  return n
end

function filwin(i1::Int32, i2::Int32, i3::Int32, i4::Int32)
  ccall((:filwin, "dislnc_d.dll"), Cvoid, (Int32, Int32, Int32, Int32), 
           i1, i2, i3, i4)
end

function fitscls()
  ccall((:fitscls, "dislnc_d.dll"), Cvoid, ())
end

function fitsflt(s::String)
  x = ccall((:fitsflt, "dislnc_d.dll"), Float64, (Ptr{UInt8}, ), s)
  return x
end

function fitshdu(i::Int32)
  n = ccall((:fitshdu, "dislnc_d.dll"), Int32, (Int32,), i)
  return n
end

function fitsimg(iray::Vector{UInt8}, nmax::Int32) 
  n = ccall((:fitsimg, "dislnc_d.dll"), Int32, (Ptr{UInt8}, Int32),
          iray, nmax)
  return n   
end

function fitsopn(s::String)
  n = ccall((:fitsopn, "dislnc_d.dll"), Int32, (Ptr{UInt8}, ), s)
  return n
end

function fitsstr(s::String)
  s = Array{UInt8}(undef, 257)
  ccall((:fitsstr, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Ptr{UInt8}, Int32), 
          s, s2, 257)
  n = ccall((:trmlen, "dislnc_d.dll"), Int32, (Ptr{UInt8}, ), s2)
  resize!(s2, n)
  GC.@preserve s2
  return unsafe_string(pointer(s2))
end

function fitstyp(s::String)
  n = ccall((:fitstyp, "dislnc_d.dll"), Int32, (Ptr{UInt8}, ), s)
  return n
end

function fitsval(s::String)
  n = ccall((:fitsval, "dislnc_d.dll"), Int32, (Ptr{UInt8}, ), s)
  return n
end

function fixspc(x::Float64)
  ccall((:fixspc, "dislnc_d.dll"), Cvoid, (Float64,), x)
end

function flab3d()
  ccall((:flab3d, "dislnc_d.dll"), Cvoid, ())
end

function flen(x::Float64, i::Int32)
  n = ccall((:flen, "dislnc_d.dll"), Cvoid, (Float64, Int32, ), x, i)
  return n
end

function frame(i::Int32)
  ccall((:frame, "dislnc_d.dll"), Cvoid, (Int32,), i)
end

function frmbar(i::Int32)
  ccall((:frmbar, "dislnc_d.dll"), Cvoid, (Int32,), i)
end

function frmclr(i::Int32)
  ccall((:frmclr, "dislnc_d.dll"), Cvoid, (Int32,), i)
end

function frmess(i::Int32)
  ccall((:frmess, "dislnc_d.dll"), Cvoid, (Int32,), i)
end

function gapcrv(x::Float64)
  ccall((:gapcrv, "dislnc_d.dll"), Cvoid, (Float64,), x)
end

function gapsiz(x::Float64, s::String)
  ccall((:gapsiz, "dislnc_d.dll"), Cvoid, (Float64, Ptr{UInt8}), x, s)
end

function gaxpar(v1::Float64, v2::Float64, s1::String, s2::String)
  x1 = Cdouble[0]
  x2 = Cdouble[0]
  x3 = Cdouble[0]
  x4 = Cdouble[0]
  i  = Cint[0]
  ccall((:gaxpar, "dislnc_d.dll"), Cvoid, (Float64, Float64, Ptr{UInt8}, 
          Ptr{UInt8}, Ptr{Cdouble}, Ptr{Cdouble}, Ptr{Cdouble}, 
          Ptr{Cdouble}, Ptr{Cint}), 
          v1, v2, s1, s2, x1, x2, x3, x4, i)
  return x1[1], x2[1], x3[1], x4[1], convert(Int32, i[1])
end

function getalf()
  p = ccall((:getalf, "dislnc_d.dll"), Cstring, ())
  return bytestring(p)
end

function getang()
  n = ccall((:getang, "dislnc_d.dll"), Int32, ())
  return n
end

function getbpp()
  n = ccall((:getbpp, "dislnc_d.dll"), Int32, ())
  return n
end

function getclp()
  i1 = Cint[0]
  i2 = Cint[0]
  i3 = Cint[0]
  i4 = Cint[0]
  ccall((:getclp, "dislnc_d.dll"), Cvoid, (Ptr{Cint}, Ptr{Cint}, Ptr{Cint},
           Ptr{Cint}), i1, i2, i3, i4)
  return convert(Int32, i1[1]), convert(Int32, i2[1]), convert(Int32, i3[1]),
         convert(Int32, i4[1])
end

function getclr()
  n = ccall((:getclr, "dislnc_d.dll"), Int32, ())
  return n
end

function getdig()
  i1 = Cint[0]
  i2 = Cint[0]
  i3 = Cint[0]
  ccall((:getdig, "dislnc_d.dll"), Cvoid, (Ptr{Cint}, Ptr{Cint}, Ptr{Cint}), 
           i1, i2, i3)
  return convert(Int32, i1[1]), convert(Int32, i2[1]), convert(Int32, i3[1])
end

function getdsp()
  p = ccall((:getdsp, "dislnc_d.dll"), Cstring, ())
  return bytestring(p)
end

function getfil()
  p = ccall((:getfil, "dislnc_d.dll"), Cstring, ())
  return bytestring(p)
end

function getgrf(s::String)
  x1 = Cdouble[0]
  x2 = Cdouble[0]
  x3 = Cdouble[0]
  x4 = Cdouble[0]
  ccall((:getgrf, "dislnc_d.dll"), Cvoid, (Ptr{Cdouble}, Ptr{Cdouble}, 
          Ptr{Cdouble}, Ptr{Cdouble}, Ptr{UInt8}), x1, x2, x3, x4, s)
  return x1[1], x2[1], x3[1], x4[1]
end

function gethgt()
  n = ccall((:gethgt, "dislnc_d.dll"), Int32, ())
  return n
end

function gethnm()
  n = ccall((:gethnm, "dislnc_d.dll"), Int32, ())
  return n
end

function getico(x1::Float64, x2::Float64)
  xp1 = Cdouble[0]
  xp2 = Cdouble[0]
  ccall((:getico, "dislnc_d.dll"), Cvoid, (Float64, Float64, 
          Ptr{Cdouble}, Ptr{Cdouble}), x1, x2, xp1, xp2)
  return xp1[1], xp2[1]
end

function getind(i::Int32)
  x1 = Cdouble[0]
  x2 = Cdouble[0]
  x3 = Cdouble[0]
  ccall((:getind, "dislnc_d.dll"), Cvoid, (Int32, Ptr{Cdouble}, Ptr{Cdouble}, 
          Ptr{Cdouble}), i, x1, x2, x3)
  return x1[1], x2[1], x3[1]
end

function getlab()
  s1 = Array{UInt8}(undef, 8);
  s2 = Array{UInt8}(undef, 8);
  s3 = Array{UInt8}(undef, 8);
  ccall((:getlab, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Ptr{UInt8},
          Ptr{UInt8}), s1, s2, s3)
  n1 = ccall((:trmlen, "dislnc_d.dll"), Int32, (Ptr{UInt8}, ), s1)
  n2 = ccall((:trmlen, "dislnc_d.dll"), Int32, (Ptr{UInt8}, ), s2)
  n3 = ccall((:trmlen, "dislnc_d.dll"), Int32, (Ptr{UInt8}, ), s3)
  resize!(s1, n1)
  resize!(s2, n2)
  resize!(s3, n3)
  GC.@preserve s1
  GC.@preserve s2
  GC.@preserve s3
  return unsafe_string(pointer(s1)), unsafe_string(pointer(s2)),
         unsafe_string(pointer(s3))
end

function getlen()
  i1 = Cint[0]
  i2 = Cint[0]
  i3 = Cint[0]
  ccall((:getlen, "dislnc_d.dll"), Cvoid, (Ptr{Cint}, Ptr{Cint}, Ptr{Cint}), 
           i1, i2, i3)
  return convert(Int32, i1[1]), convert(Int32, i2[1]), convert(Int32, i3[1])
end

function getlev()
  n = ccall((:getlev, "dislnc_d.dll"), Int32, ())
  return n
end

function getlin()
  n = ccall((:getlin, "dislnc_d.dll"), Int32, ())
  return n
end

function getlit(x1::Float64, x2::Float64, x3::Float64, x4::Float64, 
                x5::Float64, x6::Float64)
  n = ccall((:getlit, "dislnc_d.dll"), Cvoid, (Float64, Float64, Float64, 
              Float64, Float64, Float64), x1, x2, x3, x4, x5, x6)
  return n
end

function getmat(xray::Vector{Float64}, yray::Vector{Float64}, 
                zray::Vector{Float64}, n::Int32, zmat::Array{Float64, 2},
                nx::Int32, ny::Int32, zval::Float64)     
  imat = Array{Int32}(undef, nx, ny)
  wmat = Array{Float64}(undef, nx, ny)
  z = Array{Float64}(undef, nx, ny)
  ccall((:getmat, "dislnc_d.dll"), Cvoid, (Ptr{Float64}, Ptr{Float64}, 
          Ptr{Float64}, Int32, Ptr{Float64}, Int32, Int32, Float64,
          Ptr{Int32},Ptr{Float64}), 
          xray, yray, zray, n, z, nx, ny, zval, imat, wmat)

  transpose!(zmat, z)
  imat = 0
  wmat = 0
  z = 0
end

function getmfl()
  p = ccall((:getmfl, "dislnc_d.dll"), Cstring, ())
  return bytestring(p)
end

function getmix(s::String)
  p = ccall((:getmix, "dislnc_d.dll"), Cstring, (Ptr{UInt8}, ), s)
  return bytestring(p)
end

function getor()
  i1 = Cint[0]
  i2 = Cint[0]
  ccall((:getor, "dislnc_d.dll"), Cvoid, (Ptr{Cint}, Ptr{Cint}), i1, i2)
  return convert(Int32, i1[1]), convert(Int32, i2[1])
end

function getpag()
  i1 = Cint[0]
  i2 = Cint[0]
  ccall((:getpag, "dislnc_d.dll"), Cvoid, (Ptr{Cint}, Ptr{Cint}), i1, i2)
  return convert(Int32, i1[1]), convert(Int32, i2[1])
end

function getpat()
  n = ccall((:getpat, "dislnc_d.dll"), Int32, ())
  return n
end

function getplv()
  n = ccall((:getplv, "dislnc_d.dll"), Int32, ())
  return n
end

function getpos()
  i1 = Cint[0]
  i2 = Cint[0]
  ccall((:getpos, "dislnc_d.dll"), Cvoid, (Ptr{Cint}, Ptr{Cint}), i1, i2)
  return convert(Int32, i1[1]), convert(Int32, i2[1])
end

function getran()
  i1 = Cint[0]
  i2 = Cint[0]
  ccall((:getran, "dislnc_d.dll"), Cvoid, (Ptr{Cint}, Ptr{Cint}), i1, i2)
  return convert(Int32, i1[1]), convert(Int32, i2[1])
end

function getres()
  i1 = Cint[0]
  i2 = Cint[0]
  ccall((:getres, "dislnc_d.dll"), Cvoid, (Ptr{Cint}, Ptr{Cint}), i1, i2)
  return convert(Int32, i1[1]), convert(Int32, i2[1])
end

function getrco(x1::Float64, x2::Float64)
  xp1 = Cdouble[0]
  xp2 = Cdouble[0]
  ccall((:getrco, "dislnc_d.dll"), Cvoid, (Float64, Float64, 
          Ptr{Cdouble}, Ptr{Cdouble}), x1, x2, xp1, xp2)
  return xp1[1], xp2[1]
end

function getrgb()
  x1 = Cdouble[0]
  x2 = Cdouble[0]
  x3 = Cdouble[0]
  ccall((:getrgb, "dislnc_d.dll"), Cvoid, (Ptr{Cdouble}, Ptr{Cdouble}, 
          Ptr{Cdouble}), x1, x2, x3)
  return x1[1], x2[1], x3[1]
end

function getscl()
  i1 = Cint[0]
  i2 = Cint[0]
  i3 = Cint[0]
  ccall((:getscl, "dislnc_d.dll"), Cvoid, (Ptr{Cint}, Ptr{Cint}, Ptr{Cint}), 
           i1, i2, i3)
  return convert(Int32, i1[1]), convert(Int32, i2[1]), convert(Int32, i3[1])
end

function getscm()
  i1 = Cint[0]
  i2 = Cint[0]
  i3 = Cint[0]
  ccall((:getscm, "dislnc_d.dll"), Cvoid, (Ptr{Cint}, Ptr{Cint}, Ptr{Cint}), 
           i1, i2, i3)
  return convert(Int32, i1[1]), convert(Int32, i2[1]), convert(Int32, i3[1])
end

function getscr()
  i1 = Cint[0]
  i2 = Cint[0]
  ccall((:getscr, "dislnc_d.dll"), Cvoid, (Ptr{Cint}, Ptr{Cint}), i1, i2)
  return convert(Int32, i1[1]), convert(Int32, i2[1])
end

function getshf(s::String)
  p = ccall((:getshf, "dislnc_d.dll"), Cstring, (Ptr{UInt8}, ), s)
  return bytestring(p)
end

function getsp1()
  i1 = Cint[0]
  i2 = Cint[0]
  i3 = Cint[0]
  ccall((:getsp1, "dislnc_d.dll"), Cvoid, (Ptr{Cint}, Ptr{Cint}, Ptr{Cint}), 
           i1, i2, i3)
  return convert(Int32, i1[1]), convert(Int32, i2[1]), convert(Int32, i3[1])
end

function getsp2()
  i1 = Cint[0]
  i2 = Cint[0]
  i3 = Cint[0]
  ccall((:getsp2, "dislnc_d.dll"), Cvoid, (Ptr{Cint}, Ptr{Cint}, Ptr{Cint}), 
           i1, i2, i3)
  return convert(Int32, i1[1]), convert(Int32, i2[1]), convert(Int32, i3[1])
end

function getsym()
  i1 = Cint[0]
  i2 = Cint[0]
  ccall((:getsym, "dislnc_d.dll"), Cvoid, (Ptr{Cint}, Ptr{Cint}), i1, i2)
  return convert(Int32, i1[1]), convert(Int32, i2[1])
end

function gettcl()
  i1 = Cint[0]
  i2 = Cint[0]
  ccall((:gettcl, "dislnc_d.dll"), Cvoid, (Ptr{Cint}, Ptr{Cint}), i1, i2)
  return convert(Int32, i1[1]), convert(Int32, i2[1])
end

function gettic()
  i1 = Cint[0]
  i2 = Cint[0]
  i3 = Cint[0]
  ccall((:gettic, "dislnc_d.dll"), Cvoid, (Ptr{Cint}, Ptr{Cint}, Ptr{Cint}), 
           i1, i2, i3)
  return convert(Int32, i1[1]), convert(Int32, i2[1]), convert(Int32, i3[1])
end

function gettyp()
  n = ccall((:gettyp, "dislnc_d.dll"), Int32, ())
  return n
end

function getuni()
  p = ccall((:getuni, "dislnc_d.dll"), Cstring, ())
  if (p == C_NULL)
    return 0
  end
end

function getver()
  x = ccall((:getver, "dislnc_d.dll"), Float64, ())
  return x
end

function getvk()
  i1 = Cint[0]
  i2 = Cint[0]
  i3 = Cint[0]
  ccall((:getvk, "dislnc_d.dll"), Cvoid, (Ptr{Cint}, Ptr{Cint}, Ptr{Cint}), 
           i1, i2, i3)
  return convert(Int32, i1[1]), convert(Int32, i2[1]), convert(Int32, i3[1])
end

function getvlt()
  p = ccall((:getvlt, "dislnc_d.dll"), Cstring, ())
  return bytestring(p)
end

function getwid()
  n = ccall((:getwid, "dislnc_d.dll"), Int32, ())
  return n
end

function getwin()
  i1 = Cint[0]
  i2 = Cint[0]
  i3 = Cint[0]
  i4 = Cint[0]
  ccall((:getwin, "dislnc_d.dll"), Cvoid, (Ptr{Cint}, Ptr{Cint}, Ptr{Cint},
           Ptr{Cint}), i1, i2, i3, i4)
  return convert(Int32, i1[1]), convert(Int32, i2[1]), convert(Int32, i3[1]),
         convert(Int32, i4[1])
end

function getxid(s::String)
  n = ccall((:getxid, "dislnc_d.dll"), Int32, (Ptr{UInt8}, ), s)
  return n
end

function gifmod(s1::String, s2::String)
  ccall((:gifmod, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Ptr{UInt8}), s1, s2)
end

function gmxalf(s::String)
  s1 = Array{UInt8}(undef, 2);
  s2 = Array{UInt8}(undef, 2);
  n = ccall((:gmxalf, "dislnc_d.dll"), Int32, (Ptr{UInt8}, Ptr{UInt8},
          Ptr{UInt8}), s, s1, s2)
  n1 = ccall((:trmlen, "dislnc_d.dll"), Int32, (Ptr{UInt8}, ), s1)
  n2 = ccall((:trmlen, "dislnc_d.dll"), Int32, (Ptr{UInt8}, ), s2)
  resize!(s1, n1)
  resize!(s2, n2)
  GC.@preserve s1
  GC.@preserve s2
  return unsafe_string(pointer(s1)), unsafe_string(pointer(s2))
end

function gothic()
  ccall((:gothic, "dislnc_d.dll"), Cvoid, ())
end

function grace(i::Int32)
  ccall((:grace, "dislnc_d.dll"), Cvoid, (Int32,), i)
end

function graf(x1::Float64, x2::Float64, x3::Float64, x4::Float64,
              x5::Float64, x6::Float64, x7::Float64, x8::Float64)
  ccall((:graf, "dislnc_d.dll"), Cvoid, (Float64, Float64, Float64,
          Float64, Float64, Float64, Float64, Float64), 
          x1, x2, x3, x4, x5, x6, x7, x8)
end

function graf3(x1::Float64, x2::Float64, x3::Float64, x4::Float64,
               x5::Float64, x6::Float64, x7::Float64, x8::Float64,
               x9::Float64, x10::Float64, x11::Float64, x12::Float64)
  ccall((:graf3, "dislnc_d.dll"), Cvoid, (Float64, Float64, Float64,
          Float64, Float64, Float64, Float64, Float64, Float64, Float64,
          Float64, Float64),
           x1, x2, x3, x4, x5, x6, x7, x8, x9, x10, x11, x12)
end

function graf3d(x1::Float64, x2::Float64, x3::Float64, x4::Float64,
               x5::Float64, x6::Float64, x7::Float64, x8::Float64,
               x9::Float64, x10::Float64, x11::Float64, x12::Float64)
  ccall((:graf3d, "dislnc_d.dll"), Cvoid, (Float64, Float64, Float64,
          Float64, Float64, Float64, Float64, Float64, Float64, Float64,
          Float64, Float64),
           x1, x2, x3, x4, x5, x6, x7, x8, x9, x10, x11, x12)
end

function grafmp(x1::Float64, x2::Float64, x3::Float64, x4::Float64,
                x5::Float64, x6::Float64, x7::Float64, x8::Float64)
  ccall((:grafmp, "dislnc_d.dll"), Cvoid, (Float64, Float64, Float64,
          Float64, Float64, Float64, Float64, Float64), 
          x1, x2, x3, x4, x5, x6, x7, x8)
end

function grafp(x1::Float64, x2::Float64, x3::Float64, x4::Float64,
                x5::Float64)
  ccall((:grafp, "dislnc_d.dll"), Cvoid, (Float64, Float64, Float64,
          Float64, Float64), x1, x2, x3, x4, x5)
end

function grafr(xray::Vector{Float64}, n::Int32, yray::Vector{Float64}, 
               m::Int32)
  ccall((:grafr, "dislnc_d.dll"), Cvoid, 
          (Ptr{Float64}, Int32, Ptr{Float64}, Int32), xray, n, yray, m)
end

function grdpol(i1::Int32, i2::Int32)
  ccall((:grdpol, "dislnc_d.dll"), Cvoid, (Int32, Int32), i1, i2)
end

function grffin()
  ccall((:grffin, "dislnc_d.dll"), Cvoid, ())
end

function grfimg(s::String)
  ccall((:grfimg, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function grfini(x1::Float64, x2::Float64, x3::Float64, x4::Float64,
           x5::Float64, x6::Float64, x7::Float64, x8::Float64, x9::Float64)
  ccall((:grfini, "dislnc_d.dll"), Cvoid, (Float64, Float64, Float64,
          Float64, Float64, Float64, Float64, Float64, Float64), 
          x1, x2, x3, x4, x5, x6, x7, x8, x9)
end

function grid(i1::Int32, i2::Int32)
  ccall((:grid, "dislnc_d.dll"), Cvoid, (Int32, Int32), i1, i2)
end

function grid3d(i1::Int32, i2::Int32, s::String)
  ccall((:grid3d, "dislnc_d.dll"), Cvoid, (Int32, Int32, Ptr{UInt8}), 
           i1, i2, s)
end

function gridim(x1::Float64, x2::Float64, x3::Float64, i::Int32)
  ccall((:gridim, "dislnc_d.dll"), Cvoid, (Float64, Float64, Float64,
          Int32), x1, x2, x3, i)
end

function gridmp(i1::Int32, i2::Int32)
  ccall((:gridmp, "dislnc_d.dll"), Cvoid, (Int32, Int32), i1, i2)
end

function gridre(x1::Float64, x2::Float64, x3::Float64, i::Int32)
  ccall((:gridre, "dislnc_d.dll"), Cvoid, (Float64, Float64, Float64,
          Int32), x1, x2, x3, i)
end

function gwgatt(i::Int32, s::String)
  n = ccall((:gwgatt, "dislnc_d.dll"), Int32, (Int32, Ptr{UInt8}), i, s)
  return n
end

function gwgbox(i::Int32)
  n = ccall((:gwgbox, "dislnc_d.dll"), Int32, (Int32,), i)
  return n
end

function gwgbut(i::Int32)
  n = ccall((:gwgbut, "dislnc_d.dll"), Int32, (Int32,), i)
  return n
end

function gwgfil(i::Int32)
  s = Array{UInt8}(undef, 257)
  ccall((:gwgfil, "dislnc_d.dll"), Cvoid, (Int32, Ptr{UInt8}), i, s)
  n = ccall((:trmlen, "dislnc_d.dll"), Int32, (Ptr{UInt8}, ), s)
  resize!(s, n)
  GC.@preserve s
  return unsafe_string(pointer(s))
end

function gwgflt(i::Int32)
  x = ccall((:gwgflt, "dislnc_d.dll"), Float64, (Int32,), i)
  return x
end

function gwggui()
  n = ccall((:gwggui, "dislnc_d.dll"), Int32, ())
  return n
end

function gwgint(i::Int32)
  n = ccall((:gwgint, "dislnc_d.dll"), Int32, (Int32,), i)
  return n
end

function gwglis(i::Int32)
  n = ccall((:gwglis, "dislnc_d.dll"), Int32, (Int32,), i)
  return n
end

function gwgscl(i::Int32)
  x = ccall((:gwgscl, "dislnc_d.dll"), Float64, (Int32,), i)
  return x
end

function gwgsiz(i::Int32)
  i1 = Cint[0]
  i2 = Cint[0]
  ccall((:gwgsiz, "dislnc_d.dll"), Cvoid, (Int32, Ptr{Cint}, Ptr{Cint}), 
          i, i1, i2)
  return convert(Int32, i1[1]), convert(Int32, i2[1])
end

function gwgtbf(i1::Int32, i2::Int32, i3::Int32)
  x = ccall((:gwgtbf, "dislnc_d.dll"), Float64, (Int32, Int32, Int32), 
               i1, i2, i3)
  return x
end

function gwgtbi(i1::Int32, i2::Int32, i3::Int32)
  n = ccall((:gwgtbi, "dislnc_d.dll"), Int32, (Int32, Int32, Int32), 
               i1, i2, i3)
  return n
end

function gwgtbl(i1::Int32, xray::Vector{Float64}, i2::Int32, i3::Int32,
                s::String)
  ccall((:gwgtbl, "dislnc_d.dll"), Cvoid, 
          (Int32, Ptr{Float64}, Int32, Int32, Ptr{UInt8}), i1, xray, i2, i3, s)
end

function gwgtbs(i1::Int32, i2::Int32, i3::Int32)
  s = Array{UInt8}(undef, 257)
  ccall((:gwgtbs, "dislnc_d.dll"), Cvoid, (Int32, Int32, Int32, Ptr{UInt8}),
          i1, i2, i3, s)
  n = ccall((:trmlen, "dislnc_d.dll"), Int32, (Ptr{UInt8}, ), s)
  resize!(s, n)
  GC.@preserve s
  return unsafe_string(pointer(s))
end

function gwgtxt(i::Int32)
  s = Array{UInt8}(undef, 257)
  ccall((:gwgtxt, "dislnc_d.dll"), Cvoid, (Int32, Ptr{UInt8}), i, s)
  n = ccall((:trmlen, "dislnc_d.dll"), Int32, (Ptr{UInt8}, ), s)
  resize!(s, n)
  GC.@preserve s
  return unsafe_string(pointer(s))
end

function gwgxid(i::Int32)
  n = ccall((:gwgxid, "dislnc_d.dll"), Int32, (Int32,), i)
  return n
end

function height(i::Int32)
  ccall((:height, "dislnc_d.dll"), Cvoid, (Int32,), i)
end

function helve()
  ccall((:helve, "dislnc_d.dll"), Cvoid, ())
end

function helves()
  ccall((:helves, "dislnc_d.dll"), Cvoid, ())
end

function helvet()
  ccall((:helvet, "dislnc_d.dll"), Cvoid, ())
end

function hidwin(i::Int32, s::String)
  ccall((:hidwin, "dislnc_d.dll"), Cvoid, (Int32, Ptr{UInt8}), i, s)
end

function histog(xray::Vector{Float64}, n::Int32, x::Vector{Float64},
                y::Vector{Float64})
  m = Cint[0]
  ccall((:histog, "dislnc_d.dll"), Cvoid, 
          (Ptr{Float64}, Int32, Ptr{Float64}, Ptr{Float64}, Ptr{Cint}), 
          xray, n, x, y, m)
  return convert(Int32, m[1])
end

function hname(i::Int32)
  ccall((:hname, "dislnc_d.dll"), Cvoid, (Int32,), i)
end

function hpgmod(s1::String, s2::String)
  ccall((:hpgmod, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Ptr{UInt8}), s1, s2)
end

function hsvrgb(x1::Float64, x2::Float64, x3::Float64)
  xp1 = Cdouble[0]
  xp2 = Cdouble[0]
  xp3 = Cdouble[0]
  ccall((:hsvrgb, "dislnc_d.dll"), Cvoid, (Float64, Float64, Float64,
          Ptr{Cdouble}, Ptr{Cdouble}, Ptr{Cdouble}), x1, x2, x3, xp1, xp2, xp3)
  return xp1[1], xp2[1], xp3[1]
end

function hsym3d(x::Float64)
  ccall((:hsym3d, "dislnc_d.dll"), Cvoid, (Float64,), x)
end

function hsymbl(i::Int32)
  ccall((:hsymbl, "dislnc_d.dll"), Cvoid, (Int32,), i)
end

function htitle(i::Int32)
  ccall((:htitle, "dislnc_d.dll"), Cvoid, (Int32,), i)
end

function hwfont()
  ccall((:hwfont, "dislnc_d.dll"), Cvoid, ())
end

function hwmode(s1::String, s2::String)
  ccall((:hwmode, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Ptr{UInt8}), s1, s2)
end

function hworig(i1::Int32, i2::Int32)
  ccall((:hworig, "dislnc_d.dll"), Cvoid, (Int32, Int32), i1, i2)
end

function hwpage(i1::Int32, i2::Int32)
  ccall((:hwpage, "dislnc_d.dll"), Cvoid, (Int32, Int32), i1, i2)
end

function hwscal(x::Float64)
  ccall((:hwscal, "dislnc_d.dll"), Cvoid, (Float64,), x)
end

function imgbox(i1::Int32, i2::Int32, i3::Int32, i4::Int32)
  ccall((:imgbox, "dislnc_d.dll"), Cvoid, (Int32, Int32, Int32, Int32), 
           i1, i2, i3, i4)
end

function imgwin(i1::Int32, i2::Int32, i3::Int32, i4::Int32)
  ccall((:imgwin, "dislnc_d.dll"), Cvoid, (Int32, Int32, Int32, Int32), 
           i1, i2, i3, i4)
end

function imgfin()
  ccall((:imgfin, "dislnc_d.dll"), Cvoid, ())
end

function imgfmt(s::String)
  ccall((:imgfmt, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function imgini()
  ccall((:imgini, "dislnc_d.dll"), Cvoid, ())
end

function imgmod(s::String)
  ccall((:imgmod, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function imgsiz(i1::Int32, i2::Int32)
  ccall((:imgsiz, "dislnc_d.dll"), Cvoid, (Int32, Int32), i1, i2)
end

function imgptr(i::Int32)
  ccall((:imgptr, "dislnc_d.dll"), Cvoid, (Int32,), i)
end

function inccrv(i::Int32)
  ccall((:inccrv, "dislnc_d.dll"), Cvoid, (Int32,), i)
end

function incdat(i1::Int32, i2::Int32, i3::Int32)
  n = ccall((:inccrv, "dislnc_d.dll"), Cvoid, (Int32, Int32, Int32), 
              i1, i2, i3)
  return n
end

function incfil(s::String)
  ccall((:incfil, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function incmrk(i::Int32)
  ccall((:incmrk, "dislnc_d.dll"), Cvoid, (Int32,), i)
end

function indrgb(x1::Float64, x2::Float64, x3::Float64)
  n = ccall((:indrgb, "dislnc_d.dll"), Cvoid, (Float64, Float64, Float64), 
              x1, x2, x3)
  return n
end

function intax()
  ccall((:intax, "dislnc_d.dll"), Cvoid, ())
end

function intcha(i::Int32)
  s = Array{UInt8}(undef, 80)
  n = ccall((:intcha, "dislnc_d.dll"), Int32, (Int32, Ptr{UInt8}), 
              i, s)
  n = ccall((:trmlen, "dislnc_d.dll"), Int32, (Ptr{UInt8}, ), s)
  resize!(s, n)
  GC.@preserve s
  return unsafe_string(pointer(s))
end

function intlen(i::Int32)
  n = ccall((:intlen, "dislnc_d.dll"), Cvoid, (Int32, ), i)
  return n
end

function intrgb(x1::Float64, x2::Float64, x3::Float64)
  n = ccall((:intrgb, "dislnc_d.dll"), Int32, (Float64, Float64, Float64), 
              x1, x2, x3)
  return n
end

function intutf(iray::Vector{Int32}, n::Int32)
  s = Array{UInt8}(undef, n * 4 + 1)
  ccall((:intutf, "dislnc_d.dll"), Cvoid, 
         (Ptr{Int32}, Int32, Ptr{UInt8}, Int32), iray, n, s, n * 4)
  m = ccall((:trmlen, "dislnc_d.dll"), Int32, (Ptr{UInt8}, ), s)
  resize!(s, m)
  GC.@preserve s
  return unsafe_string(pointer(s))
end

function isopts(xray::Vector{Float64}, nx::Int32, yray::Vector{Float64},
                ny::Int32, zray::Vector{Float64}, nz::Int32, 
                wmat::Array{Float64, 3}, wlev::Float64,
                xtri::Vector{Float64}, ytri::Vector{Float64},
                ztri::Vector{Float64}, nmax::Int32)
  w = transpose(wmat)
  ntri = Cint[0]

  n = ccall((:isopts, "dislnc_d.dll"), Cvoid, (Ptr{Float64}, Int32, 
          Ptr{Float64}, Int32, Ptr{Float64}, Int32, Ptr{Float64}, Float64,
          Ptr{Float64}, Ptr{Float64}, Ptr{Float64}, Int32, Ptr{Cint}), 
          xray, nx, yray, ny, zray, nz, w, wlev, xtri, ytri, ztri, nmax, nzti)
  w = 0
  return convert(Int32, ntri[1])
end

function itmcat(s1::String, s2::String)
  n1 = ccall((:trmlen, "dislnc_d.dll"), Int32, (Ptr{UInt8}, ), s1)
  n2 = ccall((:trmlen, "dislnc_d.dll"), Int32, (Ptr{UInt8}, ), s2)
  s = Array{UInt8}(undef, n1 + n2 + 2)
  for i = 1:n1
    s[i] = s1[i]
  end
  s[n1+1] = 0
  ccall((:itmcat, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Ptr{UInt8}), s, s2)
  GC.@preserve s
  return unsafe_string(pointer(s))
end

function itmcnt(s::String)
  n = ccall((:itmcnt, "dislnc_d.dll"), Int32, (Ptr{UInt8},), s)
  return n
end

function itmncat(s1::String, nmax::Int32, s2::String)
  n1 = ccall((:trmlen, "dislnc_d.dll"), Int32, (Ptr{UInt8}, ), s1)
  n2 = ccall((:trmlen, "dislnc_d.dll"), Int32, (Ptr{UInt8}, ), s2)
  s = Array{UInt8}(undef, n1 + n2 + 2)
  for i = 1:n1
    s[i] = s1[i]
  end
  s[n1+1] = 0
  ccall((:itmncat, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Int32, Ptr{UInt8}), 
          s, nmax, s2)
  GC.@preserve s
  return unsafe_string(pointer(s))
end

function itmstr(s::String, i::Int32)
  p = ccall((:itmstr, "dislnc_d.dll"), Cstring, (Ptr{UInt8}, Int32), s, i)
  val = bytestring(p)
  ccall((:freeptr, "dislnc_d.dll"), Cvoid, (Cstring, ), p)
  return val
end

function jusbar(s::String)
  ccall((:jusbar, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function labclr(i::Int32, s::String)
  ccall((:labclr, "dislnc_d.dll"), Cvoid, (Int32, Ptr{UInt8}), i, s)
end

function labdig(i::Int32, s::String)
  ccall((:labdig, "dislnc_d.dll"), Cvoid, (Int32, Ptr{UInt8}), i, s)
end

function labdis(i::Int32, s::String)
  ccall((:labdis, "dislnc_d.dll"), Cvoid, (Int32, Ptr{UInt8}), i, s)
end

function labels(s1::String, s2::String)
  ccall((:labels, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Ptr{UInt8}), s1, s2)
end

function labjus(s1::String, s2::String)
  ccall((:labjus, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Ptr{UInt8}), s1, s2)
end

function labl3d(s::String)
  ccall((:labl3d, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function labmod(s1::String, s2::String, s3::String)
  ccall((:labmod, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Ptr{UInt8}, Ptr{UInt8}),
           s1, s2, s3)
end

function labpos(s1::String, s2::String)
  ccall((:labpos, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Ptr{UInt8}), s1, s2)
end

function labtyp(s1::String, s2::String)
  ccall((:labtyp, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Ptr{UInt8}), s1, s2)
end

function ldimg(s::String, iray::Vector{UInt16}, i1::Int32, i2::Int32)
  ccall((:ldimg, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Ptr{UInt16}, Int32,
          Int32), s, iray, i1, i2)
end

function legbgd(i::Int32)
  ccall((:legbgd, "dislnc_d.dll"), Cvoid, (Int32,), i)
end

function legclr()
  ccall((:legclr, "dislnc_d.dll"), Cvoid, ())
end

function legend(cbuf::Vector{UInt8}, i::Int32)
  ccall((:legend, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Int32), cbuf, i)
end

function legini(cbuf::Vector{UInt8}, i1::Int32, i2::Int32)
  ccall((:legini, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Int32, Int32), 
           cbuf, i1, i2)
end

function leglin(cbuf::Vector{UInt8}, s::String, i::Int32)
  ccall((:leglin, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Ptr{UInt8}, Int32), 
           cbuf, s, i)
end

function legopt(x1::Float64, x2::Float64, x3::Float64)
  ccall((:legopt, "dislnc_d.dll"), Cvoid, (Float64, Float64, Float64), 
          x1, x2, x3)
end

function legpat(i1::Int32, i2::Int32, i3::Int32, 
                i4::Int32, i5::Int32, i6::Int32)
  ccall((:legpat, "dislnc_d.dll"), Cvoid, (Int32, Int32, Int32, Int32, Int32, 
          Int32), i1, i2, i3, i4, i5, i6)
end

function legpos(i1::Int32, i2::Int32)
  ccall((:legpos, "dislnc_d.dll"), Cvoid, (Int32, Int32), i1, i2)
end

function legsel(nray::Vector{Int32}, n::Int32)
  ccall((:legsel, "dislnc_d.dll"), Cvoid, (Ptr{Int32}, Int32), nray, n)
end

function legtbl(i::Int32, s::String)
  ccall((:legtbl, "dislnc_d.dll"), Cvoid, (Int32, Ptr{UInt8}), i, s)
end

function legtit(s::String)
  ccall((:legtit, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function legtyp(s::String)
  ccall((:legtyp, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function legval(x::Float64, s::String)
  ccall((:legval, "dislnc_d.dll"), Cvoid, (Float64, Ptr{UInt8}), x, s)
end

function lfttit()
  ccall((:lfttit, "dislnc_d.dll"), Cvoid, ())
end

function licmod(s1::String, s2::String)
  ccall((:licmod, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Ptr{UInt8}), s1, s2)
end

function licpts(xv::Vector{Float64}, yv::Vector{Float64}, nx::Int32,
                ny::Int32, itmat::Array{Int32, 2}, wmat::Array{Float64, 2})
  imat = Array{Int32}(undef, nx, ny)
  xmat = Array{Float64}(undef, nx, ny)
  ccall((:licpts, "dislnc_d.dll"), Cvoid, (Ptr{Float64}, Ptr{Float64}, Int32, 
          Int32, Ptr{Int32}, Ptr{Float64}), xv, yv, nx, ny, imat, xmat)
  transpose!(itmat, imat)
  transpose!(wmat, xmat)
  imat = 0
  xmat = 0
end

function light(s::String)
  ccall((:light, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function linclr(nray::Vector{Int32}, n::Int32)
  ccall((:linclr, "dislnc_d.dll"), Cvoid, (Ptr{Int32}, Int32), nray, n)
end

function lincyc(i1::Int32, i2::Int32)
  ccall((:lincyc, "dislnc_d.dll"), Cvoid, (Int32, Int32), i1, i2)
end

function line(i1::Int32, i2::Int32, i3::Int32, i4::Int32)
  ccall((:line, "dislnc_d.dll"), Cvoid, (Int32, Int32, Int32, Int32), 
           i1, i2, i3, i4)
end

function linesp(x::Float64)
  ccall((:linesp, "dislnc_d.dll"), Cvoid, (Float64,), x)
end

function linfit(xray::Vector{Float64}, yray::Vector{Float64}, n::Int32,
  s1::String)
  a = Cdouble[0]
  b = Cdouble[0]
  r = Cdouble[0]
  ccall((:linfit, "dislnc_d.dll"), Cvoid, (Ptr{Float64}, Ptr{Float64}, Int32,
       Ptr{Cdouble}, Ptr{Cdouble}, Ptr{Cdouble}, Ptr{UInt8}), xray, yray, n, 
       a, b , r, s1);
  return a[1], b[1], r[1]
end

function linmod(s1::String, s2::String)
  ccall((:linmod, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Ptr{UInt8}), s1, s2)
end

function lintyp(i::Int32)
  ccall((:lintyp, "dislnc_d.dll"), Cvoid, (Int32,), i)
end

function linwid(i::Int32)
  ccall((:linwid, "dislnc_d.dll"), Cvoid, (Int32,), i)
end

function litmod(i::Int32, s::String)
  ccall((:litmod, "dislnc_d.dll"), Cvoid, (Int32, Ptr{UInt8}), i, s)
end

function litop3(i::Int32, x1::Float64, x2::Float64, x3::Float64, 
                s::String)
  ccall((:litop3, "dislnc_d.dll"), Cvoid, (Int32, Float64, Float64, Float64, 
          Ptr{UInt8}), i, x1, x2, x3, s)
end

function litopt(i::Int32, x::Float64, s::String)
  ccall((:litopt, "dislnc_d.dll"), Cvoid, (Int32, Float64, Ptr{UInt8}), 
          i, x, s)
end

function litpos(i::Int32, x1::Float64, x2::Float64, x3::Float64, 
                s::String)
  ccall((:litpos, "dislnc_d.dll"), Cvoid, (Int32, Float64, Float64, Float64, 
          Ptr{UInt8}), i, x1, x2, x3, s)
end

function lncap(s::String)
  ccall((:lncap, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function lnjoin(s::String)
  ccall((:lnjoin, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function lnmlt(x::Float64)
  ccall((:lnmlt, "dislnc_d.dll"), Cvoid, (Float64,), x)
end

function logtic(s::String)
  ccall((:logtic, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function mapbas(s::String)
  ccall((:mapbas, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function mapfil(s1::String, s2::String)
  ccall((:mapfil, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Ptr{UInt8}), s1, s2)
end

function mapimg(s::String, x1::Float64, x2::Float64, x3::Float64,
                x4::Float64, x5::Float64, x6::Float64)
  ccall((:mapimg, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Float64, Float64,
          Float64, Float64, Float64, Float64), s, x1, x2, x3, x4, x5, x6)
end

function maplab(s1::String, s2::String)
  ccall((:maplab, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Ptr{UInt8}), s1, s2)
end

function maplev(s::String)
  ccall((:maplev, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function mapmod(s::String)
  ccall((:mapmod, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function mappol(x1::Float64, x2::Float64)
  ccall((:mappol, "dislnc_d.dll"), Cvoid, (Float64, Float64), x1, x2)
end

function mapopt(s1::String, s2::String)
  ccall((:mapopt, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Ptr{UInt8}), s1, s2)
end

function mapref(x1::Float64, x2::Float64)
  ccall((:mapref, "dislnc_d.dll"), Cvoid, (Float64, Float64), x1, x2)
end

function mapsph(x::Float64)
  ccall((:mapsph, "dislnc_d.dll"), Cvoid, (Float64,), x)
end

function marker(i::Int32)
  ccall((:marker, "dislnc_d.dll"), Cvoid, (Int32,), i)
end

function matop3(x1::Float64, x2::Float64, x3::Float64, s::String)
  ccall((:matop3, "dislnc_d.dll"), Cvoid, (Float64, Float64, Float64, 
          Ptr{UInt8}), x1, x2, x3, s)
end

function matopt(x::Float64, s::String)
  ccall((:matopt, "dislnc_d.dll"), Cvoid, (Float64, Ptr{UInt8}), x, s)
end

function mdfmat(i1::Int32, i2::Int32, x::Float64)
  ccall((:mdfmat, "dislnc_d.dll"), Cvoid, (Int32, Int32, Float64), i1, i2, x)
end

function messag(s::String, i1::Int32, i2::Int32)
  ccall((:messag, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Int32, Int32), 
          s, i1, i2)
end

function metafl(s::String)
  ccall((:metafl, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function mixalf()
  ccall((:mixalf, "dislnc_d.dll"), Cvoid, ())
end

function mixleg()
  ccall((:mixleg, "dislnc_d.dll"), Cvoid, ())
end

function mpaepl(i::Int32)
  ccall((:mpaepl, "dislnc_d.dll"), Cvoid, (Int32,), i)
end

function mplang(x::Float64)
  ccall((:mplang, "dislnc_d.dll"), Cvoid, (Float64,), x)
end

function mplclr(i1::Int32, i2::Int32)
  ccall((:mplclr, "dislnc_d.dll"), Cvoid, (Int32, Int32), i1, i2)
end

function mplpos(i1::Int32, i2::Int32)
  ccall((:mplpos, "dislnc_d.dll"), Cvoid, (Int32, Int32), i1, i2)
end

function mplsiz(i::Int32)
  ccall((:mplsiz, "dislnc_d.dll"), Cvoid, (Int32,), i)
end

function mpslogo(i1::Int32, i2::Int32, i3::Int32, s::String)
  ccall((:mpslogo, "dislnc_d.dll"), Cvoid, (Int32, Int32, Int32, Ptr{UInt8}),
          i1, i2, i3, s)
end

function mrkclr(i::Int32)
  ccall((:mrkclr, "dislnc_d.dll"), Cvoid, (Int32,), i)
end

function msgbox(s::String)
  ccall((:msgbox, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function mshclr(i::Int32)
  ccall((:mshclr, "dislnc_d.dll"), Cvoid, (Int32,), i)
end

function mshcrv(i::Int32)
  ccall((:mshcrv, "dislnc_d.dll"), Cvoid, (Int32,), i)
end

function mylab(s1::String, i::Int32, s2::String)
  ccall((:mylab, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Int32, Ptr{UInt8}), 
          s1, i, s2)
end

function myline(nray::Vector{Int32}, n::Int32)
  ccall((:myline, "dislnc_d.dll"), Cvoid, (Ptr{Int32}, Int32), nray, n)
end

function mypat(i1::Int32, i2::Int32, i3::Int32, i4::Int32)
  ccall((:mypat, "dislnc_d.dll"), Cvoid, (Int32, Int32, Int32, Int32), 
           i1, i2, i3, i4)
end

function mysymb(xray::Vector{Float64}, yray::Vector{Float64}, n::Int32,
               isym::Int32, iflag::Int32)
  ccall((:mysymb, "dislnc_d.dll"), Cvoid, 
          (Ptr{Float64}, Ptr{Float64}, Int32, Int32, Int32), xray, yray, n,
          isym, iflag)
end

function myvlt(xray::Vector{Float64}, yray::Vector{Float64}, 
                zray::Vector{Float64}, n::Int32)
  ccall((:myvlt, "dislnc_d.dll"), Cvoid, (Ptr{Float64}, Ptr{Float64}, 
          Ptr{Float64}, Int32), xray, yray, zray, n)
end

function namdis(i::Int32, s::String)
  ccall((:namdis, "dislnc_d.dll"), Cvoid, (Int32, Ptr{UInt8}), i, s)
end

function name(s1::String, s2::String)
  ccall((:name, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Ptr{UInt8}), s1, s2)
end

function namjus(s1::String, s2::String)
  ccall((:namjus, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Ptr{UInt8}), s1, s2)
end

function nancrv(s::String)
  ccall((:nancrv, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function neglog(x::Float64)
  ccall((:neglog, "dislnc_d.dll"), Cvoid, (Float64,), x)
end

function newmix()
  ccall((:newmix, "dislnc_d.dll"), Cvoid, ())
end

function newpag()
  ccall((:newpag, "dislnc_d.dll"), Cvoid, ())
end

function nlmess(s::String)
  n = ccall((:nlmess, "dislnc_d.dll"), Int32, (Ptr{UInt8},), s)
  return n
end

function nlnumb(x::Float64, i::Int32)
  n = ccall((:nlnumb, "dislnc_d.dll"), Int32, (Float64, Int32), x, i)
  return n
end

function noarln()
  ccall((:noarln, "dislnc_d.dll"), Cvoid, ())
end

function nobar()
  ccall((:nobar, "dislnc_d.dll"), Cvoid, ())
end

function nobgd()
  ccall((:nobgd, "dislnc_d.dll"), Cvoid, ())
end

function nochek()
  ccall((:nochek, "dislnc_d.dll"), Cvoid, ())
end

function noclip()
  ccall((:noclip, "dislnc_d.dll"), Cvoid, ())
end

function nofill()
  ccall((:nofill, "dislnc_d.dll"), Cvoid, ())
end

function nograf()
  ccall((:nograf, "dislnc_d.dll"), Cvoid, ())
end

function nohide()
  ccall((:nohide, "dislnc_d.dll"), Cvoid, ())
end

function noline(s::String)
  ccall((:noline, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function number(x::Float64, i1::Int32, i2::Int32, i3::Int32)
  ccall((:number, "dislnc_d.dll"), Cvoid, (Float64, Int32, Int32, Int32), 
           x, i1, i2, i3)
end

function numfmt(s::String)
  ccall((:numfmt, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function numode(s1::String, s2::String, s3::String, 
                s4::String)
  ccall((:numode, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Ptr{UInt8}, Ptr{UInt8},
          Ptr{UInt8}), s1, s2, s3, s4)
end

function nwkday(i1::Int32, i2::Int32, i3::Int32)
  n = ccall((:nwkday, "dislnc_d.dll"), Int32, (Int32, Int32, Int32), 
              i1, i2, i3)
  return n
end

function nxlegn(cbuf::Vector{UInt8})
  n = ccall((:nxlegn, "dislnc_d.dll"), Int32, (Ptr{UInt8},), cbuf)
  return n
end

function nxpixl(i1::Int32, i2::Int32)
  n = ccall((:nxpixl, "dislnc_d.dll"), Int32, (Int32, Int32), i1, i2)
  return n
end

function nxposn(x::Float64)
  n = ccall((:nxposn, "dislnc_d.dll"), Int32, (Float64, ), x)
  return n
end

function nylegn(cbuf::Vector{UInt8})
  n = ccall((:nylegn, "dislnc_d.dll"), Int32, (Ptr{UInt8},), cbuf)
  return n
end

function nypixl(i1::Int32, i2::Int32)
  n = ccall((:nypixl, "dislnc_d.dll"), Int32, (Int32, Int32), i1, i2)
  return n
end

function nyposn(x::Float64)
  n = ccall((:nyposn, "dislnc_d.dll"), Int32, (Float64, ), x)
  return n
end

function nzposn(x::Float64)
  n = ccall((:nzposn, "dislnc_d.dll"), Int32, (Float64, ), x)
  return n
end

function openfl(s::String, i1::Int32, i2::Int32)
  n = ccall((:openfl, "dislnc_d.dll"), Int32, (Ptr{UInt8}, Int32, Int32),
              s, i1, i2)
  return n
end

function opnwin(i::Int32)
  ccall((:opnwin, "dislnc_d.dll"), Cvoid, (Int32,), i)
end

function origin(i1::Int32, i2::Int32)
  ccall((:origin, "dislnc_d.dll"), Cvoid, (Int32, Int32), i1, i2)
end

function page(i1::Int32, i2::Int32)
  ccall((:page, "dislnc_d.dll"), Cvoid, (Int32, Int32), i1, i2)
end

function pagera()
  ccall((:pagera, "dislnc_d.dll"), Cvoid, ())
end

function pagfll(i::Int32)
  ccall((:pagfll, "dislnc_d.dll"), Cvoid, (Int32,), i)
end

function paghdr(s1::String, s2::String, i1::Int32, i2::Int32)
  ccall((:paghdr, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Ptr{UInt8}, 
          Int32, Int32), s1, s2, i1, i2)
end

function pagmod(s::String)
  ccall((:pagmod, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function pagorg(s::String)
  ccall((:pagorg, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function pagwin(i1::Int32, i2::Int32)
  ccall((:pagwin, "dislnc_d.dll"), Cvoid, (Int32, Int32), i1, i2)
end

function patcyc(i1::Int32, i2::Int32)
  ccall((:patcyc, "dislnc_d.dll"), Cvoid, (Int32, Int32), i1, i2)
end

function pdfbuf(iray::Vector{UInt8}, nmax::Int32) 
  n = ccall((:pdfbuf, "dislnc_d.dll"), Int32, (Ptr{UInt8}, Int32),
          iray, nmax)
  return n   
end

function pdfmod(s1::String, s2::String)
  ccall((:pdfmod, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Ptr{UInt8}), s1, s2)
end

function pdfmrk(s1::String, s2::String)
  ccall((:pdfmrk, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Ptr{UInt8}), s1, s2)
end

function penwid(x::Float64)
  ccall((:penwid, "dislnc_d.dll"), Cvoid, (Float64,), x)
end

function pie(i1::Int32, i2::Int32, i3::Int32, x1::Float64, x2::Float64)
  ccall((:pie, "dislnc_d.dll"), Cvoid, (Int32, Int32, Int32, Float64, 
           Float64), i1, i2, i3, x1, x2)
end

function piebor(i::Int32)
  ccall((:piebor, "dislnc_d.dll"), Cvoid, (Int32,), i)
end

function pieclr(ic1::Vector{Int32}, ic2::Vector{Int32}, n::Int32)
  ccall((:pieclr, "dislnc_d.dll"), Cvoid, 
         (Ptr{Int32}, Ptr{Int32}, Int32), ic1, ic2, n)
end

function pieexp()
  ccall((:pieexp, "dislnc_d.dll"), Cvoid, ())
end

function piegrf(cbuf::Vector{UInt8}, i1::Int32, xray::Vector{Float64}, 
                i2::Int32)
  ccall((:piegrf, "dislnc_d.dll"), Cvoid, 
          (Ptr{UInt8}, Int32, Ptr{Float64}, Int32), cbuf, i1, xray, i2)
end

function pielab(s1::String, s2::String)
  ccall((:pielab, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Ptr{UInt8}), s1, s2)
end

function pieopt(x1::Float64, x2::Float64)
  ccall((:pieopt, "dislnc_d.dll"), Cvoid, (Float64, Float64), x1, x2)
end

function pierot(x::Float64)
  ccall((:pierot, "dislnc_d.dll"), Cvoid, (Float64,), x)
end

function pietyp(s::String)
  ccall((:pietyp, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function pieval(x::Float64, s::String)
  ccall((:pieval, "dislnc_d.dll"), Cvoid, (Float64, Ptr{UInt8}), x, s)
end

function pievec(i::Int32, s::String)
  ccall((:pievec, "dislnc_d.dll"), Cvoid, (Int32, Ptr{UInt8}), i, s)
end

function pike3d(x1::Float64, x2::Float64, x3::Float64, x4::Float64,
           x5::Float64, x6::Float64, x7::Float64, i1::Int32, i2::Int32)
  ccall((:pike3d, "dislnc_d.dll"), Cvoid, (Float64, Float64, Float64,
          Float64, Float64, Float64, Float64, Int32, Int32), 
          x1, x2, x3, x4, x5, x6, x7, i1, i2)
end

function plat3d(x1::Float64, x2::Float64, x3::Float64, x4::Float64, 
                s::String)
  ccall((:plat3d, "dislnc_d.dll"), Cvoid, (Float64, Float64, Float64, Float64, 
          Ptr{UInt8}), x1, x2, x3, x4, s)
end

function plyfin(s1::String, s2::String)
  ccall((:plyfin, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Ptr{UInt8}), s1, s2)
end

function plyini(s::String)
  ccall((:plyini, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function pngmod(s1::String, s2::String)
  ccall((:pngmod, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Ptr{UInt8}), s1, s2)
end

function point(i1::Int32, i2::Int32, i3::Int32, i4::Int32, i5::Int32)
  ccall((:point, "dislnc_d.dll"), Cvoid, (Int32, Int32, Int32, Int32, Int32), 
           i1, i2, i3, i4, i5)
end

function polcrv(s::String)
  ccall((:polcrv, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function polclp(xray::Vector{Float64}, yray::Vector{Float64}, n::Int32,
                xout::Vector{Float64},yout::Vector{Float64}, nmax::Int32,
                xv::Float64, cedge::String)
  ccall((:polclp, "dislnc_d.dll"), Cvoid, (Ptr{Float64}, Ptr{Float64}, Int32,
          Ptr{Float64}, Ptr{Float64}, Int32, Float64, Ptr{UInt8}), 
          xray, yray, n, xout, yout, nmax, xv, cedge)
end

function polmod(s1::String, s2::String)
  ccall((:potmod, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Ptr{UInt8}), s1, s2)
end

function pos2pt(x1::Float64, x2::Float64)
  xp1 = Cdouble[0]
  xp2 = Cdouble[0]
  ccall((:pos2pt, "dislnc_d.dll"), Cvoid, (Float64, Float64, 
          Ptr{Cdouble}, Ptr{Cdouble}), x1, x2, xp1, xp2)
  return xp1[1], xp2[1]
end

function pos3pt(x1::Float64, x2::Float64, x3::Float64)
  xp1 = Cdouble[0]
  xp2 = Cdouble[0]
  xp3 = Cdouble[0]
  ccall((:pos3pt, "dislnc_d.dll"), Cvoid, (Float64, Float64, Float64,
          Ptr{Cdouble}, Ptr{Cdouble}, Ptr{Cdouble}), x1, x2, x3, xp1, xp2, xp3)
  return xp1[1], xp2[1], xp3[1] 
end

function posbar(s::String)
  ccall((:posbar, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function posifl(i1::Int32, i2::Int32)
  n = ccall((:posifl, "dislnc_d.dll"), Int32, (Int32, Int32), i1, i2)
  return n
end
 
function proj3d(s::String)
  ccall((:proj3d, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function projct(s::String)
  ccall((:projct, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function psfont(s::String)
  ccall((:psfont, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function psmode(s::String)
  ccall((:psmode, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function pt2pos(x1::Float64, x2::Float64)
  xp1 = Cdouble[0]
  xp2 = Cdouble[0]
  ccall((:pt2pos, "dislnc_d.dll"), Cvoid, (Float64, Float64, 
          Ptr{Cdouble}, Ptr{Cdouble}), x1, x2, xp1, xp2)
  return xp1[1], xp2[1]
end

function pyra3d(x1::Float64, x2::Float64, x3::Float64, x4::Float64,
           x5::Float64, x6::Float64, i::Int32)
  ccall((:pyra3d, "dislnc_d.dll"), Cvoid, (Float64, Float64, Float64,
          Float64, Float64, Float64, Int32), x1, x2, x3, x4, x5, x6, i)
end

function qplbar(xray::Vector{Float64}, n::Int32)
  ccall((:qplbar, "dislnc_d.dll"), Cvoid, (Ptr{Float64}, Int32), xray, n)
end

function qplclr(zmat::Array{Float64, 2}, n::Int32, m::Int32)
  z = transpose(zmat)
  ccall((:qplclr, "dislnc_d.dll"), Cvoid, (Ptr{Float64}, Int32, Int32), z, n, m)
  z = 0  # free z
end

function qplcon(zmat::Array{Float64, 2}, n::Int32, m::Int32, nlv::Int32)
  z = transpose(zmat)
  ccall((:qplcon, "dislnc_d.dll"), Cvoid, (Ptr{Float64}, Int32, Int32, Int32), 
           z, n, m, nlv)
  z = 0  # free z
end

function qplcrv(xray::Vector{Float64}, yray::Vector{Float64}, n::Int32,
                s::String)
  ccall((:qplcrv, "dislnc_d.dll"), Cvoid, 
         (Ptr{Float64}, Ptr{Float64}, Int32, Ptr{UInt8}), xray, yray, n, s)
end

function qplot(xray::Vector{Float64}, yray::Vector{Float64}, n::Int32)
  ccall((:qplot, "dislnc_d.dll"), Cvoid, 
         (Ptr{Float64}, Ptr{Float64}, Int32), xray, yray, n)
end

function qplpie(xray::Vector{Float64}, n::Int32)
  ccall((:qplpie, "dislnc_d.dll"), Cvoid, (Ptr{Float64}, Int32), xray, n)
end

function qplsca(xray::Vector{Float64}, yray::Vector{Float64}, n::Int32)
  ccall((:qplsca, "dislnc_d.dll"), Cvoid, 
         (Ptr{Float64}, Ptr{Float64}, Int32), xray, yray, n)
end

#void  qplscl (double a, double e, double org, double stp, const char *copt);

function qplsur(zmat::Array{Float64, 2}, n::Int32, m::Int32)
  z = transpose(zmat)
  ccall((:qplsur, "dislnc_d.dll"), Cvoid, (Ptr{Float64}, Int32, Int32), 
          z, n, m)
  z = 0  # free z
end

function quad3d(x1::Float64, x2::Float64, x3::Float64, x4::Float64,
              x5::Float64, x6::Float64)
  ccall((:quad3d, "dislnc_d.dll"), Cvoid, (Float64, Float64, Float64,
          Float64, Float64, Float64), x1, x2, x3, x4, x5, x6)
end

function rbfpng(iray::Vector{UInt8}, nmax::Int32) 
  n = ccall((:rbfpng, "dislnc_d.dll"), Int32, (Ptr{UInt8}, Int32),
          iray, nmax)
  return n   
end

function rbmp(s::String)
  ccall((:rbmp, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function readfl(i1::Int32, iray::Vector{UInt8}, i2::Int32) 
  n = ccall((:readfl, "dislnc_d.dll"), Int32, (Int32, Ptr{UInt8}, Int32),
          i1, iray, i2)
  return n
end

function reawgt()
  ccall((:reawgt, "dislnc_d.dll"), Cvoid, ())
end

function recfll(i1::Int32, i2::Int32, i3::Int32, i4::Int32, i5::Int32)
  ccall((:recfll, "dislnc_d.dll"), Cvoid, (Int32, Int32, Int32, Int32, Int32), 
           i1, i2, i3, i4, i5)
end

function rectan(i1::Int32, i2::Int32, i3::Int32, i4::Int32)
  ccall((:rectan, "dislnc_d.dll"), Cvoid, (Int32, Int32, Int32, Int32), 
           i1, i2, i3, i4)
end

function rel3pt(x1::Float64, x2::Float64, x3::Float64)
  xp1 = Cdouble[0]
  xp2 = Cdouble[0]
  ccall((:rel3pt, "dislnc_d.dll"), Cvoid, (Float64, Float64, Float64,
          Ptr{Cdouble}, Ptr{Cdouble}), x1, x2, x3, xp1, xp2)
  return xp1[1], xp2[1]
end

function resatt()
  ccall((:resatt, "dislnc_d.dll"), Cvoid, ())
end

function reset(s::String)
  ccall((:reset, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function revscr()
  ccall((:revscr, "dislnc_d.dll"), Cvoid, ())
end

function rgbhsv(x1::Float64, x2::Float64, x3::Float64)
  xp1 = Cdouble[0]
  xp2 = Cdouble[0]
  xp3 = Cdouble[0]
  ccall((:rgbhsv, "dislnc_d.dll"), Cvoid, (Float64, Float64, Float64,
          Ptr{Cdouble}, Ptr{Cdouble}, Ptr{Cdouble}), x1, x2, x3, xp1, xp2, xp3)
  return xp1[1], xp2[1], xp3[1] 
end

function rgif(s::String)
  ccall((:rgif, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function rgtlab()
  ccall((:rgtlab, "dislnc_d.dll"), Cvoid, ())
end

function rimage(s::String)
  ccall((:rimage, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function rlarc(x1::Float64, x2::Float64, x3::Float64, x4::Float64,
              x5::Float64, x6::Float64, x7::Float64)
  ccall((:rlarc, "dislnc_d.dll"), Cvoid, (Float64, Float64, Float64,
          Float64, Float64, Float64, Float64), x1, x2, x3, x4, x5, x6, x7)
end

function rlarea(xray::Vector{Float64}, yray::Vector{Float64}, n::Int32)
  ccall((:rlarea, "dislnc_d.dll"), Cvoid, 
         (Ptr{Float64}, Ptr{Float64}, Int32), xray, yray, n)
end

function rlcirc(x1::Float64, x2::Float64, x3::Float64)
  ccall((:rlcirc, "dislnc_d.dll"), Cvoid, (Float64, Float64, Float64), 
          x1, x2, x3)
end

function rlconn(x1::Float64, x2::Float64)
  ccall((:rlconn, "dislnc_d.dll"), Cvoid, (Float64, Float64), x1, x2)
end

function rlell(x1::Float64, x2::Float64, x3::Float64, x4::Float64)
  ccall((:rlell, "dislnc_d.dll"), Cvoid, (Float64, Float64, Float64, Float64), 
          x1, x2, x3, x4)
end

function rline(x1::Float64, x2::Float64, x3::Float64, x4::Float64)
  ccall((:rline, "dislnc_d.dll"), Cvoid, (Float64, Float64, Float64, Float64), 
          x1, x2, x3, x4)
end

function rlmess(s::String, x1::Float64, x2::Float64)
  ccall((:rlmess, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Float64, Float64), 
          s, x1, x2)
end

function rlnumb(x1::Float64, i::Int32, x2::Float64, x3::Float64)
  ccall((:rlnumb, "dislnc_d.dll"), Cvoid, (Float64, Int32, Float64, Float64), 
          x1, i, x2, x3)
end

function rlpie(x1::Float64, x2::Float64, x3::Float64, x4::Float64,
              x5::Float64)
  ccall((:rlpie, "dislnc_d.dll"), Cvoid, (Float64, Float64, Float64,
          Float64, Float64), x1, x2, x3, x4, x5)
end

function rlpoin(x1::Float64, x2::Float64, i1::Int32, i2::Int32,
              i3::Int32)
  ccall((:rlpoin, "dislnc_d.dll"), Cvoid, (Float64, Float64, Int32,
          Int32, Int32), x1, x2, i1, i2, i3)
end

function rlrec(x1::Float64, x2::Float64, x3::Float64, x4::Float64)
  ccall((:rlrec, "dislnc_d.dll"), Cvoid, (Float64, Float64, Float64, Float64), 
          x1, x2, x3, x4)
end

function rlrnd(x1::Float64, x2::Float64, x3::Float64, x4::Float64, i::Int32)
  ccall((:rlrnd, "dislnc_d.dll"), Cvoid, (Float64, Float64, Float64,
          Float64, Int32), x1, x2, x3, x4, i)
end

function rlsec(x1::Float64, x2::Float64, x3::Float64, x4::Float64,
              x5::Float64, x6::Float64, i::Int32)
  ccall((:rlsec, "dislnc_d.dll"), Cvoid, (Float64, Float64, Float64,
          Float64, Float64, Float64, Int32), x1, x2, x3, x4, x5, x6, i)
end

function rlstrt(x1::Float64, x2::Float64)
  ccall((:rlstrt, "dislnc_d.dll"), Cvoid, (Float64, Float64), x1, x2)
end

function rlsymb(i::Int32, x1::Float64, x2::Float64)
  ccall((:rlsymb, "dislnc_d.dll"), Cvoid, (Int32, Float64, Float64), i, x1, x2)
end

function rlvec(x1::Float64, x2::Float64, x3::Float64, x4::Float64, i::Int32)
  ccall((:rlvec, "dislnc_d.dll"), Cvoid, (Float64, Float64, Float64,
          Float64, Int32), x1, x2, x3, x4, i)
end

function rlwind(x1::Float64, x2::Float64, x3::Float64, i::Int32, x4::Float64)
  ccall((:rlwind, "dislnc_d.dll"), Cvoid, (Float64, Float64, Float64,
          Int32, Float64), x1, x2, x3, i, x4)
end

function rndrec(i1::Int32, i2::Int32, i3::Int32, i4::Int32, i5::Int32)
  ccall((:rndrec, "dislnc_d.dll"), Cvoid, (Int32, Int32, Int32, Int32, Int32), 
           i1, i2, i3, i4, i5)
end

function rot3d(x1::Float64, x2::Float64, x3::Float64)
  ccall((:rot3d, "dislnc_d.dll"), Cvoid, (Float64, Float64, Float64), 
          x1, x2, x3)
end

function rpixel(i1::Int32, i2::Int32)
  iclr = Cint[0]
  ccall((:rpixel, "dislnc_d.dll"), Cvoid, (Int32, Int32, Ptr{Cint}), 
          i1, i2, iclr)
  return convert(Int32, iclr[1])
end

function rpixls(iray::Vector{UInt8}, i1::Int32, i2::Int32, i3::Int32, 
                i4::Int32)
  ccall((:rpixls, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Int32, Int32, Int32, 
          Int32), iray, i1, i2, i3, i4)
end

function rpng(s::String)
  ccall((:rpng, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function rppm(s::String)
  ccall((:rppm, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function rpxrow(iray::Vector{UInt8}, i1::Int32, i2::Int32, i3::Int32) 
  ccall((:rpxrow, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Int32, Int32, Int32),
          iray, i1, i2, i3)
end

function rtiff(s::String)
  ccall((:rtiff, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function rvynam()
  ccall((:rvynam, "dislnc_d.dll"), Cvoid, ())
end

function scale(s1::String, s2::String)
  ccall((:scale, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Ptr{UInt8}), s1, s2)
end

function sclfac(x::Float64)
  ccall((:sclfac, "dislnc_d.dll"), Cvoid, (Float64,), x)
end

function sclmod(s::String)
  ccall((:sclmod, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function scrmod(s::String)
  ccall((:scrmod, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function sector(i1::Int32, i2::Int32, i3::Int32, i4::Int32, x1::Float64,
                x2::Float64, i5::Int32)
  ccall((:sector, "dislnc_d.dll"), Cvoid, (Int32, Int32, Int32, Int32, Float64,
          Float64, Int32), i1, i2, i3, i4, x1, x2, i5)
end

function selwin(i::Int32)
  ccall((:selwin, "dislnc_d.dll"), Cvoid, (Int32,), i)
end

function sendbf()
  ccall((:sendbf, "dislnc_d.dll"), Cvoid, ())
end

function sendmb()
  ccall((:sendmb, "dislnc_d.dll"), Cvoid, ())
end

function sendok()
  ccall((:sendok, "dislnc_d.dll"), Cvoid, ())
end

function serif()
  ccall((:serif, "dislnc_d.dll"), Cvoid, ())
end

function setbas(x::Float64)
  ccall((:setbas, "dislnc_d.dll"), Cvoid, (Float64,), x)
end

function setcbk(func::Function, s::String)
  func_c = @cfunction $func Cvoid (Ptr{Cdouble}, Ptr{Cdouble}) 
  ccall((:setcbk, "dislnc_d.dll"), Cvoid, (Ptr{Cvoid}, Ptr{UInt8}), 
          func_c, s)
end

function setclr(i::Int32)
  ccall((:setclr, "dislnc_d.dll"), Cvoid, (Int32,), i)
end

function setscr(s::String)
  ccall((:setscr, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function setexp(x::Float64)
  ccall((:setexp, "dislnc_d.dll"), Cvoid, (Float64,), x)
end

function setfce(s::String)
  ccall((:setfce, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function setfil(s::String)
  ccall((:setfil, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function setgrf(s1::String, s2::String, s3::String, 
                s4::String)
  ccall((:setgrf, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Ptr{UInt8}, Ptr{UInt8},
          Ptr{UInt8}), s1, s2, s3, s4)
end

function setind(i::Int32, x1::Float64, x2::Float64, x3::Float64)
  ccall((:setind, "dislnc_d.dll"), Cvoid, (Int32, Float64, Float64, Float64), 
           i, x1, x2, x3)
end

function setmix(s1::String, s2::String)
  ccall((:setmix, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Ptr{UInt8}), s1, s2)
end

function setpag(s::String)
  ccall((:setpag, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function setres(i1::Int32, i2::Int32)
  ccall((:setres, "dislnc_d.dll"), Cvoid, (Int32, Int32), i1, i2)
end

function setres3d(x1::Float64, x2::Float64, x3::Float64)
  ccall((:setres3d, "dislnc_d.dll"), Cvoid, (Float64, Float64, Float64), 
              x1, x2, x3)
end

function setrgb(x1::Float64, x2::Float64, x3::Float64)
  ccall((:setrgb, "dislnc_d.dll"), Cvoid, (Float64, Float64, Float64), 
              x1, x2, x3)
end

function setscl(xray::Vector{Float64}, n::Int32, s::String)
  ccall((:setscl, "dislnc_d.dll"), Cvoid, 
          (Ptr{Float64}, Int32, Ptr{UInt8}), xray, n, s)
end

function setvlt(s::String)
  ccall((:setvlt, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function setxid(i::Int32, s::String)
  ccall((:setxid, "dislnc_d.dll"), Cvoid, (Int32, Ptr{UInt8}), i, s)
end

function shdafr(i1ray::Vector{Int32}, i2ray::Vector{Int32}, 
                i3ray::Vector{Int32}, n::Int32)
  ccall((:shdafr, "dislnc_d.dll"), Cvoid, 
         (Ptr{Int32}, Ptr{Int32}, Ptr{Int32}, Int32), i1ray, i2ray, i3ray, n)
end

function shdasi(i1ray::Vector{Int32}, i2ray::Vector{Int32}, 
                i3ray::Vector{Int32}, n::Int32)
  ccall((:shdasi, "dislnc_d.dll"), Cvoid, 
         (Ptr{Int32}, Ptr{Int32}, Ptr{Int32}, Int32), i1ray, i2ray, i3ray, n)
end

function shdaus(i1ray::Vector{Int32}, i2ray::Vector{Int32}, 
                i3ray::Vector{Int32}, n::Int32)
  ccall((:shdaus, "dislnc_d.dll"), Cvoid, 
         (Ptr{Int32}, Ptr{Int32}, Ptr{Int32}, Int32), i1ray, i2ray, i3ray, n)
end

function shdcha()
  ccall((:shdcha, "dislnc_d.dll"), Cvoid, ())
end

function shdcrv(x1ray::Vector{Float64}, y1ray::Vector{Float64}, n1::Int32,
                x2ray::Vector{Float64}, y2ray::Vector{Float64}, n2::Int32)
  ccall((:shdcrv, "dislnc_d.dll"), Cvoid, (Ptr{Float64}, Ptr{Float64}, 
          Int32, Ptr{Float64}, Ptr{Float64}, Int32), 
          x1ray, y1ray, n1, x2ray, y2ray, n2)
end

function shdeur(i1ray::Vector{Int32}, i2ray::Vector{Int32}, 
                i3ray::Vector{Int32}, n::Int32)
  ccall((:shdeur, "dislnc_d.dll"), Cvoid, 
         (Ptr{Int32}, Ptr{Int32}, Ptr{Int32}, Int32), i1ray, i2ray, i3ray, n)
end

function shdfac(x::Float64)
  ccall((:shdfac, "dislnc_d.dll"), Cvoid, (Float64,), x)
end

function shdmap(s::String)
  ccall((:shdmap, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function shdmod(s1::String, s2::String)
  ccall((:shdmod, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Ptr{UInt8}), s1, s2)
end

function shdnor(i1ray::Vector{Int32}, i2ray::Vector{Int32}, 
                i3ray::Vector{Int32}, n::Int32)
  ccall((:shdnor, "dislnc_d.dll"), Cvoid, 
         (Ptr{Int32}, Ptr{Int32}, Ptr{Int32}, Int32), i1ray, i2ray, i3ray, n)
end

function shdpat(i::Int32)
  ccall((:shdpat, "dislnc_d.dll"), Cvoid, (Clong,), i)
end

function shdsou(i1ray::Vector{Int32}, i2ray::Vector{Int32}, 
                i3ray::Vector{Int32}, n::Int32)
  ccall((:shdsou, "dislnc_d.dll"), Cvoid, 
         (Ptr{Int32}, Ptr{Int32}, Ptr{Int32}, Int32), i1ray, i2ray, i3ray, n)
end

function shdusa(i1ray::Vector{Int32}, i2ray::Vector{Int32}, 
                i3ray::Vector{Int32}, n::Int32)
  ccall((:shdusa, "dislnc_d.dll"), Cvoid, 
         (Ptr{Int32}, Ptr{Int32}, Ptr{Int32}, Int32), i1ray, i2ray, i3ray, n)
end

function shield(s1::String, s2::String)
  ccall((:shield, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Ptr{UInt8}), s1, s2)
end

function shlcir(i1::Int32, i2::Int32, i3::Int32)
  ccall((:shlcir, "dislnc_d.dll"), Cvoid, (Int32, Int32, Int32), i1, i2, i3)
end

function shldel(i::Int32)
  ccall((:shldel, "dislnc_d.dll"), Cvoid, (Int32,), i)
end

function shlell(i1::Int32, i2::Int32, i3::Int32, i4::Int32, x::Float64)
  ccall((:shlell, "dislnc_d.dll"), Cvoid, (Int32, Int32, Int32, Int32, 
          Float64), i1, i2, i3, i4, x)
end

function shlind()
  n = ccall((:shlind, "dislnc_d.dll"), Int32, ())
  return n
end

function shlpie(i1::Int32, i2::Int32, i3::Int32, x1::Float64, x2::Float64)
  ccall((:shlpie, "dislnc_d.dll"), Cvoid, (Int32, Int32, Int32, Float64, 
          Float64), i1, i2, i3, x1, x2)
end

function shlpol(ixray::Vector{Int32}, iyray::Vector{Int32}, n::Int32)
  ccall((:shlpol, "dislnc_d.dll"), Cvoid, 
         (Ptr{Int32}, Ptr{Int32}, Int32), ixray, iyray, n)
end

function shlrct(i1::Int32, i2::Int32, i3::Int32, i4::Int32, x::Float64)
  ccall((:shlrct, "dislnc_d.dll"), Cvoid, (Int32, Int32, Int32, Int32, 
          Float64), i1, i2, i3, i4, x)
end

function shlrec(i1::Int32, i2::Int32, i3::Int32, i4::Int32)
  ccall((:shlrec, "dislnc_d.dll"), Cvoid, (Int32, Int32, Int32, Int32), 
           i1, i2, i3, i4)
end

function shlres(i::Int32)
  ccall((:shlres, "dislnc_d.dll"), Cvoid, (Int32,), i)
end

function shlsur()
  ccall((:shlsur, "dislnc_d.dll"), Cvoid, ())
end

function shlvis(i::Int32, s::String)
  ccall((:shlvis, "dislnc_d.dll"), Cvoid, (Int32, Ptr{UInt8}), i, s)
end

function simplx()
  ccall((:simplx, "dislnc_d.dll"), Cvoid, ())
end

function skipfl(i1::Int32, i2::Int32)
  n = ccall((:skipfl, "dislnc_d.dll"), Int32, (Int32, Int32), i1, i2)
  return n
end

function smxalf(s1::String, s2::String, s3::String, i::Int32) 
  ccall((:smxalf, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Ptr{UInt8}, Ptr{UInt8},
          Int32), s1, s2, s3, i)
end

function solid()
  ccall((:solid, "dislnc_d.dll"), Cvoid, ())
end

function sortr1(xray::Vector{Float64}, n::Int32, s::String)
  ccall((:sortr1, "dislnc_d.dll"), Cvoid, (Ptr{Float64},  
          Int32, Ptr{UInt8}), xray, n, s)
end

function sortr2(xray::Vector{Float64}, yray::Vector{Float64}, n::Int32,
                s::String)
  ccall((:sortr2, "dislnc_d.dll"), Cvoid, (Ptr{Float64}, Ptr{Float64}, 
          Int32, Ptr{UInt8}), xray, yray, n, s)
end

function spcbar(i::Int32)
  ccall((:spcbar, "dislnc_d.dll"), Cvoid, (Int32,), i)
end

function sphe3d(x1::Float64, x2::Float64, x3::Float64, x4::Float64,
                i1::Int32, i2::Int32)
  ccall((:sphe3d, "dislnc_d.dll"), Cvoid, (Float64, Float64, Float64,
          Float64, Int32, Int32), x1, x2, x3, x4, i1, i2)
end

function spline(xray::Vector{Float64}, yray::Vector{Float64}, n::Int32,
                xsray::Vector{Float64}, ysray::Vector{Float64})
  nspl = Cint[0]
  ccall((:spline, "dislnc_d.dll"), Cvoid, 
          (Ptr{Float64}, Ptr{Float64}, Int32, Ptr{Float64}, Ptr{Float64},
           Ptr{Cint}), xray, yray, n, xsray, ysray, nspl)
  return convert(Int32, nspl[1])
end

function splmod(i1::Int32, i2::Int32)
  ccall((:splmod, "dislnc_d.dll"), Cvoid, (Int32, Int32), i1, i2)
end

function stmmod(s1::String, s2::String)
  ccall((:stmmod, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Ptr{UInt8}), s1, s2)
end

function stmopt(i::Int32, s::String)
  ccall((:stmopt, "dislnc_d.dll"), Cvoid, (Int32, Ptr{UInt8}), i, s)
end

function stmpts(xmat::Array{Float64, 2}, ymat::Array{Float64, 2},
                nx::Int32, ny::Int32, xp::Vector{Float64}, yp::Vector{Float64},
                x0::Float64, y0::Float64, xray::Vector{Float64}, 
                yray::Vector{Float64}, nmax::Int32)
  x = transpose(xmat)
  y = transpose(ymat)
  n = Cint[0]
  ccall((:stmpts, "dislnc_d.dll"), Int32, (Ptr{Float64}, Ptr{Float64}, 
          Int32, Int32, Ptr{Float64}, Ptr{Float64}, Float64, Float64,
          Ptr{Float64}, Ptr{Float64}, Int32, Ptr{Cint}), 
          x, y, nx, ny, xp, yp, x0, y0, xray, yray, nmax, n)
  x = 0
  y = 0 
  return convert(Int32, n[1])
end

function stmpts3d(xv::Array{Float64, 3}, yv::Array{Float64, 3},
                zv::Array{Float64, 3}, nx::Int32, ny::Int32, nz::Int32,
                xp::Vector{Float64}, yp::Vector{Float64}, zp::Vector{Float64},
                x0::Float64, y0::Float64, z0::Float64, xray::Vector{Float64}, 
                yray::Vector{Float64}, zray::Vector{Float64}, nmax::Int32)
  x = transpose(xmat)
  y = transpose(ymat)
  z = transpose(ymat)
  n = Cint[0]
  ccall((:stmpts3d, "dislnc_d.dll"), Int32, (Ptr{Float64}, Ptr{Float64}, 
          Ptr{Float64}, Int32, Int32, Int32, Ptr{Float64}, Ptr{Float64}, 
          Ptr{Float64}, Float64, Float64, Float64, Ptr{Float64}, Ptr{Float64}, 
          Ptr{Float64}, Int32, Ptr{Cint}), 
          x, y, z, nx, ny, nz, xp, yp, zp, x0, y0, z0, xray, yray, zray, nmax,
          n)
  x = 0
  y = 0 
  z = 0
  return convert(Int32, n[1])
end

function stmtri(xv::Vector{Float64}, yv::Vector{Float64},
                xp::Vector{Float64}, yp::Vector{Float64}, n::Int32,
                i1ray::Vector{Int32}, i2ray::Vector{Int32}, 
                i3ray::Vector{Int32}, ntri::Int32, 
                xs::Vector{Float64}, ys::Vector{Float64}, nray::Int32)
  ccall((:stmtri, "dislnc_d.dll"), Cvoid, 
          (Ptr{Float64}, Ptr{Float64}, Ptr{Float64}, Ptr{Float64}, Int32, 
          Ptr{Int32}, Ptr{Int32}, Ptr{Int32}, Int32, Ptr{Float64},
          Ptr{Float64}, Int32), xv, yv, xp, yp, n, i1ray, i2ray, i3ray,
          ntri, xs, ys, nray)
end

function stmval(x::Float64, s::String)
  ccall((:stmval, "dislnc_d.dll"), Cvoid, (Float64, Ptr{UInt8}), x, s)
end

function stream(xmat::Array{Float64, 2}, ymat::Array{Float64, 2},
                nx::Int32, ny::Int32, xp::Vector{Float64}, yp::Vector{Float64},
                xsray::Vector{Float64}, ysray::Vector{Float64}, n::Int32)
  x = transpose(xmat)
  y = transpose(ymat)
  ccall((:stream, "dislnc_d.dll"), Cvoid, (Ptr{Float64}, Ptr{Float64}, 
          Int32, Int32, Ptr{Float64}, Ptr{Float64}, 
          Ptr{Float64}, Ptr{Float64}, Int32), 
          x, y, nx, ny, xp, yp, xsray, ysray, n)
  x = 0
  y = 0 
end

function stream3d(xv::Array{Float64, 3}, yv::Array{Float64, 3},
                zv::Array{Float64, 3}, nx::Int32, ny::Int32, nz::Int32,
                xp::Vector{Float64}, yp::Vector{Float64}, zp::Vector{Float64},
                xsray::Vector{Float64}, ysray::Vector{Float64}, 
                zsray::Vector{Float64}, n::Int32)
  x = transpose(xmat)
  y = transpose(ymat)
  z = transpose(ymat)
  ccall((:stream3d, "dislnc_d.dll"), Cvoid, (Ptr{Float64}, Ptr{Float64}, 
          Ptr{Float64}, Int32, Int32, Int32, Ptr{Float64}, Ptr{Float64}, 
          Ptr{Float64}, Ptr{Float64}, Ptr{Float64}, Ptr{Float64}, Int32), 
          x, y, z, nx, ny, nz, xp, yp, zp, xsray, ysray, zsray, n)
  x = 0
  y = 0 
  z = 0
end

function strt3d(x1::Float64, x2::Float64, x3::Float64)
  ccall((:strt3d, "dislnc_d.dll"), Cvoid, (Float64, Float64, Float64), 
          x1, x2, x3)
end

function strtpt(x1::Float64, x2::Float64)
  ccall((:strtpt, "dislnc_d.dll"), Cvoid, (Float64, Float64), x1, x2)
end

function surclr(i1::Int32, i2::Int32)
  ccall((:surclr, "dislnc_d.dll"), Cvoid, (Int32, Int32), i1, i2)
end

function surfce(xray::Vector{Float64}, n::Int32, yray::Vector{Float64},
                m::Int32, zmat::Array{Float64, 2})
  z = transpose(zmat)
  ccall((:surfce, "dislnc_d.dll"), Cvoid, (Ptr{Float64}, Int32, Ptr{Float64}, 
          Int32, Ptr{Float64}), xray, n, yray, m, z)
  z = 0  # free z
end

function surfcp(zfun::Function, x1::Float64, x2::Float64, x3::Float64,
                x4::Float64, x5::Float64, x6::Float64)
  zfun_c = @cfunction $zfun Cdouble (Cdouble, Cdouble, Cint) 
  ccall((:surfcp, "dislnc_d.dll"), Cvoid, 
          (Ptr{Cvoid}, Float64, Float64, Float64, Float64, Float64, Float64), 
          zfun_c, x1, x2, x3, x4, x5, x6)
end

function surfun(zfun::Function, i1::Int32, x1::Float64, i2::Int32, 
                x2::Float64)
  zfun_c = @cfunction $zfun Cdouble (Cdouble, Cdouble) 
  ccall((:surfun, "dislnc_d.dll"), Cvoid, 
          (Ptr{Cvoid}, Int32, Float64, Int32, Float64), 
          zfun_c, i1, x1, i2, x2)
end

function suriso(xray::Vector{Float64}, nx::Int32, yray::Vector{Float64},
                ny::Int32, zray::Vector{Float64}, nz::Int32, 
                wmat::Array{Float64, 3}, wlev::Float64)
  w = transpose(wmat)
  ccall((:suriso, "dislnc_d.dll"), Cvoid, (Ptr{Float64}, Int32, Ptr{Float64}, 
          Int32, Ptr{Float64}, Int32, Ptr{Float64}, Float64), xray, nx, yray, 
          ny, zray, nz, w, wlev)
  w = 0
end

function surmat(zmat::Array{Float64, 2}, n::Int32, m::Int32, ixpts::Int32, 
                iypts::Int32)
  z = transpose(zmat)
  ccall((:surmat, "dislnc_d.dll"), Cvoid, (Ptr{Float64}, Int32, Int32, Int32, 
           Int32), z, n, m, ixpts, iypts)
  z = 0  # free z
end

function surmsh(s::String)
  ccall((:surmsh, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function suropt(s::String)
  ccall((:suropt, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function surshc(xray::Vector{Float64}, n::Int32, yray::Vector{Float64},
                m::Int32, zmat::Array{Float64, 2}, wmat::Array{Float64, 2})
  z = transpose(zmat)
  w = transpose(wmat)
  ccall((:surshc, "dislnc_d.dll"), Cvoid, (Ptr{Float64}, Int32, Ptr{Float64}, 
          Int32, Ptr{Float64}, Ptr{Float64}), xray, n, yray, m, z, w)
  z = 0 
  w = 0
end

function surshd(xray::Vector{Float64}, n::Int32, yray::Vector{Float64},
                m::Int32, zmat::Array{Float64, 2})
  z = transpose(zmat)
  ccall((:surshd, "dislnc_d.dll"), Cvoid, (Ptr{Float64}, Int32, Ptr{Float64}, 
          Int32, Ptr{Float64}), xray, n, yray, m, z)
  z = 0  # free z
end

function sursze(x1::Float64, x2::Float64, x3::Float64, x4::Float64)
  ccall((:sursze, "dislnc_d.dll"), Cvoid, (Float64, Float64, Float64, Float64),
          x1, x2, x3, x4)
end

function surtri(xray::Vector{Float64}, yray::Vector{Float64}, 
                zray::Vector{Float64}, n::Int32, i1ray::Vector{Int32},
                i2ray::Vector{Int32}, i3ray::Vector{Int32}, ntri::Int32)
  ccall((:surtri, "dislnc_d.dll"), Cvoid, (Ptr{Float64}, Ptr{Float64}, 
          Ptr{Float64}, Int32, Ptr{Int32}, Ptr{Int32}, Ptr{Int32}, Int32), 
          xray, yray, zray, n, i1ray, i2ray, i3ray, ntri)
end

function survis(s::String)
  ccall((:survis, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function swapi2(iray::Vector{Int16}, n::Int32)
  ccall((:swapi2, "dislnc_d.dll"), Cvoid, 
         (Ptr{Int16}, Int32), iray, n)
end

function swapi4(iray::Vector{Int32}, n::Int32)
  ccall((:swapi4, "dislnc_d.dll"), Cvoid, 
         (Ptr{Int32}, Int32), iray, n)
end

function swgatt(i::Int32, s1::String, s2::String)
  ccall((:swgatt, "dislnc_d.dll"), Cvoid, (Int32, Ptr{UInt8}, Ptr{UInt8}), 
           i, s1, s2)
end

function swgbgd(i::Int32, x1::Float64, x2::Float64, x3::Float64)
  ccall((:swgbgd, "dislnc_d.dll"), Cvoid, (Int32, Float64, Float64, Float64), 
           i, x1, x2, x3)
end

function swgbox(i1::Int32, i2::Int32)
  ccall((:swgbox, "dislnc_d.dll"), Cvoid, (Int32, Int32), i1, i2)
end

function swgbut(i1::Int32, i2::Int32)
  ccall((:swgbut, "dislnc_d.dll"), Cvoid, (Int32, Int32), i1, i2)
end

function swgcb2(i::Int32, func::Function)
  func_c = @cfunction $func Cvoid (Cint, Cint, Cint) 
  ccall((:swgcb2, "dislnc_d.dll"), Cvoid, (Int32, Ptr{Cvoid}), i, func_c)
end

function swgcb3(i::Int32, func::Function)
  func_c = @cfunction $func Cvoid (Cint, Cint) 
  ccall((:swgcb3, "dislnc_d.dll"), Cvoid, (Int32, Ptr{Cvoid}), i, func_c)
end

function swgcbk(i::Int32, func::Function)
  func_c = @cfunction $func Cvoid (Cint, ) 
  ccall((:swgcbk, "dislnc_d.dll"), Cvoid, (Int32, Ptr{Cvoid}), i, func_c)
end

function swgclr(x1::Float64, x2::Float64, x3::Float64, s::String)
  ccall((:swgclr, "dislnc_d.dll"), Cvoid, (Float64, Float64, Float64, 
          Ptr{UInt8}), x1, x2, x3, s)
end

function swgdrw(x::Float64)
  ccall((:swgdrw, "dislnc_d.dll"), Cvoid, (Float64,), x)
end

function swgfgd(i::Int32, x1::Float64, x2::Float64, x3::Float64)
  ccall((:swgfgd, "dislnc_d.dll"), Cvoid, (Int32, Float64, Float64, Float64), 
           i, x1, x2, x3)
end

function swgfil(i::Int32, s::String)
  ccall((:swgfil, "dislnc_d.dll"), Cvoid, (Int32, Ptr{UInt8}), i, s)
end

function swgflt(i1::Int32, x::Float64, i2::Int32)
  ccall((:swgflt, "dislnc_d.dll"), Cvoid, (Int32, Float64, Int32), i1, x, i2)
end

function swgfnt(s::String, i::Int32)
  ccall((:swgfnt, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Int32), s, i)
end

function swgfoc(i::Int32)
  ccall((:swgfoc, "dislnc_d.dll"), Cvoid, (Int32,), i)
end

function swghlp(s::String)
  ccall((:swghlp, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function swgint(i1::Int32, i2::Int32)
  ccall((:swgint, "dislnc_d.dll"), Cvoid, (Int32, Int32), i1, i2)
end

function swgiop(i::Int32, s::String)
  ccall((:swgiop, "dislnc_d.dll"), Cvoid, (Int32, Ptr{UInt8}), i, s)
end

function swgjus(s1::String, s2::String)
  ccall((:swgjus, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Ptr{UInt8}), s1, s2)
end

function swglis(i1::Int32, i2::Int32)
  ccall((:swglis, "dislnc_d.dll"), Cvoid, (Int32, Int32), i1, i2)
end

function swgmix(s1::String, s2::String)
  ccall((:swgmix, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Ptr{UInt8}), s1, s2)
end

function swgmrg(i::Int32, s::String)
  ccall((:swgmrg, "dislnc_d.dll"), Cvoid, (Int32, Ptr{UInt8}), i, s)
end

function swgoff(i1::Int32, i2::Int32)
  ccall((:swgoff, "dislnc_d.dll"), Cvoid, (Int32, Int32), i1, i2)
end

function swgopt(s1::String, s2::String)
  ccall((:swgopt, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Ptr{UInt8}), s1, s2)
end

function swgpop(s::String)
  ccall((:swgpop, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function swgpos(i1::Int32, i2::Int32)
  ccall((:swgpos, "dislnc_d.dll"), Cvoid, (Int32, Int32), i1, i2)
end

function swgray(xray::Vector{Float64}, n::Int32, s::String)
  ccall((:swgray, "dislnc_d.dll"), Cvoid, 
          (Ptr{Float64}, Int32, Ptr{UInt8}), xray, n, s)
end

function swgscl(i::Int32, x::Float64)
  ccall((:swgscl, "dislnc_d.dll"), Cvoid, (Int32, Float64), i, x)
end

function swgsiz(i1::Int32, i2::Int32)
  ccall((:swgsiz, "dislnc_d.dll"), Cvoid, (Int32, Int32), i1, i2)
end

function swgspc(x1::Float64, x2::Float64)
  ccall((:swgspc, "dislnc_d.dll"), Cvoid, (Float64, Float64), x1, x2)
end

function swgstp(x::Float64)
  ccall((:swgstp, "dislnc_d.dll"), Cvoid, (Float64,), x)
end

function swgtbf(i1::Int32, x::Float64, i2::Int32, i3::Int32, s::String)
  ccall((:swgtbf, "dislnc_d.dll"), Cvoid, (Int32, Float64, Int32, Int32,
          Ptr{UInt8}), i1, x, i2, i3, s)
end

function swgtbi(i1::Int32, i2::Int32, i3::Int32, i4::Int32, s::String)
  ccall((:swgtbi, "dislnc_d.dll"), Cvoid, (Int32, Int32, Int32, Int32,
          Ptr{UInt8}), i1, i2, i3, i4, s)
end

function swgtbl(i1::Int32, xray::Vector{Float64}, n::Int32, i2::Int32,
                i3::Int32, s::String)
  ccall((:swgtbl, "dislnc_d.dll"), Cvoid, (Int32, Ptr{Float64}, Int32, 
          Int32, Int32, Ptr{UInt8}), i1, xray, n, i2, i3, s)
end

function swgtbs(i1::Int32, s1::String, i2::Int32, i3::Int32, 
                s2::String)
  ccall((:swgtbs, "dislnc_d.dll"), Cvoid, (Int32, Ptr{UInt8}, Int32, Int32,
          Ptr{UInt8}), i1, s1, i2, i3, s2)
end

function swgtit(s::String)
  ccall((:swgtit, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function swgtxt(i::Int32, s::String)
  ccall((:swgtxt, "dislnc_d.dll"), Cvoid, (Int32, Ptr{UInt8}), i, s)
end

function swgtyp(s1::String, s2::String)
  ccall((:swgtyp, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Ptr{UInt8}), s1, s2)
end

function swgval(i::Int32, x::Float64)
  ccall((:swgval, "dislnc_d.dll"), Cvoid, (Int32, Float64), i, x)
end

function swgwin(i1::Int32, i2::Int32, i3::Int32, i4::Int32)
  ccall((:swgwin, "dislnc_d.dll"), Cvoid, (Int32, Int32, Int32, Int32), 
           i1, i2, i3, i4)
end

function swgwth(i::Int32)
  ccall((:swgwth, "dislnc_d.dll"), Cvoid, (Int32,), i)
end

function sym3d(i::Int32, x1::Float64, x2::Float64, x3::Float64)
  ccall((:sym3d, "dislnc_d.dll"), Cvoid, (Int32, Float64, Float64, Float64),
          i, x1, x2, x3)
end

function symbol(i1::Int32, i2::Int32, i3::Int32)
  ccall((:symbol, "dislnc_d.dll"), Cvoid, (Int32, Int32, Int32), i1, i2, i3)
end

function symfil(s1::String, s2::String)
  ccall((:symfil, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Ptr{UInt8}), s1, s2)
end

function symrot(x::Float64)
  ccall((:symrot, "dislnc_d.dll"), Cvoid, (Float64,), x)
end

function tellfl(i::Int32)
  n = ccall((:tellfl, "dislnc_d.dll"), Int32, (Int32, ), i)
  return n
end

function texmod(s::String)
  ccall((:texmod, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function texopt(s1::String, s2::String)
  ccall((:texopt, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Ptr{UInt8}), s1, s2)
end

function texval(x::Float64, s::String)
  ccall((:texval, "dislnc_d.dll"), Cvoid, (Float64, Ptr{UInt8}), x, s)
end

function thkc3d(x::Float64)
  ccall((:thkc3d, "dislnc_d.dll"), Cvoid, (Float64,), x)
end

function thkcrv(i::Int32)
  ccall((:thkcrv, "dislnc_d.dll"), Cvoid, (Int32,), i)
end

function thrfin()
  ccall((:thrfin, "dislnc_d.dll"), Cvoid, ())
end

function thrini(i::Int32)
  ccall((:thrini, "dislnc_d.dll"), Cvoid, (Int32,), i)
end

function ticks(i::Int32, s::String)
  ccall((:ticks, "dislnc_d.dll"), Cvoid, (Int32, Ptr{UInt8}), i, s)
end

function ticlen(i1::Int32, i2::Int32)
  ccall((:ticlen, "dislnc_d.dll"), Cvoid, (Int32, Int32), i1, i2)
end

function ticmod(s1::String, s2::String)
  ccall((:ticmod, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Ptr{UInt8}), s1, s2)
end

function ticpos(s1::String, s2::String)
  ccall((:ticpos, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Ptr{UInt8}), s1, s2)
end

function tifmod(i::Int32, s1::String, s2::String)
  ccall((:tifmod, "dislnc_d.dll"), Cvoid, (Int32, Ptr{UInt8}, Ptr{UInt8}), 
          i, s1, s2)
end

function tiforg(i1::Int32, i2::Int32)
  ccall((:tiforg, "dislnc_d.dll"), Cvoid, (Int32, Int32), i1, i2)
end

function tifwin(i1::Int32, i2::Int32, i3::Int32, i4::Int32)
  ccall((:tifwin, "dislnc_d.dll"), Cvoid, (Int32, Int32, Int32, Int32), 
           i1, i2, i3, i4)
end

function timopt()
  ccall((:timopt, "dislnc_d.dll"), Cvoid, ())
end

function titjus(s::String)
  ccall((:titjus, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function title()
  ccall((:title, "dislnc_d.dll"), Cvoid, ())
end

function titlin(s::String, i::Int32)
  ccall((:titlin, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Int32,), s, i)
end

function titpos(s::String)
  ccall((:titpos, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function torus3d(x1::Float64, x2::Float64, x3::Float64, x4::Float64,
                 x5::Float64, x6::Float64, x7::Float64, x8::Float64, 
                 i1::Int32, i2::Int32)
  ccall((:torus3d, "dislnc_d.dll"), Cvoid, (Float64, Float64, Float64,
          Float64, Float64, Float64, Float64, Float64, Int32, Int32), 
          x1, x2, x3, x4, x5, x6, x7, x8, i1, i2)
end

function tprfin()
  ccall((:tprfin, "dislnc_d.dll"), Cvoid, ())
end

function tprini()
  ccall((:tprini, "dislnc_d.dll"), Cvoid, ())
end

function tprmod(s1::String, s2::String)
  ccall((:tprmod, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Ptr{UInt8}), s1, s2)
end

function tprval(x::Float64)
  ccall((:tprval, "dislnc_d.dll"), Cvoid, (Float64,), x)
end

function tr3axs(x1::Float64, x2::Float64, x3::Float64, x4::Float64)
  ccall((:tr3axs, "dislnc_d.dll"), Cvoid, (Float64, Float64, Float64, Float64),
          x1, x2, x3, x4)
end

function tr3res()
  ccall((:tr3res, "dislnc_d.dll"), Cvoid, ())
end

function tr3rot(x1::Float64, x2::Float64, x3::Float64)
  ccall((:tr3rot, "dislnc_d.dll"), Cvoid, (Float64, Float64, Float64), 
          x1, x2, x3)
end

function tr3scl(x1::Float64, x2::Float64, x3::Float64)
  ccall((:tr3scl, "dislnc_d.dll"), Cvoid, (Float64, Float64, Float64), 
          x1, x2, x3)
end

function tr3shf(x1::Float64, x2::Float64, x3::Float64)
  ccall((:tr3shf, "dislnc_d.dll"), Cvoid, (Float64, Float64, Float64), 
          x1, x2, x3)
end

function trfco1(xray::Vector{Float64}, n::Int32, s1::String,
                s2::String)
  ccall((:trfco1, "dislnc_d.dll"), Cvoid, 
          (Ptr{Float64}, Int32, Ptr{UInt8}, Ptr{UInt8}), xray, n, s1, s2)
end

function trfco2(xray::Vector{Float64}, yray::Vector{Float64}, n::Int32, 
                s1::String, s2::String)
  ccall((:trfco2, "dislnc_d.dll"), Cvoid, (Ptr{Float64}, 
          Ptr{Float64}, Int32, Ptr{UInt8}, Ptr{UInt8}), xray, yray, n, s1, s2)
end

function trfco3(xray::Vector{Float64}, yray::Vector{Float64}, 
                zray::Vector{Float64}, n::Int32, 
                s1::String, s2::String)
  ccall((:trfco3, "dislnc_d.dll"), Cvoid, (Ptr{Float64}, Ptr{Float64}, 
          Ptr{Float64}, Int32, Ptr{UInt8}, Ptr{UInt8}), 
          xray, yray, zray, n, s1, s2)
end

function trfdat(i::Int32)
  i1 = Cint[0]
  i2 = Cint[0]
  i3 = Cint[0]
  ccall((:trfdat, "dislnc_d.dll"), Cvoid, (Int32, Ptr{Cint}, Ptr{Cint}, 
          Ptr{Cint}), i, i1, i2, i3)
  return convert(Int32, i1[1]), convert(Int32, i2[1]), convert(Int32, i3[1])
end
 
function trfmat(zmat::Array{Float64, 2}, n::Int32, m::Int32,
                zmat2::Array{Float64, 2}, n2::Int32, m2::Int32)
  z = transpose(zmat)
  z2 = Array{Float64}(undef, n2, m2)
  ccall((:trfmat, "dislnc_d.dll"), Cvoid, (Ptr{Float64}, Int32, Int32,
          Ptr{Float64}, Int32, Int32), z, n, m, z2, n2, m2)
  z = 0
  transpose!(zmat2, z2)
  z2 = 0
end

function trfrel(xray::Vector{Float64}, yray::Vector{Float64}, n::Int32)
  ccall((:trfrel, "dislnc_d.dll"), Cvoid, 
          (Ptr{Float64}, Ptr{Float64}, Int32), xray, yray, n)
end

function trfres()
  ccall((:trfres, "dislnc_d.dll"), Cvoid, ())
end

function trfrot(x::Float64, i1::Int32, i2::Int32)
  ccall((:trfrot, "dislnc_d.dll"), Cvoid, (Float64, Int32, Int32), x, i1, i2)
end

function trfscl(x1::Float64, x2::Float64)
  ccall((:trfscl, "dislnc_d.dll"), Cvoid, (Float64, Float64), x1, x2)
end

function trfshf(i1::Int32, i2::Int32)
  ccall((:trfshf, "dislnc_d.dll"), Cvoid, (Int32, Int32), i1, i2)
end

function tria3d(xray::Vector{Float64}, yray::Vector{Float64}, 
                zray::Vector{Float64})
  ccall((:tria3d, "dislnc_d.dll"), Cvoid, 
          (Ptr{Float64}, Ptr{Float64}, Ptr{Float64}), xray, yray, zray)
end

function triang(xray::Vector{Float64}, yray::Vector{Float64}, 
                n::Int32, i1ray::Vector{Int32}, i2ray::Vector{Int32}, 
                i3ray::Vector{Int32}, nmax::Int32)
  ntri = ccall((:triang, "dislnc_d.dll"), Int32, (Ptr{Float64}, Ptr{Float64}, 
          Int32, Ptr{Int32}, Ptr{Int32}, Ptr{Int32}, Int32),
          xray, yray, n, i1ray, i2ray, i3ray, nmax)
  return ntri 
end

function triflc(xray::Vector{Float64}, yray::Vector{Float64}, 
                iray::Vector{Int32}, n::Int32)
  ccall((:triflc, "dislnc_d.dll"), Cvoid, (Ptr{Float64}, Ptr{Float64}, 
          Ptr{Int32}, Int32), xray, yray, iray, n)
end

function trifll(xray::Vector{Float64}, yray::Vector{Float64})
  ccall((:trifll, "dislnc_d.dll"), Cvoid, 
          (Ptr{Float64}, Ptr{Float64}), xray, yray)
end

function triplx()
  ccall((:triplx, "dislnc_d.dll"), Cvoid, ())
end

function tripts(xray::Vector{Float64}, yray::Vector{Float64}, 
                zray::Vector{Float64}, n::Int32, i1ray::Vector{Int32}, 
                i2ray::Vector{Int32}, i3ray::Vector{Int32}, ntri::Int32, 
                zlev::Float64, xpts::Vector{Float64}, ypts::Vector{Float64}, 
                maxpts::Int32, nptray::Vector{Int32}, maxray::Int32)
  nlines = Cint[0]
  ccall((:tripts, "dislnc_d.dll"), Cvoid, (Ptr{Float64}, Ptr{Float64}, 
          Ptr{Float64}, Int32, Ptr{Int32}, Ptr{Int32}, Ptr{Int32}, Int32, 
          Float64, Ptr{Float64}, Ptr{Float64}, Int32, Ptr{Int32}, Int32,
          Ptr{Cint}), xray, yray, zray, n, i1ray, i2ray, i3ray, ntri, zlev,
          xpts, ypts, maxpts, nptray, maxray, nlines)
  return convert(Int32, nlines[1])
end

function trmlen(s::String)
  n = ccall((:trmlen, "dislnc_d.dll"), Int32, (Ptr{UInt8},), s)
  return n
end

function ttfont(s::String)
  ccall((:ttfont, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function tube3d(x1::Float64, x2::Float64, x3::Float64, x4::Float64,
           x5::Float64, x6::Float64, x7::Float64, i1::Int32, i2::Int32)
  ccall((:tube3d, "dislnc_d.dll"), Cvoid, (Float64, Float64, Float64,
          Float64, Float64, Float64, Float64, Int32, Int32), 
          x1, x2, x3, x4, x5, x6, x7, i1, i2)
end

function txtbgd(i::Int32)
  ccall((:txtbgd, "dislnc_d.dll"), Cvoid, (Int32,), i)
end

function txtjus(s::String)
  ccall((:txtjus, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function txture(itmat::Array{Int32, 2}, nx::Int32, ny::Int32)
  imat = Array{Int32}(undef, nx, ny)
  ccall((:txture, "dislnc_d.dll"), Cvoid, (Ptr{Int32}, Int32, Int32),
          imat, nx, ny)
  transpose!(itmat, imat)
  imat = 0
end

function unit(i::Int32)
  ccall((:unit, "dislnc_d.dll"), Cvoid, (Int32,), i)
end

function units(s::String)
  ccall((:units, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function upstr(s::String)
  return uppercase(s)
end

function utfint(s::String, iray::Vector{Int32}, nmax::Int32)
  n = ccall((:utfint, "dislnc_d.dll"), Int32, (Ptr{UInt8}, Ptr{Int32},
              Int32), s, iray, nmax)
  return n
end

function vang3d(x::Float64)
  ccall((:vang3d, "dislnc_d.dll"), Cvoid, (Float64,), x)
end

function vclp3d(x1::Float64, x2::Float64)
  ccall((:vclp3d, "dislnc_d.dll"), Cvoid, (Float64, Float64), x1, x2)
end

function vecclr(i::Int32)
  ccall((:vecclr, "dislnc_d.dll"), Cvoid, (Int32,), i)
end

function vecf3d(xv::Vector{Float64}, yv::Vector{Float64}, 
                zv::Vector{Float64}, xp::Vector{Float64}, 
                yp::Vector{Float64}, zp::Vector{Float64}, 
                n::Int32, ivec::Int32)
  ccall((:vecf3d, "dislnc_d.dll"), Cvoid, (Ptr{Float64}, Ptr{Float64}, 
          Ptr{Float64}, Ptr{Float64}, Ptr{Float64}, Ptr{Float64},
          Int32, Int32), xv, yv, zv, xp, yp, zp, n, ivec)
end

function vecfld(xv::Vector{Float64}, yv::Vector{Float64}, 
                xp::Vector{Float64}, yp::Vector{Float64}, 
                n::Int32, ivec::Int32)
  ccall((:vecfld, "dislnc_d.dll"), Cvoid, (Ptr{Float64}, Ptr{Float64}, 
          Ptr{Float64}, Ptr{Float64}, Int32, Int32), xv, yv, xp, yp, n, ivec)
end

function vecmat(xmat::Array{Float64, 2}, ymat::Array{Float64, 2},
                nx::Int32, ny::Int32, xp::Vector{Float64}, yp::Vector{Float64},
                ivec::Int32)
  x = transpose(xmat)
  y = transpose(ymat)
  ccall((:vecmat, "dislnc_d.dll"), Cvoid, (Ptr{Float64}, Ptr{Float64}, 
          Int32, Int32, Ptr{Float64}, Ptr{Float64}, Int32), 
          x, y, nx, ny, xp, yp, ivec)
  x = 0
  y = 0 
end

function vecmat3d(xmat::Array{Float64, 2}, ymat::Array{Float64, 2},
                  zmat::Array{Float64, 2}, nx::Int32, ny::Int32, nz::Int32,
                  xp::Vector{Float64}, yp::Vector{Float64},
                  zp::Vector{Float64}, ivec::Int32)
  x = transpose(xmat)
  y = transpose(ymat)
  z = transpose(zmat)
  ccall((:vecmat3d, "dislnc_d.dll"), Cvoid, (Ptr{Float64}, Ptr{Float64}, 
          Ptr{Float64}, Int32, Int32, Int32, Ptr{Float64}, Ptr{Float64}, 
          Ptr{Float64}, Int32), x, y, z, nx, ny, nz, xp, yp, zp, ivec)
  x = 0
  y = 0 
  z = 0
end

function vecopt(x::Float64, s::String)
  ccall((:vecopt, "dislnc_d.dll"), Cvoid, (Float64, Ptr{UInt8}), x, s)
end

function vector(i1::Int32, i2::Int32, i3::Int32, i4::Int32, i5::Int32)
  ccall((:vector, "dislnc_d.dll"), Cvoid, (Int32, Int32, Int32, Int32, Int32), 
          i1, i2, i3, i4, i5)
end

function vectr3(x1::Float64, x2::Float64, x3::Float64, x4::Float64,
              x5::Float64, x6::Float64, i::Int32)
  ccall((:vectr3, "dislnc_d.dll"), Cvoid, (Float64, Float64, Float64,
          Float64, Float64, Float64, Int32), x1, x2, x3, x4, x5, x6, i)
end

function vfoc3d(x1::Float64, x2::Float64, x3::Float64, s::String)
  ccall((:vfoc3d, "dislnc_d.dll"), Cvoid, (Float64, Float64, Float64, 
          Ptr{UInt8}), x1, x2, x3, s)
end

function view3d(x1::Float64, x2::Float64, x3::Float64, s::String)
  ccall((:view3d, "dislnc_d.dll"), Cvoid, (Float64, Float64, Float64, 
          Ptr{UInt8}), x1, x2, x3, s)
end

function vkxbar(i::Int32)
  ccall((:vkxbar, "dislnc_d.dll"), Cvoid, (Int32,), i)
end

function vkybar(i::Int32)
  ccall((:vkybar, "dislnc_d.dll"), Cvoid, (Int32,), i)
end

function vkytit(i::Int32)
  ccall((:vkytit, "dislnc_d.dll"), Cvoid, (Int32,), i)
end

function vltfil(s1::String, s2::String)
  ccall((:vltfil, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Ptr{UInt8}), s1, s2)
end

function vscl3d(x::Float64)
  ccall((:vscl3d, "dislnc_d.dll"), Cvoid, (Float64,), x)
end

function vtx3d(xray::Vector{Float64}, yray::Vector{Float64}, 
                zray::Vector{Float64}, n::Int32, s::String)
  ccall((:vtx3d, "dislnc_d.dll"), Cvoid, (Ptr{Float64}, Ptr{Float64}, 
          Ptr{Float64}, Int32, Ptr{UInt8}), xray, yray, zray, n, s)
end

function vtxc3d(xray::Vector{Float64}, yray::Vector{Float64}, 
                zray::Vector{Float64}, icray::Vector{Int32}, n::Int32, 
                s::String)
  ccall((:vtxc3d, "dislnc_d.dll"), Cvoid, (Ptr{Float64}, Ptr{Float64}, 
          Ptr{Float64}, Ptr{Int32}, Int32, Ptr{UInt8}), xray, yray, zray, 
          icray, n, s)
end

function vtxn3d(xray::Vector{Float64}, yray::Vector{Float64}, 
                zray::Vector{Float64}, xn::Vector{Float64}, 
                yn::Vector{Float64}, zn::Vector{Float64}, 
                n::Int32, s::String)
  ccall((:vtxn3d, "dislnc_d.dll"), Cvoid, (Ptr{Float64}, Ptr{Float64}, 
          Ptr{Float64}, Ptr{Float64}, Ptr{Float64}, Ptr{Float64},
          Int32, Ptr{UInt8}), xray, yray, zray, xn, yn, zn, n, s)
end

function vup3d(x::Float64)
  ccall((:vup3d, "dislnc_d.dll"), Cvoid, (Float64,), x)
end

function wgapp(i::Int32, s::String)
  n = ccall((:wgapp, "dislnc_d.dll"), Int32, (Int32, Ptr{UInt8}), i, s)
  return n
end

function wgappb(i1::Int32, iray::Vector{UInt8}, i2::Int32, i3::Int32) 
  ccall((:wgappb, "dislnc_d.dll"), Cvoid, (Int32, Ptr{UInt8}, Int32, Int32),
          i1, iray, i2, i3)
end

function wgbas(i::Int32, s::String)
  n = ccall((:wgbas, "dislnc_d.dll"), Int32, (Int32, Ptr{UInt8}), i, s)
  return n
end

function wgbox(i1::Int32, s::String, i2::Int32)
  n = ccall((:wgbox, "dislnc_d.dll"), Int32, (Int32, Ptr{UInt8}, Int32), 
               i1, s, i2)
  return n
end

function wgbut(i1::Int32, s::String, i2::Int32)
  n = ccall((:wgbut, "dislnc_d.dll"), Int32, (Int32, Ptr{UInt8}, Int32), 
               i1, s, i2)
  return n
end

function wgcmd(i::Int32, s1::String, s2::String)
  n = ccall((:wgcmd, "dislnc_d.dll"), Int32, (Int32, Ptr{UInt8}, Ptr{UInt8}), 
           i, s1, s2)
  return n
end

function wgdlis(i1::Int32, s::String, i2::Int32)
  n = ccall((:wgdlis, "dislnc_d.dll"), Int32, (Int32, Ptr{UInt8}, Int32), 
               i1, s, i2)
  return n
end

function wgdraw(i::Int32)
  n = ccall((:wgdraw, "dislnc_d.dll"), Int32, (Int32,), i)
  return n
end

function wgfil(i::Int32, s1::String, s2::String, s3::String)
  n = ccall((:wgfil, "dislnc_d.dll"), Int32, (Int32, Ptr{UInt8}, Ptr{UInt8},
              Ptr{UInt8}), i, s1, s2, s3)
  return n
end

function wgfin()
  ccall((:wgfin, "dislnc_d.dll"), Cvoid, ())
end

function wgicon(i1::Int32, s1::String, i2::Int32, i3::Int32, 
                 s2::String)
  n = ccall((:wgicon, "dislnc_d.dll"), Int32, (Int32, Ptr{UInt8}, Int32, 
              Int32, Ptr{UInt8}), i1, s1, i2, i3, s2)
  return n
end

function wgimg(i1::Int32, s::String, iray::Vector{UInt8}, i2::Int32, 
                i3::Int32) 
  ccall((:wgimg, "dislnc_d.dll"), Cvoid, (Int32, Ptr{UInt8}, Ptr{UInt8}, 
          Int32, Int32), i1, s, iray, i2, i3)
end

function wgini(s::String)
  n = ccall((:wgini, "dislnc_d.dll"), Int32, (Ptr{UInt8},), s)
  return n
end

function wglab(i::Int32, s::String)
  n = ccall((:wglab, "dislnc_d.dll"), Int32, (Int32, Ptr{UInt8}), i, s)
  return n
end

function wglis(i1::Int32, s::String, i2::Int32)
  n = ccall((:wglis, "dislnc_d.dll"), Int32, (Int32, Ptr{UInt8}, Int32), 
               i1, s, i2)
  return n
end

function wgltxt(i1::Int32, s1::String, s2::String, i2::Int32)
  n = ccall((:wgltxt, "dislnc_d.dll"), Int32, (Int32, Ptr{UInt8}, Ptr{UInt8}, 
              Int32), i1, s1, s2, i2)
  return n
end

function wgok(i::Int32)
  n = ccall((:wgok, "dislnc_d.dll"), Int32, (Int32,), i)
  return n
end

function wgpbar(i::Int32, x1::Float64, x2::Float64, x3::Float64)
  n = ccall((:wgpbar, "dislnc_d.dll"), Int32, (Int32, Float64, Float64, 
              Float64), i, x1, x2, x3)
  return n
end

function wgpbut(i::Int32, s::String)
  n = ccall((:wgpbut, "dislnc_d.dll"), Int32, (Int32, Ptr{UInt8}), i, s)
  return n
end

function wgpicon(i1::Int32, s1::String, i2::Int32, i3::Int32, 
                 s2::String)
  n = ccall((:wgpicon, "dislnc_d.dll"), Int32, (Int32, Ptr{UInt8}, Int32, 
              Int32, Ptr{UInt8}), i1, s1, i2, i3, s2)
  return n
end

function wgpimg(i1::Int32, s::String, iray::Vector{UInt8}, i2::Int32, 
                i3::Int32) 
  ccall((:wgpimg, "dislnc_d.dll"), Cvoid, (Int32, Ptr{UInt8}, Ptr{UInt8}, 
          Int32, Int32), i1, s, iray, i2, i3)
end

function wgpop(i::Int32, s::String)
  n = ccall((:wgpop, "dislnc_d.dll"), Int32, (Int32, Ptr{UInt8}), i, s)
  return n
end

function wgpopb(i1::Int32, iray::Vector{UInt8}, i2::Int32, i3::Int32) 
  ccall((:wgpopb, "dislnc_d.dll"), Cvoid, (Int32, Ptr{UInt8}, Int32, Int32),
          i1, iray, i2, i3)
end

function wgquit(i::Int32)
  n = ccall((:wgquit, "dislnc_d.dll"), Int32, (Int32,), i)
  return n
end

function wgscl(i1::Int32, s::String, x1::Float64, x2::Float64,
               x3::Float64, i2::Int32)
  n = ccall((:wgscl, "dislnc_d.dll"), Int32, (Int32, Ptr{UInt8}, Float64,
              Float64, Float64, Int32), i1, s, x1, x2, x3, i2)
  return n
end

function wgsep(i::Int32)
  n = ccall((:wgsep, "dislnc_d.dll"), Int32, (Int32,), i)
  return n
end

function wgstxt(i1::Int32, i2::Int32, i3::Int32)
  n = ccall((:wgstxt, "dislnc_d.dll"), Int32, (Int32, Int32, Int32), 
               i1, i2, i3)
  return n
end

function wgtbl(i1::Int32, i2::Int32, i3::Int32)
  n = ccall((:wgtbl, "dislnc_d.dll"), Int32, (Int32, Int32, Int32), 
               i1, i2, i3)
  return n
end

function wgtxt(i::Int32, s::String)
  n = ccall((:wgtxt, "dislnc_d.dll"), Int32, (Int32, Ptr{UInt8}), i, s)
  return n
end

function widbar(i::Int32)
  ccall((:widbar, "dislnc_d.dll"), Cvoid, (Int32,), i)
end

function wimage(s::String)
  ccall((:wimage, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end
  
function winapp(s::String)
  ccall((:winapp, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end
  
function wincbk(func::Function)
  func_c = @cfunction $func Cvoid (Cint, Cint, Cint, Cint, Cint) 
  ccall((:wincbk, "dislnc_d.dll"), Cvoid, (Ptr{Cvoid}, ), func_c)
end

function windbr(x1::Float64, i1::Int32, i2::Int32, i3::Int32, x2::Float64)
  ccall((:windbr, "dislnc_d.dll"), Cvoid, (Float64, Int32, Int32, Int32, 
          Float64), x1, i1, i2, i3, x2)
end

function window(i1::Int32, i2::Int32, i3::Int32, i4::Int32)
  ccall((:window, "dislnc_d.dll"), Cvoid, (Int32, Int32, Int32, Int32), 
           i1, i2, i3, i4)
end

function winfin(i::Int32)
  ccall((:winfin, "dislnc_d.dll"), Cvoid, (Int32,), i)
end

function winfnt(s::String)
  ccall((:winfnt, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function winico(s::String)
  ccall((:winico, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function winid()
  n = ccall((:winid, "dislnc_d.dll"), Int32, ())
  return n
end

function winjus(s::String)
  ccall((:winjus, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function winkey(s::String)
  ccall((:winkey, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function winmod(s::String)
  ccall((:winmod, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function winopt(i::Int32, s::String)
  ccall((:winopt, "dislnc_d.dll"), Cvoid, (Int32, Ptr{UInt8}), i, s)
end

function winsiz(i1::Int32, i2::Int32)
  ccall((:winsiz, "dislnc_d.dll"), Cvoid, (Int32, Int32), i1, i2)
end

function wintit(s::String)
  ccall((:wintit, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function wintyp(s::String)
  ccall((:wintyp, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function wmfmod(s1::String, s2::String)
  ccall((:wmfmod, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Ptr{UInt8}), s1, s2)
end

function world()
  ccall((:world, "dislnc_d.dll"), Cvoid, ())
end

function wpixel(i1::Int32, i2::Int32, i3::Int32)
  ccall((:wpixel, "dislnc_d.dll"), Cvoid, (Int32, Int32, Int32), i1, i2, i3)
end

function wpixls(iray::Vector{UInt8}, i1::Int32, i2::Int32, i3::Int32, 
                i4::Int32)
  ccall((:wpixls, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Int32, Int32, Int32, 
          Int32), iray, i1, i2, i3, i4)
end

function wpxrow(iray::Vector{UInt8}, i1::Int32, i2::Int32, i3::Int32) 
  ccall((:wpxrow, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Int32, Int32, Int32),
          iray, i1, i2, i3)
end

function writfl(i1::Int32, iray::Vector{UInt8}, i2::Int32) 
  n = ccall((:writfl, "dislnc_d.dll"), Int32, (Int32, Ptr{UInt8}, Int32),
          i1, iray, i2)
  return n
end

function wtiff(s::String)
  ccall((:wtiff, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function x11fnt(s1::String, s2::String)
  ccall((:x11fnt, "dislnc_d.dll"), Cvoid, (Ptr{UInt8}, Ptr{UInt8}), s1, s2)
end

function x11mod(s::String)
  ccall((:x11mod, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function x2dpos(x1::Float64, x2::Float64)
  x = ccall((:x2dpos, "dislnc_d.dll"), Float64, (Float64, Float64), x1, x2)
  return x
end

function x3dabs(x1::Float64, x2::Float64, x3::Float64)
  x = ccall((:x3dabs, "dislnc_d.dll"), Float64, (Float64, Float64, Float64), 
          x1, x2, x3)
  return x
end

function x3dpos(x1::Float64, x2::Float64, x3::Float64)
  x = ccall((:x3dpos, "dislnc_d.dll"), Float64, (Float64, Float64, Float64), 
          x1, x2, x3)
  return x
end

function x3drel(x1::Float64, x2::Float64, x3::Float64)
  x = ccall((:x3drel, "dislnc_d.dll"), Float64, (Float64, Float64, Float64), 
          x1, x2, x3)
  return x
end

function xaxgit()
  ccall((:xaxgit, "dislnc_d.dll"), Cvoid, ())
end

function xaxis(x1::Float64, x2::Float64, x3::Float64, x4::Float64, i1::Int32,
               s::String, i2::Int32, i3::Int32, i4::Int32)
  ccall((:xaxis, "dislnc_d.dll"), Cvoid, (Float64, Float64, Float64, Float64,
          Int32, Ptr{UInt8}, Int32, Int32, Int32), 
          x1, x2, x3, x4, i1, s, i2, i3, i4)
end

function xaxlg(x1::Float64, x2::Float64, x3::Float64, x4::Float64, i1::Int32,
               s::String, i2::Int32, i3::Int32, i4::Int32)
  ccall((:xaxlg, "dislnc_d.dll"), Cvoid, (Float64, Float64, Float64, Float64,
          Int32, Ptr{UInt8}, Int32, Int32, Int32), 
          x1, x2, x3, x4, i1, s, i2, i3, i4)
end

function xaxmap(x1::Float64, x2::Float64, x3::Float64, x4::Float64, 
               s::String, i1::Int32, i2::Int32)
  ccall((:xaxmap, "dislnc_d.dll"), Cvoid, (Float64, Float64, Float64, Float64,
          Ptr{UInt8}, Int32, Int32), x1, x2, x3, x4, s, i1, i2)
end

function xcross()
  ccall((:xcross, "dislnc_d.dll"), Cvoid, ())
end

function xdraw(x1::Float64, x2::Float64)
  ccall((:xdraw, "dislnc_d.dll"), Cvoid, (Float64, Float64), x1, x2)
end

function xinvrs(i::Int32)
  x = ccall((:xinvrs, "dislnc_d.dll"), Float64, (Int32, ), i)
  return x
end

function xmove(x1::Float64, x2::Float64)
  ccall((:xmove, "dislnc_d.dll"), Cvoid, (Float64, Float64), x1, x2)
end

function xposn(x1::Float64)
  x = ccall((:xposn, "dislnc_d.dll"), Float64, (Float64, ), x1)
  return x
end

function y2dpos(x1::Float64, x2::Float64)
  x = ccall((:y2dpos, "dislnc_d.dll"), Float64, (Float64, Float64), x1, x2)
  return x
end

function y3dabs(x1::Float64, x2::Float64, x3::Float64)
  x = ccall((:y3dabs, "dislnc_d.dll"), Float64, (Float64, Float64, Float64), 
          x1, x2, x3)
  return x
end

function y3dpos(x1::Float64, x2::Float64, x3::Float64)
  x = ccall((:y3dpos, "dislnc_d.dll"), Float64, (Float64, Float64, Float64), 
          x1, x2, x3)
  return x
end

function y3drel(x1::Float64, x2::Float64, x3::Float64)
  x = ccall((:y3drel, "dislnc_d.dll"), Float64, (Float64, Float64, Float64), 
          x1, x2, x3)
  return x
end

function yaxgit()
  ccall((:yaxgit, "dislnc_d.dll"), Cvoid, ())
end

function yaxis(x1::Float64, x2::Float64, x3::Float64, x4::Float64, i1::Int32,
               s::String, i2::Int32, i3::Int32, i4::Int32)
  ccall((:yaxis, "dislnc_d.dll"), Cvoid, (Float64, Float64, Float64, Float64,
          Int32, Ptr{UInt8}, Int32, Int32, Int32), 
          x1, x2, x3, x4, i1, s, i2, i3, i4)
end

function yaxlg(x1::Float64, x2::Float64, x3::Float64, x4::Float64, i1::Int32,
               s::String, i2::Int32, i3::Int32, i4::Int32)
  ccall((:yaxlg, "dislnc_d.dll"), Cvoid, (Float64, Float64, Float64, Float64,
          Int32, Ptr{UInt8}, Int32, Int32, Int32), 
          x1, x2, x3, x4, i1, s, i2, i3, i4)
end

function yaxmap(x1::Float64, x2::Float64, x3::Float64, x4::Float64, 
               s::String, i1::Int32, i2::Int32)
  ccall((:yaxmap, "dislnc_d.dll"), Cvoid, (Float64, Float64, Float64, Float64,
          Ptr{UInt8}, Int32, Int32), x1, x2, x3, x4, s, i1, i2)
end

function ycross()
  ccall((:ycross, "dislnc_d.dll"), Cvoid, ())
end

function yinvrs(i::Int32)
  x = ccall((:yinvrs, "dislnc_d.dll"), Float64, (Int32, ), i)
  return x
end

function ypolar(x1::Float64, x2::Float64, x3::Float64, x4::Float64,
               s::String, i1::Int32)
  ccall((:ypolar, "dislnc_d.dll"), Cvoid, (Float64, Float64, Float64, Float64,
          Ptr{UInt8}, Int32), 
          x1, x2, x3, x4, s, i1)
end

function yposn(x1::Float64)
  x = ccall((:yposn, "dislnc_d.dll"), Float64, (Float64, ), x1)
  return x
end

function z3dpos(x1::Float64, x2::Float64, x3::Float64)
  x = ccall((:z3dpos, "dislnc_d.dll"), Float64, (Float64, Float64, Float64), 
          x1, x2, x3)
  return x
end

function zaxis(x1::Float64, x2::Float64, x3::Float64, x4::Float64, i1::Int32,
               s::String, i2::Int32, i3::Int32, i4::Int32, i5::Int32)
  ccall((:zaxis, "dislnc_d.dll"), Cvoid, (Float64, Float64, Float64, Float64,
          Int32, Ptr{UInt8}, Int32, Int32, Int32, Int32), 
          x1, x2, x3, x4, i1, s, i2, i3, i4, i5)
end

function zaxlg(x1::Float64, x2::Float64, x3::Float64, x4::Float64, i1::Int32,
               s::String, i2::Int32, i3::Int32, i4::Int32, i5::Int32)
  ccall((:zaxlg, "dislnc_d.dll"), Cvoid, (Float64, Float64, Float64, Float64,
          Int32, Ptr{UInt8}, Int32, Int32, Int32, Int32), 
          x1, x2, x3, x4, i1, s, i2, i3, i4, i5)
end

function zbfers()
  ccall((:zbfers, "dislnc_d.dll"), Cvoid, ())
end

function zbffin()
  ccall((:zbffin, "dislnc_d.dll"), Cvoid, ())
end

function zbfini()
  n = ccall((:zbfini, "dislnc_d.dll"), Int32, ())
  return n
end

function zbflin(x1::Float64, x2::Float64, x3::Float64, x4::Float64,
              x5::Float64, x6::Float64)
  ccall((:zbflin, "dislnc_d.dll"), Cvoid, (Float64, Float64, Float64,
          Float64, Float64, Float64), x1, x2, x3, x4, x5, x6)
end

function zbfmod(s::String)
  ccall((:zbfmod, "dislnc_d.dll"), Cvoid, (Ptr{UInt8},), s)
end

function zbfres()
  ccall((:zbfres, "dislnc_d.dll"), Cvoid, ())
end

function zbfscl(x::Float64)
  ccall((:zbfscl, "dislnc_d.dll"), Cvoid, (Float64,), x)
end

function zbftri(xray::Vector{Float64}, yray::Vector{Float64}, 
                zray::Vector{Float64}, iray::Vector{Int32})
  ccall((:zbftri, "dislnc_d.dll"), Cvoid, (Ptr{Float64}, Ptr{Float64}, 
          Ptr{Float64}, Ptr{Int32}), xray, yray, zray, iray)
end

function zscale(x1::Float64, x2::Float64)
  ccall((:zscale, "dislnc_d.dll"), Cvoid, (Float64, Float64), x1, x2)
end

end
