******************************************************************
**                                                              **
**           IBM-PC Installation of DISLIN for Go               **
**                                                              **
**  Contents:  1.)  Introduction                                **
**             2.)  Installation of DISLIN for Go               **
**             3.)  Getting DISLIN Support                      **
**                                                              **
**  Date   :   15.03.2022                                       **
**  Version:   11.5  /  Windows                                 **
**  Author :   Helmut Michels                                   **
**             Dislin Software                                  **
**             Am Hachweg 10                                    **
**             37083 Gttingen, Germany                         **
**  Email  :   michels@dislin.de                                **
******************************************************************

1.)  Introduction

     DISLIN is a  high-level and  easy to use graphics library for
     displaying data as curves, bar graphs, pie charts, 3-D colour
     plots, surfaces, contours and maps. The software is available
     for several C, Fortran 77 and Fortran 90 compilers.

     This file describes the installation of  DISLIN  for the pro-
     gramming language Go and Windows.

     Note: The DISLIN distribution for Go contains the DISLIN 
           library for gcc/MinGW. Compiling the interface file and
           linking the Go examples with DISLIN requires a C compiler.
           For example, the free tdm-gcc distribution of gcc can be
           used.
  

2.)  Installation of DISLIN for Go

     The Windows version of DISLIN for Free Pascal is distributed
     as a  .zip file created with the file packaging utility ZIP
     (version 1.9).
     The .zip file has the file name DL_nn_GO.ZIP where  nn is the
     current version number of DISLIN.

     To install DISLIN for Go, make the following steps:

  a) Create a temporary directory and copy the files dl_11_fp.zip
     and unzip.exe to it.

  b) Extract the zipped files in the temporary directory with the
     command:

                    unzip -o dl_11_go.zip 

  c) Run the SETUP program with the command

                    setup

     -  Choose OK

     -  Give the Installation Directory where DISLIN for Go
        should be installed. The default directory is C:\DISLIN.


  d) Reconfigure the System

     Set the DISLIN environment variable to c:\dislin and include the
     directory c:\dislin\win in your path. If you have installed DISLIN
     in a different directory, you have to use that directory for the 
     environment variables above.

     Set the GOPATH environment variable to the value c:\dislin\go.
     If you are using Go version 1.16 or later, you should also set
     the GO111MODULE variable to the value off.

     The environment variables can be set or modified with the Control
     Panel 
    
     (see Control Panel -> System -> Advanced -> Environment
      Variables).

  e) Compiling and linking the Go examples

     The Go interface to DISLIN can be compiled with the command:

     cd %GOPATH%\src\dislin
     go build               

     After that you can compile and run the DISLIN examples for Go:

     cd %GOPATH%\src
     go build curve.go
     curve

     ......

3.)  Getting DISLIN Support

     The DISLIN distributions can be used freely without any restriction.
     Access to the source code is availabe via a support contract from the
     site www.dislin.de.


