#if defined(WIN32)
#define EXPORT extern  "C"  __declspec (dllexport)
#endif

#define INTEG2      short
#define INTEG4      int

#define MAX_CB      200

enum    V_TYPES {V_FREE, 
                 V_INT,
                 V_DOUBLE,
                 V_STRING};

enum    F_TYPES {F_UNDEF,
                 F_DEF};  

typedef struct { char   *name;
                 char   type;
                 char   flag;
                 union { INTEG4  i;
                         double   f;
                         char   *s;
                       } value;
               } G_SYSV;

#define NSYSV   57

static G_SYSV sysv[NSYSV] =
  {   "ERASE" , V_INT,    F_UNDEF, 0, 
      "H"     , V_INT,    F_UNDEF, 0, 
      "HNAME" , V_INT,    F_UNDEF, 0,
      "HSYMBL", V_INT,    F_UNDEF, 0, 
      "HTITLE", V_INT,    F_UNDEF, 0,
      "INCMRK", V_INT,    F_UNDEF, 0,
      "MARKER", V_INT,    F_UNDEF, 0,
      "POLCRV", V_STRING, F_UNDEF, 0,
      "T1"    , V_STRING, F_UNDEF, 0,
      "T2"    , V_STRING, F_UNDEF, 0,
      "T3"    , V_STRING, F_UNDEF, 0,
      "T4"    , V_STRING, F_UNDEF, 0,
      "X"     , V_STRING, F_UNDEF, 0,
      "XAUTO" , V_INT,    F_UNDEF, 0,
      "XDIG"  , V_INT,    F_UNDEF, 0,
      "XLAB"  , V_STRING, F_UNDEF, 0,
      "XLEN"  , V_INT,    F_UNDEF, 0,
      "XMAX"  , V_DOUBLE,  F_UNDEF, 0,
      "XMIN"  , V_DOUBLE,  F_UNDEF, 0,
      "XOR"   , V_DOUBLE,  F_UNDEF, 0,
      "XPOS"  , V_INT,    F_UNDEF, 0,
      "XRES"  , V_INT,    F_UNDEF, 0,
      "XSCL"  , V_STRING, F_UNDEF, 0,
      "XSTEP" , V_DOUBLE,  F_UNDEF, 0,
      "XTIC"  , V_INT,    F_UNDEF, 0,
      "Y"     , V_STRING, F_UNDEF, 0,
      "YAUTO" , V_INT,    F_UNDEF, 0,
      "YDIG"  , V_INT,    F_UNDEF, 0,
      "YLAB"  , V_STRING, F_UNDEF, 0,
      "YLEN"  , V_INT,    F_UNDEF, 0,
      "YMAX"  , V_DOUBLE,  F_UNDEF, 0,
      "YMIN"  , V_DOUBLE,  F_UNDEF, 0,
      "YOR"   , V_DOUBLE,  F_UNDEF, 0,
      "YPOS"  , V_INT,    F_UNDEF, 0,
      "YRES"  , V_INT,    F_UNDEF, 0,
      "YSCL"  , V_STRING, F_UNDEF, 0,
      "YSTEP" , V_DOUBLE,  F_UNDEF, 0,
      "YTIC"  , V_INT,    F_UNDEF, 0,
      "Z"     , V_STRING, F_UNDEF, 0,
      "ZAUTO" , V_INT,    F_UNDEF, 0,
      "ZDIG"  , V_INT,    F_UNDEF, 0,
      "ZLAB"  , V_STRING, F_UNDEF, 0,
      "ZLEN"  , V_INT,    F_UNDEF, 0,
      "ZMAX"  , V_DOUBLE,  F_UNDEF, 0,
      "ZMIN"  , V_DOUBLE,  F_UNDEF, 0,
      "ZOR"   , V_DOUBLE,  F_UNDEF, 0,
      "ZSCL"  , V_STRING, F_UNDEF, 0,
      "ZSTEP" , V_DOUBLE,  F_UNDEF, 0,
      "ZTIC"  , V_INT,    F_UNDEF, 0,
      "X3LEN" , V_DOUBLE,  F_UNDEF, 0,
      "Y3LEN" , V_DOUBLE,  F_UNDEF, 0,
      "Z3LEN" , V_DOUBLE,  F_UNDEF, 0,
      "X3VIEW", V_DOUBLE,  F_UNDEF, 0,
      "Y3VIEW", V_DOUBLE,  F_UNDEF, 0,
      "Z3VIEW", V_DOUBLE,  F_UNDEF, 0,
      "VTITLE", V_INT,    F_UNDEF, 0,
      "CONSHD", V_STRING, F_UNDEF, 0
    };


#define    ERASE_SYSV     0      
#define    H_SYSV         1 
#define    HNAME_SYSV     2
#define    HSYMBL_SYSV    3
#define    HTITLE_SYSV    4
#define    INCMRK_SYSV    5
#define    MARKER_SYSV    6
#define    POLCRV_SYSV    7
#define    T1_SYSV        8
#define    T2_SYSV        9
#define    T3_SYSV       10
#define    T4_SYSV       11
#define    X_SYSV        12
#define    XAUTO_SYSV    13 
#define    XDIG_SYSV     14 
#define    XLAB_SYSV     15
#define    XLEN_SYSV     16 
#define    XMAX_SYSV     17 
#define    XMIN_SYSV     18
#define    XOR_SYSV      19
#define    XPOS_SYSV     20 
#define    XRES_SYSV     21 
#define    XSCL_SYSV     22
#define    XSTEP_SYSV    23
#define    XTIC_SYSV     24 
#define    Y_SYSV        25
#define    YAUTO_SYSV    26 
#define    YDIG_SYSV     27 
#define    YLAB_SYSV     28
#define    YLEN_SYSV     29 
#define    YMAX_SYSV     30
#define    YMIN_SYSV     31
#define    YOR_SYSV      32
#define    YPOS_SYSV     33 
#define    YRES_SYSV     34 
#define    YSCL_SYSV     35 
#define    YSTEP_SYSV    36
#define    YTIC_SYSV     37 
#define    Z_SYSV        38
#define    ZAUTO_SYSV    39 
#define    ZDIG_SYSV     40 
#define    ZLAB_SYSV     41
#define    ZLEN_SYSV     42 
#define    ZMAX_SYSV     43
#define    ZMIN_SYSV     44
#define    ZOR_SYSV      45
#define    ZSCL_SYSV     46
#define    ZSTEP_SYSV    47
#define    ZTIC_SYSV     48
#define    X3LEN_SYSV    49   
#define    Y3LEN_SYSV    50
#define    Z3LEN_SYSV    51
#define    X3VIEW_SYSV   52
#define    Y3VIEW_SYSV   53 
#define    Z3VIEW_SYSV   54
#define    VTITLE_SYSV   55
#define    CONSHD_SYSV   56
