 #/****************************************************************/
 #/**                         Dislin.xs                          **/
 #/**                                                            **/
 #/** Dislin interface for Perl.                                 **/
 #/**                                                            **/
 #/** Date     : 15.03.2022                                      **/
 #/** Version  : 11.5 / Unix, Windows, 32- and 64-bit            **/
 #/****************************************************************/

#ifdef __cplusplus
extern "C" {
#endif
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
#include "dislin_d.h"
#ifdef __cplusplus
}
#endif

#define MAX_CB 100
static int nspline = 200;
static int imgop = 0;
static char *cbray[MAX_CB];
static int icbray[MAX_CB];
static int ncbray = 0;
static char cbfunc[132], cbmypr[132], cbmypie[132], cbwin[132];

int *arraytoint (AV *nray, int n)
{ int i, *p;

  if (av_len (nray) + 1 < n) return NULL;
  New (1, p, n, int);
  if ( p == NULL) return NULL;

  for (i = 0; i < n; i++)
    p[i] = (int) SvIV(*av_fetch(nray,i,0));
  return p;
}

void inttoarray (int *p, AV *nray, int n)
{ int i;

  av_extend (nray, n);
  for (i = 0; i < n; i++)
    av_store(nray,i,newSViv ((int) p[i]));
}

long *arraytolong (AV *nray, int n)
{ int i;
  long *p;

  if (av_len (nray) + 1 < n) return NULL;
  New (1, p, n, long);
  if ( p == NULL) return NULL;

  for (i = 0; i < n; i++)
    p[i] = (long) SvIV(*av_fetch(nray,i,0));
  return p;
}

double *arraytofloat (AV *xray, int n)
{ int i;
  double *p;

  if (av_len (xray) + 1 < n) return NULL;
  New (1, p, n, double);
  if ( p == NULL) return NULL;

  for (i = 0; i < n; i++)
    p[i] = SvNV(*av_fetch(xray,i,0));
  return p;
}

void floattoarray (double *p, AV *xray, int n)
{ int i;

  av_extend (xray, n);
  for (i = 0; i < n; i++)
  { av_store(xray,i,newSVnv (p[i]));
  }
}

double *matrixtofloat (AV *xmat, int nx, int ny)
{ int i, j, ii;
  AV *p2;
  double *p;
  size_t iv;

  New (1, p, nx * ny, double);
  if (p == NULL) return NULL;

  if (av_len (xmat) + 1 >= nx * ny)
  { for (i = 0; i < nx * ny; i++)
      p[i] = SvNV(*av_fetch(xmat,i,0));
  }
  else
  { for (i = 0; i < nx; i++)
    { ii = i * ny;
      iv = (size_t) SvIV(*av_fetch(xmat,i,0));
      p2 = (AV *) iv;
        for (j = 0; j < ny; j++)
           p[j+ii] = SvNV(*av_fetch(p2,j,0));
    }
  }
  return p;
}

double *matrix3tofloat (AV *xmat, int nx, int ny, int nz)
{ int i, j, k, kk, n;
  AV *p2, *p3;
  double *p;
  size_t iv;

  New (1, p, nx * ny * nz, double);
  if (p == NULL) return NULL;

  n = nx * ny * nz;
  if (av_len (xmat) + 1 >= n)
  { for (i = 0; i < n; i++)
      p[i] = SvNV(*av_fetch(xmat,i,0));
  }
  else
  { kk = 0;
    for (i = 0; i < nx; i++)
    { iv = (size_t) SvIV(*av_fetch(xmat,i,0));
      p2 = (AV *) iv;
      for (j = 0; j < ny; j++)
      { iv = (size_t) SvIV(*av_fetch(p2,j,0));
        p3 = (AV *) iv;
        for (k = 0; k < nz; k++)
        { p[kk] = SvNV(*av_fetch(p3,k,0));
          kk++;
        }
      }
    }
  }

  return p;
}


void floattomatrix (double *p, AV *xmat, int nx, int ny)
{ int i, ii, j;
  AV *p2;
  size_t iv;

  if (av_len (xmat) + 1 == nx)
  { for (i = 0; i < nx; i++)
    { ii = i * ny;
      iv = (size_t) SvIV(*av_fetch(xmat,i,0));
      p2 = (AV *) iv;
      for (j = 0; j < ny; j++)
        av_store (p2, j, newSVnv (p[j+ii]));
    }
  }
  else
  { av_extend (xmat, nx * ny);
    for (i = 0; i < nx * ny; i++)
       av_store(xmat,i,newSVnv (p[i]));
  }
}

int *matrixtoint (AV *imat, int nx, int ny)
{ int i, j, ii;
  AV *p2;
  int *p;
  size_t iv;

  New (1, p, nx * ny, int);
  if (p == NULL) return NULL;

  if (av_len (imat) + 1 >= nx * ny)
  { for (i = 0; i < nx * ny; i++)
      p[i] = (int) SvIV(*av_fetch(imat,i,0));
  }
  else
  { for (i = 0; i < nx; i++)
    { ii = i * ny;
      iv = (size_t) SvIV(*av_fetch(imat,i,0));
      p2 = (AV *) iv;
      for (j = 0; j < ny; j++)
        p[j+ii] = (int) SvIV(*av_fetch(p2,j,0));
    }
  }
  return p;
}

void inttomatrix (int *p, AV *imat, int nx, int ny)
{ int i, ii, j;
  AV *p2;
  size_t iv;

  if (av_len (imat) + 1 == nx)
  { for (i = 0; i < nx; i++)
    { ii = i * ny;
      iv = (size_t) SvIV(*av_fetch(imat,i,0));
      p2 = (AV *) iv;
      for (j = 0; j < ny; j++)
        av_store (p2, j, newSViv (p[j+ii]));
    }
  }
  else
  { av_extend (imat, nx * ny);
    for (i = 0; i < nx * ny; i++)
       av_store(imat,i,newSViv ((int) p[i]));
  }
}

void dis_callbck (int id)
{ 
  dSP;
  int i;

  ENTER;
  SAVETMPS;

  PUSHMARK(sp);
  XPUSHs(sv_2mortal(newSViv(id)));
  PUTBACK;
  
  for (i = 0; i < ncbray; i++)
  { if (id == icbray[i])
    { perl_call_pv (cbray[i], G_DISCARD);
      break;
    }
  }

  FREETMPS;
  LEAVE;
}

void dis_callbck2 (double *x, double *y)
{ 
  dSP;
  SV* xp;
  SV* yp;

  ENTER;
  SAVETMPS;

  xp = newSVnv (*x);
  yp = newSVnv (*y);
 
  PUSHMARK(sp);
  XPUSHs(sv_2mortal(xp));
  XPUSHs(sv_2mortal(yp));
  PUTBACK;
  
  perl_call_pv (cbmypr, G_DISCARD);

  *x =  SvNV (xp);
  *y =  SvNV (yp);

  FREETMPS;
  LEAVE;
}

void dis_callbck3 (int id, int irow, int icol)
{ 
  dSP;
  int i;

  ENTER;
  SAVETMPS;

  PUSHMARK(sp);
  XPUSHs(sv_2mortal(newSViv(id)));
  XPUSHs(sv_2mortal(newSViv(irow)));
  XPUSHs(sv_2mortal(newSViv(icol)));
  PUTBACK;

  for (i = 0; i < ncbray; i++)
  { if (id == icbray[i])
    { perl_call_pv (cbray[i], G_DISCARD);
      break;
    }
  }

  
  FREETMPS;
  LEAVE;
}

void dis_callbck4 (int id, int ival)
{ 
  dSP;
  int i;

  ENTER;
  SAVETMPS;

  PUSHMARK(sp);
  XPUSHs(sv_2mortal(newSViv(id)));
  XPUSHs(sv_2mortal(newSViv(ival)));
  PUTBACK;

  for (i = 0; i < ncbray; i++)
  { if (id == icbray[i])
    { perl_call_pv (cbray[i], G_DISCARD);
      break;
    }
  }

  
  FREETMPS;
  LEAVE;
}

void dis_wincbk (int id, int nx, int ny, int nw, int nh)
{ 
  dSP;

  ENTER;
  SAVETMPS;

  PUSHMARK(sp);
  XPUSHs(sv_2mortal(newSViv(id)));
  XPUSHs(sv_2mortal(newSViv(nx)));
  XPUSHs(sv_2mortal(newSViv(ny)));
  XPUSHs(sv_2mortal(newSViv(nw)));
  XPUSHs(sv_2mortal(newSViv(nh)));
  PUTBACK;

  perl_call_pv (cbwin, G_DISCARD);

  FREETMPS;
  LEAVE;
}

double dis_funcbck (double x, double y, int iopt)
{ 
  dSP;
  int icount;
  double xret;

  ENTER;
  SAVETMPS;

  PUSHMARK(sp);
  XPUSHs(sv_2mortal(newSVnv(x)));
  XPUSHs(sv_2mortal(newSVnv(y)));
  XPUSHs(sv_2mortal(newSViv(iopt)));
  PUTBACK;

  icount = perl_call_pv (cbfunc, G_SCALAR);

  SPAGAIN;
  xret = POPn;
  PUTBACK;  
  FREETMPS;
  LEAVE;
  return xret;
}

double dis_func2bck (double x, double y)
{ 
  dSP;
  int icount;
  double xret;

  ENTER;
  SAVETMPS;

  PUSHMARK(sp);
  XPUSHs(sv_2mortal(newSVnv(x)));
  XPUSHs(sv_2mortal(newSVnv(y)));
  PUTBACK;

  icount = perl_call_pv (cbfunc, G_SCALAR);

  SPAGAIN;
  xret = POPn;
  PUTBACK;  
  FREETMPS;
  LEAVE;
  return xret;
}

void dis_piebck (int iseg, double xdat, double xper, int *nrad, int *noff,
                 double *a, int *nvx, int *nvy, int *idrw, int *iann)
{ 
  dSP;
  int icount;
  SV* nradp;
  SV* noffp;
  SV* ap;
  SV* nvxp;
  SV* nvyp;
  SV* idrwp;
  SV* iannp;

  ENTER;
  SAVETMPS;

  nradp = newSViv (*nrad);
  noffp = newSViv (*noff);
  ap = newSVnv (*a);
  nvxp = newSViv (*nvx);
  nvyp = newSViv (*nvy);
  idrwp = newSViv (*idrw);
  iannp = newSViv (*iann);
 
  PUSHMARK(sp);
  XPUSHs(sv_2mortal(newSViv(iseg)));
  XPUSHs(sv_2mortal(newSVnv(xdat)));
  XPUSHs(sv_2mortal(newSVnv(xper)));
  XPUSHs(sv_2mortal(nradp));
  XPUSHs(sv_2mortal(noffp));
  XPUSHs(sv_2mortal(ap));
  XPUSHs(sv_2mortal(nvxp));
  XPUSHs(sv_2mortal(nvyp));
  XPUSHs(sv_2mortal(idrwp));
  XPUSHs(sv_2mortal(iannp));
  PUTBACK;
  
  icount = perl_call_pv (cbmypie, G_DISCARD);

  *nrad = (int) SvIV (nradp);
  *noff = (int) SvIV (noffp);
  *a    =  SvNV (ap);
  *nvx  = (int) SvIV (nvxp);
  *nvy  = (int) SvIV (nvyp);
  *idrw = (int) SvIV (idrwp);
  *iann = (int) SvIV (iannp);

  FREETMPS;
  LEAVE;
}

MODULE = Dislin		PACKAGE = Dislin	PREFIX = Dislin_

void
Dislin_abs3pt (x, y, z, xp, yp)
	double x;
	double y;
	double z;
	double xp;
	double yp;
        CODE:
        double xpt, ypt;
        abs3pt (x, y, z, &xpt, &ypt);
        xp = xpt;
        yp = ypt;
        OUTPUT:
        xp
        yp

void
Dislin_addlab (s1, v, i, s2)
	int i;
	char *s1;
	char *s2;
        double v;
	CODE:
	addlab (s1, v, i, s2);

void 
Dislin_angle  (ngrad)
	int ngrad;
        CODE:
        angle (ngrad);

void
Dislin_arcell (i1, i2, i3, i4, x1, x2, x3)
	int i1;
        int i2;
        int i3;
	int i4;
	double x1;
	double x2;
	double x3;
	CODE:
        arcell (i1, i2, i3, i4, x1, x2, x3);

void
Dislin_areaf (n1ray, n2ray, n)
	AV * n1ray = (AV *)SvRV(ST(0));
	AV * n2ray = (AV *)SvRV(ST(1));
        int n;
        CODE:
        int *p1, *p2;

        p1 = arraytoint (n1ray, n);
        p2 = arraytoint (n2ray, n);
        if (p1 != NULL && p2 != NULL)
          areaf (p1, p2, n);
        Safefree (p1);
        Safefree (p2);

void
Dislin_autres (i1, i2)
	int i1;
        int i2;
	CODE:
        autres (i1, i2);

void
Dislin_autres3d (i1, i2, i3)
	int i1;
        int i2;
        int i3;
	CODE:
        autres3d (i1, i2, i3);

void 
Dislin_ax2grf ()
	CODE:
	ax2grf ();
        
void 
Dislin_ax3len (nxl, nyl, nzl)
	int nxl;
	int nyl;
	int nzl;
	CODE:
	ax3len (nxl, nyl, nzl);

void
Dislin_axclrs (i, s1, s2)
	int i;
	char *s1;
	char *s2;
	CODE:
	axclrs (i, s1, s2);

void
Dislin_axends (s1, s2)
	char *s1;
	char *s2;
	CODE:
	axends (s1, s2);

void
Dislin_axgit ()
	CODE:
	axgit ();

void
Dislin_axis3d (x1, x2, x3)
	double x1;
	double x2;
	double x3;
	CODE:
        axis3d (x1, x2, x3);

void
Dislin_axsbgd (i)
	int i;
	CODE:
	axsbgd (i);

void
Dislin_axsers ()
	CODE:
	axsers ();

void
Dislin_axslen (nxl, nyl)
	int nxl;
	int nyl;
	CODE:
	axslen (nxl, nyl);

void
Dislin_axsorg (i1, i2)
	int i1;
	int i2;
	CODE:
	axsorg (i1, i2);

void
Dislin_axspos (i1, i2)
	int i1;
	int i2;
	CODE:
	axspos (i1, i2);

void
Dislin_axsscl (s1, s2)
	char *s1;
	char *s2;
	CODE:
	axsscl (s1, s2);

void
Dislin_axstyp (s)
	char *s;
	CODE:
	axstyp (s);

void
Dislin_barbor (n)
        int n;
	CODE:
	barbor (n);

void
Dislin_barclr (i1, i2, i3)
	int i1;
	int i2;
	int i3;
	CODE:
	barclr (i1, i2, i3);
      
void
Dislin_bargrp (i, x)
	int i;
	double x;
	CODE:
	bargrp (i, x);

void
Dislin_barmod (s1, s2)
	char *s1;
	char *s2;
	CODE:
	barmod (s1, s2);

void
Dislin_baropt (x1, x2)
	double x1;
	double x2;
	CODE:
	baropt (x1, x2);

void
Dislin_barpos (s)
	char *s;
	CODE:
	barpos (s);

void
Dislin_bars (x1ray, x2ray, x3ray, n)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
	AV * x3ray = (AV *)SvRV(ST(2));
        int n;
        CODE:
        double *p1, *p2, *p3;

        p1 = arraytofloat (x1ray, n);
        p2 = arraytofloat (x2ray, n);
        p3 = arraytofloat (x3ray, n);
        if (p1 != NULL && p2 != NULL && p3 != NULL) 
          bars (p1, p2, p3, n);
        Safefree (p1);
        Safefree (p2);
        Safefree (p3);

void
Dislin_bars3d (x1ray, x2ray, x3ray, x4ray, x5ray, x6ray, n1ray, n)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
	AV * x3ray = (AV *)SvRV(ST(2));
	AV * x4ray = (AV *)SvRV(ST(3));
	AV * x5ray = (AV *)SvRV(ST(4));
	AV * x6ray = (AV *)SvRV(ST(5));
	AV * n1ray = (AV *)SvRV(ST(6));
        int n;
        CODE:
        int *p7;
        double *p1, *p2, *p3, *p4, *p5, *p6;

        p1 = arraytofloat (x1ray, n);
        p2 = arraytofloat (x2ray, n);
        p3 = arraytofloat (x3ray, n);
        p4 = arraytofloat (x4ray, n);
        p5 = arraytofloat (x5ray, n);
        p6 = arraytofloat (x6ray, n);
        p7 = arraytoint (n1ray, n);

        if (p1 != NULL && p2 != NULL && p3 != NULL && p4 != NULL &&
            p5 != NULL && p6 != NULL && p7 != NULL) 
          bars3d (p1, p2, p3, p4, p5, p6, p7, n);

        Safefree (p1);
        Safefree (p2);
        Safefree (p3);
        Safefree (p4);
        Safefree (p5);
        Safefree (p6);
        Safefree (p7);

void
Dislin_bartyp (s)
	char *s;
	CODE:
	bartyp (s);

void
Dislin_barwth (x)
	double x;
	CODE:
	barwth (x);

void
Dislin_basalf (s)
	char *s;
	CODE:
	basalf (s);

void
Dislin_basdat (i1, i2, i3)
	int i1;
        int i2;
        int i3;
	CODE:
        basdat (i1, i2, i3);

void
Dislin_bezier (x1ray, x2ray, n, x3ray, x4ray, npt)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
        int n;
	AV * x3ray = (AV *)SvRV(ST(3));
	AV * x4ray = (AV *)SvRV(ST(4));
	int npt;
        CODE:
        double *p1, *p2, *p3, *p4;

        p1 = arraytofloat (x1ray, n);
        p2 = arraytofloat (x2ray, n);

        New (1, p3, npt, double);
        New (1, p4, npt, double);

        if (p1 != NULL && p2 != NULL && p3 != NULL && p4 != NULL)
        { bezier (p1, p2, n, p3, p4, npt);
          floattoarray (p3, x3ray, npt);
          floattoarray (p4, x4ray, npt);
        }

        Safefree (p1);
        Safefree (p2);
        Safefree (p3);
        Safefree (p4);

short
Dislin_bitsi2 (i1, i2, i3, i4, i5)
	int i1;
	short i2;
	int i3;
	short i4;
	int i5;
        CODE:
        RETVAL = bitsi2 (i1, i2, i3, i4, i5);
        OUTPUT:
        RETVAL

int
Dislin_bitsi4 (i1, i2, i3, i4, i5)
	int i1;
	int i2;
	int i3;
	int i4;
	int i5;
        CODE:
        RETVAL = bitsi4 (i1, i2, i3, i4, i5);
        OUTPUT:
        RETVAL

void
Dislin_bmpfnt (s)
	char *s;
	CODE:
	bmpfnt (s);

void
Dislin_bmpmod (i1, s1, s2)
	int i1;
	char *s1;
	char *s2;
	CODE:
	bmpmod (i1, s1, s2);

void
Dislin_box2d ()
	CODE:
	box2d ();

void
Dislin_box3d ()
	CODE:
	box3d ();

void
Dislin_bufmod (s1, s2)
	char *s1;
	char *s2;
	CODE:
	bufmod (s1, s2);

void
Dislin_center ()
	CODE:
	center ();

void
Dislin_cgmbgd (x1, x2, x3)
	double x1;
	double x2;
	double x3;
	CODE:
	cgmbgd (x1, x2, x3);

void
Dislin_cgmpic (s)
	char *s;
	CODE:
	cgmpic (s);

void
Dislin_cgmver (i)
	int i;
	CODE:
	cgmver (i);

void
Dislin_chaang (x)
	double x;
	CODE:
	chaang (x);

void
Dislin_chacod (s)
	char *s;
	CODE:
	chacod (s);

void
Dislin_chaspc (x)
	double x;
	CODE:
	chaspc (x);

void
Dislin_chawth (x)
	double x;
	CODE:
	chawth (x);

void
Dislin_chnatt ()
	CODE:
	chnatt ();

void
Dislin_chncrv (s)
	char *s;
	CODE:
	chncrv (s);

void
Dislin_chndot ()
	CODE:
	chndot ();

void
Dislin_chndsh ()
	CODE:
	chndsh ();

void
Dislin_chnbar (s)
	char *s;
	CODE:
	chnbar (s);

void
Dislin_chnpie (s)
	char *s;
	CODE:
	chnpie (s);

void
Dislin_circle (i1, i2, i3)
	int i1;
	int i2;
	int i3;
	CODE:
	circle (i1, i2, i3);

void
Dislin_circsp (i)
	int i;
	CODE:
	circsp (i);

void
Dislin_clip3d (s)
	char *s;
	CODE:
	clip3d (s);

int
Dislin_closfl (i)
	int i;
        CODE:
        RETVAL = closfl (i);
        OUTPUT:
        RETVAL

void
Dislin_clpbor (s)
	char *s;
	CODE:
	clpbor (s);

void
Dislin_clpmod (s)
	char *s;
	CODE:
	clpmod (s);

void
Dislin_clpwin (i1, i2, i3, i4)
	int i1;
        int i2;
        int i3;
        int i4;
	CODE:
        clpwin (i1, i2, i3, i4);

void
Dislin_clrcyc (i1, i2)
	int i1;
	int i2;
	CODE:
	clrcyc (i1, i2);

void
Dislin_clrmod (s)
	char *s;
	CODE:
	clrmod (s);

void
Dislin_clswin (i)
	int i;
	CODE:
	clswin (i);

void
Dislin_color (s)
	char *s;
	CODE:
	color (s);

void
Dislin_colran (i1, i2)
	int i1;
	int i2;
	CODE:
	colran (i1, i2);

void
Dislin_colray (x1ray, n1ray, n)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * n1ray = (AV *)SvRV(ST(1));
        int n;
        CODE:
        double *p1;
        int *p2;

        p1 = arraytofloat (x1ray, n);
        New (1, p2, n,  int);

        if (p1 != NULL && p2 != NULL)
        { colray (p1, p2, n);
          inttoarray (p2, n1ray, n);
        }

        Safefree (p1);
        Safefree (p2);

void 
Dislin_complx ()
	CODE:
        complx ();

void
Dislin_circ3p (x1, y1, x2, y2, x3, y3, xm, ym, r)
	double x1;
	double y1;
	double x2;
	double y2;
	double x3;
	double y3;
	double xm;
	double ym;
        double r;
        CODE:
        double xxm, yym, rr;
        circ3p (x1, y1, x2, y2, x3, y3, &xxm, &yym, &rr);
        xm = xxm;
        ym = yym;
        r  = rr;
        OUTPUT:
        xm
        ym
        r

void
Dislin_conclr (n1ray, n)
	AV * n1ray = (AV *)SvRV(ST(0));
        int n;
        CODE:
        int *p1;

        p1 = arraytoint (n1ray, n);
        if (p1 != NULL) conclr (p1, n);
        Safefree (p1);

void
Dislin_concrv (x1ray, x2ray, n, zlev)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
        int n;
        double zlev;
        CODE:
        double *p1, *p2;

        p1 = arraytofloat (x1ray, n);
        p2 = arraytofloat (x2ray, n);
        if (p1 != NULL && p2 != NULL) concrv (p1, p2, n, zlev);
        Safefree (p1);
        Safefree (p2);

void
Dislin_cone3d (x1, x2, x3, x4, x5, x6, i1, i2)
	double x1;
	double x2;
	double x3;
	double x4;
        double x5;
        double x6;
        int i1;
        int i2;
	CODE:
	cone3d (x1, x2, x3, x4, x5, x6, i1, i2);

void
Dislin_confll (x1ray, x2ray, x3ray, n, n1ray, n2ray, n3ray, ntri, x4ray, nlev)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
	AV * x3ray = (AV *)SvRV(ST(2));
        int n;
	AV * n1ray = (AV *)SvRV(ST(4));
	AV * n2ray = (AV *)SvRV(ST(5));
	AV * n3ray = (AV *)SvRV(ST(6));
        int ntri;
	AV * x4ray = (AV *)SvRV(ST(8));
        int nlev;
        CODE:
        double *p1, *p2, *p3, *p7;
        int *p4, *p5, *p6;

        p1 = arraytofloat (x1ray, n);
        p2 = arraytofloat (x2ray, n);
        p3 = arraytofloat (x3ray, n);
        p4 = arraytoint (n1ray, ntri);
        p5 = arraytoint (n2ray, ntri);
        p6 = arraytoint (n3ray, ntri);
        p7 = arraytofloat (x4ray, nlev);

        if (p1 != NULL && p2 != NULL && p3 != NULL && p4 != NULL &&
            p5 != NULL && p6 != NULL && p7 != NULL)
          confll (p1, p2, p3, n, p4, p5, p6, ntri, p7, nlev);

        Safefree (p1);
        Safefree (p2);
        Safefree (p3);
        Safefree (p4);
        Safefree (p5);
        Safefree (p6);
        Safefree (p7);

void
Dislin_congap (x)
	double x;
	CODE:
	congap (x);

void
Dislin_conlab (s)
	char *s;
	CODE:
	conlab (s);

void
Dislin_conmat (x1ray, nx, ny, zlev)
	AV * x1ray = (AV *)SvRV(ST(0));
        int nx;
	int ny;
	double zlev;
        CODE:
        double *p1;

        p1 = matrixtofloat (x1ray, nx, ny);
        if (p1 != NULL) conmat (p1, nx, ny, zlev);
        Safefree (p1);

void
Dislin_conmod (x1, x2)
	double x1;
	double x2;
	CODE:
	conmod (x1, x2);

void
Dislin_conn3d (x1, x2, x3)
	double x1;
	double x2;
	double x3;
	CODE:
	conn3d (x1, x2, x3);

void
Dislin_connpt (x1, x2)
	double x1;
	double x2;
	CODE:
	connpt (x1, x2);

int
Dislin_conpts (x1ray, nx, x2ray, ny, xmat, zlev, xpts, ypts, maxpts, nray, maxray)
	AV * x1ray = (AV *)SvRV(ST(0));
        int nx;
	AV * x2ray = (AV *)SvRV(ST(2));
	int ny;
	AV * xmat = (AV *)SvRV(ST(4));
        double zlev;
	AV * xpts = (AV *)SvRV(ST(6));
	AV * ypts = (AV *)SvRV(ST(7));
        int maxpts;
	AV * nray = (AV *)SvRV(ST(9));
        int maxray;
        CODE:
        int i, n, *p6, nlins;
        double *p1, *p2, *p3, *p4, *p5;

        p1 = arraytofloat (x1ray, nx);
        p2 = arraytofloat (x2ray, ny);
        p3 = matrixtofloat (xmat, nx, ny);

        New (1, p4, maxpts, double);
        New (1, p5, maxpts, double);
        New (1, p6, maxray, int);

        if (p1 != NULL && p2 != NULL && p3 != NULL &&
            p4 != NULL && p5 != NULL && p6 != NULL) 
        { conpts (p1, nx, p2, ny, p3, zlev, p4, p5, maxpts, p6, 
                  maxray, &nlins);
          n = 0; 
          for (i = 0; i < nlins; i++)
             n += p6[i];

          floattoarray (p4, xpts, n);
          floattoarray (p5, ypts, n);
          inttoarray (p6, nray, nlins);
        }

        Safefree (p1);
        Safefree (p2);
        Safefree (p3);
        Safefree (p4);
        Safefree (p5);
        Safefree (p6);
        RETVAL = nlins;
        OUTPUT:
        RETVAL

void
Dislin_conshd (x1ray, nx, x2ray, ny, xmat, zlray, nlev)
	AV * x1ray = (AV *)SvRV(ST(0));
        int nx;
	AV * x2ray = (AV *)SvRV(ST(2));
	int ny;
	AV * xmat = (AV *)SvRV(ST(4));
	AV * zlray = (AV *)SvRV(ST(5));
        int nlev;
        CODE:
        double *p1, *p2, *p3, *p4;

        p1 = arraytofloat (x1ray, nx);
        p2 = arraytofloat (x2ray, ny);
        p3 = matrixtofloat (xmat, nx, ny);
        p4 = arraytofloat (zlray, nlev);

        if (p1 != NULL && p2 != NULL && p3 != NULL && p4 != NULL) 
          conshd (p1, nx, p2, ny, p3, p4, nlev);

        Safefree (p1);
        Safefree (p2);
        Safefree (p3);
        Safefree (p4);

void
Dislin_conshd2 (xmat, ymat, zmat, nx, ny, zlray, nlev)
	AV * xmat = (AV *)SvRV(ST(0));
	AV * ymat = (AV *)SvRV(ST(1));
	AV * zmat = (AV *)SvRV(ST(2));
        int nx;
	int ny;
	AV * zlray = (AV *)SvRV(ST(5));
        int nlev;
        CODE:
        double *p1, *p2, *p3, *p4;

        p1 = matrixtofloat (xmat, nx, ny);
        p2 = matrixtofloat (ymat, nx, ny);
        p3 = matrixtofloat (zmat, nx, ny);
        p4 = arraytofloat  (zlray, nlev);

        if (p1 != NULL && p2 != NULL && p3 != NULL && p4 != NULL) 
          conshd2 (p1, p2, p3, nx, ny, p4, nlev);

        Safefree (p1);
        Safefree (p2);
        Safefree (p3);
        Safefree (p4);

void
Dislin_conshd3d (x1ray, nx, x2ray, ny, xmat, zlray, nlev)
	AV * x1ray = (AV *)SvRV(ST(0));
        int nx;
	AV * x2ray = (AV *)SvRV(ST(2));
	int ny;
	AV * xmat = (AV *)SvRV(ST(4));
	AV * zlray = (AV *)SvRV(ST(5));
        int nlev;
        CODE:
        double *p1, *p2, *p3, *p4;

        p1 = arraytofloat (x1ray, nx);
        p2 = arraytofloat (x2ray, ny);
        p3 = matrixtofloat (xmat, nx, ny);
        p4 = arraytofloat (zlray, nlev);

        if (p1 != NULL && p2 != NULL && p3 != NULL && p4 != NULL) 
          conshd3d (p1, nx, p2, ny, p3, p4, nlev);

        Safefree (p1);
        Safefree (p2);
        Safefree (p3);
        Safefree (p4);

void
Dislin_contri (x1ray, x2ray, x3ray, n, n1ray, n2ray, n3ray, ntri, zlev)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
	AV * x3ray = (AV *)SvRV(ST(2));
        int n;
	AV * n1ray = (AV *)SvRV(ST(4));
	AV * n2ray = (AV *)SvRV(ST(5));
	AV * n3ray = (AV *)SvRV(ST(6));
        int ntri;
        double zlev;
        CODE:
        double *p1, *p2, *p3;
        int *p4, *p5, *p6;

        p1 = arraytofloat (x1ray, n);
        p2 = arraytofloat (x2ray, n);
        p3 = arraytofloat (x3ray, n);
        p4 = arraytoint (n1ray, ntri);
        p5 = arraytoint (n2ray, ntri);
        p6 = arraytoint (n3ray, ntri);

        if (p1 != NULL && p2 != NULL && p3 != NULL &&
            p4 != NULL && p5 != NULL && p6 != NULL)
          contri (p1, p2, p3, n, p4, p5, p6, ntri, zlev);

        Safefree (p1);
        Safefree (p2);
        Safefree (p3);
        Safefree (p4);
        Safefree (p5);
        Safefree (p6);

void
Dislin_contur (x1ray, nx, x2ray, ny, xmat, zlev)
	AV * x1ray = (AV *)SvRV(ST(0));
        int nx;
	AV * x2ray = (AV *)SvRV(ST(2));
	int ny;
	AV * xmat = (AV *)SvRV(ST(4));
        double zlev;
        CODE:
        double *p1, *p2, *p3;

        p1 = arraytofloat (x1ray, nx);
        p2 = arraytofloat (x2ray, ny);
        p3 = matrixtofloat (xmat, nx, ny);

        if (p1 != NULL && p2 != NULL && p3 != NULL)
          contur (p1, nx, p2, ny, p3, zlev);

        Safefree (p1);
        Safefree (p2);
        Safefree (p3);

void
Dislin_contur2 (xmat, ymat, zmat, nx, ny, zlev)
	AV * xmat = (AV *)SvRV(ST(0));
	AV * ymat = (AV *)SvRV(ST(1));
	AV * zmat = (AV *)SvRV(ST(2));
        int nx;
	int ny;
        double zlev;
        CODE:
        double *p1, *p2, *p3;

        p1 = matrixtofloat (xmat, nx, ny);
        p2 = matrixtofloat (ymat, nx, ny);
        p3 = matrixtofloat (zmat, nx, ny);

        if (p1 != NULL && p2 != NULL && p3 != NULL)
          contur2 (p1, p2, p3, nx, ny, zlev);

        Safefree (p1);
        Safefree (p2);
        Safefree (p3);

void
Dislin_cross ()
	CODE:
	cross ();

void
Dislin_crvmat (x1ray, nx, ny, ixpts, iypts)
	AV * x1ray = (AV *)SvRV(ST(0));
        int nx;
	int ny;
	int ixpts;
	int iypts;
        CODE:
        double *p1;

        p1 = matrixtofloat (x1ray, nx, ny);
        if (p1 != NULL) crvmat (p1, nx, ny, ixpts, iypts);
        Safefree (p1);

void
Dislin_crvqdr (x1ray, x2ray, x3ray, n)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
	AV * x3ray = (AV *)SvRV(ST(2));
        int n;
        CODE:
        double *p1, *p2, *p3;

        p1 = arraytofloat (x1ray, n);
        p2 = arraytofloat (x2ray, n);
        p3 = arraytofloat (x3ray, n);

        if (p1 != NULL && p2 != NULL && p3 != NULL)
          crvqdr (p1, p2, p3, n);

        Safefree (p1);
        Safefree (p2);
        Safefree (p3);

void
Dislin_crvt3d (x1ray, x2ray, x3ray, x4ray, n1ray, n)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
	AV * x3ray = (AV *)SvRV(ST(2));
	AV * x4ray = (AV *)SvRV(ST(3));
	AV * n1ray = (AV *)SvRV(ST(4));
        int n;
        CODE:
        double *p1, *p2, *p3, *p4;
        int *p5;

        p1 = arraytofloat (x1ray, n);
        p2 = arraytofloat (x2ray, n);
        p3 = arraytofloat (x3ray, n);
        p4 = arraytofloat (x4ray, n);
        p5 = arraytoint (n1ray, n);


        if (p1 != NULL && p2 != NULL && p3 != NULL && p4 != NULL &&
            p5 != NULL)
          crvt3d (p1, p2, p3, p4, p5, n);

        Safefree (p1);
        Safefree (p2);
        Safefree (p3);
        Safefree (p4);
        Safefree (p5);

void
Dislin_crvtri (x1ray, x2ray, x3ray, n, n1ray, n2ray, n3ray, ntri)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
	AV * x3ray = (AV *)SvRV(ST(2));
        int n;
	AV * n1ray = (AV *)SvRV(ST(4));
	AV * n2ray = (AV *)SvRV(ST(5));
	AV * n3ray = (AV *)SvRV(ST(6));
        int ntri;
        CODE:
        double *p1, *p2, *p3;
        int *p4, *p5, *p6;

        p1 = arraytofloat (x1ray, n);
        p2 = arraytofloat (x2ray, n);
        p3 = arraytofloat (x3ray, n);
        p4 = arraytoint (n1ray, ntri);
        p5 = arraytoint (n2ray, ntri);
        p6 = arraytoint (n3ray, ntri);

        if (p1 != NULL && p2 != NULL && p3 != NULL && p4 != NULL &&
            p5 != NULL && p6 != NULL)
          crvtri (p1, p2, p3, n, p4, p5, p6, ntri);

        Safefree (p1);
        Safefree (p2);
        Safefree (p3);
        Safefree (p4);
        Safefree (p5);
        Safefree (p6);

void
Dislin_csrlin (i1, i2, i3, i4)
	int i1;
	int i2;
	int i3;
	int i4;
        CODE:
        int j1, j2, j3, j4;
        csrlin (&j1, &j2, &j3, &j4);
        i1 = j1;
        i2 = j2;
        i3 = j3;
        i4 = j4;
        OUTPUT:
        i1
        i2
        i3
        i4

void
Dislin_csrmod (s1, s2)
	char *s1;
	char *s2;
	CODE:
	csrmod (s1, s2);

void
Dislin_csrmov (n1ray, n2ray, nmax, n, iret)
	AV * n1ray = (AV *)SvRV(ST(0));
	AV * n2ray = (AV *)SvRV(ST(1));
        int nmax;
        int n;
        int iret;
        CODE:
        int nn, irr;
        int *p1, *p2;
        New (1, p1, nmax, int);
        New (1, p2, nmax, int);

        if (p1 != NULL && p2 != NULL)
        { csrmov (p1, p2, nmax, &nn, &irr);
          inttoarray (p1, n1ray, nn);
          inttoarray (p2, n2ray, nn);
        }

        Safefree (p1);
        Safefree (p2);
        n = nn;
        iret = irr;
        OUTPUT:
        n
        iret
       
void
Dislin_csrpt1 (i1, i2)
	int i1;
	int i2;
        CODE:
        int j1, j2;
        csrpt1 (&j1, &j2);
        i1 = j1;
        i2 = j2;
        OUTPUT:
        i1
        i2

void
Dislin_csrrec (i1, i2, i3, i4)
	int i1;
	int i2;
	int i3;
	int i4;
        CODE:
        int j1, j2, j3, j4;
        csrrec (&j1, &j2, &j3, &j4);
        i1 = j1;
        i2 = j2;
        i3 = j3;
        i4 = j4;
        OUTPUT:
        i1
        i2
        i3
        i4

int
Dislin_csrpos (i1, i2)
        int i1;
        int i2;
        CODE:
        int j1, j2;
        j1 = i1;
        j2 = i2; 
        RETVAL = csrpos (&j1, &j2);
        i1 = j1;
        i2 = j2;
        OUTPUT:
        i1
        i2 
        RETVAL

int
Dislin_csrkey ()
        CODE:
        RETVAL = csrkey ();
        OUTPUT:
        RETVAL

void
Dislin_csrpol (n1ray, n2ray, nmax, n, iret)
	AV * n1ray = (AV *)SvRV(ST(0));
	AV * n2ray = (AV *)SvRV(ST(1));
        int nmax;
        int n;
        int iret;
        CODE:
        int nn, irr;
        int *p1, *p2;

        New (1, p1, nmax, int);
        New (1, p2, nmax, int);

        if (p1 != NULL && p2 != NULL)
        { csrpol (p1, p2, nmax, &nn, &irr);
          inttoarray (p1, n1ray, nn);
          inttoarray (p2, n2ray, nn);
        }

        Safefree (p1);
        Safefree (p2);
        n = nn;
        iret = irr;
        OUTPUT:
        n
        iret

void
Dislin_csrpts (n1ray, n2ray, nmax, n, iret)
	AV * n1ray = (AV *)SvRV(ST(0));
	AV * n2ray = (AV *)SvRV(ST(1));
        int nmax;
        int n;
        int iret;
        CODE:
        int nn, irr;
        int *p1, *p2;

        New (1, p1, nmax, int);
        New (1, p2, nmax, int);

        if (p1 != NULL && p2 != NULL)
        { csrpts (p1, p2, nmax, &nn, &irr);
          inttoarray (p1, n1ray, nn);
          inttoarray (p2, n2ray, nn);
        }

        Safefree (p1);
        Safefree (p2);
        n = nn;
        iret = irr;
        OUTPUT:
        n
        iret

void
Dislin_csrtyp (s)
	char *s;
	CODE:
	csrtyp (s);
       
void
Dislin_csruni (s)
	char *s;
	CODE:
	csruni (s);

void
Dislin_curv3d (x1ray, x2ray, x3ray, n)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
	AV * x3ray = (AV *)SvRV(ST(2));
        int n;
        CODE:
        double *p1, *p2, *p3;

        p1 = arraytofloat (x1ray, n);
        p2 = arraytofloat (x2ray, n);
        p3 = arraytofloat (x3ray, n);

        if (p1 != NULL && p2 != NULL && p3 != NULL)
          curv3d (p1, p2, p3, n);

        Safefree (p1);
        Safefree (p2);
        Safefree (p3);

void
Dislin_curv4d (x1ray, x2ray, x3ray, x4ray, n)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
	AV * x3ray = (AV *)SvRV(ST(2));
	AV * x4ray = (AV *)SvRV(ST(3));
        int n;
        CODE:
        double *p1, *p2, *p3, *p4;

        p1 = arraytofloat (x1ray, n);
        p2 = arraytofloat (x2ray, n);
        p3 = arraytofloat (x3ray, n);
        p4 = arraytofloat (x4ray, n);

        if (p1 != NULL && p2 != NULL && p3 != NULL && p4 != NULL)
          curv4d (p1, p2, p3, p4, n);

        Safefree (p1);
        Safefree (p2);
        Safefree (p3);
        Safefree (p4);

void
Dislin_curve (x1ray, x2ray, n)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
        int n;
        CODE:
        double *p1, *p2;

        p1 = arraytofloat  (x1ray, n);
        p2 = arraytofloat  (x2ray, n);
        if (p1 != NULL && p2 != NULL) curve (p1, p2, n);
        Safefree (p1);
        Safefree (p2);

void
Dislin_curve3 (x1ray, x2ray, x3ray, n)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
	AV * x3ray = (AV *)SvRV(ST(2));
        int n;
        CODE:
        double *p1, *p2, *p3;

        p1 = arraytofloat  (x1ray, n);
        p2 = arraytofloat  (x2ray, n);
        p3 = arraytofloat  (x3ray, n);
        if (p1 != NULL && p2 != NULL && p3 != NULL)
          curve3 (p1, p2, p3, n);
        Safefree (p1);
        Safefree (p2);
        Safefree (p3);

void
Dislin_curvmp (x1ray, x2ray, n)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
        int n;
        CODE:
        double *p1, *p2;

        p1 = arraytofloat  (x1ray, n);
        p2 = arraytofloat  (x2ray, n);
        if (p1 != NULL && p2 != NULL)
          curvmp (p1, p2, n);
        Safefree (p1);
        Safefree (p2);

void
Dislin_curvx3 (x1ray, y, x2ray, n)
	AV * x1ray = (AV *)SvRV(ST(0));
        double y;
	AV * x2ray = (AV *)SvRV(ST(2));
        int n;
        CODE:
        double *p1, *p2;

        p1 = arraytofloat  (x1ray, n);
        p2 = arraytofloat  (x2ray, n);
        if (p1 != NULL && p2 != NULL)
          curvx3 (p1, y, p2, n);
        Safefree (p1);
        Safefree (p2);

void
Dislin_curvy3 (x, x1ray, x2ray, n)
	double x;
	AV * x1ray = (AV *)SvRV(ST(1));
	AV * x2ray = (AV *)SvRV(ST(2));
        int n;
        CODE:
        double *p1, *p2;

        p1 = arraytofloat  (x1ray, n);
        p2 = arraytofloat  (x2ray, n);
        if (p1 != NULL && p2 != NULL)
          curvy3 (x, p1, p2, n);
        Safefree (p1);
        Safefree (p2);

void
Dislin_cyli3d (x1, x2, x3, x4, x5, i1, i2)
	double x1;
	double x2;
	double x3;
	double x4;
        double x5;
        int i1;
        int i2;
	CODE:
	cyli3d (x1, x2, x3, x4, x5, i1, i2);

void
Dislin_dash ()
	CODE:
	dash ();

void
Dislin_dashl ()
	CODE:
	dashl ();

void
Dislin_dashm ()
	CODE:
	dashm ();

void
Dislin_dbffin ()
	CODE:
        dbffin ();      

int
Dislin_dbfini ()
        CODE:
        RETVAL = dbfini ();
        OUTPUT:
        RETVAL

void
Dislin_dbfmod (s)
	char *s;
	CODE:
	dbfmod (s);

void
Dislin_delglb ()
	CODE:
        delglb ();      

void
Dislin_digits (i, s)
	int i;
	char *s;
	CODE:
	digits (i, s);

void
Dislin_disalf ()
	CODE:
	disalf ();

void
Dislin_disenv (s)
	char *s;
	CODE:
	disenv (s);

void
Dislin_disfin ()
	CODE:
        disfin ();      

void
Dislin_disini ()
	CODE:
        disini ();
        nspline = 200;      

void
Dislin_disk3d (x1, x2, x3, x4, x5, i1, i2)
	double x1;
	double x2;
	double x3;
	double x4;
        double x5;
        int i1;
        int i2;
	CODE:
	disk3d (x1, x2, x3, x4, x5, i1, i2);

void
Dislin_doevnt ()
	CODE:
	doevnt ();

void
Dislin_dot ()
	CODE:
	dot ();

void
Dislin_dotl ()
	CODE:
	dotl ();

void
Dislin_duplx ()
	CODE:
	duplx ();

int
Dislin_dwgbut (s, i)
	char *s;
	int i;
        CODE:
        RETVAL = dwgbut (s, i);
        OUTPUT:
        RETVAL

int
Dislin_dwgerr ()
        CODE:
        RETVAL = dwgerr ();
        OUTPUT:
        RETVAL

char *
Dislin_dwgfil (s1, s2, s3)
	char *s1;
	char *s2;
	char *s3;
        CODE:
        RETVAL = dwgfil (s1, s2, s3);
        OUTPUT:
        RETVAL

int
Dislin_dwglis (s1, s2, i)
	char *s1;
	char *s2;
	int i;
        CODE:
        RETVAL = dwglis (s1, s2, i);
        OUTPUT:
        RETVAL

void
Dislin_dwgmsg (s)
	char *s;
	CODE:
	dwgmsg (s);

char *
Dislin_dwgtxt (s1, s2)
	char *s1;
	char *s2;
        CODE:
        RETVAL = dwgtxt (s1, s2);
        OUTPUT:
        RETVAL

void
Dislin_ellips (i1, i2, i3, i4)
	int i1;
        int i2;
        int i3;
        int i4;
	CODE:
        ellips (i1, i2, i3, i4);

void
Dislin_endgrf ()
	CODE:
	endgrf ();

void
Dislin_erase ()
	CODE:
	erase ();

void
Dislin_errbar (x1ray, x2ray, x3ray, x4ray, n)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
	AV * x3ray = (AV *)SvRV(ST(2));
	AV * x4ray = (AV *)SvRV(ST(3));
        int n;
        CODE:
        double *p1, *p2, *p3, *p4;

        p1 = arraytofloat (x1ray, n);
        p2 = arraytofloat (x2ray, n);
        p3 = arraytofloat (x3ray, n);
        p4 = arraytofloat (x4ray, n);

        if (p1 != NULL && p2 != NULL && p3 != NULL && p4 != NULL)
          errbar (p1, p2, p3, p4, n);

        Safefree (p1);
        Safefree (p2);
        Safefree (p3);
        Safefree (p4);

void
Dislin_errdev (s)
	char *s;
	CODE:
	errdev (s);

void
Dislin_errfil (s)
	char *s;
	CODE:
	errfil (s);

void
Dislin_errmod (s1, s2)
	char *s1;
	char *s2;
	CODE:
	errmod (s1, s2);

void
Dislin_eushft (s1, s2)
	char *s1;
	char *s2;
	CODE:
	eushft (s1, s2);

void
Dislin_expimg (s1, s2)
	char *s1;
	char *s2;
	CODE:
	expimg (s1, s2);

void
Dislin_expzlb (s)
	char *s;
	CODE:
	expzlb (s);

void
Dislin_fbars (x1ray, x2ray, x3ray, x4ray, x5ray, n)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
	AV * x3ray = (AV *)SvRV(ST(2));
	AV * x4ray = (AV *)SvRV(ST(3));
	AV * x5ray = (AV *)SvRV(ST(4));
        int n;
        CODE:
        double *p1, *p2, *p3, *p4, *p5;

        p1 = arraytofloat  (x1ray, n);
        p2 = arraytofloat  (x2ray, n);
        p3 = arraytofloat  (x3ray, n);
        p4 = arraytofloat  (x4ray, n);
        p5 = arraytofloat  (x5ray, n);
        if (p1 != NULL && p2 != NULL && p3 != NULL && p4 != NULL && p5 != NULL)
          fbars (p1, p2, p3, p4, p5, n);
        Safefree (p1);
        Safefree (p2);
        Safefree (p3);
        Safefree (p4);
        Safefree (p5);

char *
Dislin_fcha (x, i)
	double x;
	int i;
        CODE:
        int n;
	char s[41];
        n = fcha (x, i, s);
        RETVAL = s;
        OUTPUT:
        RETVAL

void
Dislin_field (x1ray, x2ray, x3ray, x4ray, n, ivec)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
	AV * x3ray = (AV *)SvRV(ST(2));
	AV * x4ray = (AV *)SvRV(ST(3));
        int n;
        int ivec;
        CODE:
        double *p1, *p2, *p3, *p4;

        p1 = arraytofloat (x1ray, n);
        p2 = arraytofloat (x2ray, n);
        p3 = arraytofloat (x3ray, n);
        p4 = arraytofloat (x4ray, n);

        if (p1 != NULL && p2 != NULL && p3 != NULL && p4 != NULL)
          field (p1, p2, p3, p4, n, ivec);

        Safefree (p1);
        Safefree (p2);
        Safefree (p3);
        Safefree (p4);

void
Dislin_field3d (x1ray, x2ray, x3ray, x4ray, x5ray, x6ray, n, ivec)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
	AV * x3ray = (AV *)SvRV(ST(2));
	AV * x4ray = (AV *)SvRV(ST(3));
	AV * x5ray = (AV *)SvRV(ST(4));
	AV * x6ray = (AV *)SvRV(ST(5));
        int n;
        int ivec;
        CODE:
        double *p1, *p2, *p3, *p4, *p5, *p6;

        p1 = arraytofloat (x1ray, n);
        p2 = arraytofloat (x2ray, n);
        p3 = arraytofloat (x3ray, n);
        p4 = arraytofloat (x4ray, n);
        p5 = arraytofloat (x5ray, n);
        p6 = arraytofloat (x6ray, n);

        if (p1 != NULL && p2 != NULL && p3 != NULL && 
            p4 != NULL && p5 != NULL && p6 != NULL)
          field3d (p1, p2, p3, p4, p5, p6, n, ivec);

        Safefree (p1);
        Safefree (p2);
        Safefree (p3);
        Safefree (p4);
        Safefree (p5);
        Safefree (p6);

void
Dislin_filbox (i1, i2, i3, i4)
	int i1;
        int i2;
        int i3;
        int i4;
	CODE:
        filbox (i1, i2, i3, i4);

void
Dislin_filclr (s)
	char *s;
	CODE:
	filclr (s);

void
Dislin_filmod (s)
	char *s;
	CODE:
	filmod (s);

void
Dislin_filopt (s1, s2)
	char *s1;
	char *s2;
	CODE:
	filopt (s1, s2);

int
Dislin_filsiz (s, i1, i2)
	char *s;
	int i1;
	int i2;
        CODE:
        int j1, j2;
        RETVAL = filsiz (s, &j1, &j2);
        i1 = j1;
        i2 = j2;
        OUTPUT:
        i1
        i2
        RETVAL

int
Dislin_filtyp (s)
	char *s;
        CODE:
        RETVAL = filtyp (s);
        OUTPUT:
        RETVAL

void
Dislin_filwin (i1, i2, i3, i4)
	int i1;
        int i2;
        int i3;
        int i4;
	CODE:
        filwin (i1, i2, i3, i4);

void
Dislin_fitscls ()
	CODE:
	fitscls ();

double
Dislin_fitsflt (s)
	char *s;
        CODE:
        RETVAL = fitsflt (s);
        OUTPUT:
        RETVAL

int
Dislin_fitshdu (i)
	int i;
        CODE:
        RETVAL = fitshdu (i);
        OUTPUT:
        RETVAL

int
Dislin_fitsimg (iray, nmax)
	AV * iray = (AV *)SvRV(ST(0));
        int nmax;
        CODE:
        char *p;
        int n;
        int i;

        p = NULL; 
        if (nmax != 0) 
        { New (1, p, nmax, char);
        }

        n = fitsimg ((unsigned char *) p, nmax);
        RETVAL = n;
        if (nmax != 0 && n > 0)
        { for (i = 0; i < n; i++)
             av_store(iray, i, newSViv ((int) p[i]));
        }  
        if (nmax != 0) Safefree (p);
        OUTPUT:
        RETVAL

int
Dislin_fitsopn (s)
	char *s;
        CODE:
        RETVAL = fitsopn (s);
        OUTPUT:
        RETVAL

char *
Dislin_fitsstr (s)
	char *s;
        CODE:
        char cstr[257];
        fitsstr (s, cstr, 257);
        RETVAL = cstr;
        OUTPUT:
        RETVAL

int
Dislin_fitstyp (s)
	char *s;
        CODE:
        RETVAL = fitstyp (s);
        OUTPUT:
        RETVAL

int
Dislin_fitsval (s)
	char *s;
        CODE:
        RETVAL = fitsval (s);
        OUTPUT:
        RETVAL

void
Dislin_fixspc (x)
	double x;
	CODE:
	fixspc (x);

void
Dislin_flab3d ()
	CODE:
	flab3d ();

int
Dislin_flen (x, i)
	double x;
	int i;
        CODE:
        RETVAL = flen (x, i);
        OUTPUT:
        RETVAL

void
Dislin_frame (i)
	int i;
	CODE:
	frame (i);

void
Dislin_freeptr (s)
	char *s;
	CODE:
	freeptr ((void *) s);

void
Dislin_frmclr (i)
	int i;
	CODE:
	frmclr (i);

void
Dislin_frmbar (i)
	int i;
	CODE:
	frmbar (i);

void
Dislin_frmess (i)
	int i;
	CODE:
	frmess (i);

void
Dislin_gapcrv (x)
	double x;
	CODE:
	gapcrv (x);

void
Dislin_gapsiz (x, s)
        double x;
	char *s;
	CODE:
	gapsiz (x, s);

void
Dislin_gaxpar (v1, v2, s1, s2, a, b, or, stp, ndig)
        double v1;
        double v2;
        char *s1;
        char *s2;
        double a;
        double b;
        double or;
        double stp;
        int ndig;
        CODE:
        double y1, y2, y3, y4;
        int n;
        gaxpar (v1, v2, s1, s2, &y1, &y2, &y3, &y4, &n);
        a = y1;
        b = y2;
        or = y3;
        stp = y4;
        ndig = n;
        OUTPUT:
        a
        b
        or
        stp
        ndig

char *
Dislin_getalf ()
        CODE:
        RETVAL = getalf ();
        OUTPUT:
        RETVAL

int
Dislin_getang ()
        CODE:
        RETVAL = getang ();
        OUTPUT:
        RETVAL

int
Dislin_getbpp ()
        CODE:
        RETVAL = getbpp ();
        OUTPUT:
        RETVAL

int
Dislin_getclr ()
        CODE:
        RETVAL = getclr ();
        OUTPUT:
        RETVAL

void
Dislin_getclp (i1, i2, i3, i4)
	int i1;
	int i2;
	int i3;
	int i4;
        CODE:
        int j1, j2, j3, j4;
        getclp (&j1, &j2, &j3, &j4);
        i1 = j1;
        i2 = j2;
        i3 = j3;
        i4 = j4;
        OUTPUT:
        i1
        i2
        i3
        i4

void
Dislin_getdig (i1, i2, i3)
	int i1;
	int i2;
	int i3;
        CODE:
        int j1, j2, j3;
        getdig (&j1, &j2, &j3);
        i1 = j1;
        i2 = j2;
        i3 = j3;
        OUTPUT:
        i1
        i2
        i3

char *
Dislin_getdsp ()
        CODE:
        RETVAL = getdsp ();
        OUTPUT:
        RETVAL

char *
Dislin_getfil ()
        CODE:
        RETVAL = getfil ();
        OUTPUT:
        RETVAL

void
Dislin_getgrf (x1, x2, x3, x4, s)
	double x1;
	double x2;
	double x3;
	double x4;
	char  *s;
        CODE:
        double y1, y2, y3, y4;
        getgrf (&y1, &y2, &y3, &y4, s);
        x1 = y1;
        x2 = y2;
        x3 = y3;
        x4 = y4;
        OUTPUT:
        x1
        x2
        x3
        x4

int
Dislin_gethgt ()
        CODE:
        RETVAL = gethgt ();
        OUTPUT:
        RETVAL

int
Dislin_gethnm ()
        CODE:
        RETVAL = gethnm ();
        OUTPUT:
        RETVAL

void
Dislin_getico (x, y, xp, yp)
	double x;
	double y;
	double xp;
	double yp;
        CODE:
        double xpt, ypt;
        getico (x, y, &xpt, &ypt);
        xp = xpt;
        yp = ypt;
        OUTPUT:
        xp
        yp

void
Dislin_getind (i, x1, x2, x3)
	int    i;
	double x1;
	double x2;
	double x3;
        CODE:
        double y1, y2, y3;
        getind (i, &y1, &y2, &y3);
        x1 = y1;
        x2 = y2;
        x3 = y3;
        OUTPUT:
        x1
        x2
        x3

void
Dislin_getlab (s1, s2, s3)
	char *s1;
	char *s2;
	char *s3;
        CODE:
        char t1[5], t2[5], t3[5];
        getlab (t1, t2, t3);
        sv_setpv((SV *) ST(0), t1);
        sv_setpv((SV *) ST(1), t2);
        sv_setpv((SV *) ST(2), t3);

void
Dislin_getlen (i1, i2, i3)
	int i1;
	int i2;
	int i3;
        CODE:
        int j1, j2, j3;
        getlen (&j1, &j2, &j3);
        i1 = j1;
        i2 = j2;
        i3 = j3;
        OUTPUT:
        i1
        i2
        i3

int
Dislin_getlev ()
        CODE:
        RETVAL = getlev ();
        OUTPUT:
        RETVAL

int
Dislin_getlin ()
        CODE:
        RETVAL = getlin ();
        OUTPUT:
        RETVAL

int
Dislin_getlit (xp, yp, zp, xn, yn, zn)
        double xp;
        double yp;
        double zp;
        double xn;
        double yn;
        double zn;
        CODE:
        RETVAL = getlit (xp, yp, zp, xn, yn, zn);
        OUTPUT:
        RETVAL

void
Dislin_getmat (x1ray, x2ray, x3ray, n, xmat, nx, ny, zval)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
	AV * x3ray = (AV *)SvRV(ST(2));
        int n;
	AV * xmat = (AV *)SvRV(ST(4));
	int nx;
        int ny;
        double zval;
        CODE:
        int *p5;
        double *p1, *p2, *p3, *p4, *p6;

        p1 = arraytofloat (x1ray, n);
        p2 = arraytofloat (x2ray, n);
        p3 = arraytofloat (x3ray, n);

        New (1, p4, nx * ny, double);
        New (1, p5, nx * ny, int);
        New (1, p6, nx * ny, double);

        if (p1 != NULL && p2 != NULL && p3 != NULL && 
            p4 != NULL && p5 != NULL && p6 != NULL)
        { getmat (p1, p2, p3, n, p4, nx, ny, zval, p5, p6);
          floattomatrix (p4, xmat, nx, ny);
        }

        Safefree (p1);
        Safefree (p2);
        Safefree (p3);
        Safefree (p4);
        Safefree (p5);
        Safefree (p6);

char *
Dislin_getmfl ()
        CODE:
        RETVAL = getmfl ();
        OUTPUT:
        RETVAL

char *
Dislin_getmix (s)
        char *s;
        CODE:
        RETVAL = getmix (s);
        OUTPUT:
        RETVAL

void
Dislin_getor (i1, i2)
	int i1;
	int i2;
        CODE:
        int j1, j2;
        getor (&j1, &j2);
        i1 = j1;
        i2 = j2;
        OUTPUT:
        i1
        i2

void
Dislin_getpag (i1, i2)
	int i1;
	int i2;
        CODE:
        int j1, j2;
        getpag (&j1, &j2);
        i1 = j1;
        i2 = j2;
        OUTPUT:
        i1
        i2

int
Dislin_getpat ()
        CODE:
        RETVAL = getpat ();
        OUTPUT:
        RETVAL

int
Dislin_getplv ()
        CODE:
        RETVAL = getplv ();
        OUTPUT:
        RETVAL

void
Dislin_getpos (i1, i2)
	int i1;
	int i2;
        CODE:
        int j1, j2;
        getpos (&j1, &j2);
        i1 = j1;
        i2 = j2;
        OUTPUT:
        i1
        i2

void
Dislin_getran (i1, i2)
	int i1;
	int i2;
        CODE:
        int j1, j2;
        getran (&j1, &j2);
        i1 = j1;
        i2 = j2;
        OUTPUT:
        i1
        i2

void
Dislin_getrco (x, y, xp, yp)
	double x;
	double y;
	double xp;
	double yp;
        CODE:
        double xpt, ypt;
        getrco (x, y, &xpt, &ypt);
        xp = xpt;
        yp = ypt;
        OUTPUT:
        xp
        yp

void
Dislin_getres (i1, i2)
	int i1;
	int i2;
        CODE:
        int j1, j2;
        getres (&j1, &j2);
        i1 = j1;
        i2 = j2;
        OUTPUT:
        i1
        i2

void
Dislin_getrgb (xr, xg, xb)
	double xr;
	double xg;
	double xb;
        CODE:
        double xrr, xgg, xbb;
        getrgb (&xrr, &xgg, &xbb);
        xr = xrr;
        xg = xgg;
        xb = xbb;
        OUTPUT:
        xr
        xg
        xb

void
Dislin_getscl (i1, i2, i3)
	int i1;
	int i2;
	int i3;
        CODE:
        int j1, j2, j3;
        getscl (&j1, &j2, &j3);
        i1 = j1;
        i2 = j2;
        i3 = j3;
        OUTPUT:
        i1
        i2
        i3

void
Dislin_getscm (i1, i2, i3)
	int i1;
	int i2;
	int i3;
        CODE:
        int j1, j2, j3;
        getscm (&j1, &j2, &j3);
        i1 = j1;
        i2 = j2;
        i3 = j3;
        OUTPUT:
        i1
        i2
        i3

void
Dislin_getscr (i1, i2)
	int i1;
	int i2;
        CODE:
        int j1, j2;
        getscr (&j1, &j2);
        i1 = j1;
        i2 = j2;
        OUTPUT:
        i1
        i2

char *
Dislin_getshf (s)
        char *s;
        CODE:
        RETVAL = getshf (s);
        OUTPUT:
        RETVAL

void
Dislin_getsp1 (i1, i2, i3)
	int i1;
	int i2;
	int i3;
        CODE:
        int j1, j2, j3;
        getsp1 (&j1, &j2, &j3);
        i1 = j1;
        i2 = j2;
        i3 = j3;
        OUTPUT:
        i1
        i2
        i3

void
Dislin_getsp2 (i1, i2, i3)
	int i1;
	int i2;
	int i3;
        CODE:
        int j1, j2, j3;
        getsp2 (&j1, &j2, &j3);
        i1 = j1;
        i2 = j2;
        i3 = j3;
        OUTPUT:
        i1
        i2
        i3

void
Dislin_getsym (i1, i2)
	int i1;
	int i2;
        CODE:
        int j1, j2;
        getsym (&j1, &j2);
        i1 = j1;
        i2 = j2;
        OUTPUT:
        i1
        i2

void
Dislin_gettcl (i1, i2)
	int i1;
	int i2;
        CODE:
        int j1, j2;
        gettcl (&j1, &j2);
        i1 = j1;
        i2 = j2;
        OUTPUT:
        i1
        i2

void
Dislin_gettic (i1, i2, i3)
	int i1;
	int i2;
	int i3;
        CODE:
        int j1, j2, j3;
        gettic (&j1, &j2, &j3);
        i1 = j1;
        i2 = j2;
        i3 = j3;
        OUTPUT:
        i1
        i2
        i3

int
Dislin_gettyp ()
        CODE:
        RETVAL = gettyp ();
        OUTPUT:
        RETVAL

int
Dislin_getuni ()
        CODE:
        FILE *fp;
        fp = (FILE *) getuni ();
        if (fp == NULL)
          RETVAL = 0;
        else 
          RETVAL = 6;  
        OUTPUT:
        RETVAL

double
Dislin_getver ()
        CODE:
        RETVAL = getver ();
        OUTPUT:
        RETVAL

void
Dislin_getvk (i1, i2, i3)
	int i1;
	int i2;
	int i3;
        CODE:
        int j1, j2, j3;
        getvk (&j1, &j2, &j3);
        i1 = j1;
        i2 = j2;
        i3 = j3;
        OUTPUT:
        i1
        i2
        i3

char *
Dislin_getvlt ()
        CODE:
        RETVAL = getvlt ();
        OUTPUT:
        RETVAL

int
Dislin_getwid ()
        CODE:
        RETVAL = getwid ();
        OUTPUT:
        RETVAL

void
Dislin_getwin (i1, i2, i3, i4)
	int i1;
	int i2;
	int i3;
	int i4;
        CODE:
        int j1, j2, j3, j4;
        getwin (&j1, &j2, &j3, &j4);
        i1 = j1;
        i2 = j2;
        i3 = j3;
        i4 = j4;
        OUTPUT:
        i1
        i2
        i3
        i4

int
Dislin_getxid (s)
	char *s;
        CODE:
        RETVAL = getxid (s);
        OUTPUT:
        RETVAL

void
Dislin_gifmod (s1, s2)
	char *s1;
	char *s2;
	CODE:
	gifmod (s1, s2);

int
Dislin_gmxalf (s1, s2, s3)
	char *s1;
	char *s2;
	char *s3;
        CODE:
        char t1[5], t2[5];
        RETVAL = gmxalf (s1, t1, t2);
        sv_setpv((SV *) ST(1), t1);
        sv_setpv((SV *) ST(2), t2);
        OUTPUT:
        RETVAL

void 
Dislin_gothic ()
	CODE:
        gothic ();

void
Dislin_grace (i)
	int i;
	CODE:
	grace (i);

void
Dislin_graf (xa, xe, xor, xstp, ya, ye, yor, ystp)
        double xa;
        double xe;
        double xor;
        double xstp;
        double ya;
        double ye;
        double yor;
        double ystp;
        CODE:
        graf (xa, xe, xor, xstp, ya, ye, yor, ystp);

void
Dislin_graf3 (xa, xe, xor, xstp, ya, ye, yor, ystp, za, ze, zor, zstp)
        double xa;
        double xe;
        double xor;
        double xstp;
        double ya;
        double ye;
        double yor;
        double ystp;
        double za;
        double ze;
        double zor;
        double zstp;
        CODE:
        graf3 (xa, xe, xor, xstp, ya, ye, yor, ystp, za, ze, zor, zstp);

void
Dislin_graf3d (xa, xe, xor, xstp, ya, ye, yor, ystp, za, ze, zor, zstp)
        double xa;
        double xe;
        double xor;
        double xstp;
        double ya;
        double ye;
        double yor;
        double ystp;
        double za;
        double ze;
        double zor;
        double zstp;
        CODE:
        graf3d (xa, xe, xor, xstp, ya, ye, yor, ystp, za, ze, zor, zstp);

void
Dislin_grafmp (xa, xe, xor, xstp, ya, ye, yor, ystp)
        double xa;
        double xe;
        double xor;
        double xstp;
        double ya;
        double ye;
        double yor;
        double ystp;
        CODE:
        grafmp (xa, xe, xor, xstp, ya, ye, yor, ystp);

void
Dislin_grffin ()
	CODE:
	grffin ();

void
Dislin_grfimg (s)
	char *s;
	CODE:
	grfimg (s);

void
Dislin_grfini (x1, y1, z1, x2, y2, z2, x3, y3, z3)
	double x1;
	double y1;
	double z1;
	double x2;
	double y2;
	double z2;
	double x3;
	double y3;
	double z3;
	CODE:
        grfini (x1, y1, z1, x2, y2, z2, x3, y3, z3);

void
Dislin_grdpol (i1, i2)
	int i1;
	int i2;
	CODE:
	grdpol (i1, i2);

void
Dislin_grid (i1, i2)
	int i1;
	int i2;
	CODE:
	grid (i1, i2);

void
Dislin_grid3d (i1, i2, s)
	int i1;
	int i2;
	char *s;
	CODE:
	grid3d (i1, i2, s);

void
Dislin_gridim (x1, x2, x3, i)
	double x1;
	double x2;
	double x3;
	int i;
	CODE:
	gridim (x1, x2, x3, i);

void
Dislin_gridmp (i1, i2)
	int i1;
	int i2;
	CODE:
	gridmp (i1, i2);

void
Dislin_gridre (x1, x2, x3, i)
	double x1;
	double x2;
	double x3;
	int i;
	CODE:
	gridre (x1, x2, x3, i);

int
Dislin_gwgatt (i, s)
	int i;
        char *s;
        CODE:
        RETVAL = gwgatt (i, s);
        OUTPUT:
        RETVAL

int
Dislin_gwgbox (i)
	int i;
        CODE:
        RETVAL = gwgbox (i);
        OUTPUT:
        RETVAL

int
Dislin_gwgbut (i)
	int i;
        CODE:
        RETVAL = gwgbut (i);
        OUTPUT:
        RETVAL

char *
Dislin_gwgfil (i)
	int i;
        CODE:
        char cstr[257];
        gwgfil (i, cstr);
        RETVAL = cstr;
        OUTPUT:
        RETVAL

double
Dislin_gwgflt (i)
	int i;
        CODE:
        RETVAL = gwgflt (i);
        OUTPUT:
        RETVAL

int
Dislin_gwggui ()
        CODE:
        RETVAL = gwggui ();
        OUTPUT:
        RETVAL

int
Dislin_gwgint (i)
	int i;
        CODE:
        RETVAL = gwgint (i);
        OUTPUT:
        RETVAL

int
Dislin_gwglis (i)
	int i;
        CODE:
        RETVAL = gwglis (i);
        OUTPUT:
        RETVAL

double
Dislin_gwgscl (i)
	int i;
        CODE:
        RETVAL = gwgscl (i);
        OUTPUT:
        RETVAL

void
Dislin_gwgsiz (i1, i2, i3)
	int i1;
	int i2;
	int i3;
        CODE:
        int j1, j2;
        gwgsiz (i1, &j1, &j2);
        i2 = j1;
        i3 = j2;
        OUTPUT:
        i2
        i3

double
Dislin_gwgtbf (i, irow, icol)
	int i;
        int irow;
        int icol;
        CODE:
        RETVAL = gwgtbf (i, irow, icol);
        OUTPUT:
        RETVAL

int
Dislin_gwgtbi (i, irow, icol)
	int i;
        int irow;
        int icol;
        CODE:
        RETVAL = gwgtbi (i, irow, icol);
        OUTPUT:
        RETVAL

void
Dislin_gwgtbl (id, xray, n, idx, s)
        int id;
	AV * xray = (AV *)SvRV(ST(1));
        int n;
        int idx;
        char *s;
        CODE:
        double *p1;

        New (1, p1, n, double);
        if (p1 != NULL) 
        { gwgtbl (id, p1, n, idx, s);
          floattoarray (p1, xray, n);
        }

        Safefree (p1);

char *
Dislin_gwgtbs (i, irow, icol)
	int i;
        int irow;
        int icol;
        CODE:
        char cstr[81];
        gwgtbs (i, irow, icol, cstr);
        RETVAL = cstr;
        OUTPUT:
        RETVAL

char *
Dislin_gwgtxt (i)
	int i;
        CODE:
        char cstr[257];
        gwgtxt (i, cstr);
        RETVAL = cstr;
        OUTPUT:
        RETVAL

int
Dislin_gwgxid (i)
	int i;
        CODE:
        RETVAL = gwgxid (i);
        OUTPUT:
        RETVAL

void
Dislin_height (i)
	int i;
	CODE:
	height (i);

void
Dislin_helve ()
	CODE:
	helve ();

void
Dislin_helves ()
	CODE:
	helves ();

void
Dislin_helvet ()
	CODE:
	helvet ();

void
Dislin_hidwin (i, s)
	int i;
	char *s;
	CODE:
	hidwin (i, s);

int
Dislin_histog (x1ray, n, x2ray, x3ray)
	AV * x1ray = (AV *)SvRV(ST(0));
        int n;
	AV * x2ray = (AV *)SvRV(ST(2));
	AV * x3ray = (AV *)SvRV(ST(3));
        CODE:
        int npt;
        double *p1, *p2, *p3;

        npt = 0;
        p1 = arraytofloat (x1ray, n);
        New (1, p2, n, double);
        New (1, p3, n, double);

        if (p1 != NULL && p2 != NULL && p3 != NULL)
        { histog (p1, n, p2, p3, &npt);
          floattoarray (p2, x2ray, npt);
          floattoarray (p3, x3ray, npt);
        }  

        RETVAL = npt;
        Safefree (p1);
        Safefree (p2);
        Safefree (p3);
        OUTPUT:
        RETVAL

void
Dislin_hname (i)
	int i;
	CODE:
	hname (i);

void
Dislin_hpgmod (s1, s2)
	char *s1;
	char *s2;
	CODE:
	hpgmod (s1, s2);

void
Dislin_hsvrgb (x, y, z, xp, yp, zp)
	double x;
	double y;
	double z;
	double xp;
	double yp;
	double zp;
        CODE:
        double xpt, ypt, zpt;
        hsvrgb (x, y, z, &xpt, &ypt, &zpt);
        xp = xpt;
        yp = ypt;
        zp = zpt;
        OUTPUT:
        xp
        yp
        zp

void
Dislin_hsym3d (x)
	double x;
	CODE:
	hsym3d (x);

void
Dislin_hsymbl (i)
	int i;
	CODE:
	hsymbl (i);

void
Dislin_htitle (i)
	int i;
	CODE:
	htitle (i);

void
Dislin_hwfont ()
	CODE:
	hwfont ();

void
Dislin_hwmode (s1, s2)
	char *s1;
	char *s2;
	CODE:
	hwmode (s1, s2);

void
Dislin_hworig (i1, i2)
	int i1;
	int i2;
	CODE:
	hworig (i1, i2);

void
Dislin_hwpage (i1, i2)
	int i1;
	int i2;
	CODE:
	hwpage (i1, i2);

void
Dislin_hwscal (x)
	double x;
	CODE:
	hwscal (x);

void
Dislin_imgbox (i1, i2, i3, i4)
	int i1;
        int i2;
        int i3;
        int i4;
	CODE:
        imgbox (i1, i2, i3, i4);

void
Dislin_imgclp (i1, i2, i3, i4)
	int i1;
        int i2;
        int i3;
        int i4;
	CODE:
        imgclp (i1, i2, i3, i4);

void
Dislin_imgfin ()
	CODE:
	imgfin ();

void
Dislin_imgfmt (s)
	char *s;
	CODE:
	imgfmt (s);

void
Dislin_imgini ()
	CODE:
	imgini ();

void
Dislin_imgmod (s)
	char *s;
	CODE:
	imgmod (s);
        imgop = 0;
        if (s[0] == 'r' || s[0] == 'R') imgop = 1;

void
Dislin_imgsiz (i1, i2)
	int i1;
	int i2;
	CODE:
	imgsiz (i1, i2);

void
Dislin_imgtpr (i)
	int i;
	CODE:
	imgtpr (i);

void
Dislin_inccrv (i)
	int i;
	CODE:
	inccrv (i);

int
Dislin_incdat (i1, i2, i3)
	int i1;
        int i2;
        int i3;
        CODE:
        RETVAL = incdat (i1, i2, i3);
        OUTPUT:
        RETVAL


void
Dislin_incfil (s)
	char *s;
	CODE:
	incfil (s);

void
Dislin_incmrk (i)
	int i;
	CODE:
	incmrk (i);

int
Dislin_indrgb (xr, xg, xb)
	double xr;
        double xg;
        double xb;
        CODE:
        RETVAL = indrgb (xr, xg, xb);
        OUTPUT:
        RETVAL

void
Dislin_intax ()
	CODE:
	intax ();

char *
Dislin_intcha (i)
	int i;
        CODE:
        char s[21];
        int n;
        n = intcha (i, s);
        RETVAL = s;
        OUTPUT:
        RETVAL

int
Dislin_intlen (i)
	int i;
        CODE:
        RETVAL = intlen (i);
        OUTPUT:
        RETVAL

int
Dislin_intrgb (xr, xg, xb)
	double xr;
        double xg;
        double xb;
        CODE:
        RETVAL = intrgb (xr, xg, xb);
        OUTPUT:
        RETVAL

int
Dislin_intutf (n1ray, nray, s, nmax)
	AV * n1ray = (AV *)SvRV(ST(0));
        int nray;
	char *s;
        int nmax;
        CODE:
        int *p1;
        char *p;
        int n;

        n = 0;
        p1 = arraytoint (n1ray, n);
        New (1, p, nmax, char);

        if (p1 != NULL && p != NULL) 
          n = intutf (p1, nray, p, nmax);
         
        RETVAL = n;
        if (n > 0)
        { sv_setpvn ((SV*) ST(2), p, n);
        }  

        Safefree (p1);
        Safefree (p);
        OUTPUT:
        RETVAL

int
Dislin_isopts (x1ray, nx, x2ray, ny, x3ray, nz, wmat, wlev, xtri, ytri, ztri, maxpts)
	AV * x1ray = (AV *)SvRV(ST(0));
        int nx;
	AV * x2ray = (AV *)SvRV(ST(2));
	int ny;
	AV * x3ray = (AV *)SvRV(ST(4));
	int nz;
	AV * wmat = (AV *)SvRV(ST(6));
        double wlev;
	AV * xtri = (AV *)SvRV(ST(8));
	AV * ytri = (AV *)SvRV(ST(9));
	AV * ztri = (AV *)SvRV(ST(10));
        int maxpts;
        CODE:
        int ntri;
        double *p1, *p2, *p3, *p4, *p5, *p6, *p7;

        p1 = arraytofloat (x1ray, nx);
        p2 = arraytofloat (x2ray, ny);
        p3 = arraytofloat (x3ray, nz);
        p4 = matrix3tofloat (wmat, nx, ny, nz);

        New (1, p5, maxpts, double);
        New (1, p6, maxpts, double);
        New (1, p7, maxpts, double);

        if (p1 != NULL && p2 != NULL && p3 != NULL && p4 != NULL &&
            p5 != NULL && p6 != NULL && p7 != NULL)
        { isopts (p1, nx, p2, ny, p3, nz, p4, wlev, p5, p6, p7, maxpts, 
                  &ntri); 
          floattoarray (p5, xtri, ntri);
          floattoarray (p6, ytri, ntri);
          floattoarray (p7, ztri, ntri);
        }

        Safefree (p1);
        Safefree (p2);
        Safefree (p3);
        Safefree (p4);
        Safefree (p5);
        Safefree (p6);
        Safefree (p7);

        RETVAL = ntri;
        OUTPUT:
        RETVAL

char *
Dislin_itmcat (s1, s2)
	char *s1;
	char *s2;
        CODE:
        int n1, n2;
        char *p;
        n1 = (int) strlen (s1);
        n2 = (int) strlen (s2);
        New (1, p, n1 + n2 + 2, char);
        strcpy (p, s1);
        itmcat (p, s2);
        RETVAL = p;
        Safefree (p);
        OUTPUT:
        RETVAL

char *
Dislin_itmncat (s1, nmx, s2)
	char *s1;
        int nmx;
	char *s2;
        CODE:
        int n1, n2;
        char *p;
        n1 = (int) strlen (s1);
        n2 = (int) strlen (s2);
        New (1, p, n1 + n2 + 2, char);
        strcpy (p, s1);
        itmncat (p, nmx, s2);
        RETVAL = p;
        Safefree (p);
        OUTPUT:
        RETVAL
        
int
Dislin_itmcnt (s)
	char *s;
        CODE:
        RETVAL = itmcnt (s);
        OUTPUT:
        RETVAL

char *
Dislin_itmstr (s, i)
	char *s;
	int i;
        CODE:
        RETVAL = itmstr (s, i);
        OUTPUT:
        RETVAL

void
Dislin_jusbar (s)
	char *s;
	CODE:
	jusbar (s);

void
Dislin_labclr (i, s)
	int i;
	char *s;
	CODE:
	labclr (i, s);

void
Dislin_labdig (i, s)
	int i;
	char *s;
	CODE:
	labdig (i, s);

void
Dislin_labdis (i, s)
	int i;
	char *s;
	CODE:
	labdis (i, s);

void
Dislin_labels (s1, s2)
	char *s1;
	char *s2;
	CODE:
	labels (s1, s2);

void
Dislin_labjus (s1, s2)
	char *s1;
	char *s2;
	CODE:
	labjus (s1, s2);

void
Dislin_labl3d (s1)
	char *s1;
	CODE:
	labl3d (s1);

void
Dislin_labmod (s1, s2, s3)
	char *s1;
	char *s2;
	char *s3;
	CODE:
	labmod (s1, s2, s3);

void
Dislin_labpos (s1, s2)
	char *s1;
	char *s2;
	CODE:
	labpos (s1, s2);

void
Dislin_labtyp (s1, s2)
	char *s1;
	char *s2;
	CODE:
	labtyp (s1, s2);

int
Dislin_ldimg (s1, iray, nmax, nc)
        char *s1; 
	AV * iray = (AV *)SvRV(ST(1));
        int nmax;
        int nc;
        CODE:
        unsigned char *q;
        short *p;
        int n;
        int i;

        p = NULL; 
        if (nmax != 0) 
        { New (1, p, nmax, short);
        }

        n = ldimg (s1, (unsigned short *) p, nmax, nc);
        if (nc == -1) n = n + n; 
        RETVAL = n;
        if (nmax != 0 && n > 0)
        { if (nc == -1)
          { q = (unsigned char *) p;
            for (i = 0; i < n; i++)
              av_store(iray, i, newSViv ((int) q[i]));
          }
          else 
          { for (i = 0; i < n; i++)
              av_store(iray, i, newSViv ((int) p[i]));
          }
        }  
        if (nmax != 0) Safefree (p);
        OUTPUT:
        RETVAL

void
Dislin_legbgd (i)
	int i;
	CODE:
	legbgd (i);

void
Dislin_legclr ()
	CODE:
	legclr ();

void
Dislin_legend (s, i)
	char *s;
	int i;
	CODE:
	legend (s, i);

void
Dislin_legini (s, i1, i2)
	char *s;
	int i1;
	int i2;
	CODE:
        int n;
        char *p;
        n = i1 * i2 + 1;
        New (1, p, n, char);
	legini (p, i1, i2);
        sv_setpvn((SV *) ST(0), p, n);
        Safefree (p);

void
Dislin_leglin (s1, s2, i)
	char *s1;
	char *s2;
	int i;
	CODE:
	leglin (s1, s2, i);
        OUTPUT:
        s1

void
Dislin_legopt (x1, x2, x3)
	double x1;
	double x2;
	double x3;
	CODE:
	legopt (x1, x2, x3);

void
Dislin_legpat (i1, i2, i3, i4, i5, i6)
	int i1;
	int i2;
	int i3;
	int i4;
	int i5;
	int i6;
	CODE:
	legpat (i1, i2, i3, i4, i5, i6);

void
Dislin_legpos (i1, i2)
	int i1;
	int i2;
	CODE:
	legpos (i1, i2);

void
Dislin_legsel (n1ray, n)
	AV * n1ray = (AV *)SvRV(ST(0));
        int n;
        CODE:
        int *p1 = NULL;

        if (n > 0) p1 = arraytoint (n1ray, n);
        if (p1 != NULL || n < 1) legsel (p1, n);
        if (n > 0) Safefree (p1);

void
Dislin_legtbl (i, s)
	int i;
	char *s;
	CODE:
	legtbl (i, s);

void
Dislin_legtit (s)
	char *s;
	CODE:
	legtit (s);

void
Dislin_legtyp (s)
	char *s;
	CODE:
	legtyp (s);

void
Dislin_legval (x, s)
        double x;
	char *s;
	CODE:
	legval (x, s);

void
Dislin_lfttit ()
	CODE:
	lfttit ();

void
Dislin_licmod (s1, s2)
	char *s1;
	char *s2;
	CODE:
	licmod (s1, s2);

void
Dislin_licpts (xmat, ymat, nx, ny, itmat, wmat)
	AV * xmat = (AV *)SvRV(ST(0));
	AV * ymat = (AV *)SvRV(ST(1));
        int nx;
	int ny;
	AV * itmat = (AV *)SvRV(ST(4));
	AV * wmat  = (AV *)SvRV(ST(5));
        CODE:
        double *p1, *p2, *p5;
        int *p3, *p4;

        p1 = matrixtofloat (xmat, nx, ny);
        p2 = matrixtofloat (ymat, nx, ny);
        p3 = matrixtoint   (itmat, nx, ny);

        New (1, p4, nx * ny, int);
        New (1, p5, nx * ny, double);

        if (p1 != NULL && p2 != NULL && p3 != NULL && p4 != NULL &&
            p5 != NULL)
        { licpts (p1, p2, nx, ny, p3, p4, p5);
          floattomatrix (p5, wmat, nx, ny);
        }

        Safefree (p1);
        Safefree (p2);
        Safefree (p3);
        Safefree (p4);
        Safefree (p5);

void
Dislin_light (s)
	char *s;
	CODE:
	light (s);

void
Dislin_linclr (n1ray, n)
	AV * n1ray = (AV *)SvRV(ST(0));
        int n;
        CODE:
        int *p1;

        p1 = arraytoint (n1ray, n);
        if (p1 != NULL) linclr (p1, n);
        Safefree (p1);

void
Dislin_lincyc (i1, i2)
	int i1;
	int i2;
	CODE:
	lincyc (i1, i2);

void
Dislin_line (i1, i2, i3, i4)
	int i1;
        int i2;
        int i3;
        int i4;
	CODE:
        line (i1, i2, i3, i4);

void
Dislin_linesp (x)
	double x;
	CODE:
	linesp (x);

void
Dislin_linfit (x1ray, x2ray, n, a, b, r, s)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
        int n;
        double a;
        double b;
        double r;
        char *s;
        CODE:
        double *p1, *p2, aa, bb, rr;
        p1 = arraytofloat  (x1ray, n);
        p2 = arraytofloat  (x2ray, n);
        if (p1 != NULL && p2 != NULL) linfit (p1, p2, n, &aa, &bb, &rr, s);
        Safefree (p1);
        Safefree (p2);
        a = aa;
        b = bb;
        r = rr;
        OUTPUT:
        a
        b
        r

void
Dislin_linmod (s1, s2)
	char *s1;
	char *s2;
	CODE:
	linmod (s1, s2);

void
Dislin_lintyp (i)
	int i;
	CODE:
	lintyp (i);

void
Dislin_linwid (i)
	int i;
	CODE:
	linwid (i);

void
Dislin_litmod (i, s)
        int i;
	char *s;
	CODE:
	litmod (i, s);

void
Dislin_litop3 (i, xr, xg, xb, s)
        int i;
        double xr;
        double xg;
        double xb;
	char *s;
	CODE:
	litop3(i, xr, xg, xb, s);

void
Dislin_litopt (i, x, s)
        int i;
        double x;
	char *s;
	CODE:
	litopt(i, x, s);

void
Dislin_litpos (i, x, y, z, s)
        int i;
        double x;
        double y;
        double z;
	char *s;
	CODE:
	litpos (i, x, y, z, s);

void
Dislin_lncap (s)
	char *s;
	CODE:
	lncap (s);

void
Dislin_lnjoin (s)
	char *s;
	CODE:
	lnjoin (s);

void
Dislin_lnmlt (x)
	double x;
	CODE:
	lnmlt (x);

void
Dislin_logtic (s)
	char *s;
	CODE:
	logtic (s);

void
Dislin_mapbas (s)
	char *s;
	CODE:
	mapbas (s);

void
Dislin_mapfil (s1, s2)
	char *s1;
	char *s2;
	CODE:
	mapfil (s1, s2);

void 
Dislin_mapimg (s1, x1, x2, x3, x4, x5, x6)  
        char *s1;
        double x1;
        double x2;
        double x3;
        double x4;
        double x5;
        double x6;
        CODE:
        mapimg (s1, x1, x2, x3, x4, x5, x6);
 
void
Dislin_maplab (s1, s2)
	char *s1;
	char *s2;
	CODE:
	maplab (s1, s2);

void
Dislin_maplev (s)
	char *s;
	CODE:
	maplev (s);

void
Dislin_mapmod (s)
	char *s;
	CODE:
	mapmod (s);

void
Dislin_mapopt (s1, s2)
	char *s1;
	char *s2;
	CODE:
	mapopt (s1, s2);

void
Dislin_mappol (x1, x2)
	double x1;
	double x2;
	CODE:
	mappol (x1, x2);

void
Dislin_mapref (x1, x2)
	double x1;
	double x2;
	CODE:
	mapref (x1, x2);

void
Dislin_mapsph (x)
	double x;
	CODE:
	mapsph (x);

void
Dislin_marker (i)
	int i;
	CODE:
	marker (i);

void
Dislin_matop3 (xr, xg, xb, s)
        double xr;
        double xg;
        double xb;
	char *s;
	CODE:
	matop3 (xr, xg, xb, s);

void
Dislin_matopt (x, s)
        double x;
	char *s;
	CODE:
	matopt (x, s);

void
Dislin_mdfmat (i1, i2, x)
	int i1;
	int i2;
	double x;
	CODE:
	mdfmat (i1, i2, x);

void
Dislin_messag (cstr, nx, ny)
	char *cstr;
	int  nx;
	int  ny;
	CODE:
	messag (cstr, nx, ny);

void 
Dislin_metafl (s)
	char *s;
	CODE:
        metafl (s);

void
Dislin_mixalf ()
	CODE:
	mixalf ();

void
Dislin_mixleg ()
	CODE:
	mixleg ();

void
Dislin_mpaepl (i)
	int i;
	CODE:
	mpaepl (i);

void
Dislin_mplang (x)
	double x;
	CODE:
	mplang (x);

void
Dislin_mplclr (i1, i2)
	int i1;
	int i2;
	CODE:
	mplclr (i1, i2);

void
Dislin_mplpos (i1, i2)
	int i1;
	int i2;
	CODE:
	mplpos (i1, i2);

void
Dislin_mplsiz (i)
	int i;
	CODE:
	mplsiz (i);

void
Dislin_mpslogo (i1, i2, i3, s)
	int i1;
        int i2;
        int i3;
        char *s;
	CODE:
	mpslogo (i1, i2, i3, s);

void
Dislin_mrkclr (i)
	int i;
	CODE:
	mrkclr (i);

void
Dislin_msgbox (s)
	char *s;
	CODE:
	msgbox (s);

void
Dislin_mshclr (i)
	int i;
	CODE:
	mshclr (i);

void
Dislin_mshcrv (i)
	int i;
	CODE:
	mshcrv (i);

void
Dislin_mylab (s1, i, s2)
	char *s1;
	int i;
	char *s2;
	CODE:
	mylab (s1, i, s2);

void
Dislin_myline (n1ray, n)
	AV * n1ray = (AV *)SvRV(ST(0));
        int n;
        CODE:
        int *p1;

        p1 = arraytoint (n1ray, n);
        if (p1 != NULL) myline (p1, n);
        Safefree (p1);

void
Dislin_mypat (i1, i2, i3, i4)
	int i1;
        int i2;
        int i3;
        int i4;
	CODE:
        mypat (i1, i2, i3, i4);

void
Dislin_mysymb (x1ray, x2ray, n, isym, iflag)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
        int n;
        int isym;
        int iflag; 
        CODE:
        double *p1, *p2;

        p1 = arraytofloat (x1ray, n);
        p2 = arraytofloat (x2ray, n);
        if (p1 != NULL && p2 != NULL)
          mysymb (p1, p2, n, isym, iflag);
        Safefree (p1);
        Safefree (p2);

void
Dislin_myvlt (x1ray, x2ray, x3ray, n)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
	AV * x3ray = (AV *)SvRV(ST(2));
        int n;
        CODE:
        double *p1, *p2, *p3;

        p1 = arraytofloat (x1ray, n);
        p2 = arraytofloat (x2ray, n);
        p3 = arraytofloat (x3ray, n);
        if (p1 != NULL && p2 != NULL && p3 != NULL)
          myvlt (p1, p2, p3, n);
        Safefree (p1);
        Safefree (p2);
        Safefree (p3);

void
Dislin_namdis (i, s)
	int i;
	char *s;
	CODE:
	namdis (i, s);

void
Dislin_name (s1, s2)
	char *s1;
	char *s2;
	CODE:
	name (s1, s2);

void
Dislin_namjus (s1, s2)
	char *s1;
	char *s2;
	CODE:
	namjus (s1, s2);


void
Dislin_nancrv (s)
	char *s;
	CODE:
	nancrv (s);

void
Dislin_neglog (x)
	double x;
	CODE:
	neglog (x);

void
Dislin_newmix ()
	CODE:
	newmix ();

void
Dislin_newpag ()
	CODE:
	newpag ();

int
Dislin_nlmess (s)
	char *s;
        CODE:
        RETVAL = nlmess (s);
        OUTPUT:
        RETVAL

int
Dislin_nlnumb (x, i)
	double x;
        int i;
        CODE:
        RETVAL = nlnumb (x, i);
        OUTPUT:
        RETVAL

void
Dislin_noarln ()
	CODE:
	noarln ();

void
Dislin_nobar ()
	CODE:
	nobar ();

void
Dislin_nobgd ()
	CODE:
	nobgd ();

void
Dislin_nochek ()
	CODE:
	nochek ();

void
Dislin_noclip ()
	CODE:
	noclip ();

void
Dislin_nofill ()
	CODE:
	nofill ();

void
Dislin_nograf ()
	CODE:
	nograf ();

void
Dislin_nohide ()
	CODE:
	nohide ();

void
Dislin_noline (s)
	char *s;
	CODE:
	noline (s);

void
Dislin_number (x, i1, i2, i3)
	double x;
	int i1;
	int i2;
	int i3;
	CODE:
	number (x, i1, i2, i3);

void
Dislin_numfmt (s)
	char *s;
	CODE:
	numfmt (s);

void
Dislin_numode (s1, s2, s3, s4)
	char *s1;
	char *s2;
	char *s3;
	char *s4;
	CODE:
	numode (s1, s2, s3, s4);

int
Dislin_nwkday (i1, i2, i3)
	int i1;
        int i2;
        int i3;
        CODE:
        RETVAL = nwkday (i1, i2, i3);
        OUTPUT:
        RETVAL

int
Dislin_nxlegn (s)
	char *s;
        CODE:
        RETVAL = nxlegn (s);
        OUTPUT:
        RETVAL

int
Dislin_nxpixl (ix, iy)
	int ix;
        int iy;
        CODE:
        RETVAL = nxpixl (ix, iy);
        OUTPUT:
        RETVAL

int
Dislin_nxposn (x)
	double x;
        CODE:
        RETVAL = nxposn (x);
        OUTPUT:
        RETVAL

int
Dislin_nylegn (s)
	char *s;
        CODE:
        RETVAL = nylegn (s);
        OUTPUT:
        RETVAL

int
Dislin_nypixl (ix, iy)
	int ix;
        int iy;
        CODE:
        RETVAL = nypixl (ix, iy);
        OUTPUT:
        RETVAL

int
Dislin_nyposn (x)
	double x;
        CODE:
        RETVAL = nyposn (x);
        OUTPUT:
        RETVAL

int
Dislin_nzposn (x)
	double x;
        CODE:
        RETVAL = nzposn (x);
        OUTPUT:
        RETVAL

int
Dislin_openfl (s, i1, i2)
	char *s;
	int i1;
	int i2;
        CODE:
        RETVAL = openfl (s, i1, i2);
        OUTPUT:
        RETVAL

void
Dislin_opnwin (i)
	int i;
	CODE:
	opnwin (i);

void
Dislin_origin (i1, i2)
	int i1;
	int i2;
	CODE:
	origin (i1, i2);

void
Dislin_page (i1, i2)
	int i1;
	int i2;
	CODE:
	page (i1, i2);

void
Dislin_pagera ()
	CODE:
        pagera ();

void
Dislin_pagfll (i)
	int i;
	CODE:
	pagfll (i);

void
Dislin_paghdr (s1, s2, i1, i2)
	char *s1;
	char *s2;
	int i1;
	int i2;
	CODE:
	paghdr (s1, s2, i1, i2);

void
Dislin_pagmod (s)
	char *s;
	CODE:
	pagmod (s);

void
Dislin_pagorg (s)
	char *s;
	CODE:
	pagorg (s);

void
Dislin_pagwin (i1, i2)
	int i1;
	int i2;
	CODE:
	pagwin (i1, i2);

void
Dislin_patcyc (i1, i2)
	int i1;
	int i2;
	CODE:
	patcyc (i1, i2);

int
Dislin_pdfbuf (s, nmax)
	char *s;
        int nmax;
        CODE:
        char *p;
        int n;

        p = NULL;
        if (nmax != 0)
        { New (1, p, nmax, char);
        }

        n = pdfbuf (p, nmax);
        RETVAL = n;
        if (nmax != 0 && n > 0)
        { sv_setpvn ((SV*) ST(0), p, n);
        }  
        if (nmax != 0) Safefree (p);
        OUTPUT:
        RETVAL

void
Dislin_pdfmod (s1, s2)
	char *s1;
	char *s2;
	CODE:
	pdfmod (s1, s2);

void
Dislin_pdfmrk (s1, s2)
	char *s1;
	char *s2;
	CODE:
	pdfmrk (s1, s2);

void
Dislin_penwid (x)
	double x;
	CODE:
	penwid (x);

void
Dislin_pie (i1, i2, i3, x1, x2)
	int i1;
	int i2;
	int i3;
	double x1;
	double x2;
	CODE:
	pie (i1, i2, i3, x1, x2);

void
Dislin_piebor (n)
        int n;
	CODE:
	piebor (n);

void
Dislin_piecbk (s1)
	char *s1;
	CODE:
        strcpy (cbmypie, s1);
        piecbk (dis_piebck);

void
Dislin_pieclr (n1ray, n2ray, n)
	AV * n1ray = (AV *)SvRV(ST(0));
	AV * n2ray = (AV *)SvRV(ST(1));
        int n;
        CODE:
        int *p1, *p2;

        p1 = arraytoint (n1ray, n);
        p2 = arraytoint (n2ray, n);
        if (p1 != NULL && p2 != NULL) 
          pieclr (p1, p2, n);
        Safefree (p1);
        Safefree (p2);

void
Dislin_pieexp ()
	CODE:
	pieexp ();

void
Dislin_piegrf (s, nlin, x1ray, n)
	char *s;
	int nlin;
	AV * x1ray = (AV *)SvRV(ST(2));
        int n;
        CODE:
        double *p1;

        p1 = arraytofloat (x1ray, n);
        if (p1 != NULL) piegrf (s, nlin, p1, n);
        Safefree (p1);

void
Dislin_pielab (s1, s2)
	char *s1;
	char *s2;
	CODE:
	pielab (s1, s2);

void
Dislin_pieopt (x1, x2)
	double x1;
	double x2;
	CODE:
	pieopt (x1, x2);

void
Dislin_pierot (x)
	double x;
	CODE:
	pierot (x);

void
Dislin_pietyp (s)
	char *s;
	CODE:
	pietyp (s);

void
Dislin_pieval (x, s)
        double x;
	char *s;
	CODE:
	pieval (x, s);

void
Dislin_pievec (i, s)
	int i;
	char *s;
	CODE:
	pievec (i, s);

void
Dislin_pike3d (x1, x2, x3, x4, x5, x6, x7, n, m)
	double x1;
	double x2;
	double x3;
	double x4;
	double x5;
	double x6;
	double x7;
        int n;
        int m;
	CODE:
	pike3d (x1, x2, x3, x4, x5, x6, x7, n, m);

void
Dislin_plat3d (x1, x2, x3, x4, s1)
	double x1;
	double x2;
	double x3;
	double x4;
        char *s1;
	CODE:
	plat3d (x1, x2, x3, x4, s1);

void
Dislin_plyfin (s1, s2)
	char *s1;
	char *s2;
	CODE:
	plyfin (s1, s2);

void
Dislin_plyini (s)
	char *s;
	CODE:
	plyini (s);

void
Dislin_pngmod (s1, s2)
	char *s1;
	char *s2;
	CODE:
	pngmod (s1, s2);

void
Dislin_point (i1, i2, i3, i4, i5)
	int i1;
        int i2;
        int i3;
        int i4;
	int i5;
	CODE:
        point (i1, i2, i3, i4, i5);

void
Dislin_grafp (xe, xor, xstp, yor, ystp)
        double xe;
        double xor;
        double xstp;
        double yor;
        double ystp;
        CODE:
        grafp (xe, xor, xstp, yor, ystp);

void
Dislin_grafr (x1ray, n, x2ray, m)
	AV * x1ray = (AV *)SvRV(ST(0));
        int n;
	AV * x2ray = (AV *)SvRV(ST(1));
        int m;
        CODE:
        double *p1, *p2;

        p1 = arraytofloat  (x1ray, n);
        p2 = arraytofloat  (x2ray, m);
        if (p1 != NULL && p2 != NULL) grafr (p1, n, p2, m);
        Safefree (p1);
        Safefree (p2);

void
Dislin_polar (xe, xor, xstp, yor, ystp)
        double xe;
        double xor;
        double xstp;
        double yor;
        double ystp;
        CODE:
        grafp (xe, xor, xstp, yor, ystp);

int
Dislin_polclp (x1ray, x2ray, n, x3ray, x4ray, nmax, xv, s1)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
        int n;
	AV * x3ray = (AV *)SvRV(ST(3));
	AV * x4ray = (AV *)SvRV(ST(4));
        int nmax;
        double xv;
        char *s1;
        CODE:
        int nout;
        double *p1, *p2, *p3, *p4;

        p1 = arraytofloat (x1ray, n);
        p2 = arraytofloat (x2ray, n);
        New (1, p3, nmax, double);
        New (1, p4, nmax, double);
        nout = 0;
        if (p1 != NULL && p2 != NULL && p3 != NULL && p4 != NULL)
        { nout = polclp (p1, p2, n, p3, p4, nmax, xv, s1);
          floattoarray (p3, x3ray, nout);
          floattoarray (p4, x4ray, nout);
        }

        RETVAL = nout;
        Safefree (p1);
        Safefree (p2);
        Safefree (p3);
        Safefree (p4);
        OUTPUT:
        RETVAL

void
Dislin_polcrv (s)
	char *s;
	CODE:
	polcrv (s);

void
Dislin_polmod (s1, s2)
	char *s1;
	char *s2;
	CODE:
	polmod (s1, s2);

void
Dislin_pos2pt (x, y, xp, yp)
	double x;
	double y;
	double xp;
	double yp;
        CODE:
        double xpt, ypt;
        pos2pt (x, y, &xpt, &ypt);
        xp = xpt;
        yp = ypt;
        OUTPUT:
        xp
        yp

void
Dislin_pos3pt (x, y, z, xp, yp, zp)
	double x;
	double y;
	double z;
	double xp;
	double yp;
	double zp;
        CODE:
        double xpt, ypt, zpt;
        pos3pt (x, y, z, &xpt, &ypt, &zpt);
        xp = xpt;
        yp = ypt;
        zp = zpt;
        OUTPUT:
        xp
        yp
        zp

void
Dislin_posbar (s)
	char *s;
	CODE:
	posbar (s);

int
Dislin_posifl (i1, i2)
	int i1;
	int i2;
        CODE:
        RETVAL = posifl (i1, i2);
        OUTPUT:
        RETVAL

void
Dislin_proj3d (s)
	char *s;
	CODE:
	proj3d (s);

void
Dislin_projct (s)
	char *s;
	CODE:
	projct (s);

void
Dislin_psfont (s)
	char *s;
	CODE:
	psfont (s);

void
Dislin_psmode (s)
	char *s;
	CODE:
	psmode (s);

void
Dislin_pt2pos (x, y, xp, yp)
	double x;
	double y;
	double xp;
	double yp;
        CODE:
        double xpt, ypt;
        pt2pos (x, y, &xpt, &ypt);
        xp = xpt;
        yp = ypt;
        OUTPUT:
        xp
        yp

void
Dislin_pyra3d (x1, x2, x3, x4, x5, x6, i1)
	double x1;
	double x2;
	double x3;
	double x4;
        double x5;
        double x6;
        int i1;
	CODE:
	pyra3d (x1, x2, x3, x4, x5, x6, i1);

void
Dislin_qplbar (x1ray, n)
	AV * x1ray = (AV *)SvRV(ST(0));
        int n;
        CODE:
        double *p1;

        p1 = arraytofloat (x1ray, n);
        if (p1 != NULL) qplbar (p1, n);
        Safefree (p1);

void
Dislin_qplclr (x1ray, nx, ny)
	AV * x1ray = (AV *)SvRV(ST(0));
        int nx;
	int ny;
        CODE:
        double *p1;

        p1 = matrixtofloat (x1ray, nx, ny);
        if (p1 != NULL) qplclr (p1, nx, ny);
        Safefree (p1);

void
Dislin_qplcon (x1ray, nx, ny, nlev)
	AV * x1ray = (AV *)SvRV(ST(0));
        int nx;
	int ny;
        int nlev; 
        CODE:
        double *p1;

        p1 = matrixtofloat (x1ray, nx, ny);
        if (p1 != NULL) qplcon (p1, nx, ny, nlev);
        Safefree (p1);

void
Dislin_qplcrv (x1ray, x2ray, n, s1)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
        int n;
        char *s1;
        CODE:
        double *p1, *p2;

        p1 = arraytofloat (x1ray, n);
        p2 = arraytofloat (x2ray, n);
        if (p1 != NULL && p2 != NULL) 
          qplcrv (p1, p2, n, s1);
        Safefree (p1);
        Safefree (p2);

void
Dislin_qplot (x1ray, x2ray, n)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
        int n;
        CODE:
        double *p1, *p2;

        p1 = arraytofloat (x1ray, n);
        p2 = arraytofloat (x2ray, n);
        if (p1 != NULL && p2 != NULL) 
          qplot (p1, p2, n);
        Safefree (p1);
        Safefree (p2);

void
Dislin_qplpie (x1ray, n)
	AV * x1ray = (AV *)SvRV(ST(0));
        int n;
        CODE:
        double *p1;

        p1 = arraytofloat (x1ray, n);
        if (p1 != NULL) qplpie (p1, n);
        Safefree (p1);

void
Dislin_qplsca (x1ray, x2ray, n)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
        int n;
        CODE:
        double *p1, *p2;

        p1 = arraytofloat (x1ray, n);
        p2 = arraytofloat (x2ray, n);
        if (p1 != NULL && p2 != NULL)
          qplsca (p1, p2, n);
        Safefree (p1);
        Safefree (p2);

void
Dislin_qplscl (xa, xe, xor, xstp, s)
	double xa;
	double xe;
	double xor;
	double xstp;
	char *s;
	CODE:
	qplscl (xa, xe, xor, xstp, s);

void
Dislin_qplsur (x1ray, nx, ny)
	AV * x1ray = (AV *)SvRV(ST(0));
        int nx;
	int ny;
        CODE:
        double *p1;

        p1 = matrixtofloat (x1ray, nx, ny);
        if (p1 != NULL) qplsur (p1, nx, ny);
        Safefree (p1);

void
Dislin_quad3d (x1, x2, x3, x4, x5, x6)
	double x1;
	double x2;
	double x3;
	double x4;
        double x5;
        double x6; 
	CODE:
	quad3d (x1, x2, x3, x4, x5, x6);

void
Dislin_rbmp (s)
	char *s;
	CODE:
	rbmp (s);

int
Dislin_rbfpng (s, nmax)
	char *s;
        int nmax;
        CODE:
        char *p;
        int n;

        p = NULL; 
        if (nmax != 0)
        { New (1, p, nmax, char);
        }

        n = rbfpng (p, nmax);
        RETVAL = n;
        if (nmax != 0 && n > 0)
        { sv_setpvn ((SV*) ST(0), p, n);
        }  
        if (nmax != 0) Safefree (p);
        OUTPUT:
        RETVAL

int
Dislin_readfl (nu, n1ray, nbyte)
	AV * n1ray = (AV *)SvRV(ST(0));
        int nu;
	int nbyte;
        CODE:
        char *p1;
        int n1; 
        int i;
        New (1, p1, nbyte, char);
        n1 = readfl (nu, (unsigned char *) p1, nbyte);
        for (i = 0; i < n1; i++)
          av_store(n1ray,i,newSViv ((int) p1[i]));
        Safefree (p1);

        RETVAL=n1;
        OUTPUT:
        RETVAL

void
Dislin_reawgt ()
	CODE:
        reawgt ();      

void
Dislin_recfll (i1, i2, i3, i4, i5)
	int i1;
        int i2;
        int i3;
        int i4;
	int i5;
	CODE:
        recfll (i1, i2, i3, i4, i5);

void
Dislin_rectan (i1, i2, i3, i4)
	int i1;
        int i2;
        int i3;
        int i4;
	CODE:
        rectan (i1, i2, i3, i4);

void
Dislin_rel3pt (x, y, z, xp, yp)
	double x;
	double y;
	double z;
	double xp;
	double yp;
        CODE:
        double xpt, ypt;
        rel3pt (x, y, z, &xpt, &ypt);
        xp = xpt;
        yp = ypt;
        OUTPUT:
        xp
        yp

void
Dislin_resatt ()
	CODE:
	resatt ();

void
Dislin_reset (s)
	char *s;
	CODE:
	reset (s);

void
Dislin_revscr ()
	CODE:
	revscr ();

void
Dislin_rgbhsv (x, y, z, xp, yp, zp)
	double x;
	double y;
	double z;
	double xp;
	double yp;
	double zp;
        CODE:
        double xpt, ypt, zpt;
        rgbhsv (x, y, z, &xpt, &ypt, &zpt);
        xp = xpt;
        yp = ypt;
        zp = zpt;
        OUTPUT:
        xp
        yp
        zp

void
Dislin_rgif (s)
	char *s;
	CODE:
	rgif (s);

void
Dislin_rgtlab ()
	CODE:
	rgtlab ();

void
Dislin_rimage (s)
	char *s;
	CODE:
	rimage (s);

void
Dislin_rlarc (x1, x2, x3, x4, x5, x6, x7)
	double x1;
	double x2;
	double x3;
	double x4;
	double x5;
	double x6;
	double x7;
	CODE:
	rlarc (x1, x2, x3, x4, x5, x6, x7);

void
Dislin_rlarea (x1ray, x2ray, n)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
        int n;
        CODE:
        double *p1, *p2;

        p1 = arraytofloat (x1ray, n);
        p2 = arraytofloat (x2ray, n);
        if (p1 != NULL && p2 != NULL) rlarea (p1, p2, n);
        Safefree (p1);
        Safefree (p2);

void
Dislin_rlcirc (x1, x2, x3)
	double x1;
	double x2;
	double x3;
	CODE:
	rlcirc (x1, x2, x3);

void
Dislin_rlconn (x1, x2)
	double x1;
	double x2;
	CODE:
	rlconn (x1, x2);

void
Dislin_rlell (x1, x2, x3, x4)
	double x1;
	double x2;
	double x3;
	double x4;
	CODE:
	rlell (x1, x2, x3, x4);

void
Dislin_rline (x1, x2, x3, x4)
	double x1;
	double x2;
	double x3;
	double x4;
	CODE:
	rline (x1, x2, x3, x4);

void
Dislin_rlmess (s, x1, x2)
	char *s;
	double x1;
	double x2;
	CODE:
	rlmess (s, x1, x2);

void
Dislin_rlnumb (x1, i, x2, x3)
	double x1;
	int i;
	double x2;
	double x3;
	CODE:
	rlnumb (x1, i, x2, x3);

void
Dislin_rlpie (x1, x2, x3, x4, x5)
	double x1;
	double x2;
	double x3;
	double x4;
	double x5;
	CODE:
	rlpie (x1, x2, x3, x4, x5);

void
Dislin_rlpoin (x1, x2, i1, i2, i3)
	double x1;
	double x2;
	int i1;
	int i2;
	int i3;
	CODE:
	rlpoin (x1, x2, i1, i2, i3);

void
Dislin_rlrec (x1, x2, x3, x4)
	double x1;
	double x2;
	double x3;
	double x4;
	CODE:
	rlrec (x1, x2, x3, x4);

void
Dislin_rlrnd (x1, x2, x3, x4, i)
	double x1;
	double x2;
	double x3;
	double x4;
	int i;
	CODE:
	rlrnd (x1, x2, x3, x4, i);

void
Dislin_rlsec (x1, x2, x3, x4, x5, x6, i)
	double x1;
	double x2;
	double x3;
	double x4;
	double x5;
	double x6;
	int i;
	CODE:
	rlsec (x1, x2, x3, x4, x5, x6, i);

void
Dislin_rlstrt (x1, x2)
	double x1;
	double x2;
	CODE:
	rlstrt (x1, x2);

void
Dislin_rlsymb (i, x1, x2)
	int i;
	double x1;
	double x2;
	CODE:
	rlsymb (i, x1, x2);

void
Dislin_rlvec (x1, x2, x3, x4, i)
	double x1;
	double x2;
	double x3;
	double x4;
	int i;
	CODE:
	rlvec (x1, x2, x3, x4, i);

void
Dislin_rlwind (x1, x2, x3, i1, x4)
        double x1;
        double x2;
        double x3;
	int i1;
        double x4; 
	CODE:
        rlwind (x1, x2, x3, i1, x4);

void
Dislin_rndrec (i1, i2, i3, i4, i5)
	int i1;
        int i2;
        int i3;
        int i4;
	int i5;
	CODE:
        rndrec (i1, i2, i3, i4, i5);

void
Dislin_rot3d (x1, x2, x3)
	double x1;
	double x2;
	double x3;
	CODE:
	rot3d (x1, x2, x3);

int
Dislin_rpixel (i1, i2)
	int i1;
	int i2;
        CODE:
        int iclr;
        rpixel (i1, i2, &iclr);
        RETVAL = iclr;
        OUTPUT:
        RETVAL

void
Dislin_rpixls (n1ray, i1, i2, i3, i4)
	AV * n1ray = (AV *)SvRV(ST(0));
	int i1;
	int i2;
	int i3;
	int i4;
        CODE:
        int i, n1;
        char *p1;
        n1 = i3 * i4;
        if (imgop == 1) n1 = 3 * n1;
        New (1, p1, n1, char);
	rpixls ((unsigned char *) p1, i1, i2, i3, i4);
        for (i = 0; i < n1; i++)
          av_store(n1ray,i,newSViv ((int) p1[i]));
        Safefree (p1);

void
Dislin_rpng (s)
	char *s;
	CODE:
	rpng (s);

void
Dislin_rppm (s)
	char *s;
	CODE:
	rppm (s);

void
Dislin_rpxrow (n1ray, i1, i2, i3)
	AV * n1ray = (AV *)SvRV(ST(0));
	int i1;
	int i2;
	int i3;
	CODE:
        int i, n1;
        char *p1;
        n1 = i3;
        if (imgop == 1) n1 = 3 * n1;
        New (1, p1, n1, char);
	rpxrow ((unsigned char *) p1, i1, i2, i3);
        for (i = 0; i < n1; i++)
          av_store(n1ray,i,newSViv ((int) p1[i]));
        Safefree (p1);

void
Dislin_rtiff (s)
	char *s;
	CODE:
	rtiff (s);

void
Dislin_rvynam ()
	CODE:
	rvynam ();

void
Dislin_scale (s1, s2)
	char *s1;
	char *s2;
	CODE:
	scale (s1, s2);

void
Dislin_sclfac (x)
	double x;
	CODE:
	sclfac (x);

void
Dislin_sclmod (s)
	char *s;
	CODE:
	sclmod (s);

void
Dislin_scrmod (s)
	char *s;
	CODE:
	scrmod (s);

void
Dislin_sector (i1, i2, i3, i4, x1, x2, i5)
	int i1;
        int i2;
        int i3;
	int i4;
	double x1;
	double x2;
	int i5;
	CODE:
        sector (i1, i2, i3, i4, x1, x2, i5);

void
Dislin_selwin (i)
	int i;
	CODE:
	selwin (i);

void
Dislin_sendbf ()
	CODE:
	sendbf ();

void
Dislin_sendmb ()
	CODE:
	sendmb ();

void
Dislin_sendok ()
	CODE:
	sendok ();


void
Dislin_serif ()
	CODE:
	serif ();

void
Dislin_setbas (x)
	double x;
	CODE:
	setbas (x);

void
Dislin_setcbk (s1, s2)
	char *s1;
        char *s2;
	CODE:
        strcpy (cbmypr, s1);
        setcbk (dis_callbck2, s2);

void
Dislin_setclr (i)
	int i;
	CODE:
	setclr (i);

void
Dislin_setcsr (s)
	char *s;
	CODE:
	setcsr (s);

void
Dislin_setexp (x)
	double x;
	CODE:
	setexp (x);

void
Dislin_setfce (s)
	char *s;
	CODE:
	setfce (s);

void
Dislin_setfil (s)
	char *s;
	CODE:
	setfil (s);

void
Dislin_setgrf (s1, s2, s3, s4)
	char *s1;
	char *s2;
	char *s3;
	char *s4;
	CODE:
	setgrf (s1, s2, s3, s4);

void
Dislin_setind (i, x1, x2, x3)
	int i;
	double x1;
	double x2;
	double x3;
	CODE:
	setind (i, x1, x2, x3);

void
Dislin_setmix (s1, s2)
	char *s1;
	char *s2;
	CODE:
	setmix (s1, s2);

void
Dislin_setpag (s)
	char *s;
	CODE:
	setpag (s);

void
Dislin_setres (i1, i2)
	int i1;
	int i2;
	CODE:
	setres (i1, i2);

void
Dislin_setres3d (x1, x2, x3)
	double x1;
	double x2;
	double x3;
	CODE:
	setres3d (x1, x2, x3);

void
Dislin_setrgb (xr, xg, xb)
	double xr;
	double xg;
	double xb;
	CODE:
	setrgb (xr, xg, xb);

void
Dislin_setscl (x1ray, n, s)
	AV * x1ray = (AV *)SvRV(ST(0));
        int n;
	char *s;
        CODE:
        double *p1;

        p1 = arraytofloat (x1ray, n);
        if (p1 != NULL) setscl (p1, n, s);
        Safefree (p1);

void
Dislin_setvlt (s)
	char *s;
	CODE:
	setvlt (s);

void
Dislin_setxid (i, s)
	int i;
	char *s;
	CODE:
	setxid (i, s);

void
Dislin_shdafr (n1ray, n2ray, n3ray, n)
	AV * n1ray = (AV *)SvRV(ST(0));
	AV * n2ray = (AV *)SvRV(ST(1));
	AV * n3ray = (AV *)SvRV(ST(2));
        int n;
        CODE:
        int *p1, *p3;
        long *p2;

        p1 = arraytoint (n1ray, n);
        p2 = arraytolong (n2ray, n);
        p3 = arraytoint (n3ray, n);

        if (p1 != NULL && p2 != NULL && p3 != NULL)
          shdafr (p1, p2, p3, n);

        Safefree (p1);
        Safefree (p2);
        Safefree (p3);

void
Dislin_shdasi (n1ray, n2ray, n3ray, n)
	AV * n1ray = (AV *)SvRV(ST(0));
	AV * n2ray = (AV *)SvRV(ST(1));
	AV * n3ray = (AV *)SvRV(ST(2));
        int n;
        CODE:
        int *p1, *p3;
        long *p2;

        p1 = arraytoint (n1ray, n);
        p2 = arraytolong (n2ray, n);
        p3 = arraytoint (n3ray, n);

        if (p1 != NULL && p2 != NULL && p3 != NULL)
          shdasi (p1, p2, p3, n);

        Safefree (p1);
        Safefree (p2);
        Safefree (p3);

void
Dislin_shdaus (n1ray, n2ray, n3ray, n)
	AV * n1ray = (AV *)SvRV(ST(0));
	AV * n2ray = (AV *)SvRV(ST(1));
	AV * n3ray = (AV *)SvRV(ST(2));
        int n;
        CODE:
        int *p1, *p3;
        long *p2;

        p1 = arraytoint (n1ray, n);
        p2 = arraytolong (n2ray, n);
        p3 = arraytoint (n3ray, n);

        if (p1 != NULL && p2 != NULL && p3 != NULL)
          shdaus (p1, p2, p3, n);

        Safefree (p1);
        Safefree (p2);
        Safefree (p3);

void
Dislin_shdcha ()
	CODE:
	shdcha ();

void
Dislin_shdcrv (x1ray, x2ray, n, x3ray, x4ray, m)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
        int n;
	AV * x3ray = (AV *)SvRV(ST(3));
	AV * x4ray = (AV *)SvRV(ST(4));
        int m;
        CODE:
        double *p1, *p2, *p3, *p4;

        p1 = arraytofloat (x1ray, n);
        p2 = arraytofloat (x2ray, n);
        p3 = arraytofloat (x3ray, m);
        p4 = arraytofloat (x4ray, m);

        if (p1 != NULL && p2 != NULL && p3 != NULL && p4 != NULL)
          shdcrv (p1, p2, n, p3, p4, m);

        Safefree (p1);
        Safefree (p2);
        Safefree (p3);
        Safefree (p4);

void
Dislin_shdeur (n1ray, n2ray, n3ray, n)
	AV * n1ray = (AV *)SvRV(ST(0));
	AV * n2ray = (AV *)SvRV(ST(1));
	AV * n3ray = (AV *)SvRV(ST(2));
        int n;
        CODE:
        int *p1, *p3;
        long *p2;

        p1 = arraytoint (n1ray, n);
        p2 = arraytolong (n2ray, n);
        p3 = arraytoint (n3ray, n);

        if (p1 != NULL && p2 != NULL && p3 != NULL)
          shdeur (p1, p2, p3, n);

        Safefree (p1);
        Safefree (p2);
        Safefree (p3);

void
Dislin_shdfac (x)
	double x;
	CODE:
	shdfac (x);

void
Dislin_shdmap (s)
	char *s;
	CODE:
	shdmap (s);

void
Dislin_shdmod (s1, s2)
	char *s1;
	char *s2;
	CODE:
	shdmod (s1, s2);

void
Dislin_shdnor (n1ray, n2ray, n3ray, n)
	AV * n1ray = (AV *)SvRV(ST(0));
	AV * n2ray = (AV *)SvRV(ST(1));
	AV * n3ray = (AV *)SvRV(ST(2));
        int n;
        CODE:
        int *p1, *p3;
        long *p2;

        p1 = arraytoint (n1ray, n);
        p2 = arraytolong (n2ray, n);
        p3 = arraytoint (n3ray, n);

        if (p1 != NULL && p2 != NULL && p3 != NULL)
          shdnor (p1, p2, p3, n);

        Safefree (p1);
        Safefree (p2);
        Safefree (p3);

void
Dislin_shdpat (i)
	int i;
	CODE:
	shdpat (i);

void
Dislin_shdsou (n1ray, n2ray, n3ray, n)
	AV * n1ray = (AV *)SvRV(ST(0));
	AV * n2ray = (AV *)SvRV(ST(1));
	AV * n3ray = (AV *)SvRV(ST(2));
        int n;
        CODE:
        int *p1, *p3;
        long *p2;

        p1 = arraytoint (n1ray, n);
        p2 = arraytolong (n2ray, n);
        p3 = arraytoint (n3ray, n);

        if (p1 != NULL && p2 != NULL && p3 != NULL)
          shdsou (p1, p2, p3, n);

        Safefree (p1);
        Safefree (p2);
        Safefree (p3);

void
Dislin_shdusa (n1ray, n2ray, n3ray, n)
	AV * n1ray = (AV *)SvRV(ST(0));
	AV * n2ray = (AV *)SvRV(ST(1));
	AV * n3ray = (AV *)SvRV(ST(2));
        int n;
        CODE:
        int *p1, *p3;
        long *p2;

        p1 = arraytoint (n1ray, n);
        p2 = arraytolong (n2ray, n);
        p3 = arraytoint (n3ray, n);

        if (p1 != NULL && p2 != NULL && p3 != NULL)
          shdusa (p1, p2, p3, n);

        Safefree (p1);
        Safefree (p2);
        Safefree (p3);

void
Dislin_shield (s1, s2)
	char *s1;
	char *s2;
	CODE:
	shield (s1, s2);

void
Dislin_shlcir (i1, i2, i3)
	int i1;
        int i2;
        int i3;
	CODE:
        shlcir (i1, i2, i3);

void
Dislin_shldel (i)
	int i;
	CODE:
	shldel (i);

void
Dislin_shlell (i1, i2, i3, i4, x)
	int i1;
        int i2;
        int i3;
        int i4;
	double x;
	CODE:
        shlell (i1, i2, i3, i4, x);

int
Dislin_shlind ()
        CODE:
        RETVAL = shlind ();
        OUTPUT:
        RETVAL

void
Dislin_shlpie (i1, i2, i3, x1, x2)
	int i1;
        int i2;
        int i3;
        double x1;
	double x2;
	CODE:
        shlpie (i1, i2, i3, x1, x2);

void
Dislin_shlpol (n1ray, n2ray, n)
	AV * n1ray = (AV *)SvRV(ST(0));
	AV * n2ray = (AV *)SvRV(ST(1));
        int n;
        CODE:
        int *p1, *p2;

        p1 = arraytoint (n1ray, n);
        p2 = arraytoint (n2ray, n);
        if (p1 != NULL && p2 != NULL) 
          shlpol (p1, p2, n);
        Safefree (p1);
        Safefree (p2);

void
Dislin_shlrct (i1, i2, i3, i4, x)
	int i1;
        int i2;
        int i3;
        int i4;
	double x;
	CODE:
        shlrct (i1, i2, i3, i4, x);

void
Dislin_shlrec (i1, i2, i3, i4)
	int i1;
        int i2;
        int i3;
        int i4;
	CODE:
        shlrec (i1, i2, i3, i4);

void
Dislin_shlres (i)
	int i;
	CODE:
	shlres (i);

void
Dislin_shlsur ()
	CODE:
	shlsur ();

void
Dislin_shlvis (i, s)
	int i;
	char *s;
	CODE:
	shlvis (i, s);

void
Dislin_simplx ()
	CODE:
	simplx ();

int
Dislin_skipfl (i1, i2)
	int i1;
	int i2;
        CODE:
        RETVAL = skipfl (i1, i2);
        OUTPUT:
        RETVAL
 
void
Dislin_smxalf (s1, s2, s3, i)
	char *s1;
	char *s2;
	char *s3;
	int i;
	CODE:
	smxalf (s1, s2, s3, i);

void
Dislin_solid ()
	CODE:
	solid ();

void
Dislin_sortr1 (x1ray, n, s)
	AV * x1ray = (AV *)SvRV(ST(0));
        int n;
	char *s;
        CODE:
        double *p1;

        p1 = arraytofloat (x1ray, n);
        if (p1 != NULL)
        { sortr1 (p1, n, s);
          floattoarray (p1, x1ray, n);
        } 
        Safefree (p1);

void
Dislin_sortr2 (x1ray, x2ray, n, s)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
        int n;
	char *s;
        CODE:
        double *p1, *p2;

        p1 = arraytofloat (x1ray, n);
        p2 = arraytofloat (x2ray, n);
        if (p1 != NULL && p2 != NULL)
        { sortr2 (p1, p2, n, s);
          floattoarray (p1, x1ray, n);
          floattoarray (p2, x2ray, n);
        }
        Safefree (p1);
        Safefree (p2);

void
Dislin_spcbar (i)
	int i;
	CODE:
	spcbar (i);

void
Dislin_sphe3d (x1, x2, x3, x4, i1, i2)
	double x1;
	double x2;
	double x3;
	double x4;
        int i1;
        int i2;
	CODE:
	sphe3d (x1, x2, x3, x4, i1, i2);

int
Dislin_spline (x1ray, x2ray, n, x3ray, x4ray)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
        int n;
	AV * x3ray = (AV *)SvRV(ST(3));
	AV * x4ray = (AV *)SvRV(ST(4));
        CODE:
        int npt;
        double *p1, *p2, *p3, *p4;

        p1 = arraytofloat (x1ray, n);
        p2 = arraytofloat (x2ray, n);
        New (1, p3, nspline, double);
        New (1, p4, nspline, double);

        if (p1 != NULL && p2 != NULL && p3 != NULL && p4 != NULL)
        { spline (p1, p2, n, p3, p4, &npt);
          floattoarray (p3, x3ray, npt);
          floattoarray (p4, x4ray, npt);
        }

        RETVAL = npt;
        Safefree (p1);
        Safefree (p2);
        Safefree (p3);
        Safefree (p4);
        OUTPUT:
        RETVAL

void
Dislin_splmod (i1, i2)
	int i1;
	int i2;
	CODE:
	splmod (i1, i2);
        if (i2 >= 5) nspline = i2;

void
Dislin_stmmod (s1, s2)
	char *s1;
	char *s2;
	CODE:
	stmmod (s1, s2);

void
Dislin_stmopt (n, s)
        int n;
	char *s;
	CODE:
	stmopt (n, s);

int
Dislin_stmpts (xmat, ymat, nx, ny, xp, yp, x0, y0, xray, yray, nmax)
	AV * xmat = (AV *)SvRV(ST(0));
	AV * ymat = (AV *)SvRV(ST(1));
        int nx;
	int ny;
	AV * xp = (AV *)SvRV(ST(4));
	AV * yp = (AV *)SvRV(ST(5));
        double x0;
        double y0;
	AV * xray = (AV *)SvRV(ST(8));
	AV * yray = (AV *)SvRV(ST(9));
        int nmax;
        CODE:
        int n;
        double *p1, *p2, *p3, *p4, *p5, *p6;

        p1 = matrixtofloat (xmat, nx, ny);
        p2 = matrixtofloat (ymat, nx, ny);
        p3 = arraytofloat  (xp, nx);
        p4 = arraytofloat  (yp, ny);
        New (1, p5, nmax, double);
        New (1, p6, nmax, double);

        if (p1 != NULL && p2 != NULL && p3 != NULL &&
            p4 != NULL && p5 != NULL && p6 != NULL)
        { stmpts (p1, p2, nx, ny, p3, p4, x0, y0, p5, p6, nmax, &n);
          floattoarray (p5, xray, n);
          floattoarray (p6, yray, n);
        }

        Safefree (p1);
        Safefree (p2);
        Safefree (p3);
        Safefree (p4);
        Safefree (p5);
        Safefree (p6);
        RETVAL = n;
        OUTPUT:
        RETVAL

int
Dislin_stmpts3d (xmat, ymat, zmat,  nx, ny, nz, xp, yp, zp, x0, y0, z0, xray, yray, zray, nmax)
	AV * xmat = (AV *)SvRV(ST(0));
	AV * ymat = (AV *)SvRV(ST(1));
	AV * zmat = (AV *)SvRV(ST(2));
        int nx;
	int ny;
	int nz;
	AV * xp = (AV *)SvRV(ST(6));
	AV * yp = (AV *)SvRV(ST(7));
	AV * zp = (AV *)SvRV(ST(8));
        double x0;
        double y0;
        double z0;
	AV * xray = (AV *)SvRV(ST(12));
	AV * yray = (AV *)SvRV(ST(13));
	AV * zray = (AV *)SvRV(ST(14));
        int nmax;
        CODE:
        int n;
        double *p1, *p2, *p3, *p4, *p5, *p6, *p7, *p8, *p9;

        p1 = matrix3tofloat (xmat, nx, ny, nz);
        p2 = matrix3tofloat (ymat, nx, ny, nz);
        p3 = matrix3tofloat (zmat, nx, ny, nz);
        p4 = arraytofloat  (xp, nx);
        p5 = arraytofloat  (yp, ny);
        p6 = arraytofloat  (zp, nz);
        New (1, p7, nmax, double);
        New (1, p8, nmax, double);
        New (1, p9, nmax, double);

        if (p1 != NULL && p2 != NULL && p3 != NULL &&
            p4 != NULL && p5 != NULL && p6 != NULL &&
            p7 != NULL && p8 != NULL && p9 != NULL)
        { stmpts3d (p1, p2, p3, nx, ny, nz, p4, p5, p6, x0, y0, z0,
                    p7, p8, p9, nmax, &n);
          floattoarray (p7, xray, n);
          floattoarray (p8, yray, n);
          floattoarray (p9, zray, n);
        }

        Safefree (p1);
        Safefree (p2);
        Safefree (p3);
        Safefree (p4);
        Safefree (p5);
        Safefree (p6);
        Safefree (p7);
        Safefree (p8);
        Safefree (p9);
        RETVAL = n;
        OUTPUT:
        RETVAL

void
Dislin_stmtri (x1ray, x2ray, x3ray, x4ray, n, n1ray, n2ray, n3ray, ntri, x4ray, x5ray, nray)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
	AV * x3ray = (AV *)SvRV(ST(2));
	AV * x4ray = (AV *)SvRV(ST(3));
        int n;
	AV * n1ray = (AV *)SvRV(ST(5));
	AV * n2ray = (AV *)SvRV(ST(6));
	AV * n3ray = (AV *)SvRV(ST(7));
        int ntri;
	AV * x5ray = (AV *)SvRV(ST(9));
	AV * x6ray = (AV *)SvRV(ST(10));
        int nray;
        CODE:
        double *p1, *p2, *p3, *p4, *p8, *p9;
        int *p5, *p6, *p7;

        p1 = arraytofloat  (x1ray, n);
        p2 = arraytofloat  (x2ray, n);
        p3 = arraytofloat  (x3ray, n);
        p4 = arraytofloat  (x4ray, n);
        p5 = arraytoint (n1ray, ntri);
        p6 = arraytoint (n2ray, ntri);
        p7 = arraytoint (n3ray, ntri);
        if (nray > 0) 
        { p8 = arraytofloat  (x5ray, n);
          p9 = arraytofloat  (x6ray, n);
        }
        else
        { p8 = NULL;
          p9 = NULL;
        }

        if (p1 != NULL && p2 != NULL && p3 != NULL && p4 != NULL &&
            p5 != NULL && p6 != NULL && p7 != NULL)
          stmtri (p1, p2, p3, p4, n, p5, p6, p7, ntri, p8, p9, nray);

        Safefree (p1);
        Safefree (p2);
        Safefree (p3);
        Safefree (p4);
        Safefree (p5);
        Safefree (p6);
        Safefree (p7);

        if (n > 0) 
        { Safefree (p6);
          Safefree (p7);
        }

void
Dislin_stmval (x, s)
        double x;
	char *s;
	CODE:
	stmval (x, s);

void
Dislin_stream (xmat, ymat, nx, ny, xp, yp, xs, ys, n)
	AV * xmat = (AV *)SvRV(ST(0));
	AV * ymat = (AV *)SvRV(ST(1));
        int nx;
	int ny;
	AV * xp = (AV *)SvRV(ST(4));
	AV * yp = (AV *)SvRV(ST(5));
	AV * xs = (AV *)SvRV(ST(6));
	AV * ys = (AV *)SvRV(ST(7));
        int n;
        CODE:
        double *p1, *p2, *p3, *p4, *p5, *p6;

        p1 = matrixtofloat (xmat, nx, ny);
        p2 = matrixtofloat (ymat, nx, ny);
        p3 = arraytofloat  (xp, nx);
        p4 = arraytofloat  (yp, ny);

        if (n > 0) 
        { p5 = arraytofloat  (xs, n);
          p6 = arraytofloat  (ys, n);
        }
        else
        { p5 = NULL;
          p6 = NULL;
        }

        if (p1 != NULL && p2 != NULL && p3 != NULL && p4 != NULL)
          stream (p1, p2, nx, ny, p3, p4, p5, p6, n);

        Safefree (p1);
        Safefree (p2);
        Safefree (p3);
        Safefree (p4);
        if (n > 0) 
        { Safefree (p5);
          Safefree (p6);
        } 

void
Dislin_stream3d (xmat, ymat, zmat,  nx, ny, nz, xp, yp, zp, xs, ys, zs, n)
	AV * xmat = (AV *)SvRV(ST(0));
	AV * ymat = (AV *)SvRV(ST(1));
	AV * zmat = (AV *)SvRV(ST(2));
        int nx;
	int ny;
	int nz;
	AV * xp = (AV *)SvRV(ST(6));
	AV * yp = (AV *)SvRV(ST(7));
	AV * zp = (AV *)SvRV(ST(8));
	AV * xs = (AV *)SvRV(ST(9));
	AV * ys = (AV *)SvRV(ST(10));
	AV * zs = (AV *)SvRV(ST(11));
        int n;
        CODE:
        double *p1, *p2, *p3, *p4, *p5, *p6, *p7, *p8, *p9;

        p1 = matrix3tofloat (xmat, nx, ny, nz);
        p2 = matrix3tofloat (ymat, nx, ny, nz);
        p3 = matrix3tofloat (zmat, nx, ny, nz);
        p4 = arraytofloat  (xp, nx);
        p5 = arraytofloat  (yp, ny);
        p6 = arraytofloat  (zp, nz);

        if (n > 0) 
        { p7 = arraytofloat  (xs, n);
          p8 = arraytofloat  (ys, n);
          p9 = arraytofloat  (zs, n);
        }
        else
        { p7 = NULL;
          p8 = NULL;
          p9 = NULL;
        }

        if (p1 != NULL && p2 != NULL && p3 != NULL && 
            p4 != NULL && p5 != NULL && p6 != NULL)
          stream3d (p1, p2, p3, nx, ny, nz, p4, p5, p6, p7, p8, p9, n);

        Safefree (p1);
        Safefree (p2);
        Safefree (p3);
        Safefree (p4);
        Safefree (p5);
        Safefree (p6);
        if (n > 0) 
        { Safefree (p7);
          Safefree (p8);
          Safefree (p9);
        } 

void
Dislin_strt3d (x1, x2, x3)
	double x1;
	double x2;
        double x3;
	CODE:
	strt3d (x1, x2, x3);

void
Dislin_strtpt (x1, x2)
	double x1;
	double x2;
	CODE:
	strtpt (x1, x2);

void
Dislin_surclr (i1, i2)
	int i1;
	int i2;
	CODE:
	surclr (i1, i2);

void
Dislin_surfce (x1ray, nx, x2ray, ny, xmat)
	AV * x1ray = (AV *)SvRV(ST(0));
        int nx;
	AV * x2ray = (AV *)SvRV(ST(2));
	int ny;
	AV * xmat = (AV *)SvRV(ST(4));
        CODE:
        double *p1, *p2, *p3;

        p1 = arraytofloat (x1ray, nx);
        p2 = arraytofloat (x2ray, ny);
        p3 = matrixtofloat (xmat, nx, ny);
        if (p1 != NULL && p2 != NULL && p3 != NULL)
          surfce (p1, nx, p2, ny, p3);
        Safefree (p1);
        Safefree (p2);
        Safefree (p3);

void
Dislin_surfcp (s, a1, a2, a3, b1, b2, b3)
	char *s;
        double a1;
        double a2;
        double a3;
        double b1;
        double b2;
        double b3;
	CODE:
        strcpy (cbfunc, s);
        surfcp (dis_funcbck, a1, a2, a3, b1, b2, b3);

void
Dislin_surfun (s, i1, a1, i2, a2)
	char *s;
        int i1;
        double a1;
        int i2;
        double a2;
	CODE:
        strcpy (cbfunc, s);
        surfun (dis_func2bck, i1, a1, i2, a2);

void
Dislin_suriso (x1ray, nx, x2ray, ny, x3ray, nz, wmat, wlev)
	AV * x1ray = (AV *)SvRV(ST(0));
        int nx;
	AV * x2ray = (AV *)SvRV(ST(2));
	int ny;
	AV * x3ray = (AV *)SvRV(ST(4));
	int nz;
	AV * wmat = (AV *)SvRV(ST(6));
        double wlev;
        CODE:
        double *p1, *p2, *p3, *p4;

        p1 = arraytofloat (x1ray, nx);
        p2 = arraytofloat (x2ray, ny);
        p3 = arraytofloat (x3ray, nz);
        p4 = matrix3tofloat (wmat, nx, ny, nz);

        if (p1 != NULL && p2 != NULL && p3 != NULL && p4 != NULL)
          suriso (p1, nx, p2, ny, p3, nz, p4, wlev);

        Safefree (p1);
        Safefree (p2);
        Safefree (p3);
        Safefree (p4);

void
Dislin_surmat (x1ray, nx, ny, ixpts, iypts)
	AV * x1ray = (AV *)SvRV(ST(0));
        int nx;
	int ny;
	int ixpts;
	int iypts;
        CODE:
        double *p1;

        p1 = matrixtofloat (x1ray, nx, ny);
        if (p1 != NULL) surmat (p1, nx, ny, ixpts, iypts);
        Safefree (p1);

void
Dislin_surtri (x1ray, x2ray, x3ray, n, n1ray, n2ray, n3ray, ntri)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
	AV * x3ray = (AV *)SvRV(ST(2));
        int n;
	AV * n1ray = (AV *)SvRV(ST(4));
	AV * n2ray = (AV *)SvRV(ST(5));
	AV * n3ray = (AV *)SvRV(ST(6));
        int ntri;
        CODE:
        double *p1, *p2, *p3;
        int *p4, *p5, *p6;

        p1 = arraytofloat (x1ray, n);
        p2 = arraytofloat (x2ray, n);
        p3 = arraytofloat (x3ray, n);
        p4 = arraytoint (n1ray, ntri);
        p5 = arraytoint (n2ray, ntri);
        p6 = arraytoint (n3ray, ntri);

        if (p1 != NULL && p2 != NULL && p3 != NULL &&
            p4 != NULL && p5 != NULL && p6 != NULL)
          surtri (p1, p2, p3, n, p4, p5, p6, ntri);

        Safefree (p1);
        Safefree (p2);
        Safefree (p3);
        Safefree (p4);
        Safefree (p5);
        Safefree (p6);

void
Dislin_surmsh (s)
	char *s;
	CODE:
	surmsh (s);

void
Dislin_suropt (s)
	char *s;
	CODE:
	suropt (s);

void
Dislin_surshc (x1ray, nx, x2ray, ny, xmat, wmat)
	AV * x1ray = (AV *)SvRV(ST(0));
        int nx;
	AV * x2ray = (AV *)SvRV(ST(2));
	int ny;
	AV * xmat = (AV *)SvRV(ST(4));
	AV * wmat = (AV *)SvRV(ST(4));
        CODE:
        double *p1, *p2, *p3, *p4;

        p1 = arraytofloat (x1ray, nx);
        p2 = arraytofloat (x2ray, ny);
        p3 = matrixtofloat (xmat, nx, ny);
        p4 = matrixtofloat (wmat, nx, ny);

        if (p1 != NULL && p2 != NULL && p3 != NULL && p4 != NULL)
          surshc (p1, nx, p2, ny, p3, p4);

        Safefree (p1);
        Safefree (p2);
        Safefree (p3);
        Safefree (p4);

void
Dislin_surshd (x1ray, nx, x2ray, ny, xmat)
	AV * x1ray = (AV *)SvRV(ST(0));
        int nx;
	AV * x2ray = (AV *)SvRV(ST(2));
	int ny;
	AV * xmat = (AV *)SvRV(ST(4));
        CODE:
        double *p1, *p2, *p3;

        p1 = arraytofloat (x1ray, nx);
        p2 = arraytofloat (x2ray, ny);
        p3 = matrixtofloat (xmat, nx, ny);


        if (p1 != NULL && p2 != NULL && p3 != NULL)
          surshd (p1, nx, p2, ny, p3);

        Safefree (p1);
        Safefree (p2);
        Safefree (p3);

void
Dislin_sursze (x1, x2, x3, x4)
	double x1;
	double x2;
        double x3;
	double x4;
	CODE:
	sursze (x1, x2, x3, x4);

void
Dislin_survis (s)
	char *s;
	CODE:
	survis (s);

void
Dislin_swapi2 (n1ray, n)
	AV * n1ray = (AV *)SvRV(ST(0));
        int n;
        CODE:
        int i;
        short *p1;

        New (1, p1, n, short);
        for (i = 0; i < n; i++)
          p1[i] = (short) SvIV(*av_fetch(n1ray,i,0));

        if (p1 != NULL)
        { swapi2 (p1, n);
          for (i = 0; i < n; i++)
            av_store(n1ray,i,newSViv ((int) p1[i]));
        }
        Safefree (p1);

void
Dislin_swapi4 (n1ray, n)
	AV * n1ray = (AV *)SvRV(ST(0));
        int n;
        CODE:
        int *p1;

        p1 = arraytoint (n1ray, n);
        if (p1 != NULL)
        {  swapi4 (p1, n);
           inttoarray (p1, n1ray, n);
        }
        Safefree (p1);

void
Dislin_swgatt (i, s1, s2)
        int i;
	char *s1;
	char *s2;
	CODE:
	swgatt (i, s1, s2);

void
Dislin_swgbox (i1, i2)
	int i1;
	int i2;
	CODE:
	swgbox (i1, i2);

void
Dislin_swgbut (i1, i2)
	int i1;
	int i2;
	CODE:
	swgbut (i1, i2);

void
Dislin_swgcb2 (i, s)
	int i;
	char *s;
	CODE:
        int n;
        char *p;
        n = (int) strlen (s);
        New (1, p, n + 1, char);
        strcpy (p, s);
        if (ncbray < MAX_CB)
        { cbray[ncbray] = p;
          icbray[ncbray] = i;
          ncbray++;
          swgcb2 (i, dis_callbck3);
        }

void
Dislin_swgcb3 (i, s)
	int i;
	char *s;
	CODE:
        int n;
        char *p;
        n = (int) strlen (s);
        New (1, p, n + 1, char);
        strcpy (p, s);
        if (ncbray < MAX_CB)
        { cbray[ncbray] = p;
          icbray[ncbray] = i;
          ncbray++;
          swgcb3 (i, dis_callbck4);
        }

void
Dislin_swgcbk (i, s)
	int i;
	char *s;
	CODE:
        int n;
        char *p;
        n = (int) strlen (s);
        New (1, p, n + 1, char);
        strcpy (p, s);
        if (ncbray < MAX_CB)
        { cbray[ncbray] = p;
          icbray[ncbray] = i;
          ncbray++;
          swgcbk (i, dis_callbck);
        }

void
Dislin_swgclr (x1, x2, x3, s)
	double x1;
	double x2;
	double x3;
        char *s;
	CODE:
	swgclr (x1, x2, x3, s);

void
Dislin_swgbgd (id, x1, x2, x3)
        int id; 
	double x1;
	double x2;
	double x3;
	CODE:
	swgbgd (id, x1, x2, x3);

void
Dislin_swgfgd (id, x1, x2, x3)
        int id; 
	double x1;
	double x2;
	double x3;
	CODE:
	swgfgd (id, x1, x2, x3);

void
Dislin_swgdrw (x)
	double x;
	CODE:
	swgdrw (x);

void
Dislin_swgfil (i, s)
	int i;
	char *s;
	CODE:
	swgfil (i, s);

void
Dislin_swgflt (i, x, ndig)
	int i;
	double x;
        int ndig;
	CODE:
	swgflt (i, x, ndig);

void
Dislin_swgfnt (s, i)
	char *s;
        int i;
	CODE:
	swgfnt (s, i);

void
Dislin_swgfoc (i)
	int i;
	CODE:
	swgfoc (i);

void
Dislin_swghlp (s)
	char *s;
	CODE:
	swghlp (s);

void
Dislin_swgint (i, iv)
	int i;
	int iv;
	CODE:
	swgint (i, iv);

void
Dislin_swgiop (i, s)
	int i;
	char *s;
	CODE:
	swgiop (i, s);

void
Dislin_swgjus (s1, s2)
	char *s1;
	char *s2;
	CODE:
	swgjus (s1, s2);

void
Dislin_swglis (i1, i2)
	int i1;
	int i2;
	CODE:
	swglis (i1, i2);

void
Dislin_swgmix (s1, s2)
	char *s1;
	char *s2;
	CODE:
	swgmix (s1, s2);

void
Dislin_swgmrg (i, s)
	int i;
	char *s;
	CODE:
	swgmrg (i, s);

void
Dislin_swgoff (i1, i2)
	int i1;
	int i2;
	CODE:
	swgoff (i1, i2);

void
Dislin_swgopt (s1, s2)
	char *s1;
	char *s2;
	CODE:
	swgopt (s1, s2);

void
Dislin_swgpop (s)
	char *s;
	CODE:
	swgpop (s);

void
Dislin_swgpos (i1, i2)
	int i1;
	int i2;
	CODE:
	swgpos (i1, i2);

void
Dislin_swgray (x1ray, n, s)
	AV * x1ray = (AV *)SvRV(ST(0));
        int n;
        char *s;
        CODE:
        double *p1;

        p1 = arraytofloat (x1ray, n);
        if (p1 != NULL) swgray (p1, n, s);
        Safefree (p1);

void
Dislin_swgscl (i, x)
	int i;
	double x;
	CODE:
	swgscl (i, x);

void
Dislin_swgsiz (i1, i2)
	int i1;
	int i2;
	CODE:
	swgsiz (i1, i2);

void
Dislin_swgspc (x, y)
	double x;
        double y;
	CODE:
	swgspc (x, y);

void
Dislin_swgstp (x)
	double x;
	CODE:
	swgstp (x);

void
Dislin_swgtbf (i, x, ndig, irow, icol, s)
	int i;
	double x;
        int ndig;
        int irow;
        int icol;
        char *s;
	CODE:
	swgtbf (i, x, ndig, irow, icol, s);

void
Dislin_swgtbi (i, ix, irow, icol, s)
	int i;
	int ix;
        int irow;
        int icol;
        char *s;
	CODE:
	swgtbi (i, ix, irow, icol, s);

void
Dislin_swgtbl (id, x1ray, n, ndig, idx, s)
        int id;
	AV * x1ray = (AV *)SvRV(ST(1));
        int n;
        int ndig;
        int idx; 
        char *s;
        CODE:
        double *p1;

        p1 = arraytofloat (x1ray, n);
        if (p1 != NULL) swgtbl (id, p1, n, ndig, idx, s);
        Safefree (p1);

void
Dislin_swgtbs (i, s1, irow, icol, s2)
	int i;
	char *s1;
        int irow;
        int icol;
        char *s2;
	CODE:
	swgtbs (i, s1, irow, icol, s2);

void
Dislin_swgtit (s)
	char *s;
	CODE:
	swgtit (s);

void
Dislin_swgtxt (i, s)
	int i;
	char *s;
	CODE:
	swgtxt (i, s);

void
Dislin_swgtyp (s1, s2)
	char *s1;
	char *s2;
	CODE:
	swgtyp (s1, s2);

void
Dislin_swgval (i, x)
	int i;
	double x;
	CODE:
	swgval (i, x);

void
Dislin_swgwin (i1, i2, i3, i4)
	int i1;
        int i2;
        int i3;
        int i4;
	CODE:
        swgwin (i1, i2, i3, i4);

void
Dislin_swgwth (i)
	int i;
	CODE:
	swgwth (i);

void
Dislin_symb3d (i1, x1, x2, x3)
        int i1;
	double x1;
	double x2;
	double x3;
	CODE:
	symb3d (i1, x1, x2, x3);

void
Dislin_symbol (i1, i2, i3)
	int i1;
	int i2;
	int i3;
	CODE:
	symbol (i1, i2, i3);

void
Dislin_symfil (s1, s2)
	char *s1;
	char *s2;
	CODE:
	symfil (s1, s2);

void
Dislin_symrot (x)
	double x;
	CODE:
	symrot (x);

int
Dislin_tellfl (i)
	int i;
        CODE:
        RETVAL = tellfl (i);
        OUTPUT:
        RETVAL

void
Dislin_thkc3d (x)
	double x;
	CODE:
	thkc3d (x);

void
Dislin_thkcrv (i)
	int i;
	CODE:
	thkcrv (i);

void
Dislin_thrfin ()
	CODE:
        thrfin ();      

void
Dislin_thrini (i)
	int i;
	CODE:
	thrini (i);

void
Dislin_ticks (i, s)
	int i;
	char *s;
	CODE:
	ticks (i, s);

void
Dislin_ticlen (i1, i2)
	int i1;
	int i2;
	CODE:
	ticlen (i1, i2);

void
Dislin_ticmod (s1, s2)
	char *s1;
	char *s2;
	CODE:
	ticmod (s1, s2);

void
Dislin_ticpos (s1, s2)
	char *s1;
	char *s2;
	CODE:
	ticpos (s1, s2);

void
Dislin_tifmod (i1, s1, s2)
	int i1;
	char *s1;
	char *s2;
	CODE:
	tifmod (i1, s1, s2);

void
Dislin_tiforg (i1, i2)
	int i1;
	int i2;
	CODE:
	tiforg (i1, i2);

void
Dislin_tifwin (i1, i2, i3, i4)
	int i1;
        int i2;
        int i3;
        int i4;
	CODE:
        tifwin (i1, i2, i3, i4);

void
Dislin_timopt ()
	CODE:
	timopt ();

void
Dislin_titjus (s)
	char *s;
	CODE:
	titjus (s);

void
Dislin_title ()
	CODE:
	title ();

void
Dislin_titlin (s, i)
	char *s;
	int i;
	CODE:
	titlin (s, i);

void
Dislin_torus3d (x1, x2, x3, x4, x5, x6, x7, x8, i1, i2)
	double x1;
	double x2;
	double x3;
	double x4;
	double x5;
	double x6;
	double x7;
	double x8;
        int i1;
        int i2;
	CODE:
	torus3d (x1, x2, x3, x4, x5, x6, x7, x8, i1, i2);

void
Dislin_tprini ()
	CODE:
	tprini ();

void
Dislin_tprfin ()
	CODE:
	tprfin ();

void
Dislin_tprmod (s1, s2)
	char *s1;
	char *s2;
	CODE:
	tprmod (s1, s2);

void
Dislin_tprval (x)
	double x;
	CODE:
	tprval (x);

void
Dislin_tr3axs (x1, x2, x3, a)
	double x1;
	double x2;
	double x3;
	double a;
	CODE:
	tr3axs (x1, x2, x3, a);

void
Dislin_tr3res ()
	CODE:
	tr3res ();

void
Dislin_tr3rot (x1, x2, x3)
	double x1;
	double x2;
	double x3;
	CODE:
	tr3rot (x1, x2, x3);

void
Dislin_tr3scl (x1, x2, x3)
	double x1;
	double x2;
	double x3;
	CODE:
	tr3scl (x1, x2, x3);

void
Dislin_tr3shf (x1, x2, x3)
	double x1;
	double x2;
	double x3;
	CODE:
	tr3shf (x1, x2, x3);

void
Dislin_titpos (s)
	char *s;
	CODE:
	titpos (s);

void
Dislin_trfco1 (x1ray, n, s1, s2)
	AV * x1ray = (AV *)SvRV(ST(0));
        int n;
	char *s1;
	char *s2;
        CODE:
        double *p1;

        p1 = arraytofloat (x1ray, n);
        if (p1 != NULL)
        { trfco1 (p1, n, s1, s2);
          floattoarray (p1, x1ray, n);
        } 
        Safefree (p1);

void
Dislin_trfco2 (x1ray, x2ray, n, s1, s2)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
        int n;
	char *s1;
	char *s2;
        CODE:
        double *p1, *p2;

        p1 = arraytofloat (x1ray, n);
        p2 = arraytofloat (x2ray, n);

        if (p1 != NULL && p2 != NULL)
        { trfco2 (p1, p2, n, s1, s2);
          floattoarray (p1, x1ray, n);
          floattoarray (p2, x2ray, n);
        }

        Safefree (p1);
        Safefree (p2);

void
Dislin_trfco3 (x1ray, x2ray, x3ray, n, s1, s2)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
	AV * x3ray = (AV *)SvRV(ST(2));
        int n;
	char *s1;
	char *s2;
        CODE:
        double *p1, *p2, *p3;

        p1 = arraytofloat (x1ray, n);
        p2 = arraytofloat (x2ray, n);
        p3 = arraytofloat (x3ray, n);

        if (p1 != NULL && p2 != NULL && p3 != NULL)
        { trfco3 (p1, p2, p3, n, s1, s2);
          floattoarray (p1, x1ray, n);
          floattoarray (p2, x2ray, n);
          floattoarray (p3, x3ray, n);
        }

        Safefree (p1);
        Safefree (p2);
        Safefree (p3);

void
Dislin_trfdat (i1, i2, i3, i4)
	int i1;
	int i2;
	int i3;
	int i4;
        CODE:
        int j1, j2, j3;
        trfdat (i1, &j1, &j2, &j3);
        i2 = j1;
        i3 = j2;
        i4 = j3;
        OUTPUT:
        i2
        i3
        i4

void
Dislin_triflc (x1ray, x2ray, n1ray, n)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
	AV * n1ray = (AV *)SvRV(ST(2));
        int n;
        CODE:
        double *p1, *p2;
        int *p3;

        p1 = arraytofloat (x1ray, n);
        p2 = arraytofloat (x2ray, n);
        p3 = arraytoint (n1ray, n);

        if (p1 != NULL && p2 != NULL && p3 != NULL)
          triflc (p1, p2, p3, n);

        Safefree (p1);
        Safefree (p2);
        Safefree (p3);

void
Dislin_trifll (x1ray, x2ray)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
        CODE:
        double *p1, *p2;

        p1 = arraytofloat (x1ray, 3);
        p2 = arraytofloat (x2ray, 3);
        if (p1 != NULL && p2 != NULL) trifll (p1, p2);
        Safefree (p1);
        Safefree (p2);

void
Dislin_trfmat (xmat, nx, ny, xmat2, nx2, ny2)
	AV * xmat = (AV *)SvRV(ST(0));
	int nx;
        int ny;
	AV * xmat2 = (AV *)SvRV(ST(3));
	int nx2;
        int ny2;
        CODE:
        double *p1, *p2;

        p1 = matrixtofloat (xmat, nx, ny);
        New (1, p2, nx2 * ny2, double);

        if (p1 != NULL && p2 != NULL)
        { trfmat (p1, nx, ny, p2, nx2, ny2);
          floattomatrix (p2, xmat2, nx2, ny2);
        } 

        Safefree (p1);
        Safefree (p2);

void
Dislin_trfrel (x1ray, x2ray, n)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
        int n;
        CODE:
        double *p1, *p2;

        p1 = arraytofloat (x1ray, n);
        p2 = arraytofloat (x2ray, n);
        if (p1 != NULL && p2 != NULL)
        { trfrel (p1, p2, n);
          floattoarray (p1, x1ray, n);
          floattoarray (p2, x2ray, n);
        }

        Safefree (p1);
        Safefree (p2);

void
Dislin_trfres ()
	CODE:
	trfres ();

void
Dislin_trfrot (x, i1, i2)
	double x;
	int i1;
	int i2;
	CODE:
	trfrot (x, i1, i2);

void
Dislin_trfscl (x1, x2)
	double x1;
	double x2;
	CODE:
	trfscl (x1, x2);

void
Dislin_trfshf (i1, i2)
	int i1;
	int i2;
	CODE:
	trfshf (i1, i2);

void
Dislin_tria3d (x1ray, x2ray, x3ray)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
	AV * x3ray = (AV *)SvRV(ST(2));
        CODE:
        double *p1, *p2, *p3;

        p1 = arraytofloat (x1ray, 3);
        p2 = arraytofloat (x2ray, 3);
        p3 = arraytofloat (x3ray, 3);
        if (p1 != NULL && p2 != NULL && p3 != NULL)
          tria3d (p1, p2, p3);
        Safefree (p1);
        Safefree (p2);
        Safefree (p3);

int
Dislin_triang (x1ray, x2ray, n, n1ray, n2ray, n3ray, nmax)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
        int n;
	AV * n1ray = (AV *)SvRV(ST(3));
	AV * n2ray = (AV *)SvRV(ST(4));
	AV * n3ray = (AV *)SvRV(ST(5));
        int nmax;
        CODE:
        int ntri;
        double *p1, *p2;
        int *p3, *p4, *p5; 

        p1 = arraytofloat (x1ray, n + 3);
        p2 = arraytofloat (x2ray, n + 3);
        New (1, p3, nmax, int);
        New (1, p4, nmax, int);
        New (1, p5, nmax, int);

        ntri = 0;
        if (p1 != NULL && p2 != NULL && p3 != NULL && p4 != NULL &&
            p5 != NULL) 
        { ntri = triang (p1, p2, n, p3, p4, p5, nmax);
          inttoarray (p3, n1ray, ntri);
          inttoarray (p4, n2ray, ntri);
          inttoarray (p5, n3ray, ntri);
        }

        RETVAL = ntri;
        Safefree (p1);
        Safefree (p2);
        Safefree (p3);
        Safefree (p4);
        Safefree (p5);
        OUTPUT:
        RETVAL

void
Dislin_triplx ()
	CODE:
	triplx ();

int
Dislin_tripts (x1ray, x2ray, x3ray, n, n1ray, n2ray, n3ray, ntri, zlev,xpts, ypts, maxpts, nray, maxray)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
	AV * x3ray = (AV *)SvRV(ST(2));
        int n;
	AV * n1ray = (AV *)SvRV(ST(4));
	AV * n2ray = (AV *)SvRV(ST(5));
	AV * n3ray = (AV *)SvRV(ST(6));
        int ntri;
        double zlev;
	AV * xpts = (AV *)SvRV(ST(9));
	AV * ypts = (AV *)SvRV(ST(10));
        int maxpts;
	AV * nray = (AV *)SvRV(ST(12));
        int maxray;
        CODE:
        int i, nn, nlins;
        double *p1, *p2, *p3, *p7, *p8;
        int *p4, *p5, *p6, *p9;

        p1 = arraytofloat (x1ray, n);
        p2 = arraytofloat (x2ray, n);
        p3 = arraytofloat (x3ray, n);
        p4 = arraytoint (n1ray, ntri);
        p5 = arraytoint (n2ray, ntri);
        p6 = arraytoint (n3ray, ntri);

        New (1, p7, maxpts, double);
        New (1, p8, maxpts, double);
        New (1, p9, maxray, int);

        if (p1 != NULL && p2 != NULL && p3 != NULL &&
            p4 != NULL && p5 != NULL && p6 != NULL &&
            p7 != NULL && p8 != NULL && p9 != NULL)
        { tripts (p1, p2, p3, n, p4, p5, p6, ntri, zlev, p7, p8, maxpts, p9,
                  maxray, &nlins);
          nn = 0; 
          for (i = 0; i < nlins; i++)
             nn += p9[i];

          floattoarray (p7, xpts, nn);
          floattoarray (p8, ypts, nn);
          inttoarray (p9, nray, nn);
        }

        Safefree (p1);
        Safefree (p2);
        Safefree (p3);
        Safefree (p4);
        Safefree (p5);
        Safefree (p6);
        Safefree (p7);
        Safefree (p8);
        Safefree (p9);
        RETVAL = nlins;
        OUTPUT:
        RETVAL

int
Dislin_trmlen (s)
	char *s;
        CODE:
        RETVAL = trmlen (s);
        OUTPUT:
        RETVAL

void
Dislin_texmod (s)
	char *s;
	CODE:
	texmod (s);

void
Dislin_texopt (s1, s2)
	char *s1;
	char *s2;
	CODE:
	texopt (s1, s2);

void
Dislin_texval (x, s)
        double x;
	char *s;
	CODE:
	texval (x, s);

void
Dislin_ttfont (s)
	char *s;
	CODE:
	ttfont (s);

void
Dislin_tube3d (x1, x2, x3, x4, x5, x6, x7, i1, i2)
	double x1;
	double x2;
	double x3;
	double x4;
        double x5;
        double x6;
        double x7; 
        int i1;
        int i2;
	CODE:
	tube3d (x1, x2, x3, x4, x5, x6, x7, i1, i2);

void
Dislin_txtbgd (i)
	int i;
	CODE:
	txtbgd (i);

void
Dislin_txtjus (s)
	char *s;
	CODE:
	txtjus (s);

void
Dislin_txture (imat, nx, ny)
	AV * imat = (AV *)SvRV(ST(0));
	int nx;
        int ny;
        CODE:
        int *p1;

        New (1, p1, nx * ny, int);
        if (p1 != NULL)
        { txture (p1, nx, ny);
          inttomatrix (p1, imat, nx, ny);
        }
        Safefree (p1);

void
Dislin_unit (i)
	int i;
	CODE:
        if (i == 0)
          unit (NULL);
        else
          unit ((void *) stdout);

void
Dislin_units (s)
	char *s;
	CODE:
	units (s);

void
Dislin_upstr (s)
	char *s;
        CODE:
        upstr (s);
        OUTPUT:
        s

int
Dislin_utfint (s, n1ray, nray)
	char *s;
	AV * n1ray = (AV *)SvRV(ST(1));
        int nray;
        CODE:
        int i;
        int *p1;
        int n;
        New (1, p1, nray,  int);

        n = utfint (s, p1, nray);
        for (i = 0; i < n; i++)
          av_store(n1ray,i,newSViv ((int) p1[i]));

        RETVAL = n;
        Safefree (p1);
        OUTPUT:
        RETVAL

void
Dislin_vang3d (x)
	double x;
	CODE:
	vang3d (x);

void
Dislin_vclp3d (x1, x2)
	double x1;
	double x2;
	CODE:
	vclp3d (x1, x2);

void
Dislin_vecclr (i)
	int i;
	CODE:
	vecclr (i);

void
Dislin_vecf3d (x1ray, x2ray, x3ray, x4ray, x5ray, x6ray, n, ivec)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
	AV * x3ray = (AV *)SvRV(ST(2));
	AV * x4ray = (AV *)SvRV(ST(3));
	AV * x5ray = (AV *)SvRV(ST(4));
	AV * x6ray = (AV *)SvRV(ST(5));
        int n;
        int ivec;
        CODE:
        double *p1, *p2, *p3, *p4, *p5, *p6;

        p1 = arraytofloat (x1ray, n);
        p2 = arraytofloat (x2ray, n);
        p3 = arraytofloat (x3ray, n);
        p4 = arraytofloat (x4ray, n);
        p5 = arraytofloat (x5ray, n);
        p6 = arraytofloat (x6ray, n);

        if (p1 != NULL && p2 != NULL && p3 != NULL &&
            p2 != NULL && p5 != NULL && p6 != NULL)
          vecf3d (p1, p2, p3, p4, p5, p6, n, ivec);

        Safefree (p1);
        Safefree (p2);
        Safefree (p3);
        Safefree (p4);
        Safefree (p5);
        Safefree (p6);

void
Dislin_vecfld (x1ray, x2ray, x3ray, x4ray, n, ivec)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
	AV * x3ray = (AV *)SvRV(ST(2));
	AV * x4ray = (AV *)SvRV(ST(3));
        int n;
        int ivec;
        CODE:
        double *p1, *p2, *p3, *p4;

        p1 = arraytofloat  (x1ray, n);
        p2 = arraytofloat  (x2ray, n);
        p3 = arraytofloat  (x3ray, n);
        p4 = arraytofloat  (x4ray, n);

        if (p1 != NULL && p2 != NULL && p3 != NULL && p4 != NULL)
          vecfld (p1, p2, p3, p4, n, ivec);

        Safefree (p1);
        Safefree (p2);
        Safefree (p3);
        Safefree (p4);

void
Dislin_vecmat (xmat, ymat, nx, ny, xp, yp, ivec)
	AV * xmat = (AV *)SvRV(ST(0));
	AV * ymat = (AV *)SvRV(ST(1));
        int nx;
	int ny;
	AV * xp = (AV *)SvRV(ST(4));
	AV * yp = (AV *)SvRV(ST(5));
        int ivec;
        CODE:
        double *p1, *p2, *p3, *p4;

        p1 = matrixtofloat (xmat, nx, ny);
        p2 = matrixtofloat (ymat, nx, ny);
        p3 = arraytofloat  (xp, nx);
        p4 = arraytofloat  (yp, ny);

        if (p1 != NULL && p2 != NULL && p3 != NULL && p4 != NULL)
          vecmat (p1, p2, nx, ny, p3, p4, ivec);

        Safefree (p1);
        Safefree (p2);
        Safefree (p3);
        Safefree (p4);

void
Dislin_vecmat3d (xmat, ymat, zmat,  nx, ny, nz, xp, yp, zp, ivec)
	AV * xmat = (AV *)SvRV(ST(0));
	AV * ymat = (AV *)SvRV(ST(1));
	AV * zmat = (AV *)SvRV(ST(2));
        int nx;
	int ny;
	int nz;
	AV * xp = (AV *)SvRV(ST(6));
	AV * yp = (AV *)SvRV(ST(7));
	AV * zp = (AV *)SvRV(ST(8));
        int ivec;
        CODE:
        double *p1, *p2, *p3, *p4, *p5, *p6;

        p1 = matrix3tofloat (xmat, nx, ny, nz);
        p2 = matrix3tofloat (ymat, nx, ny, nz);
        p3 = matrix3tofloat (zmat, nx, ny, nz);
        p4 = arraytofloat  (xp, nx);
        p5 = arraytofloat  (yp, ny);
        p6 = arraytofloat  (zp, nz);

        if (p1 != NULL && p2 != NULL && p3 != NULL && 
            p4 != NULL && p5 != NULL && p6 != NULL)
        vecmat3d (p1, p2, p3, nx, ny, nz, p4, p5, p6, ivec);

        Safefree (p1);
        Safefree (p2);
        Safefree (p3);
        Safefree (p4);
        Safefree (p5);
        Safefree (p6);

void
Dislin_vecopt (x, s)
        double x;
	char *s;
	CODE:
	vecopt (x, s);

void
Dislin_vector (i1, i2, i3, i4, i5)
	int i1;
        int i2;
        int i3;
        int i4;
	int i5;
	CODE:
        vector (i1, i2, i3, i4, i5);

void
Dislin_vectr3 (x1, x2, x3, x4, x5, x6, i)
	double x1;
	double x2;
	double x3;
	double x4;
	double x5;
	double x6;
	int i;
	CODE:
        vectr3 (x1, x2, x3, x4, x5, x6, i);

void
Dislin_vfoc3d (x1, x2, x3, s)
	double x1;
	double x2;
	double x3;
	char *s;
	CODE:
        vfoc3d (x1, x2, x3, s);

void
Dislin_view3d (x1, x2, x3, s)
	double x1;
	double x2;
	double x3;
	char *s;
	CODE:
        view3d (x1, x2, x3, s);

void
Dislin_vkxbar (i)
	int i;
	CODE:
	vkxbar (i);

void
Dislin_vkybar (i)
	int i;
	CODE:
	vkybar (i);

void
Dislin_vkytit (i)
	int i;
	CODE:
	vkytit (i);

void
Dislin_vltfil (s1, s2)
	char *s1;
        char *s2;
	CODE:
	vltfil (s1, s2);

void
Dislin_vscl3d (x)
	double x;
	CODE:
	vscl3d (x);

void
Dislin_vtx3d (x1ray, x2ray, x3ray, n, s1)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
	AV * x3ray = (AV *)SvRV(ST(2));
        int n;
        char *s1;
        CODE:
        double *p1, *p2, *p3;

        p1 = arraytofloat (x1ray, n);
        p2 = arraytofloat (x2ray, n);
        p3 = arraytofloat (x3ray, n);

        if (p1 != NULL && p2 != NULL && p3 != NULL)
          vtx3d (p1, p2, p3, n, s1);

        Safefree (p1);
        Safefree (p2);
        Safefree (p3);

void
Dislin_vtxc3d (x1ray, x2ray, x3ray, n1ray, n, s1)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
	AV * x3ray = (AV *)SvRV(ST(2));
	AV * n1ray = (AV *)SvRV(ST(3));
        int n;
        char *s1;
        CODE:
        double *p1, *p2, *p3;
        int *p4;

        p1 = arraytofloat (x1ray, n);
        p2 = arraytofloat (x2ray, n);
        p3 = arraytofloat (x3ray, n);
        p4 = arraytoint (n1ray, n);

        if (p1 != NULL && p2 != NULL && p3 != NULL && p4 != NULL)
          vtxc3d (p1, p2, p3, p4, n, s1);

        Safefree (p1);
        Safefree (p2);
        Safefree (p3);
        Safefree (p4);

void
Dislin_vtxn3d (x1ray, x2ray, x3ray, x4ray, x5ray, x6ray, n, s1)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
	AV * x3ray = (AV *)SvRV(ST(2));
	AV * x4ray = (AV *)SvRV(ST(3));
	AV * x5ray = (AV *)SvRV(ST(4));
	AV * x6ray = (AV *)SvRV(ST(5));
        int n;
        char *s1;
        CODE:
        double *p1, *p2, *p3, *p4, *p5, *p6;

        p1 = arraytofloat (x1ray, n);
        p2 = arraytofloat (x2ray, n);
        p3 = arraytofloat (x3ray, n);
        p4 = arraytofloat (x4ray, n);
        p5 = arraytofloat (x5ray, n);
        p6 = arraytofloat (x6ray, n);

        if (p1 != NULL && p2 != NULL && p3 != NULL && 
            p4 != NULL && p5 != NULL && p6 != NULL)
          vtxn3d (p1, p2, p3, p4, p5, p6, n, s1);

        Safefree (p1);
        Safefree (p2);
        Safefree (p3);
        Safefree (p4);
        Safefree (p5);
        Safefree (p6);

void
Dislin_vup3d (x)
	double x;
	CODE:
	vup3d (x);

int
Dislin_wgapp (ip, s)
	int ip;
	char *s;
        CODE:
        RETVAL = wgapp (ip, s);
        OUTPUT:
        RETVAL

int
Dislin_wgappb (ip, n1ray, nw, nh)
	int ip;
	AV * n1ray = (AV *)SvRV(ST(1));
        int nw;
        int nh;
        CODE:
        int i, n1;
        char *p1;
        n1 = (int) av_len (n1ray) + 1;

        New (1, p1, n1, char);
        for (i = 0; i < n1; i++)
          p1[i] = (int) SvIV(*av_fetch(n1ray,i,0));

        RETVAL = wgappb (ip, (unsigned char *) p1, nw, nh);
        Safefree (p1);
        OUTPUT:
        RETVAL

int
Dislin_wgbas (ip, s)
	int ip;
	char *s;
        CODE:
        RETVAL = wgbas (ip, s);
        OUTPUT:
        RETVAL


int
Dislin_wgbox (ip, s, i)
	int ip;
	char *s;
	int i;
        CODE:
        RETVAL = wgbox (ip, s, i);
        OUTPUT:
        RETVAL

int
Dislin_wgbut (ip, s, i)
	int ip;
	char *s;
	int i;
        CODE:
        RETVAL = wgbut (ip, s, i);
        OUTPUT:
        RETVAL

int
Dislin_wgcmd (ip, s1, s2)
	int ip;
	char *s1;
	char *s2;
        CODE:
        RETVAL = wgcmd (ip, s1, s2);
        OUTPUT:
        RETVAL

int
Dislin_wgdlis (ip, s, i)
	int ip;
	char *s;
	int i;
        CODE:
        RETVAL = wgdlis (ip, s, i);
        OUTPUT:
        RETVAL

int
Dislin_wgdraw (ip)
	int ip;
        CODE:
        RETVAL = wgdraw (ip);
        OUTPUT:
        RETVAL

int
Dislin_wgfil (ip, s1, s2, s3)
	int ip;
	char *s1;
	char *s2;
	char *s3;
        CODE:
        RETVAL = wgfil (ip, s1, s2, s3);
        OUTPUT:
        RETVAL

void
Dislin_wgfin ()
	CODE:
	wgfin ();

int
Dislin_wgini (s)
	char *s;
        CODE:
        RETVAL = wgini (s);
        OUTPUT:
        RETVAL

int
Dislin_wglab (ip, s)
	int ip;
	char *s;
        CODE:
        RETVAL = wglab (ip, s);
        OUTPUT:
        RETVAL

int
Dislin_wgicon (ip, s1, nw, nh, s2)
	int ip;
	char *s1;
        int nw;
        int nh;
        char *s2;
        CODE:
        RETVAL = wgicon (ip, s1, nw, nh, s2);
        OUTPUT:
        RETVAL

int
Dislin_wgimg (ip, s, n1ray, nw, nh)
	int ip;
        char *s;
	AV * n1ray = (AV *)SvRV(ST(2));
        int nw;
        int nh;
        CODE:
        int i, n1;
        char *p1;
        n1 = (int) av_len (n1ray) + 1;

        New (1, p1, n1, char);
        for (i = 0; i < n1; i++)
          p1[i] = (int) SvIV(*av_fetch(n1ray,i,0));

        RETVAL = wgimg (ip, s, (unsigned char *) p1, nw, nh);
        Safefree (p1);
        OUTPUT:
        RETVAL

int
Dislin_wglis (ip, s, i)
	int ip;
	char *s;
	int i;
        CODE:
        RETVAL = wglis (ip, s, i);
        OUTPUT:
        RETVAL

int
Dislin_wgok (ip)
	int ip;
        CODE:
        RETVAL = wgok (ip);
        OUTPUT:
        RETVAL

int
Dislin_wgpop (ip, s)
	int ip;
	char *s;
        CODE:
        RETVAL = wgpop (ip, s);
        OUTPUT:
        RETVAL

int
Dislin_wgpopb (ip, n1ray, nw, nh)
	int ip;
	AV * n1ray = (AV *)SvRV(ST(1));
        int nw;
        int nh;
        CODE:
        int i, n1;
        char *p1;
        n1 = (int) av_len (n1ray) + 1;

        New (1, p1, n1, char);
        for (i = 0; i < n1; i++)
          p1[i] = (int) SvIV(*av_fetch(n1ray,i,0));

        RETVAL = wgpopb (ip, (unsigned char *) p1, nw, nh);
        Safefree (p1);
        OUTPUT:
        RETVAL

int
Dislin_wgquit (ip)
	int ip;
        CODE:
        RETVAL = wgquit (ip);
        OUTPUT:
        RETVAL

int
Dislin_wgltxt (ip, s1, s2, i)
	int ip;
	char *s1;
	char *s2;
	int i;
        CODE:
        RETVAL = wgltxt (ip, s1, s2, i);
        OUTPUT:
        RETVAL

int
Dislin_wgpbut (ip, s)
	int ip;
	char *s;
        CODE:
        RETVAL = wgpbut (ip, s);
        OUTPUT:
        RETVAL

int
Dislin_wgpicon (ip, s1, nw, nh, s2)
	int ip;
	char *s1;
        int nw;
        int nh;
        char *s2;
        CODE:
        RETVAL = wgpicon (ip, s1, nw, nh, s2);
        OUTPUT:
        RETVAL

int
Dislin_wgpimg (ip, s, n1ray, nw, nh)
	int ip;
        char *s;
	AV * n1ray = (AV *)SvRV(ST(2));
        int nw;
        int nh;
        CODE:
        int i, n1;
        char *p1;
        n1 = (int) av_len (n1ray) + 1;

        New (1, p1, n1, char);
        for (i = 0; i < n1; i++)
          p1[i] = (int) SvIV(*av_fetch(n1ray,i,0));

        RETVAL = wgpimg (ip, s, (unsigned char *) p1, nw, nh);
        Safefree (p1);
        OUTPUT:
        RETVAL

int
Dislin_wgscl (ip, s, x1, x2, x3, i)
	int ip;
	char *s;
	double x1;
	double x2;
	double x3;
	int i;
        CODE:
        RETVAL = wgscl (ip, s, x1, x2, x3, i);
        OUTPUT:
        RETVAL

int
Dislin_wgsep (ip)
	int ip;
        CODE:
        RETVAL = wgsep (ip);
        OUTPUT:
        RETVAL

int
Dislin_wgpbar (ip, x1, x2, x3)
	int ip;
	double x1;
	double x2;
	double x3;
        CODE:
        RETVAL = wgpbar (ip, x1, x2, x3);
        OUTPUT:
        RETVAL

int
Dislin_wgstxt (ip, nsize, nmax)
	int ip;
        int nsize;
        int nmax;
        CODE:
        RETVAL = wgstxt (ip, nsize, nmax);
        OUTPUT:
        RETVAL

int
Dislin_wgtbl (ip, nrows, ncols)
	int ip;
        int nrows;
        int ncols;
        CODE:
        RETVAL = wgtbl (ip, nrows, ncols);
        OUTPUT:
        RETVAL

int
Dislin_wgtxt (ip, s)
	int ip;
	char *s;
        CODE:
        RETVAL = wgtxt (ip, s);
        OUTPUT:
        RETVAL

void
Dislin_widbar (i)
	int i;
	CODE:
	widbar (i);

void
Dislin_wimage (s)
	char *s;
	CODE:
	wimage (s);

void
Dislin_winapp (s)
	char *s;
	CODE:
	winapp (s);

void
Dislin_wincbk (s1, s2)
	char *s1;
        char *s2;
	CODE:
        strcpy (cbwin, s1);
        wincbk (dis_wincbk, s2);

void
Dislin_windbr (x1, i1, i2, i3, x2)
        double x1;
	int i1;
        int i2;
        int i3;
        double x2; 
	CODE:
        windbr (x1, i1, i2, i3, x2);

void
Dislin_window (i1, i2, i3, i4)
	int i1;
        int i2;
        int i3;
        int i4;
	CODE:
        window (i1, i2, i3, i4);

void
Dislin_winfnt (s)
	char *s;
	CODE:
	winfnt (s);

void
Dislin_winico (s)
	char *s;
	CODE:
	winico (s);

int
Dislin_winid ()
        CODE:
        RETVAL = winid ();
        OUTPUT:
        RETVAL

void
Dislin_winjus (s)
	char *s;
	CODE:
	winjus (s);
  
void
Dislin_winkey (s)
	char *s;
	CODE:
	winkey (s);

void
Dislin_winmod (s)
	char *s;
	CODE:
	winmod (s);

void
Dislin_winopt (i, s)
	char *s;
        int i;
	CODE:
	winopt (i, s);

void
Dislin_winsiz (i1, i2)
	int i1;
	int i2;
	CODE:
	winsiz (i1, i2);

void
Dislin_wintit (s)
	char *s;
	CODE:
	wintit (s);

void
Dislin_wintyp (s)
	char *s;
	CODE:
	wintyp (s);

void
Dislin_wmfmod (s1, s2)
	char *s1;
	char *s2;
	CODE:
	wmfmod (s1, s2);


void
Dislin_world ()
	CODE:
	world ();

void
Dislin_wpixel (i1, i2, i3)
	int i1;
	int i2;
	int i3;
	CODE:
	wpixel (i1, i2, i3);

void
Dislin_wpixls (n1ray, i1, i2, i3, i4)
	AV * n1ray = (AV *)SvRV(ST(0));
	int i1;
	int i2;
	int i3;
	int i4;
        CODE:
        int i, n1;
        char *p1;
        n1 = (int) av_len (n1ray) + 1;

        New (1, p1, n1, char);
        for (i = 0; i < n1; i++)
          p1[i] = (int) SvIV(*av_fetch(n1ray,i,0));

	wpixls ((unsigned char *) p1, i1, i2, i3, i4);
        Safefree (p1);

void
Dislin_wpxrow (n1ray, i1, i2, i3)
	AV * n1ray = (AV *)SvRV(ST(0));
	int i1;
	int i2;
	int i3;
	CODE:
        int i, n1;
        char *p1;
        n1 = (int) av_len (n1ray) + 1;
        New (1, p1, n1, char);

        for (i = 0; i < n1; i++)
          p1[i] = (int) SvIV(*av_fetch(n1ray,i,0));

	wpxrow ((unsigned char *) p1, i1, i2, i3);
        Safefree (p1);

int
Dislin_writfl (nu, cbuf, nbyte)
        int nu;
	char *cbuf;
	int nbyte;
        CODE:
        RETVAL = writfl (nu, (unsigned char *) cbuf, nbyte);
        OUTPUT:
        RETVAL

void
Dislin_wtiff (s)
	char *s;
	CODE:
	wtiff (s);

void
Dislin_x11fnt (s1, s2)
	char *s1;
        char *s2;
	CODE:
	x11fnt (s1, s2);

void
Dislin_x11mod (s)
	char *s;
	CODE:
	x11mod (s);

double
Dislin_x2dpos (x, y)
	double x;
	double y;
        CODE:
        RETVAL = x2dpos (x, y);
        OUTPUT:
        RETVAL

double
Dislin_x3dabs (x, y, z)
	double x;
	double y;
	double z;
        CODE:
        RETVAL = x3dabs (x, y, z);
        OUTPUT:
        RETVAL

double
Dislin_x3dpos (x, y, z)
	double x;
	double y;
	double z;
        CODE:
        RETVAL = x3dpos (x, y, z);
        OUTPUT:
        RETVAL

double
Dislin_x3drel (x, y, z)
	double x;
	double y;
	double z;
        CODE:
        RETVAL = x3drel (x, y, z);
        OUTPUT:
        RETVAL

void
Dislin_xaxgit ()
	CODE:
	xaxgit ();

void
Dislin_xaxis (xa, xe, xor, xstp, nl, s, it, nx, ny)
	double xa;
	double xe;
	double xor;
	double xstp;
	int nl;
	char *s;
	int it;
	int nx;
	int ny;
	CODE:
	xaxis (xa, xe, xor, xstp, nl, s, it, nx, ny);

void
Dislin_xaxlg (xa, xe, xor, xstp, nl, s, it, nx, ny)
	double xa;
	double xe;
	double xor;
	double xstp;
	int nl;
	char *s;
	int it;
	int nx;
	int ny;
	CODE:
	xaxlg (xa, xe, xor, xstp, nl, s, it, nx, ny);

void
Dislin_xaxmap (xa, xe, xor, xstp, s, it, ny)
	double xa;
	double xe;
	double xor;
	double xstp;
	char *s;
	int it;
	int ny;
	CODE:
	xaxmap (xa, xe, xor, xstp, s, it, ny);

void
Dislin_xcross ()
	CODE:
	xcross ();

void
Dislin_xdraw (x1, x2)
	double x1;
	double x2;
	CODE:
	xdraw (x1, x2);

double
Dislin_xinvrs (ix)
	int ix;
        CODE:
        RETVAL = xinvrs (ix);
        OUTPUT:
        RETVAL

void
Dislin_xmove (x1, x2)
	double x1;
	double x2;
	CODE:
	xmove (x1, x2);

double
Dislin_xposn (x)
	double x;
        CODE:
        RETVAL = xposn (x);
        OUTPUT:
        RETVAL

double
Dislin_y2dpos (x, y)
	double x;
	double y;
        CODE:
        RETVAL = y2dpos (x, y);
        OUTPUT:
        RETVAL

double
Dislin_y3dabs (x, y, z)
	double x;
	double y;
	double z;
        CODE:
        RETVAL = y3dabs (x, y, z);
        OUTPUT:
        RETVAL

double
Dislin_y3dpos (x, y, z)
	double x;
	double y;
	double z;
        CODE:
        RETVAL = y3dpos (x, y, z);
        OUTPUT:
        RETVAL

double
Dislin_y3drel (x, y, z)
	double x;
	double y;
	double z;
        CODE:
        RETVAL = y3drel (x, y, z);
        OUTPUT:
        RETVAL

void
Dislin_yaxgit ()
	CODE:
	yaxgit ();

void
Dislin_yaxis (xa, xe, xor, xstp, nl, s, it, nx, ny)
	double xa;
	double xe;
	double xor;
	double xstp;
	int nl;
	char *s;
	int it;
	int nx;
	int ny;
	CODE:
	yaxis (xa, xe, xor, xstp, nl, s, it, nx, ny);

void
Dislin_yaxlg (xa, xe, xor, xstp, nl, s, it, nx, ny)
	double xa;
	double xe;
	double xor;
	double xstp;
	int nl;
	char *s;
	int it;
	int nx;
	int ny;
	CODE:
	yaxlg (xa, xe, xor, xstp, nl, s, it, nx, ny);

void
Dislin_yaxmap (xa, xe, xor, xstp, s, it, ny)
	double xa;
	double xe;
	double xor;
	double xstp;
	char *s;
	int it;
	int ny;
	CODE:
	yaxmap (xa, xe, xor, xstp, s, it, ny);

void
Dislin_ycross ()
	CODE:
	ycross ();

double
Dislin_yinvrs (ix)
	int ix;
        CODE:
        RETVAL = yinvrs (ix);
        OUTPUT:
        RETVAL

void
Dislin_ypolar (xa, xe, xor, xstp, s, ndist)
	double xa;
	double xe;
	double xor;
	double xstp;
	char *s;
	int ndist;
	CODE:
	ypolar (xa, xe, xor, xstp, s, ndist);

double
Dislin_yposn (x)
	double x;
        CODE:
        RETVAL = yposn (x);
        OUTPUT:
        RETVAL

double
Dislin_z3dpos (x, y, z)
	double x;
	double y;
	double z;
        CODE:
        RETVAL = z3dpos (x, y, z);
        OUTPUT:
        RETVAL

void
Dislin_zaxis (xa, xe, xor, xstp, nl, s, it, id, nx, ny)
	double xa;
	double xe;
	double xor;
	double xstp;
	int nl;
	char *s;
	int it;
	int id;
	int nx;
	int ny;
	CODE:
	zaxis (xa, xe, xor, xstp, nl, s, it, id, nx, ny);

void
Dislin_zaxlg (xa, xe, xor, xstp, nl, s, it, id, nx, ny)
	double xa;
	double xe;
	double xor;
	double xstp;
	int nl;
	char *s;
	int it;
	int id;
	int nx;
	int ny;
	CODE:
	zaxlg (xa, xe, xor, xstp, nl, s, it, id, nx, ny);

void
Dislin_zbfers ()
	CODE:
        zbfers ();      

void
Dislin_zbffin ()
	CODE:
        zbffin ();      

int
Dislin_zbfini ()
        CODE:
        RETVAL = zbfini ();
        OUTPUT:
        RETVAL

void
Dislin_zbflin (x1, y1, z1, x2, y2, z2)
	double x1;
	double y1;
	double z1;
	double x2;
	double y2;
	double z2;
	CODE:
	zbflin (x1, y1, z1, x2, y2, z2);

void
Dislin_zbfmod (s)
	char *s;
	CODE:
	zbfmod (s);

void
Dislin_zbfres ()
	CODE:
        zbfres ();      

void
Dislin_zbfscl (x)
        double x;
	CODE:
        zbfscl (x);      

void
Dislin_zbftri (x1ray, x2ray, x3ray, n1ray)
	AV * x1ray = (AV *)SvRV(ST(0));
	AV * x2ray = (AV *)SvRV(ST(1));
	AV * x3ray = (AV *)SvRV(ST(2));
	AV * n1ray = (AV *)SvRV(ST(3));
        CODE:
        double *p1, *p2, *p3;
        int *p4;

        p1 = arraytofloat (x1ray, 3);
        p2 = arraytofloat (x2ray, 3);
        p3 = arraytofloat (x3ray, 3);
        p4 = arraytoint (n1ray, 3);

        if (p1 != NULL && p2 != NULL && p3 != NULL && p4 != NULL)
          zbftri (p1, p2, p3, p4);

        Safefree (p1);
        Safefree (p2);
        Safefree (p3);
        Safefree (p4);

void
Dislin_zscale (x1, x2)
	double x1;
	double x2;
	CODE:
	zscale (x1, x2);
