program dislin_surfcp;

uses
   dislin;

var
   pi, stp, pi2	: double;

function myfunc (x:double; y:double; iopt:int32) : double; stdcall;
var
   xv :  double;
begin

   xv := sin (y);
   if iopt = 1 then
      xv := cos (x) * (3 + cos (y));

   if iopt = 2 then
      xv := sin (x) * (3 + cos (y));
   myfunc := xv;
end;

begin
   
   pi  := 3.1415927;	

   scrmod ('revers');
   metafl ('cons');
   setpag ('da4p');
   disini ();
   pagera ();
   complx ();

   titlin ('Surface Plot of the Parametric Function', 2);
   titlin ('[COS(t)*(3+COS(u)), SIN(t)*(3+COS(u)), SIN(u)]', 4);

   axspos (200, 2400);
   axslen (1800, 1800);

   name   ('X-axis', 'X');
   name   ('Y-axis', 'Y');
   name   ('Z-axis', 'Z');
   intax  ();

   vkytit (-300);
   zscale (-1.0, 1.0);
   surmsh ('on');

   graf3d (-4.0 ,4.0, -4.0, 1.0, -4.0, 4.0, -4.0, 1.0,
               -3.0, 3.0, -3.0, 1.0);
   height (40);
   title  ();

   stp := 2 * pi / 30.0;
   pi2 := 2 * pi;

   surfcp (@myfunc, 0.0, pi2, stp, 0.0, pi2, stp);
   disfin ();
end.


