program dislin_surface;

uses
   dislin;

const
   n = 50;
   m = 50;

var
   i, j	 : int32;
   fpi, stepx, stepy, x, y : double;
   zmat	 : array[0..n*m-1] of double;
   ctit1 : ansistring = 'Surface Plot (SURMAT)';
   ctit2 : ansistring = 'F(X,Y) = 2*SIN(X)*SIN(Y)';

begin

   stepx := 360.0 / (n - 1);
   stepy := 360.0 / (m - 1);
   fpi := 3.1415926 / 180.0;

   for i:= 1 to n  do
   begin
      x := (i - 1) * stepx;
      for j:= 1 to m do
      begin	 
	 y := (j - 1) * stepy;
	 zmat[i - 1 + (j - 1) * m] := 2 * sin (x * fpi) * sin (y * fpi);
      end;
   end;

   scrmod ('revers');
   setpag ('da4p');
   metafl ('cons');
   disini ();
   pagera ();
   complx ();
   axspos (200, 2600);
   axslen (1800, 1800);

   name   ('X-axis', 'x');
   name   ('Y-axis', 'y');
   name   ('Z-axis', 'z');

   titlin (ctit1, 2);
   titlin (ctit2, 4);

   view3d (-5.0, -5.0, 4.0, 'abs');
   graf3d (0.0, 360.0, 0.0, 90.0, 0.0, 360.0, 0.0, 90.0,
             -3.0, 3.0, -3.0, 1.0);
   height (50);
   title  ();

   color  ('green');
   surmat (@zmat[0], n, m, 1, 1);
   disfin ();
end.
