program dislin_polar;

uses
   dislin;

const
   n = 300;
   m =  10;
   
var
   i, ic	: int32;
   f, step, a	: double;
   xray, yray	: array[0..n-1] of double;
   x2, y2	: array[0..m-1] of double;

begin
   f := 3.1415926 / 180.0;
   step := 360.0 / (n - 1);
   for i:= 0 to n - 1 do
   begin   
      a := i * step * f;
      yray[i] := a;
      xray[i] := sin (5 * a);
   end;

   for i:= 0 to m - 1 do
   begin   
      x2[i] := i + 1;
      y2[i] := i + 1;
   end;

   setpag ('da4p');
   metafl ('cons');
   scrmod ('revers');
   disini ();
   pagera ();
   hwfont ();
   axspos (450,1800);

   titlin ('Polar Plots', 2);
   ticks  (3, 'Y');
   axends ('NOENDS', 'X');
   labdig (-1, 'Y');
   axslen (1000, 1000);
   axsorg (1050, 900);

   ic := intrgb (0.95, 0.95, 0.95);
   axsbgd (ic);
 
   grafp  (1.0, 0.0, 0.2, 0.0, 30.0);
   color  ('blue');
   curve  (xray, yray, n);
   color  ('fore');
   htitle (50);
   title  ();
   endgrf ();

   labdig (-1, 'X');
   axsorg (1050, 2250);
   labtyp ('VERT', 'Y');
   grafp  (10.0, 0.0, 2.0, 0.0, 30.0);
   barwth (-5.0);
   polcrv ('FBARS');
   color  ('blue');
   curve  (x2, y2, m);
   disfin ();
end.