program dislin_curve;

uses
   dislin;

var
   cbuf	  : ansistring;
   xray	  : array[0..4] of double = (2.0, 4.0, 6.0, 8.0, 10.0);
   y1ray  : array[0..4] of double = (0.0, 0.0, 0.0, 0.0, 0.0);
   y2ray  : array[0..4] of double = (3.2, 1.5, 2.0, 1.0, 3.0);
   ic1ray : array[0..4] of int32  = (50, 150, 100, 200, 175);
   ic2ray : array[0..4] of int32  = (50, 150, 100, 200, 175);

begin
   SetLength (cbuf, 80);
   scrmod ('revers');
   setpag ('da4p');
   metafl ('cons');
   disini ();
   pagera ();
   hwfont ();

   titlin ('3-D Bar Graph / 3-D Pie Chart', 2);
   htitle (40);

   shdpat (16);
   axslen (1500, 1000);
   axspos (300, 1400);

   barwth (0.5);
   bartyp ('3dvert');
   labels ('second', 'bars');
   labpos ('outside', 'bars');
   labclr (255, 'bars');
   graf   (0.0, 12.0, 0.0, 2.0, 0.0, 5.0, 0.0, 1.0);
   title  ();
   color  ('red');
   bars   (@xray[0], @y1ray[0], @y2ray[0], 5);
   endgrf ();

   shdpat (16);
   labels ('data', 'pie');
   labclr (255, 'pie');
   chnpie ('none');
   pieclr (@ic1ray[0], @ic2ray[0], 5);
   pietyp ('3d');
   axspos (300, 2700);
   piegrf (cbuf, 0, @y2ray[0], 5);       
   disfin ();
end.

