program dislin_curve;

uses
   dislin;

const
   n =  100;

var
   i, ic, nx, ny : int32;
   fpi, step, x	 : double;
   xray, y1ray, y2ray : array[0..n-1] of double;
   cbuf	  : ansistring;

begin
   SetLength (cbuf, 15);
   fpi := 3.1415926 / 180.0;
   step := 360.0 / (n - 1);
   for i:= 0 to n - 1 do
   begin
      xray[i] := i * step;
      x := xray[i] * fpi;
      y1ray[i] := sin (x); 
      y2ray[i] := cos (x); 
   end;

   metafl ('cons');
   scrmod ('reverse');
   disini ();
   pagera ();
   complx ();
   axspos (450, 1800);
   axslen (2200, 1200);

   name ('X-axis', 'X');
   name ('Y-axis', 'Y');

   labdig (-1, 'x');
   ticks (9, 'x');
   ticks (10, 'y');

   titlin ('Demonstration of CURVE', 1);
   titlin ('Legend', 3);

   ic := intrgb (0.95, 0.95, 0.95);
   axsbgd (ic);

   graf (0.0, 360.0, 0.0, 90.0, -1.0, 1.0, -1.0, 0.5);
   setrgb (0.7, 0.7, 0.7);
   grid   (1, 1);

   color ('fore');
   height (50);
   title ();

   color ('red');
   curve (@xray[0], @y1ray[0], n);
   color ('green');
   curve (@xray[0], @y2ray[0], n);

   color ('fore');
   legini (cbuf, 2, 7);
   nx := nxposn (190.0);
   ny := nyposn (0.75);
   legpos (nx, ny);
   leglin (cbuf, 'sin (x)', 1);
   leglin (cbuf, 'cos (x)', 2);
   legtit ('Legend');
   legend (cbuf, 3);

   disfin ();
end.
