program dislin_curve;

uses
   dislin;

const
   n = 16;

var
   nya		 : int32 = 2700;
   i, nx, ny, ic : int32;
   x : array[0..n-1] of double = (0.0, 1.0, 3.0, 4.5, 6.0, 8.0, 9.0,
		 11.0, 12.0, 12.5, 13.0, 15.0, 16.0, 17.0, 19.0, 20.0);
   y : array[0..n-1] of double = (2.0, 4.0, 4.5, 3.0, 1.0, 7.0, 2.0,
		  3.0, 5.0, 2.0, 2.5, 2.0, 4.0, 6.0, 5.5, 4.0);
   cpol : array[0..5] of ansistring = ('SPLINE', 'STEM', 'BARS', 'STAIRS',
		  'STEP', 'LINEAR');
   ctit : ansistring = 'Interpolation Methods';

begin
   setpag ('da4p');
   metafl ('cons');
   scrmod ('revers');
   disini ();
   complx ();
   pagera ();
   incmrk (1);
   hsymbl (25);
   titlin (ctit, 2);
   axslen (1500, 350);
   setgrf ('line', 'line', 'line', 'line');
   ic := intrgb (1.0, 1.0, 0.0);
   axsbgd (ic);

   for i := 0 to 5 do
   begin
      axspos (350, nya - i * 350);
      polcrv (cpol[i]);
      marker(16);

      graf   (0.0, 20.0, 0.0, 5.0, 0.0, 10.0, 0.0, 5.0);
      nx := nxposn (1.0);
      ny := nyposn (8.0);
      messag (cpol[i], nx, ny);
      color  ('red');
      curve  (x, y, 16);
      color  ('fore');

      if i = 5 then
      begin
	 height (50);
         title  ();
      end;
      endgrf ();
   end;
   disfin ();
end.
				  
