  {************************************************************** }
  {*                        dislin.pas                          * }
  {*                                                            * }
  {* Dislin interface for Free Pascal.                          * }
  {*                                                            * }
  {* Date     : 15.03.2022                                      * }
  {* Functions: 797                                             * }
  {* Version  : 11.5, Windows, 32- and 64-bit                   * }
  {************************************************************** }

unit dislin;
interface

Type
   Vint32  = longint;
   Vint16  = smallint;
   Pbyte   = ^byte;
   Pchar   = ansistring;
   Pint16  = ^smallint;
   Pint32  = ^longint;
   Pdouble = ^double;
   Pcb1	   = procedure (id:Vint32); stdcall;
   Pcb2    = procedure (x:Pdouble; y:Pdouble); stdcall;
   Pcb3    = procedure (i1:Vint32; i2:Vint32; i3:Vint32); stdcall;
   Pcb4    = procedure (i1:Vint32; i2:Vint32); stdcall;
   Pcb5    = procedure (i1:Vint32); stdcall;
   Pcb6    = procedure (i1:Vint32; i2:Vint32; i3:Vint32; i4:Vint32;
                        i5:Vint32); stdcall;
   Pcb7    = procedure (iseg:Vint32; xdat:double; xper:double; nrad:Pint32;
                        noff:Pint32; angle:Pdouble; nvx:Pint32; 
                        nvy:Pint32; idrw:Pint32; iann:Pint32); stdcall;
   Pfunc1  = function  (x:double; y:double):double;stdcall;
   Pfunc2  = function  (x:double; y:double; n:Vint32):double;stdcall;

procedure abs3pt (x:double; y:double; z:double; xp:Pdouble; yp:Pdouble); 
                  stdcall; external 'dislnc_d.dll';
procedure addlab (cstr:Pchar; v:double; itic:Vint32; cax:Pchar);
                  stdcall; external 'dislnc_d.dll';
procedure angle  (ngrad:Vint32); stdcall; external 'dislnc_d.dll';
procedure arcell (nx:Vint32; ny:Vint32; na:Vint32; nb:Vint32; a:double;
                  b:double; t:double); stdcall; external 'dislnc_d.dll';
procedure areaf  (nxray:Pint32; nyray:Pint32; n:Vint32); stdcall; 
                  external 'dislnc_d.dll';
procedure autres (ixdim:Vint32; iydim:Vint32); stdcall;
                  external 'dislnc_d.dll';
procedure autres3d (ixdim:Vint32; iydim:Vint32; izdim:Vint32); stdcall;
                   external 'dislnc_d.dll';
procedure ax2grf (); stdcall; external 'dislnc_d.dll';
procedure ax3len (nxl:Vint32; nyl:Vint32; nzl:Vint32); stdcall; 
                  external 'dislnc_d.dll';
procedure axclrs (nclr:Vint32; copt:Pchar; cax:Pchar); stdcall; 
                  external 'dislnc_d.dll';
procedure axends (cstr:Pchar; cax:Pchar); stdcall; external 'dislnc_d.dll';
procedure axgit  (); stdcall; external 'dislnc_d.dll';
procedure axis3d (x:double; y:double; z:double); stdcall; 
                  external 'dislnc_d.dll';
procedure axsbgd (nclr:Vint32); stdcall; external 'dislnc_d.dll';
procedure axsers (); stdcall; external 'dislnc_d.dll';
procedure axslen (nxl:Vint32; nyl:Vint32); stdcall; external 'dislnc_d.dll';
procedure axsorg (nxa:Vint32; nya:Vint32); stdcall; external 'dislnc_d.dll';
procedure axspos (nxa:Vint32; nya:Vint32); stdcall; external 'dislnc_d.dll';
procedure axsscl (cscl:Pchar; cax:Pchar); stdcall; external 'dislnc_d.dll';
procedure axstyp (copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure barbor (iclr:Vint32); stdcall; external 'dislnc_d.dll';
procedure barclr (ic1:Vint32; ic2:Vint32; ic3:Vint32); stdcall; 
                  external 'dislnc_d.dll';
procedure bargrp (ngrp:Vint32; gap:double); stdcall; external 'dislnc_d.dll';
procedure barmod (cmod:Pchar; copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure baropt (xf:double; a:double); stdcall; external 'dislnc_d.dll';
procedure barpos (copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure bars   (xray:Pdouble; y1ray:Pdouble; y2ray:Pdouble; n:Vint32); 
                  stdcall; external 'dislnc_d.dll';
procedure bars3d (xray:Pdouble; yray:Pdouble; z1ray:Pdouble; 
                  z2ray:Pdouble; xwray:Pdouble; ywray:Pdouble;
                  icray:Pint32; n:Vint32); stdcall; external 'dislnc_d.dll';
procedure bartyp (ctyp:Pchar); stdcall; external 'dislnc_d.dll';
procedure barwth (factor:double); stdcall; external 'dislnc_d.dll';
procedure basalf (calph:Pchar); stdcall; external 'dislnc_d.dll';
procedure basdat (id:Vint32; im:Vint32; iy:Vint32); stdcall;
                  external 'dislnc_d.dll';
procedure bezier (xray:Pdouble; yray:Pdouble; nray:Vint32; 
                  x:Pdouble; y:Pdouble; n:Vint32); stdcall;
                  external 'dislnc_d.dll';
procedure bfcclr (ic:Vint32); stdcall; external 'dislnc_d.dll';
procedure bfcmsh (ic:Vint32); stdcall; external 'dislnc_d.dll';
function  bitsi2 (mbits:Vint32; mher:Vint16; iher:Vint32; mhin:Vint16; 
                  ihin:Vint32):Vint16; stdcall; external 'dislnc_d.dll';
function  bitsi4 (nbits:Vint32; mher:Vint32; iher:Vint32; mhin:Vint32; 
                  ihin:Vint32):Vint32; stdcall; external 'dislnc_d.dll';
procedure bmpfnt (copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure bmpmod (n:Vint32; cval:Pchar; copt:Pchar); stdcall; 
                  external 'dislnc_d.dll';
procedure box2d  (); stdcall; external 'dislnc_d.dll';
procedure box3d  (); stdcall; external 'dislnc_d.dll';
procedure bufmod (cmod:Pchar; ckey:Pchar); stdcall; external 'dislnc_d.dll';
procedure center (); stdcall; external 'dislnc_d.dll';
procedure cgmbgd (xr:double; xg:double; xb:double); stdcall; 
                  external 'dislnc_d.dll';
procedure cgmpic (cstr:Pchar); stdcall; external 'dislnc_d.dll';
procedure cgmver (nclr:Vint32); stdcall; external 'dislnc_d.dll';
procedure chaang (angle:double); stdcall; external 'dislnc_d.dll';
procedure chacod (copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure chaspc (xspc:double); stdcall; external 'dislnc_d.dll';
procedure chawth (xwth:double); stdcall; external 'dislnc_d.dll';
procedure chnatt (); stdcall; external 'dislnc_d.dll';
procedure chncrv (copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure chndot (); stdcall; external 'dislnc_d.dll';
procedure chndsh (); stdcall; external 'dislnc_d.dll';
procedure chnbar (copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure chnpie (copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure circ3p (x1:double; y1:double; x2:double; y2:double; 
                  x3:double; y3:double; xm:Pdouble; ym:Pdouble; r:Pdouble);
                  stdcall; external 'dislnc_d.dll';
procedure circle (nx:Vint32; ny:Vint32; nr:Vint32); stdcall; 
                  external 'dislnc_d.dll';
procedure circsp (nspc:Vint32); stdcall; external 'dislnc_d.dll';
procedure clip3d (ctyp:Pchar); stdcall; external 'dislnc_d.dll';
function  closfl (nu:Vint32):Vint32; stdcall; external 'dislnc_d.dll'; 
procedure clpbor (copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure clpmod (copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure clpwin (nx:Vint32; ny:Vint32; nw:Vint32; nh:Vint32); stdcall; 
                  external 'dislnc_d.dll';
procedure clrcyc (index:Vint32; iclr:Vint32); stdcall; external 'dislnc_d.dll';
procedure clrmod (cmod:Pchar); stdcall; external 'dislnc_d.dll';
procedure clswin (id:Vint32); stdcall; external 'dislnc_d.dll';
procedure color  (col:Pchar); stdcall; external 'dislnc_d.dll';
procedure colran (nca:Vint32; nce:Vint32); stdcall; external 'dislnc_d.dll';
procedure colray (zray:Pdouble; nray:Pint32; n:Vint32); stdcall; 
                  external 'dislnc_d.dll';
procedure complx (); stdcall; external 'dislnc_d.dll';
procedure conclr (nray:Pint32; n:Vint32); stdcall; external 'dislnc_d.dll';
procedure concrv (xray:Pdouble; yray:Pdouble; n:Vint32; zlev:double); 
                  stdcall; external 'dislnc_d.dll';
procedure cone3d (xm:double; ym:double; zm:double; r:double; 
                  h1:double; h2:double; nsk1:Vint32; nsk2:Vint32); 
                  stdcall; external 'dislnc_d.dll'; 
procedure confll (xray:Pdouble; yray:Pdouble; zray:Pdouble; n:Vint32; 
                  i1ray:Pint32; i2ray:Pint32; i3ray:Pint32; ntri:Vint32; 
                  zlev:Pdouble; nlev:Vint32); stdcall; external 'dislnc_d.dll';
procedure congap (xfac:double); stdcall; external 'dislnc_d.dll';
procedure conlab (clab:Pchar); stdcall; external 'dislnc_d.dll';
procedure conmat (xmat:Pdouble; n:Vint32; m:Vint32; zlev:double); stdcall;
                  external 'dislnc_d.dll';
procedure conmod (xfac:double; xquot:double); stdcall; external 'dislnc_d.dll';
procedure conn3d (x:double; y:double; z:double); stdcall; 
                  external 'dislnc_d.dll';
procedure connpt (x:double; y:double); stdcall; external 'dislnc_d.dll';
procedure conpts (xray:Pdouble; n:Vint32; yray:Pdouble; m:Vint32; 
                  zmat:Pdouble; zlev:double; xpts:Pdouble; ypts:Pdouble; 
                  maxpts:Vint32; nray:Pint32; maxray:Vint32; nlins:Pint32);
                  stdcall; external 'dislnc_d.dll';
procedure conshd (xray:Pdouble; n:Vint32; yray:Pdouble; m:Vint32;
		  zmat:Pdouble; zlev:Pdouble; nlev:Vint32); stdcall;
                  external 'dislnc_d.dll';
procedure conshd2 (xmat:Pdouble; ymat:Pdouble; zmat:Pdouble;
		  n:Vint32; m:Vint32; zlev:Pdouble; nlev:Vint32); stdcall;
                  external 'dislnc_d.dll';
procedure conshd3d (xray:Pdouble; n:Vint32; yray:Pdouble; m:Vint32; 
		  zmat:Pdouble; zlev:Pdouble; nlev:Vint32);
                  stdcall; external 'dislnc_d.dll';
procedure contri (xray:Pdouble; yray:Pdouble; zray:Pdouble; n:Vint32; 
		  i1ray:Pint32; i2ray:Pint32; i3ray:Pint32; 
		  ntri:Vint32; zlev:double); stdcall; external 'dislnc_d.dll';
procedure contur (xray:Pdouble; n:Vint32; yray:Pdouble; m:Vint32;
                  zmat:Pdouble; zlev:double); stdcall; external 'dislnc_d.dll';
procedure contur2 (xmat:Pdouble; ymat:Pdouble; zmat:Pdouble; 
                  n:Vint32; m:Vint32; zlev:double); stdcall; 
                  external 'dislnc_d.dll';
procedure cross  (); stdcall; external 'dislnc_d.dll';
procedure crvmat (zmat:Pdouble; n:Vint32; m:Vint32; ixpts:Vint32;
                  iypts:Vint32); stdcall; external 'dislnc_d.dll';
procedure crvqdr (xray:Pdouble; yray:Pdouble; zray:Pdouble; n:Vint32); 
                  stdcall; external 'dislnc_d.dll'; 
procedure crvt3d (xray:Pdouble; yray:Pdouble; zray:Pdouble;
                  rray:Pdouble; icray:Pint32; n:Vint32); stdcall;
                  external 'dislnc_d.dll';
procedure crvtri (xray:Pdouble; yray:Pdouble; zray:Pdouble; n:Vint32; 
                  i1ray:Pint32; i2ray:Pint32; i3ray:Pint32; ntri:Vint32); 
                  stdcall; external 'dislnc_d.dll';
function  csrkey ():Vint32; stdcall; external 'dislnc_d.dll';
procedure csrlin (ix1:Pint32; iy1:Pint32; ix2:Pint32; iy2:Pint32); stdcall;
                  external 'dislnc_d.dll';
procedure csrmod (cmod:Pchar; ckay:Pchar); stdcall; external 'dislnc_d.dll';
procedure csrpol (ix:Pint32; iy:Pint32; nmax:Vint32; n:Pint32; iret:Pint32); 
                  stdcall; external 'dislnc_d.dll';
function  csrpos (ix:Pint32; iy:Pint32):Vint32; stdcall; 
                  external 'dislnc_d.dll';
procedure csrpt1 (ix:Pint32; iy:Pint32); stdcall; external 'dislnc_d.dll';
procedure csrpts (ix:Pint32; iy:Pint32; nmax:Vint32; n:Pint32; iret:Pint32); 
                  stdcall; external 'dislnc_d.dll';
procedure csrmov (ix:Pint32; iy:Pint32; nmax:Vint32; n:Pint32; iret:Pint32);
                  stdcall; external 'dislnc_d.dll';
procedure csrrec (ix1:Pint32; iy1:Pint32; ix2:Pint32; iy2:Pint32);
                  stdcall; external 'dislnc_d.dll';
procedure csrtyp (copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure csruni (copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure curv3d (xray:Pdouble; yray:Pdouble; zray:Pdouble; n:Vint32); 
                  stdcall; external 'dislnc_d.dll';
procedure curv4d (xray:Pdouble; yray:Pdouble; zray:Pdouble; 
                  wray:Pdouble; n:Vint32); stdcall; external 'dislnc_d.dll';
procedure curve  (xray:Pdouble; yray:Pdouble; n:Vint32); 
                  stdcall; external 'dislnc_d.dll';
procedure curve3 (xray:Pdouble; yray:Pdouble; zray:Pdouble; n:Vint32);
                  stdcall; external 'dislnc_d.dll';
procedure curvmp (xray:Pdouble; yray:Pdouble; n:Vint32); stdcall; 
                  external 'dislnc_d.dll';
procedure curvx3 (xray:Pdouble; y:double; zray:Pdouble; n:Vint32); 
                  stdcall; external 'dislnc_d.dll';
procedure curvy3 (x:double; yray:Pdouble; zray:Pdouble; n:Vint32); 
                  stdcall; external 'dislnc_d.dll';
procedure cyli3d (xm:double; ym:double; zm:double; z:double; h:double; 
                  nsk1:Vint32; nsk2:Vint32); stdcall; external 'dislnc_d.dll'; 
procedure dash   (); stdcall; external 'dislnc_d.dll';
procedure dashl  (); stdcall; external 'dislnc_d.dll';
procedure dashm  (); stdcall; external 'dislnc_d.dll';
procedure dbffin (); stdcall; external 'dislnc_d.dll';
function  dbfini ():Vint32; stdcall; external 'dislnc_d.dll';
procedure dbfmod (copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure delglb (); stdcall; external 'dislnc_d.dll';
procedure digits (ndig:Vint32; cax:Pchar); stdcall; external 'dislnc_d.dll';
procedure disalf (); stdcall; external 'dislnc_d.dll';
procedure disenv (cenv:Pchar); stdcall; external 'dislnc_d.dll';
procedure disfin (); stdcall; external 'dislnc_d.dll';
procedure disini (); stdcall; external 'dislnc_d.dll';
procedure disk3d (xm:double; ym:double; zm:double; r1:double; r2:double; 
                  nsk1:Vint32; nsk2:Vint32); stdcall; external 'dislnc_d.dll'; 
procedure doevnt (); stdcall; external 'dislnc_d.dll';
procedure dot    (); stdcall; external 'dislnc_d.dll';
procedure dotl   (); stdcall; external 'dislnc_d.dll';
procedure duplx  (); stdcall; external 'dislnc_d.dll';
function  dwgbut (cstr:Pchar; ival:Vint32 ):Vint32; stdcall; 
                  external 'dislnc_d.dll';
function  dwgerr ():Vint32; stdcall; external 'dislnc_d.dll';
function  dwgfil (clab:Pchar; cstr:Pchar; cmask:Pchar):Pchar; stdcall; 
                  external 'dislnc_d.dll';
function  dwglis (clab:Pchar; clis:Pchar; ilis:Vint32):Vint32; stdcall;
                  external 'dislnc_d.dll';
procedure dwgmsg (cstr:Pchar); stdcall; external 'dislnc_d.dll';
function  dwgtxt (clab:Pchar; cstr:Pchar):Pchar; stdcall; 
                  external 'dislnc_d.dll';
procedure ellips (nx:Vint32; ny:Vint32; na:Vint32; nb:Vint32); stdcall; 
                  external 'dislnc_d.dll';
procedure endgrf (); stdcall; external 'dislnc_d.dll';
procedure erase  (); stdcall; external 'dislnc_d.dll';
procedure errbar (x:Pdouble; y:Pdouble; err1:Pdouble; err2:Pdouble; 
                  n:Vint32); stdcall; external 'dislnc_d.dll';
procedure errdev (cdev:Pchar); stdcall; external 'dislnc_d.dll';
procedure errfil (cfil:Pchar); stdcall; external 'dislnc_d.dll';
procedure errmod (cstr:Pchar; copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure eushft (cnat:Pchar; cshf:Pchar); stdcall; external 'dislnc_d.dll';
procedure expimg (cfil:Pchar; copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure expzlb (cstr:Pchar); stdcall; external 'dislnc_d.dll';
procedure fbars  (xray:Pdouble; y1ray:Pdouble; y2ray:Pdouble; y3ray:Pdouble;
                  y4ray:Pdouble; n:Vint32); stdcall; external 'dislnc_d.dll';
function  fcha   (x:double; ndig:Vint32; cstr:Pchar):Vint32; stdcall; 
                  external 'dislnc_d.dll';
procedure field  (xray:Pdouble; yray:Pdouble; uray:Pdouble; vray:Pdouble;
                  n:Vint32; ivec:Vint32); stdcall; external 'dislnc_d.dll';
procedure field3d (x1ray:Pdouble; y1ray:Pdouble; z1ray:Pdouble;
                   x2ray:Pdouble; y2ray:Pdouble; z2ray:Pdouble;
                   n:Vint32; ivec:Vint32); stdcall; external 'dislnc_d.dll';
procedure filbox (nx:Vint32; ny:Vint32; nw:Vint32; nh:Vint32); stdcall; 
                  external 'dislnc_d.dll';
procedure filclr (copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure filmod (cmod:Pchar); stdcall; external 'dislnc_d.dll';
procedure filopt (copt:Pchar; ckey:Pchar); stdcall; external 'dislnc_d.dll';
function  filsiz (cfl:Pchar; nw:Pint32; nh:Pint32):Vint32; stdcall; 
                  external 'dislnc_d.dll';
function  filtyp (cfl:Pchar):Vint32; stdcall; external 'dislnc_d.dll';
procedure filwin (nx:Vint32; ny:Vint32; nw:Vint32; nh:Vint32); stdcall; 
                  external 'dislnc_d.dll';
procedure fitscls (); stdcall; external 'dislnc_d.dll';
function  fitsflt (ckey:Pchar):double; stdcall; external 'dislnc_d.dll';
function  fitshdu (nhdu:Vint32):Vint32; stdcall; external 'dislnc_d.dll';
function  fitsimg (iray:Pbyte; nmax:Vint32):Vint32; stdcall; 
                   external 'dislnc_d.dll';
function  fitsopn (cfl:Pchar):Vint32; stdcall; external 'dislnc_d.dll';
procedure fitsstr (ckey:Pchar; cval:Pchar; nmax:Vint32); 
                   stdcall; external 'dislnc_d.dll';
function  fitstyp (ckey:Pchar):Vint32; stdcall; external 'dislnc_d.dll';
function  fitsval (ckey:Pchar):Vint32; stdcall; external 'dislnc_d.dll';
procedure fixspc (xfac:double); stdcall; external 'dislnc_d.dll';
procedure flab3d (); stdcall; external 'dislnc_d.dll';
function  flen   (x:double; ndig:Vint32):Vint32; stdcall; 
                  external 'dislnc_d.dll';
procedure frame  (nfrm:Vint32); stdcall; external 'dislnc_d.dll';
procedure freeptr (p:pointer); stdcall; external 'dislnc_d.dll';
procedure frmbar (nfrm:Vint32); stdcall; external 'dislnc_d.dll';
procedure frmclr (nclr:Vint32); stdcall; external 'dislnc_d.dll';
procedure frmess (nfrm:Vint32); stdcall; external 'dislnc_d.dll';
procedure gapcrv (xgap:double); stdcall; external 'dislnc_d.dll';
procedure gapsiz (gap:double; cax:Pchar); stdcall; external 'dislnc_d.dll';
procedure gaxpar (a1:double; a2:double; copt:Pchar; cax:Pchar;
                  a:Pdouble; b:Pdouble; org:Pdouble; stp:Pdouble; 
                  ndig:Pint32); stdcall; external 'dislnc_d.dll';
function  getalf ():Pchar; stdcall; external 'dislnc_d.dll';
function  getang ():Vint32; stdcall; external 'dislnc_d.dll';
function  getbpp ():Vint32; stdcall; external 'dislnc_d.dll';
procedure getclp (nx:Pint32; ny:Pint32; nw:Pint32; nh:Pint32);
                  stdcall; external 'dislnc_d.dll';
function  getclr ():Vint32; stdcall; external 'dislnc_d.dll';
procedure getdig (nx:Pint32; ny:Pint32; nz:Pint32); stdcall; 
                  external 'dislnc_d.dll';
function  getdsp ():Pchar; stdcall; external 'dislnc_d.dll';
function  getfil ():Pchar; stdcall; external 'dislnc_d.dll';
procedure getgrf (a:Pdouble; e:Pdouble; org:Pdouble; step:Pdouble; cax:Pchar);
                  stdcall; external 'dislnc_d.dll';
function  gethgt ():Vint32; stdcall; external 'dislnc_d.dll';
function  gethnm ():Vint32; stdcall; external 'dislnc_d.dll';
procedure getico (rre:double; rimg:double; zre:Pdouble; zimg:Pdouble); 
                  stdcall; external 'dislnc_d.dll'; 
procedure getind (index:Vint32; xr:Pdouble; xg:Pdouble; xb:Pdouble);
                  stdcall; external 'dislnc_d.dll';
procedure getlab (cx:Pchar; cy:Pchar; cz:Pchar); stdcall; 
                  external 'dislnc_d.dll';
procedure getlen (nxl:Pint32; nyl:Pint32; nzl:Pint32); 
                  stdcall; external 'dislnc_d.dll';
function  getlev ():Vint32; stdcall; external 'dislnc_d.dll';
function  getlin ():Vint32; stdcall; external 'dislnc_d.dll';
function  getlit (xp:double; yp:double; zp:double;
                  xn:double; yn:double; zn:double):Vint32;
                  stdcall; external 'dislnc_d.dll';
procedure getmat (xray:Pdouble; yray:Pdouble; zray:Pdouble; n:Vint32;
                  zmat:Pdouble; nx:Vint32; ny:Vint32; zval:double; imat:Pint32;
                  wmat:Pdouble); stdcall; external 'dislnc_d.dll';
function  getmfl ():Pchar; stdcall; external 'dislnc_d.dll';
function  getmix (copt:Pchar):Pchar; stdcall; external 'dislnc_d.dll';
procedure getor  (nx0:Pint32; ny0:Pint32); stdcall; external 'dislnc_d.dll';
procedure getpag (nxpag:Pint32; nypag:Pint32); stdcall; 
                  external 'dislnc_d.dll';
function  getpat ():Vint32; stdcall; external 'dislnc_d.dll';
function  getplv ():Vint32; stdcall; external 'dislnc_d.dll';
procedure getpos (nxa:Pint32; nya:Pint32); stdcall; external 'dislnc_d.dll';
procedure getran (nca:Pint32; nce:Pint32); stdcall; external 'dislnc_d.dll';
procedure getrco (zre:double; zimg:double; rre:Pdouble; rimg:Pdouble);
                  stdcall; external 'dislnc_d.dll'; 
procedure getres (npb:Pint32; nph:Pint32); stdcall; external 'dislnc_d.dll';
procedure getrgb (xr:Pdouble; xg:Pdouble; xb:Pdouble); stdcall; 
                  external 'dislnc_d.dll';
procedure getscl (nxscl:Pint32; nyscl:Pint32; nzscl:Pint32); stdcall;
                  external 'dislnc_d.dll';
procedure getscm (ix:Pint32; iy:Pint32; iz:Pint32); stdcall; 
                  external 'dislnc_d.dll';
procedure getscr (nwidth:Pint32; nheight:Pint32); stdcall; 
                  external 'dislnc_d.dll';
function  getshf (copt:Pchar):Pchar; stdcall; external 'dislnc_d.dll';
procedure getsp1 (nxdis:Pint32; nydis:Pint32; nzdis:Pint32); stdcall;
                  external 'dislnc_d.dll';
procedure getsp2 (nxdis:Pint32; nydis:Pint32; nzdis:Pint32); stdcall;
                  external 'dislnc_d.dll';
procedure getsym (nxsym:Pint32; nysym:Pint32); stdcall; 
                  external 'dislnc_d.dll';
procedure gettcl (nmaj:Pint32; nmin:Pint32); stdcall; external 'dislnc_d.dll';
procedure gettic (nxtix:Pint32; nytic:Pint32; nztic:Pint32); stdcall;
                  external 'dislnc_d.dll';
function  gettyp ():Vint32; stdcall; external 'dislnc_d.dll';
function  getuni ():pointer; stdcall; external 'dislnc_d.dll';
function  getver ():double; stdcall; external 'dislnc_d.dll';
procedure getvk  (nv:Pint32; nvfx:Pint32; nvfy:Pint32); stdcall; 
                  external 'dislnc_d.dll';
function  getvlt ():Pchar; stdcall; external 'dislnc_d.dll';
function  getwid ():Vint32; stdcall; external 'dislnc_d.dll';
procedure getwin (ix:Pint32; iy:Pint32; nwidth:Pint32; nheight:Pint32); 
                  stdcall; external 'dislnc_d.dll';
function  getxid (copt:Pchar):Vint32; stdcall; external 'dislnc_d.dll';
procedure gifmod (cmod:Pchar; ckey:Pchar); stdcall; external 'dislnc_d.dll';
function  gmxalf (copt:Pchar; ca:Pchar; cb:Pchar):Vint32; stdcall; 
                  external 'dislnc_d.dll';
procedure gothic (); stdcall; external 'dislnc_d.dll';
procedure grace  (nrace:Vint32); stdcall; external 'dislnc_d.dll';
procedure graf   (xa:double; xe:double; xorg:double; xstp:double;
                  ya:double; ye:double; yorg:double; ystp:double);
                  stdcall; external 'dislnc_d.dll';
procedure graf3  (xa:double; xe:double; xorg:double; xstp:double;
                  ya:double; ye:double; yorg:double; ystp:double;
                  za:double; ze:double; zorg:double; zstp:double);
                  stdcall; external 'dislnc_d.dll';
procedure graf3d (xa:double; xe:double; xorg:double; xstp:double;
                  ya:double; ye:double; yorg:double; ystp:double;
                  za:double; ze:double; zorg:double; zstp:double);
                  stdcall; external 'dislnc_d.dll';
procedure grafmp (xa:double; xe:double; xorg:double; xstp:double;
                  ya:double; ye:double; yorg:double; ystp:double);
                  stdcall; external 'dislnc_d.dll';
procedure grafp  (xe:double; xorg:double; xstp:double; yorg:double;
                  ystp:double); stdcall; external 'dislnc_d.dll';
procedure grafr  (zre:Pdouble; nre:Vint32; zimg:Pdouble; nimg:Vint32);
                  stdcall; external 'dislnc_d.dll';
procedure grdpol (ix:Vint32; iy:Vint32); stdcall; external 'dislnc_d.dll';
procedure grffin (); stdcall; external 'dislnc_d.dll';
procedure grfimg (cfil:Pchar); stdcall; external 'dislnc_d.dll';
procedure grfini (x1:double; y1:double; z1:double;
                  x2:double; y2:double; z2:double; 
                  x3:double; y3:double; z3:double); 
                  stdcall; external 'dislnc_d.dll';
procedure grid   (ix:Vint32; iy:Vint32); stdcall; external 'dislnc_d.dll';
procedure grid3d (ix:Vint32; iy:Vint32; copt:Pchar); stdcall; 
                  external 'dislnc_d.dll';
procedure gridim (zim:double; zre1:double; zre2:double; n:Vint32);
                  stdcall; external 'dislnc_d.dll';
procedure gridmp (ix:Vint32; iy:Vint32); stdcall; external 'dislnc_d.dll';
procedure gridre (zre:double; zim1:double; zim2:double; n:Vint32);
                  stdcall; external 'dislnc_d.dll';
function  gwgatt (id:Vint32; copt:Pchar):Vint32; stdcall; 
                  external 'dislnc_d.dll';
function  gwgbox (id:Vint32):Vint32; stdcall; external 'dislnc_d.dll';
function  gwgbut (id:Vint32):Vint32; stdcall; external 'dislnc_d.dll';
procedure gwgfil (id:Vint32; cfl:Pchar); stdcall; external 'dislnc_d.dll';
function  gwgflt (id:Vint32):double; stdcall; external 'dislnc_d.dll';
function  gwggui ():Vint32; stdcall; external 'dislnc_d.dll';
function  gwgint (id:Vint32):Vint32; stdcall; external 'dislnc_d.dll';
function  gwglis (id:Vint32):Vint32; stdcall; external 'dislnc_d.dll';
function  gwgscl (id:Vint32):double; stdcall; external 'dislnc_d.dll';
procedure gwgsiz (id:Vint32; nw:Pint32; nh:Pint32); stdcall; 
                  external 'dislnc_d.dll';
function  gwgtbf (id:Vint32; i:Vint32; j:Vint32):double; stdcall;
                  external 'dislnc_d.dll';
function  gwgtbi (id:Vint32; i:Vint32; j:Vint32):Vint32; stdcall; 
                  external 'dislnc_d.dll';
procedure gwgtbl (id:Vint32; xray:Pdouble; n:Vint32; idx:Vint32; copt:Pchar);
                  stdcall; external 'dislnc_d.dll';
procedure gwgtbs (id:Vint32; i:Vint32; j:Vint32; s:Pchar); stdcall; 
                  external 'dislnc_d.dll';
procedure gwgtxt (id:Vint32; ctext:Pchar); stdcall; external 'dislnc_d.dll';
function  gwgxid (id:Vint32):Vint32; stdcall; external 'dislnc_d.dll';
procedure height (nhchar:Vint32); stdcall; external 'dislnc_d.dll';
procedure helve  (); stdcall; external 'dislnc_d.dll';
procedure helves (); stdcall; external 'dislnc_d.dll';
procedure helvet (); stdcall; external 'dislnc_d.dll';
procedure hidwin (id:Vint32; copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure histog (xray:Pdouble; n:Vint32; x:Pdouble; y:Pdouble; m:Pint32);
                  stdcall; external 'dislnc_d.dll';
procedure hname  (nhchar:Vint32); stdcall; external 'dislnc_d.dll';
procedure hpgmod (cmod:Pchar; ckey:Pchar); stdcall; external 'dislnc_d.dll';
procedure hsvrgb (xh:double; xs:double; xv:double; xr:Pdouble; xg:Pdouble;
                  xb:Pdouble); stdcall; external 'dislnc_d.dll';
procedure hsym3d (x:double); stdcall; external 'dislnc_d.dll';
procedure hsymbl (nhsym:Vint32); stdcall; external 'dislnc_d.dll';
procedure htitle (nhtit:Vint32); stdcall; external 'dislnc_d.dll';
procedure hwfont (); stdcall; external 'dislnc_d.dll';
procedure hwmode (copt:Pchar; ckey:Pchar); stdcall; external 'dislnc_d.dll';
procedure hworig (nx:Vint32; ny:Vint32); stdcall; external 'dislnc_d.dll';
procedure hwpage (nw:Vint32; nh:Vint32); stdcall; external 'dislnc_d.dll';
procedure hwscal (xfac:double); stdcall; external 'dislnc_d.dll';
procedure imgbox (nx:Vint32; ny:Vint32; nw:Vint32; nh:Vint32); stdcall; 
                  external 'dislnc_d.dll';
procedure imgclp (nx:Vint32; ny:Vint32; nw:Vint32; nh:Vint32); stdcall; 
                  external 'dislnc_d.dll';
procedure imgfin (); stdcall; external 'dislnc_d.dll';
procedure imgfmt (copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure imgini (); stdcall; external 'dislnc_d.dll';
procedure imgmod (copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure imgsiz (nw:Vint32; nh:Vint32); stdcall; external 'dislnc_d.dll';
procedure imgtpr (n:Vint32); stdcall; external 'dislnc_d.dll';
procedure inccrv (ncrv:Vint32); stdcall; external 'dislnc_d.dll';
function  incdat (id:Vint32; im:Vint32; iy:Vint32):Vint32; stdcall; 
                  external 'dislnc_d.dll';
procedure incfil (cfil:Pchar); stdcall; external 'dislnc_d.dll';
procedure incmrk (nmrk:Vint32); stdcall; external 'dislnc_d.dll';
function  indrgb (xr:double; xg:double; xb:double):Vint32; stdcall; 
                  external 'dislnc_d.dll';
procedure intax  (); stdcall; external 'dislnc_d.dll';
function  intcha (nx:Vint32; cstr:Pchar):Vint32; stdcall; 
                  external 'dislnc_d.dll';
function  intlen (nx:Vint32):Vint32; stdcall; external 'dislnc_d.dll';
function  intrgb (xr:double; xg:double; xb:double):Vint32; stdcall; 
                  external 'dislnc_d.dll';
function  intutf (iray:Pint32; n:Vint32; cstr:Pchar; nmax:Vint32):Vint32; 
                  stdcall; external 'dislnc_d.dll';
procedure isopts (xray:Pdouble; nx:Vint32; yray:Pdouble; ny:Vint32; 
                  zray:Pdouble; nz:Vint32; wmat:Pdouble; wlev:double;
                  xtri:Pdouble; ytri:Pdouble; ztri:Pdouble; nmax:Vint32; 
                  ntri:Pint32); stdcall; external 'dislnc_d.dll';
procedure itmcat (clis:Pchar; cstr:Pchar); stdcall; external 'dislnc_d.dll';
function  itmcnt (clis:Pchar):Vint32; stdcall; external 'dislnc_d.dll';
procedure itmncat (clis:Pchar; nmax:Vint32; cstr:Pchar); stdcall; 
                  external 'dislnc_d.dll';
function  itmstr (clis:Pchar; nlis:Vint32):Pchar; stdcall; 
                  external 'dislnc_d.dll';
procedure jusbar (copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure labclr (iclr:Vint32; copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure labdig (ndig:Vint32; cax:Pchar); stdcall; external 'dislnc_d.dll';
procedure labdis (ndis:Vint32; cax:Pchar); stdcall; external 'dislnc_d.dll';
procedure labels (clab:Pchar; cax:Pchar); stdcall; external 'dislnc_d.dll';
procedure labjus (copt:Pchar; cax:Pchar); stdcall; external 'dislnc_d.dll';
procedure labl3d (copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure labmod (ckey:Pchar; cval:Pchar; cax:Pchar); stdcall;
                  external 'dislnc_d.dll';
procedure labpos (cpos:Pchar; cax:Pchar); stdcall; external 'dislnc_d.dll';
procedure labtyp (ctyp:Pchar; cax:Pchar); stdcall; external 'dislnc_d.dll';
function  ldimg  (cfil:Pchar; iray:VInt16; nmax:Vint32; nc:Vint32):Vint32; 
                  stdcall; external 'dislnc_d.dll';
procedure legbgd (iclr:Vint32); stdcall; external 'dislnc_d.dll';
procedure legclr (); stdcall; external 'dislnc_d.dll';
procedure legend (cbuf:Pchar; ncor:Vint32); stdcall; external 'dislnc_d.dll';
procedure legini (cbuf:Pchar; nlin:Vint32; nmaxln:Vint32); stdcall; 
                  external 'dislnc_d.dll';
procedure leglin (cbuf:Pchar; cstr:Pchar; ilin:Vint32); stdcall; 
                  external 'dislnc_d.dll';
procedure legopt (x1:double; x2:double; x3:double); stdcall; 
                  external 'dislnc_d.dll';
procedure legpat (ityp:Vint32; ithk:Vint32; isym:Vint32; iclr:Vint32;
                  ipat:Vint32; ilin:Vint32); stdcall; external 'dislnc_d.dll';
procedure legpos (nx:Vint32; ny:Vint32); stdcall; external 'dislnc_d.dll';
procedure legsel (nray:Pint32; n:Vint32); stdcall; external 'dislnc_d.dll';
procedure legtbl (itick:Vint32; cax:Pchar); stdcall; external 'dislnc_d.dll';
procedure legtit (cstr:Pchar); stdcall; external 'dislnc_d.dll';
procedure legtyp (copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure legval (x:double; copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure lfttit (); stdcall; external 'dislnc_d.dll';
procedure licmod (cmod:Pchar; ckey:Pchar); stdcall; external 'dislnc_d.dll';
procedure licpts (xv:Pdouble; yv:Pdouble; nx:Vint32; ny:Vint32; itmat:Pint32;
                  iwmat:Pint32; wmat:Pdouble); stdcall; 
                  external 'dislnc_d.dll'; 
procedure light  (copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure linclr (nray:Pint32; n:Vint32); stdcall; external 'dislnc_d.dll';
procedure lincyc (indx:Vint32; ityp:Vint32); stdcall; external 'dislnc_d.dll';
procedure line   (nx:Vint32; ny:Vint32; nu:Vint32; nv:Vint32); stdcall; 
                  external 'dislnc_d.dll';
procedure linesp (xfac:double); stdcall; external 'dislnc_d.dll';
procedure linfit (x:Pdouble; y:Pdouble; n:Vint32; a:Pdouble; b:Pdouble;
                  r:Pdouble; copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure linmod (cmod:Pchar; ckey:Pchar); stdcall; external 'dislnc_d.dll';
procedure lintyp (ntyp:Vint32); stdcall; external 'dislnc_d.dll';
procedure linwid (i:Vint32); stdcall; external 'dislnc_d.dll';
procedure litmod (id:Vint32; copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure litop3 (id:Vint32; xr:double; xg:double; xb:double; copt:Pchar);
                  stdcall; external 'dislnc_d.dll';
procedure litopt (id:Vint32; xval:double; copt:Pchar); stdcall; 
                  external 'dislnc_d.dll';
procedure litpos (id:Vint32; x:double; y:double; z:double; copt:Pchar); 
                  stdcall; external 'dislnc_d.dll';
procedure lncap  (copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure lnjoin (copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure lnmlt  (x:double); stdcall; external 'dislnc_d.dll';
procedure logtic (cmod:Pchar); stdcall; external 'dislnc_d.dll';
procedure mapbas (cmod:Pchar); stdcall; external 'dislnc_d.dll';
procedure mapfil (cfil:Pchar; copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure mapimg (cfil:Pchar; x1:double; x2:double; x3:double; x4:double;
                  x5:double; x6:double); stdcall; external 'dislnc_d.dll';
procedure maplab (copt:Pchar; ckey:Pchar); stdcall; external 'dislnc_d.dll';
procedure maplev (cmod:Pchar); stdcall; external 'dislnc_d.dll';
procedure mapmod (cmod:Pchar); stdcall; external 'dislnc_d.dll';
procedure mappol (xpol:double; ypol:double); stdcall; external 'dislnc_d.dll';
procedure mapopt (copt:Pchar; ckey:Pchar); stdcall; external 'dislnc_d.dll';
procedure mapref (ylower:double; yupper:double); stdcall; 
                  external 'dislnc_d.dll';
procedure mapsph (xrad:double); stdcall; external 'dislnc_d.dll';
procedure marker (nsym:Vint32); stdcall; external 'dislnc_d.dll';
procedure matop3 (xr:double; xg:double; xb:double; copt:Pchar); stdcall;
                  external 'dislnc_d.dll';
procedure matopt (xval:double; copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure mdfmat (nx:Vint32; ny:Vint32; weight:double); stdcall; 
                  external 'dislnc_d.dll';
procedure messag (cstr:Pchar; nx:Vint32; ny:Vint32); stdcall; 
                  external 'dislnc_d.dll';
procedure metafl (cstr:Pchar); stdcall; external 'dislnc_d.dll';
procedure mixalf (); stdcall; external 'dislnc_d.dll';
procedure mixleg (); stdcall; external 'dislnc_d.dll';
procedure mpaepl (i:Vint32); stdcall; external 'dislnc_d.dll';
procedure mplang (x:double); stdcall; external 'dislnc_d.dll';
procedure mplclr (nbg:Vint32; nfg:Vint32); stdcall; external 'dislnc_d.dll';
procedure mplpos (nx:Vint32; ny:Vint32); stdcall; external 'dislnc_d.dll';
procedure mplsiz (nsize:Vint32); stdcall; external 'dislnc_d.dll';
procedure mpslogo (nx:Vint32; ny:Vint32; nsize:Vint32; copt:Pchar);
                   stdcall; external 'dislnc_d.dll';
procedure mrkclr (nclr:Vint32); stdcall; external 'dislnc_d.dll';
procedure msgbox (cstr:Pchar); stdcall; external 'dislnc_d.dll';
procedure mshclr (ic:Vint32); stdcall; external 'dislnc_d.dll';
procedure mshcrv (n:Vint32); stdcall; external 'dislnc_d.dll';
procedure mylab  (cstr:Pchar; itick:Vint32; cax:Pchar); stdcall; 
                  external 'dislnc_d.dll';
procedure myline (nray:Pint32; n:Vint32); stdcall; external 'dislnc_d.dll';
procedure mypat  (iang:Vint32; itype:Vint32; idens:Vint32; icross:Vint32);
                  stdcall; external 'dislnc_d.dll';
procedure mysymb (xray:Pdouble; yray:Pdouble; n:Vint32; isym:Vint32; 
                  iflag:Vint32); stdcall; external 'dislnc_d.dll';
procedure myvlt  (xr:Pdouble; xg:Pdouble; xb:Pdouble; n:Vint32);
                  stdcall; external 'dislnc_d.dll';
procedure namdis (ndis:Vint32; cax:Pchar); stdcall; external 'dislnc_d.dll';
procedure name   (cstr:Pchar; cax:Pchar); stdcall; external 'dislnc_d.dll';
procedure namjus (copt:Pchar; cax:Pchar); stdcall; external 'dislnc_d.dll';
procedure nancrv (copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure neglog (eps:double); stdcall; external 'dislnc_d.dll';
procedure newmix (); stdcall; external 'dislnc_d.dll';
procedure newpag (); stdcall; external 'dislnc_d.dll';
function  nlmess (cstr:Pchar):Vint32; stdcall; external 'dislnc_d.dll';
function  nlnumb (x:double; ndig:Vint32):Vint32; stdcall; 
                  external 'dislnc_d.dll';
procedure noarln (); stdcall; external 'dislnc_d.dll';
procedure nobar  (); stdcall; external 'dislnc_d.dll';
procedure nobgd  (); stdcall; external 'dislnc_d.dll';
procedure nochek (); stdcall; external 'dislnc_d.dll';
procedure noclip (); stdcall; external 'dislnc_d.dll';
procedure nofill (); stdcall; external 'dislnc_d.dll';
procedure nograf (); stdcall; external 'dislnc_d.dll';
procedure nohide (); stdcall; external 'dislnc_d.dll';
procedure noline (cax:Pchar); stdcall; external 'dislnc_d.dll';
procedure number (x:double; ndig:Vint32; nx:Vint32; ny:Vint32); stdcall;
                  external 'dislnc_d.dll';
procedure numfmt (copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure numode (cdec:Pchar; cgrp:Pchar; cpos:Pchar; cfix:Pchar); stdcall;
                  external 'dislnc_d.dll';
function  nwkday (id:Vint32; im:Vint32; iy:Vint32):Vint32; stdcall; 
                  external 'dislnc_d.dll';
function  nxlegn (cbuf:Pchar):Vint32; stdcall; external 'dislnc_d.dll';
function  nxpixl (ix:Vint32; iy:Vint32):Vint32; stdcall;
                  external 'dislnc_d.dll';
function  nxposn (x:double):Vint32; stdcall; external 'dislnc_d.dll';
function  nylegn (cbuf:Pchar):Vint32; stdcall; external 'dislnc_d.dll';
function  nypixl (ix:Vint32; iy:Vint32):Vint32; stdcall;
                  external 'dislnc_d.dll';
function  nyposn (y:double):Vint32; stdcall; external 'dislnc_d.dll';
function  nzposn (z:double):Vint32; stdcall; external 'dislnc_d.dll';
function  openfl (cfil:Pchar; nu:Vint32; irw:Vint32):Vint32; stdcall; 
                  external 'dislnc_d.dll'; 
procedure opnwin (id:Vint32); stdcall; external 'dislnc_d.dll';
procedure origin (nx0:Vint32; ny0:Vint32); stdcall; external 'dislnc_d.dll';
procedure page   (nw:Vint32; nh:Vint32); stdcall; external 'dislnc_d.dll';
procedure pagera (); stdcall; external 'dislnc_d.dll';
procedure pagfll (nclr:Vint32); stdcall; external 'dislnc_d.dll';
procedure paghdr (cstr1:Pchar; cstr2:Pchar; iopt:Vint32; idir:Vint32); 
                  stdcall; external 'dislnc_d.dll';
procedure pagmod (cmod:Pchar); stdcall; external 'dislnc_d.dll';
procedure pagorg (cpos:Pchar); stdcall; external 'dislnc_d.dll';
procedure pagwin (nw:Vint32; nh:Vint32); stdcall; external 'dislnc_d.dll';
procedure patcyc (index:Vint32; ipat:Vint32); stdcall; external 'dislnc_d.dll';
function  pdfbuf (cbuf:Pchar; nmax:Vint32):Vint32; stdcall; 
                  external 'dislnc_d.dll';
procedure pdfmod (cmod:Pchar; ckey:Pchar); stdcall; external 'dislnc_d.dll';
procedure pdfmrk (cstr:Pchar; copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure penwid (x:double); stdcall; external 'dislnc_d.dll';
procedure pie    (nxm:Vint32; nym:Vint32; nr:Vint32; a:double; b:double);
                  stdcall; external 'dislnc_d.dll';
procedure piebor (iclr:Vint32); stdcall; external 'dislnc_d.dll';
procedure piecbk (callbck:Pcb7); stdcall; external 'dislnc_d.dll';
procedure pieclr (ic1:Pint32; ic2:Pint32; n:Vint32); stdcall; 
                  external 'dislnc_d.dll';
procedure pieexp (); stdcall; external 'dislnc_d.dll';
procedure piegrf (cbuf:Pchar; nlin:Vint32; xray:Pdouble; nseg:Vint32); stdcall;
                  external 'dislnc_d.dll';
procedure pielab (clab:Pchar; cpos:Pchar); stdcall; external 'dislnc_d.dll';
procedure pieopt (xf:double; a:double); stdcall; external 'dislnc_d.dll';
procedure pierot (angle:double); stdcall; external 'dislnc_d.dll';
procedure pietyp (ctyp:Pchar); stdcall; external 'dislnc_d.dll';
procedure pieval (x:double; copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure pievec (ivac:Vint32; copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure pike3d (x1:double; y1:double; z1:double; x2:double; y2:double; 
                  z2:double; r:double; nsk1:Vint32; nsk2:Vint32); stdcall;
                  external 'dislnc_d.dll'; 
procedure plat3d (xm:double; ym:double; zm:double; xl:double; copt:Pchar); 
                  stdcall; external 'dislnc_d.dll'; 
procedure plyfin (cfl:Pchar; cobj:Pchar); stdcall; external 'dislnc_d.dll';
procedure plyini (copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure pngmod (cmod:Pchar; ckey:Pchar); stdcall; external 'dislnc_d.dll';
procedure point  (nx:Vint32; ny:Vint32; nb:Vint32; nh:Vint32; ncol:Vint32); 
                  stdcall; external 'dislnc_d.dll';
procedure polar  (xe:double; xorg:double; xstp:double; yorg:double; 
                  ystp:double); stdcall; external 'dislnc_d.dll';
procedure polcrv (cpol:Pchar); stdcall; external 'dislnc_d.dll';
function  polclp (xray:Pdouble; yray:Pdouble; n:Vint32; xout:Pdouble; 
                  yout:Pdouble; nmax:Vint32; xv:double; cedge:Pchar):Vint32; 
                  stdcall; external 'dislnc_d.dll';
procedure polmod (cpos:Pchar; cdir:Pchar); stdcall; external 'dislnc_d.dll';
procedure pos2pt (x:double; y:double; xp:Pdouble; yp:Pdouble); 
                  stdcall; external 'dislnc_d.dll';
procedure pos3pt (x:double; y:double; z:double; xp:Pdouble; yp:Pdouble; 
                  zp:Pdouble); stdcall; external 'dislnc_d.dll';
procedure posbar (copt:Pchar); stdcall; external 'dislnc_d.dll';
function  posifl (nu:Vint32; nbyte:Vint32):Vint32; stdcall; 
                  external 'dislnc_d.dll'; 
procedure proj3d (copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure projct (cproj:Pchar); stdcall; external 'dislnc_d.dll';
procedure psfont (cfont:Pchar); stdcall; external 'dislnc_d.dll';
procedure psmode (cmod:Pchar); stdcall; external 'dislnc_d.dll';
procedure pt2pos (x:double; y:double; xp:Pdouble; yp:Pdouble); stdcall; 
                  external 'dislnc_d.dll';
procedure pyra3d (xm:double; ym:double; zm:double; xl:double; h1:double;
                  h2:double; n:Vint32); stdcall; external 'dislnc_d.dll'; 
procedure qplbar (yray:Pdouble; n:Vint32); stdcall; external 'dislnc_d.dll';
procedure qplclr (zmat:Pdouble; n:Vint32; m:Vint32); stdcall; 
                  external 'dislnc_d.dll';
procedure qplcon (zmat:Pdouble; n:Vint32; m:Vint32; nlv:Vint32); stdcall; 
                  external 'dislnc_d.dll';
procedure qplcrv (xray:Pdouble; yray:Pdouble; n:Vint32; copt:Pchar); stdcall;
                  external 'dislnc_d.dll';
procedure qplot  (xray:Pdouble; yray:Pdouble; n:Vint32); stdcall; 
                  external 'dislnc_d.dll';
procedure qplpie (xray:Pdouble; n:Vint32); stdcall; external 'dislnc_d.dll';
procedure qplsca (xray:Pdouble; yray:Pdouble; n:Vint32); stdcall; 
                  external 'dislnc_d.dll';
procedure qplscl (a:double; e:double; org:double; stp:double; copt:Pchar); 
                  stdcall; external 'dislnc_d.dll';
procedure qplsur (zmat:Pdouble; n:Vint32; m:Vint32); stdcall; 
                  external 'dislnc_d.dll';
procedure quad3d (xm:double; ym:double; zm:double; xl:double; yl:double;
                  zl:double); stdcall; external 'dislnc_d.dll';
function  rbfpng (cbuf:Pchar; nmax:Vint32):Vint32; stdcall; 
                  external 'dislnc_d.dll';
procedure rbmp   (cfil:Pchar); stdcall; external 'dislnc_d.dll';
function  readfl (nu:Vint32; cbuf:Pbyte; nbyte:Vint32):Vint32; stdcall; 
                  external 'dislnc_d.dll'; 
procedure reawgt (); stdcall; external 'dislnc_d.dll';
procedure recfll (nx:Vint32; ny:Vint32; nw:Vint32; nh:Vint32; ncol:Vint32);
                  stdcall; external 'dislnc_d.dll';
procedure rectan (nx:Vint32; ny:Vint32; nw:Vint32; nh:Vint32); stdcall; 
                  external 'dislnc_d.dll';
procedure rel3pt (x:double; y:double; z:double; xp:Pdouble; yp:Pdouble);
                  stdcall; external 'dislnc_d.dll';
procedure resatt (); stdcall; external 'dislnc_d.dll';
procedure reset  (cname:Pchar); stdcall; external 'dislnc_d.dll';
procedure revscr (); stdcall; external 'dislnc_d.dll';
procedure rgbhsv (xr:double; xg:double; xb:double; xh:Pdouble; xs:Pdouble; 
                  xv:Pdouble); stdcall; external 'dislnc_d.dll';
procedure rgif   (cfil:Pchar); stdcall; external 'dislnc_d.dll';
procedure rgtlab (); stdcall; external 'dislnc_d.dll';
procedure rimage (cfil:Pchar); stdcall; external 'dislnc_d.dll';
procedure rlarc  (xm:double; ym:double; xa:double; xb:double; a:double;
                  b:double;  t:double); stdcall; external 'dislnc_d.dll';
procedure rlarea (xray:Pdouble; yray:Pdouble; n:Vint32); stdcall; 
                  external 'dislnc_d.dll';
procedure rlcirc (xm:double; ym:double; r:double); stdcall;
                  external 'dislnc_d.dll';
procedure rlconn (x:double; y:double); stdcall; external 'dislnc_d.dll';
procedure rlell  (xm:double; ym:double; a:double; b:double); stdcall; 
                  external 'dislnc_d.dll';
procedure rline  (x:double; y:double; u:double; v:double); stdcall; 
                  external 'dislnc_d.dll';
procedure rlmess (cstr:Pchar; x:double; y:double); stdcall; 
                  external 'dislnc_d.dll';
procedure rlnumb (x:double; ndig:Vint32; xp:double; yp:double); stdcall; 
                  external 'dislnc_d.dll';
procedure rlpie  (xm:double; ym:double; r:double; a:double; b:double);
                  stdcall; external 'dislnc_d.dll';
procedure rlpoin (x:double; y:double; nb:Vint32; nh:Vint32; ncol:Vint32);
                  stdcall; external 'dislnc_d.dll';
procedure rlrec  (x:double; y:double; xw:double; xh:double); stdcall; 
                  external 'dislnc_d.dll';
procedure rlrnd  (x:double; y:double; xb:double; xh:double; irnd:Vint32);
                  stdcall; external 'dislnc_d.dll';
procedure rlsec  (xm:double; ym:double; r1:double; r2:double; a:double;
                  b:double; ncol:Vint32); stdcall; external 'dislnc_d.dll';
procedure rlstrt (x:double; y:double); stdcall; external 'dislnc_d.dll';
procedure rlsymb (nsym:Vint32; x:double; y:double); stdcall; 
                  external 'dislnc_d.dll';
procedure rlvec  (x1:double; y1:double; x2:double; y2:double; ivec:Vint32);
                  stdcall; external 'dislnc_d.dll';
procedure rlwind (xk:double; x:double; y:double; nwidth:Vint32; a:double);
                  stdcall; external 'dislnc_d.dll';
procedure rndrec (nx:Vint32; ny:Vint32; nb:Vint32; nh:Vint32; irnd:Vint32);
                  stdcall; external 'dislnc_d.dll';
procedure rot3d  (xa:double; ya:double; za:double); stdcall; 
                  external 'dislnc_d.dll'; 
procedure rpixel (ix:Vint32; iy:Vint32; iclr:Pint32); stdcall; 
                  external 'dislnc_d.dll';
procedure rpixls (iray:Pbyte; ix:Vint32; iy:Vint32; nw:Vint32; nh:Vint32);
                  stdcall; external 'dislnc_d.dll';
procedure rpng   (cfil:Pchar); stdcall; external 'dislnc_d.dll';
procedure rppm   (cfil:Pchar); stdcall; external 'dislnc_d.dll';
procedure rpxrow (iray:Pbyte; ix:Vint32; iy:Vint32; n:Vint32); stdcall;
                  external 'dislnc_d.dll';
procedure rtiff  (cfil:Pchar); stdcall; external 'dislnc_d.dll';
procedure rvynam (); stdcall; external 'dislnc_d.dll';
procedure scale  (cscl:Pchar; cax:Pchar); stdcall; external 'dislnc_d.dll';
procedure sclfac (xfac:double); stdcall; external 'dislnc_d.dll';
procedure sclmod (cmod:Pchar); stdcall; external 'dislnc_d.dll';
procedure scrmod (cmod:Pchar); stdcall; external 'dislnc_d.dll';
procedure sector (nx:Vint32; ny:Vint32; nr1:Vint32; nr2:Vint32; a:double; 
                  b:double; ncol:Vint32); stdcall; external 'dislnc_d.dll';
procedure selwin (id:Vint32); stdcall; external 'dislnc_d.dll';
procedure sendbf (); stdcall; external 'dislnc_d.dll';
procedure sendmb (); stdcall; external 'dislnc_d.dll';
procedure sendok (); stdcall; external 'dislnc_d.dll';
procedure serif  (); stdcall; external 'dislnc_d.dll';
procedure setbas (xfac:double); stdcall; external 'dislnc_d.dll';
procedure setcbk (callbck:Pcb2; copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure setclr (ncol:Vint32); stdcall; external 'dislnc_d.dll';
procedure setcsr (copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure setexp (fexp:double); stdcall; external 'dislnc_d.dll';
procedure setfce (copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure setfil (cfil:Pchar); stdcall; external 'dislnc_d.dll';
procedure setgrf (c1:Pchar; c2:Pchar; c3:Pchar; c4:Pchar); stdcall;
                  external 'dislnc_d.dll';
procedure setind (index:Vint32; xr:double; xg:double; xb:double); stdcall;
                  external 'dislnc_d.dll';
procedure setmix (cstr:Pchar; cmix:Pchar); stdcall; external 'dislnc_d.dll';
procedure setpag (cpag:Pchar); stdcall; external 'dislnc_d.dll';
procedure setres (npb:Vint32; nph:Vint32); stdcall; external 'dislnc_d.dll';
procedure setres3d (x:double; y:double; z:double); stdcall; 
                  external 'dislnc_d.dll';
procedure setrgb (xr:double; xg:double; xb:double); stdcall;
                  external 'dislnc_d.dll';
procedure setscl (xray:Pdouble; n:Vint32; cax:Pchar); stdcall; 
                  external 'dislnc_d.dll';
procedure setvlt (cvlt:Pchar); stdcall; external 'dislnc_d.dll';
procedure setxid (id:Vint32; copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure shdafr (inray:Pint32; ipray:Pint32; icray:Pint32; n:Vint32);
                  stdcall; external 'dislnc_d.dll';
procedure shdasi (inray:Pint32; ipray:Pint32; icray:Pint32; n:Vint32);
                  stdcall; external 'dislnc_d.dll';
procedure shdaus (inray:Pint32; ipray:Pint32; icray:Pint32; n:Vint32);
                  stdcall; external 'dislnc_d.dll';
procedure shdcha (); stdcall; external 'dislnc_d.dll';
procedure shdcrv (x1ray:Pdouble; y1ray:Pdouble; n1:Vint32;
                  x2ray:Pdouble; y2ray:Pdouble; n2:Vint32); 
                  stdcall; external 'dislnc_d.dll';
procedure shdeur (inray:Pint32; ipray:Pint32; icray:Pint32; n:Vint32);
                  stdcall; external 'dislnc_d.dll';
procedure shdfac (xfaq:double); stdcall; external 'dislnc_d.dll';
procedure shdmap (cmap:Pchar); stdcall; external 'dislnc_d.dll';
procedure shdmod (copt:Pchar; ctyp:Pchar); stdcall; external 'dislnc_d.dll';
procedure shdnor (inray:Pint32; ipray:Pint32; icray:Pint32; n:Vint32);
                  stdcall; external 'dislnc_d.dll';
procedure shdpat (ipat:Vint32); stdcall; external 'dislnc_d.dll';
procedure shdsou (inray:Pint32; ipray:Pint32; icray:Pint32; n:Vint32);
                  stdcall; external 'dislnc_d.dll';
procedure shdusa (inray:Pint32; ipray:Pint32; icray:Pint32; n:Vint32);
                  stdcall; external 'dislnc_d.dll';
procedure shield (carea:Pchar; cmod:Pchar); stdcall; external 'dislnc_d.dll';
procedure shlcir (nx:Vint32; ny:Vint32; nr:Vint32); stdcall; 
                  external 'dislnc_d.dll';
procedure shldel (id:Vint32); stdcall; external 'dislnc_d.dll';
procedure shlell (nx:Vint32; ny:Vint32; na:Vint32; nb:Vint32; t:double);
                  stdcall; external 'dislnc_d.dll';
function  shlind ():Vint32; stdcall; external 'dislnc_d.dll';
procedure shlpie (nx:Vint32; ny:Vint32; nr:Vint32; a:double; b:double);
                  stdcall; external 'dislnc_d.dll';
procedure shlpol (nxray:Pint32; nyray:Pint32; n:Vint32); stdcall; 
                  external 'dislnc_d.dll';
procedure shlrct (nx:Vint32; ny:Vint32; nw:Vint32; nh:Vint32; t:double);
                  stdcall; external 'dislnc_d.dll';
procedure shlrec (nx:Vint32; ny:Vint32; nw:Vint32; nh:Vint32); stdcall;
                  external 'dislnc_d.dll';
procedure shlres (n:Vint32); stdcall; external 'dislnc_d.dll';
procedure shlsur (); stdcall; external 'dislnc_d.dll';
procedure shlvis (id:Vint32; cmod:Pchar); stdcall; external 'dislnc_d.dll';
procedure simplx (); stdcall; external 'dislnc_d.dll';
function  skipfl (nu:Vint32; nbyte:Vint32):Vint32; stdcall; 
                  external 'dislnc_d.dll'; 
procedure smxalf (calph:Pchar; c1:Pchar; c2:Pchar; n:Vint32); stdcall; 
                  external 'dislnc_d.dll';
procedure solid  (); stdcall; external 'dislnc_d.dll';
procedure sortr1 (xray:Pdouble; n:Vint32; copt:Pchar); stdcall; 
                  external 'dislnc_d.dll';
procedure sortr2 (xray:Pdouble; yray:Pdouble; n:Vint32; copt:Pchar); stdcall;
                  external 'dislnc_d.dll';
procedure spcbar (n:Vint32); stdcall; external 'dislnc_d.dll';
procedure sphe3d (xm:double; ym:double; zm:double; r:double; n:Vint32; 
                  m:Vint32); stdcall; external 'dislnc_d.dll';
procedure spline (xray:Pdouble; yray:Pdouble;  n:Vint32;
                  xsray:Pdouble; ysray:Pdouble; nspl:Pint32); 
                  stdcall; external 'dislnc_d.dll';
procedure splmod (ngrad:Vint32; npts:Vint32); stdcall; external 'dislnc_d.dll';
procedure stmmod (cmod:Pchar; ckey:Pchar); stdcall; external 'dislnc_d.dll';
procedure stmopt (n:Vint32; copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure stmpts (xmat:Pdouble; ymat:Pdouble; nx:Vint32; ny:Vint32; 
                  xp:Pdouble; yp:Pdouble; x0:double; y0:double; 
                  xray:Pdouble; yray:Pdouble; nmax:Vint32; nray:Pint32); 
                  stdcall; external 'dislnc_d.dll';
procedure stmpts3d (xv:Pdouble; yv:Pdouble; zv:Pdouble;
	          nx:Vint32; ny:Vint32; nz:Vint32; xp:Pdouble; yp:Pdouble; 
	          zp:Pdouble; x0:double; y0:double; z0:double; 
                  xray:Pdouble; yray:Pdouble; zray:Pdouble; nmax:Vint32; 
                  nray:Pint32); stdcall; external 'dislnc_d.dll';
procedure stmtri (xv:Pdouble; yv:Pdouble; xp:Pdouble; yp:Pdouble; n:Vint32;
                  i1ray:Pint32; i2ray:Pint32; i3ray:Pint32; ntri:Vint32; 
                  xs:Pdouble; ys:Pdouble; nray:Vint32); stdcall; 
                  external 'dislnc_d.dll';
procedure stmval (x:double; copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure stream (xmat:Pdouble; ymat:Pdouble; nx:Vint32; ny:Vint32; 
                  xp:Pdouble; yp:Pdouble; xs:Pdouble; ys:Pdouble; n:Vint32);
                  stdcall; external 'dislnc_d.dll';
procedure stream3d (xv:Pdouble; yv:Pdouble; zv:Pdouble; nx:Vint32; ny:Vint32;
                  nz:Vint32; xp:Pdouble; yp:Pdouble; zp:Pdouble; xs:Pdouble;
                  ys:Pdouble; zs:Pdouble; n:Vint32); stdcall;
                  external 'dislnc_d.dll';
procedure strt3d (x:double; y:double; z:double); stdcall;
                  external 'dislnc_d.dll';
procedure strtpt (x:double; y:double); stdcall; external 'dislnc_d.dll';
procedure surclr (ictop:Vint32; icbot:Vint32); stdcall;
                  external 'dislnc_d.dll';
procedure surfce (xray:Pdouble; n:Vint32; yray:Pdouble; m:Vint32;
                  zmat:Pdouble); stdcall; external 'dislnc_d.dll';
procedure surfcp (zfun:Pfunc2; a1:double; a2:double; astp:double;
                  b1:double; b2:double; bstp:double); stdcall; 
                  external 'dislnc_d.dll';
procedure surfun (zfun:Pfunc1; ixpts:Vint32; xdel:double; iypts:Vint32; 
                  ydel:double); stdcall; external 'dislnc_d.dll';
procedure suriso (xray:Pdouble; nx:Vint32; yray:Pdouble; ny:Vint32; 
                  zray:Pdouble; nz:Vint32; wmat:Pdouble; wlev:double); 
                  stdcall; external 'dislnc_d.dll';
procedure surmat (zmat:Pdouble; nx:Vint32; ny:Vint32; ixpts:Vint32;
                  iypts:Vint32); stdcall; external 'dislnc_d.dll';
procedure surmsh (copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure suropt (copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure surshc (xray:Pdouble; n:Vint32; yray:Pdouble; m:Vint32;   
                  zmat:Pdouble; wmat:Pdouble); stdcall; 
                  external 'dislnc_d.dll';
procedure surshd (xray:Pdouble; n:Vint32; yray:Pdouble; m:Vint32; 
                  zmat:Pdouble); stdcall; external 'dislnc_d.dll';
procedure sursze (xmin:double; xmax:double; ymin:double; ymax:double);
                  stdcall; external 'dislnc_d.dll';
procedure surtri (xray:Pdouble; yray:Pdouble; zray:Pdouble; n:Vint32; 
                  i1ray:Pint32; i2ray:Pint32; i3ray:Pint32; ntri:Vint32);
                  stdcall; external 'dislnc_d.dll';
procedure survis (cvis:Pchar); stdcall; external 'dislnc_d.dll';
procedure swapi2 (iray:Pint16; n:Vint32); stdcall; external 'dislnc_d.dll';
procedure swapi4 (iray:Pint32; n:Vint32); stdcall; external 'dislnc_d.dll';
procedure swgatt (id:Vint32; cval:Pchar; copt:Pchar); stdcall; 
                  external 'dislnc_d.dll';
procedure swgbgd (id:Vint32; xr:double; xg:double; xb:double); stdcall;
                  external 'dislnc_d.dll';
procedure swgbox (ip:Vint32; ival:Vint32); stdcall; external 'dislnc_d.dll';
procedure swgbut (ip:Vint32; ival:Vint32); stdcall; external 'dislnc_d.dll';
procedure swgcb2 (id:Vint32; callbck:Pcb3); stdcall; external 'dislnc_d.dll';
procedure swgcb3 (id:Vint32; callbck:Pcb4); stdcall; external 'dislnc_d.dll';
procedure swgcbk (id:Vint32; callbck:Pcb5); stdcall; external 'dislnc_d.dll';
procedure swgclr (xr:double; xg:double; xb:double; copt:Pchar); stdcall; 
                  external 'dislnc_d.dll';
procedure swgdrw (x:double); stdcall; external 'dislnc_d.dll';
procedure swgfgd (id:Vint32; xr:double; xg:double; xb:double); stdcall;
                  external 'dislnc_d.dll';
procedure swgfil (ip:Vint32; cval:Pchar); stdcall; external 'dislnc_d.dll';
procedure swgflt (ip:Vint32; xv:double; ndig:Vint32); stdcall;
                  external 'dislnc_d.dll';
procedure swgfnt (cfnt:Pchar; n:Vint32); stdcall; external 'dislnc_d.dll';
procedure swgfoc (id:Vint32); stdcall; external 'dislnc_d.dll';
procedure swghlp (cstr:Pchar); stdcall; external 'dislnc_d.dll';
procedure swgint (ip:Vint32; iv:Vint32); stdcall; external 'dislnc_d.dll';
procedure swgiop (n:Vint32; copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure swgjus (ctyp:Pchar; cwidg:Pchar); stdcall; external 'dislnc_d.dll';
procedure swglis (ip:Vint32; ival:Vint32); stdcall; external 'dislnc_d.dll';
procedure swgmix (c:Pchar; cstr:Pchar); stdcall; external 'dislnc_d.dll';
procedure swgmrg (ival:Vint32; cstr:Pchar); stdcall; external 'dislnc_d.dll';
procedure swgoff (nx:Vint32; ny:Vint32); stdcall; external 'dislnc_d.dll';
procedure swgopt (cval:Pchar; copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure swgpop (copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure swgpos (nx:Vint32; ny:Vint32); stdcall; external 'dislnc_d.dll';
procedure swgray (xray:Pdouble; nray:Vint32; copt:Pchar); stdcall; 
                  external 'dislnc_d.dll';
procedure swgscl (ip:Vint32; xval:double); stdcall; external 'dislnc_d.dll';
procedure swgsiz (nx:Vint32; ny:Vint32); stdcall; external 'dislnc_d.dll';
procedure swgspc (xw:double; xh:double); stdcall; external 'dislnc_d.dll';
procedure swgstp (step:double); stdcall; external 'dislnc_d.dll';
procedure swgtbf (id:Vint32; xval:double; ndig:Vint32; irow:Vint32;
                  icol:Vint32; copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure swgtbi (id:Vint32; ival:Vint32; irow:Vint32; icol:Vint32;
                  copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure swgtbl (id:Vint32; xray:Pdouble; nray:Vint32; ndig:Vint32;
                  idx:Vint32; copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure swgtbs (id:Vint32; cstr:Pchar; irow:Vint32; icol:Vint32; copt:Pchar);
                  stdcall; external 'dislnc_d.dll';
procedure swgtit (ctit:Pchar); stdcall; external 'dislnc_d.dll';
procedure swgtxt (ip:Vint32; cval:Pchar); stdcall; external 'dislnc_d.dll';
procedure swgtyp (ctyp:Pchar; cwidg:Pchar); stdcall; external 'dislnc_d.dll';
procedure swgval (ip:Vint32; xval:double); stdcall; external 'dislnc_d.dll';
procedure swgwin (nx:Vint32; ny:Vint32; nw:Vint32; nh:Vint32); stdcall; 
                  external 'dislnc_d.dll';
procedure swgwth (nchar:Vint32); stdcall; external 'dislnc_d.dll';
procedure symb3d (n:Vint32; xm:double; ym:double; zm:double); stdcall; 
                  external 'dislnc_d.dll'; 
procedure symbol (nsym:Vint32; nx:Vint32; ny:Vint32); stdcall;
                  external 'dislnc_d.dll';
procedure symfil (cdev:Pchar; cstat:Pchar); stdcall; external 'dislnc_d.dll';
procedure symrot (angle:double); stdcall; external 'dislnc_d.dll';
function  tellfl (nu:Vint32):Vint32; stdcall; external 'dislnc_d.dll'; 
procedure texmod (copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure texopt (copt:Pchar; ytyp:Pchar); stdcall; external 'dislnc_d.dll';
procedure texval (x:double; copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure thkc3d (x:double); stdcall; external 'dislnc_d.dll';
procedure thkcrv (nthk:Vint32); stdcall; external 'dislnc_d.dll';
procedure thrfin (); stdcall; external 'dislnc_d.dll';
procedure thrini (n:Vint32); stdcall; external 'dislnc_d.dll';
procedure ticks  (itick:Vint32; cax:Pchar); stdcall; external 'dislnc_d.dll';
procedure ticlen (nmaj:Vint32; nmin:Vint32); stdcall; external 'dislnc_d.dll';
procedure ticmod (copt:Pchar; cax:Pchar); stdcall; external 'dislnc_d.dll';
procedure ticpos (cpos:Pchar; cax:Pchar); stdcall; external 'dislnc_d.dll';
procedure tifmod (n:Vint32; cval:Pchar; copt:Pchar); stdcall; 
                  external 'dislnc_d.dll';
procedure tiforg (nx:Vint32; ny:Vint32); stdcall; external 'dislnc_d.dll';
procedure tifwin (nx:Vint32; ny:Vint32; nw:Vint32; nh:Vint32); stdcall;
                  external 'dislnc_d.dll';
procedure timopt (); stdcall; external 'dislnc_d.dll';
procedure titjus (copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure title  (); stdcall; external 'dislnc_d.dll';
procedure titlin (cstr:Pchar; n:Vint32); stdcall; external 'dislnc_d.dll';
procedure titpos (copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure torus3d (xm:double; ym:double; zm:double; r1:double; r2:double; 
	          h:double; a1:double; a2:double; n:Vint32; m:Vint32);
                  stdcall; external 'dislnc_d.dll';
procedure tprfin (); stdcall; external 'dislnc_d.dll';
procedure tprini (); stdcall; external 'dislnc_d.dll';
procedure tprmod (cmod:Pchar; ckey:Pchar); stdcall; external 'dislnc_d.dll';
procedure tprval (x:double); stdcall; external 'dislnc_d.dll';
procedure tr3axs (x:double; y:double; z:double; a:double); stdcall;
                  external 'dislnc_d.dll';
procedure tr3res (); stdcall; external 'dislnc_d.dll';
procedure tr3rot (a:double; b:double; c:double); stdcall; 
                  external 'dislnc_d.dll';
procedure tr3scl (x:double; y:double; z:double); stdcall;
                  external 'dislnc_d.dll';
procedure tr3shf (x:double; y:double; z:double);
                  stdcall; external 'dislnc_d.dll';
procedure trfco1 (xray:Pdouble; n:Vint32; cfrom:Pchar; cto:Pchar); stdcall;
                  external 'dislnc_d.dll'; 
procedure trfco2 (xray:Pdouble; yray:Pdouble; n:Vint32; cfrom:Pchar;
                  cto:Pchar); stdcall; external 'dislnc_d.dll'; 
procedure trfco3 (xray:Pdouble; yray:Pdouble; zray:Pdouble; n:Vint32; 
                  cfrom:Pchar; cto:Pchar); stdcall; external 'dislnc_d.dll';
procedure trfdat (ndays:Vint32; id:Pint32; im:Pint32; iy:Pint32); stdcall;
                  external 'dislnc_d.dll'; 
procedure trfmat (zmat:Pdouble; nx:Vint32; ny:Vint32; zmat2:Pdouble;
                  nx2:Vint32; ny2:Vint32); stdcall; external 'dislnc_d.dll';
procedure trfrel (xray:Pdouble; yray:Pdouble; n:Vint32); stdcall; 
                  external 'dislnc_d.dll';
procedure trfres (); stdcall; external 'dislnc_d.dll';
procedure trfrot (xang:double; nx:Vint32; ny:Vint32); stdcall; 
                  external 'dislnc_d.dll';
procedure trfscl (xscl:double; yscl:double); stdcall; external 'dislnc_d.dll';
procedure trfshf (nx:Vint32; ny:Vint32); stdcall; external 'dislnc_d.dll';
procedure tria3d (xtri:Pdouble; ytri:Pdouble; ztri:Pdouble); stdcall; 
                  external 'dislnc_d.dll';
function  triang (xray:Pdouble; yray:Pdouble; n:Vint32; i1ray:Pint32; 
                  i2ray:Pint32; i3ray:Pint32; nmax:Vint32):Vint32; stdcall; 
                  external 'dislnc_d.dll'; 
procedure triflc (xray:Pdouble; yray:Pdouble; iray:Pint32; n:Vint32); 
                  stdcall; external 'dislnc_d.dll';
procedure trifll (xray:Pdouble; yray:Pdouble); stdcall; 
                  external 'dislnc_d.dll';
procedure triplx (); stdcall; external 'dislnc_d.dll';
procedure tripts (xray:Pdouble; yray:Pdouble; zray:Pdouble; n:Vint32; 
                  i1ray:Pint32; i2ray:Pint32; i3ray:Pint32; ntri:Vint32;
                  zlev:double; xpts:Pdouble; ypts:Pdouble; maxpts:Vint32; 
                  nptray:Pint32; maxray:Vint32; nlins:Pint32); stdcall;
                  external 'dislnc_d.dll';
function  trmlen (cstr:Pchar):Vint32; stdcall; external 'dislnc_d.dll';
procedure ttfont (cfnt:Pchar); stdcall; external 'dislnc_d.dll';
procedure tube3d (x1:double; y1:double; z1:double; x2:double; y2:double;
                  z2:double; r:double; nsk1:Vint32; nsk2:Vint32); stdcall;
                  external 'dislnc_d.dll'; 
procedure txtbgd (n:Vint32); stdcall; external 'dislnc_d.dll';
procedure txtjus (copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure txture (itmat:Pint32; nx:Vint32; ny:Vint32); stdcall; 
                  external 'dislnc_d.dll'; 
procedure units  (copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure upstr  (cstr:Pchar); stdcall; external 'dislnc_d.dll';
function  utfint (cstr:Pchar; inray:Pint32; n:Vint32):Vint32; stdcall;
                  external 'dislnc_d.dll';
procedure vang3d (a:double); stdcall; external 'dislnc_d.dll';
procedure vclp3d (x1:double; x2:double); stdcall; external 'dislnc_d.dll';
procedure vecclr (iclr:Vint32); stdcall; external 'dislnc_d.dll';
procedure vecf3d (xv:Pdouble; yv:Pdouble; zv:Pdouble; 
                  xp:Pdouble; yp:Pdouble; zp:Pdouble; n:Vint32; ivec:Vint32);
                  stdcall; external 'dislnc_d.dll';
procedure vecfld (xv:Pdouble; yv:Pdouble; xp:Pdouble; yp:Pdouble; n:Vint32;
                  ivec:Vint32); stdcall; external 'dislnc_d.dll';
procedure vecmat (xmat:Pdouble; ymat:Pdouble; nx:Vint32; ny:Vint32; 
                  xp:Pdouble; yp:Pdouble; ivec:Vint32); stdcall; 
                  external 'dislnc_d.dll';
procedure vecmat3d (xv:Pdouble; yv:Pdouble; zv:Pdouble; nx:Vint32; ny:Vint32;
                  nz:Vint32; xp:Pdouble; yp:Pdouble; zp:Pdouble; ivec:Vint32);
                  stdcall; external 'dislnc_d.dll';
procedure vecopt (x:double; copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure vector (nx1:Vint32; ny1:Vint32; nx2:Vint32; ny2:Vint32; ivec:Vint32);
                  stdcall; external 'dislnc_d.dll';
procedure vectr3 (x1:double; y1:double; z1:double;
                  x2:double; y2:double; z2:double; ivec:Vint32); 
                  stdcall; external 'dislnc_d.dll';
procedure vfoc3d (x:double; y:double; z:double; cview:Pchar); 
                  stdcall; external 'dislnc_d.dll';
procedure view3d (xvu:double; yvu:double; zvu:double; cvu:Pchar);
                  stdcall; external 'dislnc_d.dll';
procedure vkxbar (nvfx:Vint32); stdcall; external 'dislnc_d.dll';
procedure vkybar (nvfy:Vint32); stdcall; external 'dislnc_d.dll';
procedure vkytit (nvfy:Vint32); stdcall; external 'dislnc_d.dll';
procedure vltfil (cfl:Pchar; copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure vscl3d (x:double); stdcall; external 'dislnc_d.dll';
procedure vtx3d  (xray:Pdouble; yray:Pdouble; zray:Pdouble;
                  n:Vint32; copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure vtxc3d (xray:Pdouble; yray:Pdouble; zray:Pdouble; ic:Pint32; 
                  n:Vint32; copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure vtxn3d (xray:Pdouble; yray:Pdouble; zray:Pdouble; 
                  xn:Pdouble; yn:Pdouble; zn:Pdouble; 
                  n:Vint32; copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure vup3d  (a:double); stdcall; external 'dislnc_d.dll';
function  wgapp  (ip:Vint32; clab:Pchar):Vint32; stdcall; 
                  external 'dislnc_d.dll';
function  wgappb (ip:Vint32; iray:Pbyte; nw:Vint32; nh:Vint32):Vint32; 
                  stdcall; external 'dislnc_d.dll';
function  wgbas  (ip:Vint32; ctyp:Pchar):Vint32; stdcall; 
                  external 'dislnc_d.dll';
function  wgbox  (ip:Vint32; cstr:Pchar; isel:Vint32):Vint32; stdcall; 
                  external 'dislnc_d.dll';
function  wgbut  (ip:Vint32; cstr:Pchar; ival:Vint32):Vint32; stdcall;
                  external 'dislnc_d.dll';
function  wgcmd  (ip:Vint32; clab:Pchar; cmd:Pchar):Vint32; stdcall;
                  external 'dislnc_d.dll';
function  wgdlis (ip:Vint32; cstr:Pchar; isel:Vint32):Vint32; stdcall;
                  external 'dislnc_d.dll';
function  wgdraw (ip:Vint32):Vint32; stdcall; external 'dislnc_d.dll';
function  wgfil  (ip:Vint32; clab:Pchar; cstr:Pchar; cmask:Pchar):Vint32;
                  stdcall; external 'dislnc_d.dll';
procedure wgfin  (); stdcall; external 'dislnc_d.dll';
function  wgicon (ip:Vint32; clab:Pchar; nw:Vint32; nh:Vint32;
                  cfl:Pchar):Vint32; stdcall; external 'dislnc_d.dll';
function  wgimg  (ip:Vint32; clab:Pchar; iray:Pbyte; nw:Vint32;
                  nh:Vint32):Vint32; stdcall; external 'dislnc_d.dll';
function  wgini  (ctyp:Pchar):Vint32; stdcall; external 'dislnc_d.dll';
function  wglab  (ip:Vint32; cstr:Pchar):Vint32; stdcall; 
                  external 'dislnc_d.dll';
function  wglis  (ip:Vint32; cstr:Pchar; isel:Vint32):Vint32; stdcall; 
                  external 'dislnc_d.dll';
function  wgltxt (ip:Vint32; clab:Pchar; ctext:Pchar; iper:Vint32):Vint32;
                  stdcall; external 'dislnc_d.dll';
function  wgok   (ip:Vint32):Vint32; stdcall; external 'dislnc_d.dll';
function  wgpbar (ip:Vint32; x1:double; x2:double; xval:double):Vint32;
                  stdcall; external 'dislnc_d.dll';
function  wgpbut (ip:Vint32; clab:Pchar):Vint32; stdcall; 
                  external 'dislnc_d.dll';
function  wgpicon (ip:Vint32; clab:Pchar; nw:Vint32; nh:Vint32;
                   cfl:Pchar):Vint32; stdcall; external 'dislnc_d.dll';
function  wgpimg (ip:Vint32; clab:Pchar; iray:Pbyte; nw:Vint32;
                  nh:Vint32):Vint32; stdcall; external 'dislnc_d.dll';
function  wgpop  (ip:Vint32; clab:Pchar):Vint32; stdcall; 
                  external 'dislnc_d.dll';
function  wgpopb (ip:Vint32; iray:Pbyte; nw:Vint32; nh:Vint32):Vint32; stdcall;
                  external 'dislnc_d.dll';
function  wgquit (ip:Vint32):Vint32; stdcall; external 'dislnc_d.dll';
function  wgscl  (ip:Vint32; cstr:Pchar; x1:double; x2:double; xval:double; 
                  ndez:Vint32):Vint32; stdcall; external 'dislnc_d.dll';
function  wgsep  (ip:Vint32):Vint32; stdcall; external 'dislnc_d.dll';
function  wgstxt (ip:Vint32; nsize:Vint32; nmax:Vint32):Vint32; stdcall;
                  external 'dislnc_d.dll';
function  wgtbl  (ip:Vint32; nrows:Vint32; ncols:Vint32):Vint32; stdcall;
                  external 'dislnc_d.dll';
function  wgtxt  (ip:Vint32; cstr:Pchar):Vint32; stdcall; 
                  external 'dislnc_d.dll';
procedure widbar (nzb:Vint32); stdcall; external 'dislnc_d.dll';
procedure wimage (cfil:Pchar); stdcall; external 'dislnc_d.dll';  
procedure winapp (copt:Pchar); stdcall; external 'dislnc_d.dll';  
procedure wincbk (callbck:Pcb6; copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure windbr (xk:double; nx:Vint32; ny:Vint32; nwidth:Vint32; a:double);
                  stdcall; external 'dislnc_d.dll';
procedure window (nx:Vint32; ny:Vint32; nw:Vint32; nh:Vint32); stdcall; 
                  external 'dislnc_d.dll';
procedure winfin (iopt:Vint32); stdcall; external 'dislnc_d.dll';
procedure winfnt (cfont:Pchar); stdcall; external 'dislnc_d.dll';
procedure winico (cstr:Pchar); stdcall; external 'dislnc_d.dll';
function  winid  ():Vint32; stdcall; external 'dislnc_d.dll';
procedure winjus (copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure winkey (copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure winmod (copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure winopt (iopt:Vint32; copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure winsiz (nw:Vint32; nh:Vint32); stdcall; external 'dislnc_d.dll';
procedure wintit (cstr:Pchar); stdcall; external 'dislnc_d.dll';
procedure wintyp (copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure wmfmod (cmod:Pchar; ckey:Pchar); stdcall; external 'dislnc_d.dll';
procedure world  (); stdcall; external 'dislnc_d.dll';
procedure wpixel (ix:Vint32; iy:Vint32; iclr:Vint32); stdcall; 
                  external 'dislnc_d.dll';
procedure wpixls (iray:Pbyte; ix:Vint32; iy:Vint32; nw:Vint32; nh:Vint32); 
                  stdcall; external 'dislnc_d.dll';
procedure wpxrow (iray:Pbyte; ix:Vint32; iy:Vint32; n:Vint32); stdcall; 
                  external 'dislnc_d.dll';
function  writfl (nu:Vint32; cbuf:Pbyte; nbyte:Vint32):Vint32; stdcall; 
                  external 'dislnc_d.dll'; 
procedure wtiff  (cfil:Pchar); stdcall; external 'dislnc_d.dll';
procedure x11fnt (cfont:Pchar; copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure x11mod (copt:Pchar); stdcall; external 'dislnc_d.dll';
function  x2dpos (x:double; y:double):double; stdcall; external 'dislnc_d.dll';
function  x3dabs (x:double; y:double; z:double):double; stdcall; 
                  external 'dislnc_d.dll';
function  x3dpos (x:double; y:double; z:double):double; stdcall; 
                  external 'dislnc_d.dll';
function  x3drel (x:double; y:double; z:double):double; stdcall; 
                  external 'dislnc_d.dll';
procedure xaxgit (); stdcall; external 'dislnc_d.dll';
procedure xaxis  (xa:double; xe:double; xorg:double; xstp:double; nl:Vint32;
                  cstr:Pchar; it:Vint32; nx:Vint32; ny:Vint32); stdcall; 
                  external 'dislnc_d.dll';
procedure xaxlg  (xa:double; xe:double; xorg:double; xstp:double; nl:Vint32;
                  cstr:Pchar; it:Vint32; nx:Vint32; ny:Vint32); stdcall; 
                  external 'dislnc_d.dll';
procedure xaxmap (xa:double; xe:double; xorg:double; xstp:double; cstr:Pchar;
                  it:Vint32; ny:Vint32); stdcall; external 'dislnc_d.dll';
procedure xcross (); stdcall; external 'dislnc_d.dll';
procedure xdraw  (x:double; y:double); stdcall; external 'dislnc_d.dll';
function  xinvrs (n:Vint32):double; stdcall; external 'dislnc_d.dll';
procedure xmove  (x:double; y:double); stdcall; external 'dislnc_d.dll';
function  xposn  (x:double):double; stdcall; external 'dislnc_d.dll';
function  y2dpos (x:double; y:double):double; stdcall; external 'dislnc_d.dll';
function  y3dabs (x:double; y:double; z:double):double; stdcall; 
                  external 'dislnc_d.dll';
function  y3dpos (x:double; y:double; z:double):double; stdcall; 
                  external 'dislnc_d.dll';
function  y3drel (x:double; y:double; z:double):double; stdcall; 
                  external 'dislnc_d.dll';
procedure yaxgit (); stdcall; external 'dislnc_d.dll';
procedure yaxis  (ya:double; ye:double; yor:double; ystp:double; 
                  nl:Vint32; cstr:Pchar; it:Vint32; nx:Vint32; ny:Vint32);
                  stdcall; external 'dislnc_d.dll';
procedure yaxlg  (ya:double; ye:double; yor:double; ystp:double;
                  nl:Vint32; cstr:Pchar; it:Vint32; nx:Vint32; ny:Vint32); 
                  stdcall; external 'dislnc_d.dll';
procedure yaxmap (ya:double; ye:double; yor:double; ystp:double;
                  cstr:Pchar; it:Vint32; ny:Vint32); stdcall; 
                  external 'dislnc_d.dll';
procedure ycross (); stdcall; external 'dislnc_d.dll';
function  yinvrs (n:Vint32):double; stdcall; external 'dislnc_d.dll';
procedure ypolar  (ya:double; ye:double; yor:double; ystp:double; 
                  cstr:Pchar; ndist:Vint32);
                  stdcall; external 'dislnc_d.dll';
function  yposn  (y:double):double; stdcall; external 'dislnc_d.dll';
function  z3dpos (x:double; y:double; z:double):double; stdcall; 
                  external 'dislnc_d.dll';
procedure zaxis  (za:double; ze:double; zor:double; zstp:double; 
                  nl:Vint32; cstr:Pchar; it:Vint32; id:Vint32; nx:Vint32; 
                  ny:Vint32); stdcall; external 'dislnc_d.dll';
procedure zaxlg  (za:double; ze:double; zor:double; zstp:double; 
                  nl:Vint32; cstr:Pchar; it:Vint32; id:Vint32; nx:Vint32; 
                  ny:Vint32); stdcall; external 'dislnc_d.dll';
procedure zbfers (); stdcall; external 'dislnc_d.dll';
procedure zbffin (); stdcall; external 'dislnc_d.dll';
function  zbfini ():Vint32; stdcall; external 'dislnc_d.dll';
procedure zbflin (x1:double; y1:double; z1:double; x2:double; y2:double;
		  z2:double); stdcall; external 'dislnc_d.dll';
procedure zbfmod (copt:Pchar); stdcall; external 'dislnc_d.dll';
procedure zbfres (); stdcall; external 'dislnc_d.dll';
procedure zbfscl (x:double); stdcall; external 'dislnc_d.dll';
procedure zbftri (x:Pdouble; y:Pdouble; z:Pdouble; ic:Pint32); stdcall;
		  external 'dislnc_d.dll';
procedure zscale (za:double; ze:double); stdcall; external 'dislnc_d.dll';
implementation

end.
