program dislin_contour;

uses
   dislin;

const
   n = 50;
   m = 50;

var
   i, j	: int32;
   fpi, stepx, stepy, x, y, zlev : double;
   zmat	: array[0..n*m-1] of double;
   xray	: array[0..n-1] of double;
   yray	: array[0..m-1] of double;

begin

   stepx := 360.0 / (n - 1);
   stepy := 360.0 / (m - 1);
   fpi := 3.1415926 / 180.0;

   for i := 0 to n - 1 do
      xray[i] := i * stepx;

   for j := 0 to m - 1 do
      yray[j] := j * stepy;

   for i := 1 to n  do
   begin
      x := xray[i-1] * fpi;
      for j := 1 to m do
      begin
	 y := yray[j-1] * fpi;    
	 zmat[i - 1 + (j - 1) * m] := 2 * sin (x) * sin (y);
      end;
   end;   

   scrmod ('revers');
   setpag ('da4p');
   metafl ('cons');
   disini ();
   complx ();
   pagera ();

   titlin ('Contour Plot', 1);
   titlin ('F(X,Y) = 2 * SIN(X) * SIN(Y)', 3);

   name   ('X-axis', 'x');
   name   ('Y-axis', 'y');

   intax  ();
   axspos (450, 2670);
   graf   (0.0, 360.0, 0.0, 90.0, 0.0, 360.0, 0.0, 90.0);

   height (30);
   for i := 0 to 8 do
   begin   
      zlev := -2.0 + i * 0.5;
      setclr ((i + 1) * 25);
      if i = 4 then
        labels ('none', 'contur') 
      else
        labels ('float', 'contur');

      contur  (@xray[0], n, @yray[0], m, @zmat[0], zlev);
   end;

   height (50);
   color  ('fore');
   title  ();
   disfin ();
end. 

