program dislin_conshd;

uses
   dislin;

const
   n = 50;
   m = 50;

var
   i, j	: int32;
   stepx, stepy, x, y : double;
   zmat	: array[0..n*m-1] of double;
   xray	: array[0..n-1] of double;
   yray	: array[0..m-1] of double;
   zlev	: array[0..11] of double;

begin 
   stepx := 1.6 / (n - 1);
   stepy := 1.6 / (m - 1);
   for i := 0 to n - 1  do
   begin
      x := 0.0 + i * stepx;
      xray[i] := x;
      for j := 0 to m - 1 do
      begin	 
	 y := 0.0 + j * stepy;
	 yray[j] := y;
	 zmat[i + j * m] := (x * x - 1.0) * (x * x - 1.0) + 
                   (y * y - 1.0) * (y * y - 1.0);
      end;
   end;

   scrmod ('revers');
   setpag ('da4p');
   metafl ('cons');
   disini ();
   pagera ();
   complx ();

   mixalf ();
   titlin ('Shaded Contour Plot', 1);
   titlin ('F(X,Y) = (X[2$ - 1)[2$ + (Y[2$ - 1)[2$', 3);
   name   ('X-axis', 'x');
   name   ('Y-axis', 'y');

   shdmod ('poly', 'contur');
   axspos (450, 2670);
   graf   (0.0, 1.6, 0.0, 0.2, 0.0, 1.6, 0.0, 0.2);

   for i := 1 to 12 do
      zlev[12-i] := 0.1 + (i - 1) * 0.1;

   conshd (@xray[0], n, @yray[0], n, @zmat[0], @zlev[0], 12);

   height (50);
   title  ();
   disfin ();
end.

