program dislin_color3d;

uses
   dislin;

const
   n = 100;
   m = 100;
   
var
   i, j		   : int32;
   fpi, stepx, stepy, x, y : double;
   zmat		   : array[0..n*m-1] of double;

begin
   stepx := 360.0 / (n - 1);
   stepy := 360.0 / (m - 1);
   fpi := 3.1415926 / 180.0;

   for i:= 1 to n  do
   begin
      x := (i - 1) * stepx;
      for j:= 1 to m do
      begin	 
	 y := (j - 1) * stepy;
	 zmat[i - 1 + (j - 1) * m] := 2 * sin (x * fpi) * sin (y * fpi);
      end;
   end;

   scrmod ('revers');
   metafl ('cons');
   disini ();
   pagera ();
   hwfont ();

   titlin ('3-D Colour Plot of the Function', 2);
   titlin ('F(X,Y) = 2 * SIN(X) * SIN(Y)', 4);

   name   ('X-axis', 'x');
   name   ('Y-axis', 'y');
   name   ('Z-axis', 'z');

   intax  ();
   autres (n, n);
   axspos (300, 1850);
   ax3len (2200, 1400, 1400);

   graf3  (0.0, 360.0, 0.0, 90.0, 0.0, 360.0, 0.0, 90.0,
            -2.0, 2.0, -2.0, 1.0);
   crvmat (zmat, n, m, 1, 1);
  
   height (50);
   title  ();
   disfin ();
end.

