program dislin_curve;

uses
   dislin;

const
   n =  18;

var
   i	 : int32;
   cbuf  : ansistring;
   xray  : array[0..n-1] of double  = (1.0, 3.0, 8.0, 1.5, 9.0, 6.3, 5.8,
              2.3, 8.1, 3.5, 2.2, 8.7, 9.2, 4.8, 3.4, 6.9, 7.5, 3.8);
   yray  : array[0..n-1] of double = (5.0, 8.0, 3.5, 2.0, 7.0, 1.0, 4.3, 7.2,
             6.0, 8.5, 4.1, 5.0, 7.3, 2.8, 1.6, 8.9, 9.5, 3.2);
   z1ray : array[0..n-1] of double = (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
	     0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
   z2ray : array[0..n-1] of double = (4.0, 5.0, 3.0, 2.0, 3.5, 4.5, 2.0,
	     1.6, 3.8, 4.7, 2.1, 3.5, 1.9, 4.2, 4.9, 2.8, 3.6, 4.3);
   icray : array[0..n-1] of int32  = (30, 30, 30, 30, 30, 30, 100, 100,
	     100, 100, 100, 100, 170, 170, 170, 170, 170, 170);
   xwray : array[0..n-1] of double;
   ywray : array[0..n-1] of double;

begin
   SetLength (cbuf, 80);
   for i := 0 to n - 1 do
   begin
      xwray[i] := 0.5;
      ywray[i] := 0.5;
   end; 

   scrmod ('revers');
   setpag ('da4p');
   metafl ('cons');
   disini ();
   pagera ();
   hwfont ();
   axspos (200, 2600);
   axslen (1800, 1800);

   name   ('X-axis', 'x');
   name   ('Y-axis', 'y');
   name   ('Z-axis', 'z');

   titlin ('3-D Bars / BARS3D', 3);
   labl3d ('hori');

   graf3d (0.0, 10.0, 0.0, 2.0, 0.0, 10.0, 0.0, 2.0,
             0.0, 5.0, 0.0, 1.0);
   grid3d (1, 1, 'bottom');
   bars3d (@xray[0], @yray[0], @z1ray[0], @z2ray[0],
	   @xwray[0], @ywray[0], @icray[0], n);

   legini (cbuf, 3, 20);
   legtit (' ');
   legpos (1350, 1150);
   leglin (cbuf, 'First', 1);
   leglin (cbuf, 'Second', 2);
   leglin (cbuf, 'Third', 3);
   legend (cbuf, 3);

   height (50);
   title  ();
   disfin ();
end.
