program dislin_bars;

uses
   dislin;

var
   nya, i : int32;
   ctit	  : ansistring = 'Bar Graphs (BARS)';
   cbuf	  : ansistring;
   x  : array[0..8] of double = (1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0);
   y  : array[0..8] of double = (0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
   y1 : array[0..8] of double = (1.0, 1.5, 2.5, 1.3, 2.0, 1.2, 0.7, 1.4, 1.1);
   y2 : array[0..8] of double = (2.0, 2.7, 3.5, 2.1, 3.2, 1.9, 2.0, 2.3, 1.8);
   y3 : array[0..8] of double = (4.0, 3.5, 4.5, 3.7, 4.0, 2.9, 3.0, 3.2, 2.6);

begin
   nya  := 2700;
   SetLength (cbuf, 25);
   
   scrmod ('revers');
   setpag ('da4p');
   metafl ('cons');
   disini ();
   pagera ();
   complx ();
   ticks  (1, 'x');
   intax  ();;
   axslen (1600, 700);
   titlin (ctit, 3);

   legini (cbuf, 3, 8);
   leglin (cbuf, 'FIRST', 1);
   leglin (cbuf, 'SECOND', 2);
   leglin (cbuf, 'THIRD', 3);
   legtit (' ');
   shdpat (5);
   for i := 1 to 3 do
   begin  
      if i > 1 then
	 labels ('none', 'x');
      axspos (300, nya - (i - 1) * 800);
      graf   (0.0, 10.0, 0.0, 1.0, 0.0, 5.0, 0.0, 1.0);

      if i = 1 then
      begin
	 bargrp (3, 0.15);
         color  ('red');
         bars   (@x[0], @y[0], @y1[0], 9);
         color  ('green');
         bars   (@x[0], @y[0], @y2[0], 9);
         color  ('blue');
         bars   (@x[0], @y[0], @y3[0], 9);
         color  ('fore');
         reset  ('bargrp');
      end
      else if i = 2 then
      begin  
         height (30);
         labels ('delta', 'bars');
         labpos ('center', 'bars');
         color  ('red');
         bars   (@x[0], @y[0], @y1[0], 9);
         color  ('green');
         bars   (@x[0], @y1[0], @y2[0], 9);
         color  ('blue');
         bars   (@x[0], @y2[0], @y3[0], 9);
         color  ('fore');
         reset  ('height');
      end  
      else if i = 3 then
      begin	  
         labels ('second', 'bars');
         labpos ('outside', 'bars');
         color  ('red');
         bars   (@x[0], @y[0], @y1[0], 9);
         color  ('fore');
      end;

      if i <> 3 then
	 legend (cbuf, 7);

      if i = 3 then
      begin  
         height (50);
         title  ();
      end;
      endgrf ();
   end;
   disfin ();
end.