#INCLUDE "dislin.bi"

DIM AS INTEGER n = 50
DIM AS SINGLE zmat(n,n)
DIM AS SINGLE x, y, stp, fpi
DIM AS INTEGER i, j

fpi = 3.1415926 / 180
stp = 360.0f / n
  
FOR i = 0 TO n
  x = i * stp
  FOR j = 0 TO n
    y = j * stp
    zmat (i,j) = 2 * sin (x * fpi) * sin (y * fpi)
  NEXT j
NEXT i

Dislin.metafl ("xwin")
Dislin.setpag ("da4p")
Dislin.disini ()
Dislin.pagera ()
Dislin.hwfont ()

Dislin.titlin ("Surface Plot of the Function", 2)
Dislin.titlin ("F(X,Y) = 2 * SIN(X) * SIN(Y)", 4)

Dislin.axspos (200, 2600)
Dislin.axslen (1800, 1800)

Dislin.name   ("X-axis", "X")
Dislin.name   ("Y-axis", "Y")
Dislin.name   ("Z-axis", "Z")

Dislin.view3d (-5.0, -5.0, 4.0, "ABS")
Dislin.graf3d (0.0, 360.0, 0.0, 90.0, 0.0, 360.0, 0.0, 90.0, _
               -3.0, 3.0, -3.0, 1.0)
Dislin.height (50)
Dislin.title  ()

Dislin.color  ("green")
Dislin.surmat (@zmat(0,0), n + 1, n + 1, 1, 1) 
Dislin.disfin ()
END
