#INCLUDE "dislin.bi"

DIM AS INTEGER n = 300 - 1
DIM AS INTEGER m = 10 - 1
DIM AS SINGLE  pi = 3.1415926
DIM AS SINGLE xray(n), x1(n), y1(n)
DIM AS SINGLE x2(n), y2(n)
DIM AS SINGLE a, x, f, stp
DIM AS INTEGER i, ic

f = pi / 180.0
stp = 360.0 / n
FOR i = 0 TO n
    a = i * stp * f 
    xray(i) = i * stp
    x = xray(i) * f
    y1(i) = a
    x1(i) = sin (5 * a)
NEXT i

FOR i = 0 TO m
    x2(i) = i + 1
    y2(i) = i + 1
NEXT i

Dislin.setpag ("da4p")
Dislin.metafl ("cons")
Dislin.scrmod ("revers")
Dislin.disini ()
Dislin.pagera ()
Dislin.hwfont ()

Dislin.titlin ("Polar Plots", 2)
Dislin.ticks  (3, "Y")
Dislin.axends ("NOENDS", "X")
Dislin.labdig (-1, "Y")
Dislin.axslen (1000, 1000)
Dislin.axsorg (1050, 900)

ic = Dislin.intrgb (0.95, 0.95, 0.95)
Dislin.axsbgd (ic)

Dislin.grafp  (1.0, 0.0, 0.2, 0.0, 30.0)
Dislin.color  ("blue")
Dislin.curve  (@x1(0), @y1(0), n)
Dislin.color  ("fore")
Dislin.htitle (50)
Dislin.title  ()
Dislin.endgrf ()

Dislin.labdig (-1, "X")
Dislin.axsorg (1050, 2250)
Dislin.labtyp ("VERT", "Y")
Dislin.grafp  (10.0, 0.0, 2.0, 0.0, 30.0)
Dislin.barwth (-5.0)
Dislin.polcrv ("FBARS")
Dislin.color  ("blue")
Dislin.curve  (@x2(0), @y2(0), m)
Dislin.disfin ()
END

