#INCLUDE "dislin.bi"

DIM AS INTEGER n = 300 
DIM AS SINGLE xray(n), y1ray(n), y2ray(n)
DIM AS SINGLE x, stp, fpi
DIM AS INTEGER i, nx, ny
DIM cbuf AS ZSTRING * 80

fpi = 3.1415926 / 180
stp = 360.0 / n
  
FOR i = 0 TO n
  xray(i) = i * stp
  x = xray(i) * fpi
  y1ray(i) =  sin (x)
  y2ray(i) =  cos (x)
NEXT i

Dislin.metafl ("xwin")
Dislin.disini ()
Dislin.pagera ()
Dislin.complx ()

Dislin.axspos (450, 1800)
Dislin.axslen (2200, 1200)

Dislin.name ("X-axis", "X")
Dislin.name ("Y-axis", "Y")

Dislin.labdig (-1, "X")
Dislin.ticks (10, "XY")

Dislin.titlin ("Demonstration of CURVE", 1)
Dislin.titlin ("SIN(X), COS(X)", 3)

Dislin.graf (0.0f, 360.0f, 0.0f, 90.0f, -1.0f, 1.0f, -1.0f, 0.5f)
Dislin.xaxgit ()
Dislin.title ()

Dislin.chncrv ("Both")
Dislin.curve (@xray(0), @y1ray(0), n + 1)
Dislin.curve (@xray(0), @y2ray(0), n + 1)

Dislin.legini (cbuf, 2, 7)
nx = Dislin.nxposn (190.0f)
ny = Dislin.nyposn (0.75f)
Dislin.legpos (nx, ny)
Dislin.leglin (cbuf, "sin (x)", 1)

Dislin.leglin (cbuf, "cos (x)", 2)
Dislin.legtit ("Legend")
Dislin.legend (cbuf, 3)

Dislin.disfin ()
END
