#INCLUDE "dislin.bi"

DIM AS INTEGER n = 50, m = 80
DIM AS STRING ctit1 = "Shaded Contour Plot"
DIM AS STRING ctit2 = "F(X,Y) = (X[2$ - 1)[2$ + (Y[2$ - 1)[2$"
DIM AS SINGLE xray(n), yray(m), zmat(n,m), zlev(11)
DIM AS SINGLE stpx, stpy, x, x2, y, y2
DIM AS INTEGER i, j

stpx = 1.6 / n
stpy = 1.6 / n

FOR i = 0 TO n
  xray(i) = i * stpx
  x = xray(i) * xray(i) - 1.0
  x2 = x * x
  FOR j = 0 TO m
    yray(j) = j * stpy
    y = yray(j) * yray(j) - 1.0
    y2 = y * y
    zmat(i,j) = x2 + y2
  NEXT j
NEXT i

Dislin.scrmod ("revers")
Dislin.metafl ("cons")
Dislin.setpag ("da4p")

Dislin.disini ()
Dislin.pagera ()
Dislin.complx ()
Dislin.mixalf ()

Dislin.titlin (ctit1, 1)
Dislin.titlin (ctit2, 3)

Dislin.name   ("X-axis", "X")
Dislin.name   ("Y-axis", "Y")

Dislin.axspos (450, 2670)
Dislin.shdmod ("poly", "contur")
Dislin.graf   (0., 1.6, 0., 0.2, 0., 1.6, 0., 0.2)

FOR i = 0 TO 11
  zlev(11-i) = 0.1 + i * 0.1
NEXT i

Dislin.conshd (@xray(0), n + 1, @yray(0), m + 1, @zmat(0,0), @zlev(0), 12)

Dislin.height (50)
Dislin.title  ()
Dislin.disfin ()
END

