#INCLUDE "dislin.bi"

DIM AS INTEGER n = 100
DIM AS SINGLE zmat(n,n)
DIM AS SINGLE x, y, stp, fpi
DIM AS INTEGER i, j

fpi = 3.1415926 / 180
stp = 360.0f / n
  
FOR i = 0 TO n
  x = i * stp
  FOR j = 0 TO n
    y = j * stp
    zmat (i,j) = 2 * sin (x * fpi) * sin (y * fpi)
  NEXT j
NEXT i

Dislin.metafl ("xwin")
Dislin.disini ()
Dislin.pagera ()
Dislin.hwfont ()

Dislin.titlin ("3-D Colour Plot of the Function", 1)
Dislin.titlin ("F(X,Y) = 2 * SIN(X) * SIN(Y)", 3)
Dislin.name   ("X-axis", "X")
Dislin.name   ("Y-axis", "Y")
Dislin.name   ("Z-axis", "Z")

Dislin.axspos (300, 1850)
Dislin.ax3len (2200, 1400, 1400)

Dislin.intax  ()    
Dislin.autres (n, n)
Dislin.graf3  (0.0, 360.0, 0.0, 90.0, 0.0, 360.0, 0.0, 90.0, _
              -2.0, 2.0, -2.0, 1.0)
Dislin.crvmat (@zmat(0,0), n + 1, n + 1, 1, 1) 

Dislin.height (50)
Dislin.title  ()
Dislin.disfin ()
END
