#INCLUDE "dislin.bi"

DIM AS INTEGER n = 17
DIM AS SINGLE xray(17)  = {1., 3., 8., 1.5, 9., 6.3, 5.8, 2.3, 8.1, 3.5, _
			  2.2, 8.7, 9.2, 4.8, 3.4, 6.9, 7.5, 3.8}
DIM AS SINGLE yray(17)  = {5., 8., 3.5, 2., 7., 1.,4.3, 7.2, 6.0, 8.5,   _
			  4.1, 5.0, 7.3, 2.8, 1.6, 8.9, 9.5, 3.2}
DIM AS SINGLE z1ray(17) = {0., 0., 0., 0., 0., 0., 0., 0., 0., 0.,       _
			  0., 0., 0., 0., 0., 0., 0., 0.}
DIM AS SINGLE z2ray(17) = {4., 5., 3., 2., 3.5, 4.5, 2., 1.6, 3.8, 4.7,  _
		          2.1, 3.5, 1.9, 4.2, 4.9, 2.8, 3.6, 4.3}
DIM AS INTEGER icray(17) = {30, 30, 30, 30, 30, 30, 100, 100, 100, 100,  _
			   100, 100, 170, 170, 170, 170, 170, 170}
DIM AS SINGLE xwray(17), ywray(17)
DIM cbuf AS ZSTRING * 80
DIM AS INTEGER i

FOR i = 0 TO n
  xwray(i) = 0.5
  ywray(i) = 0.5
NEXT i

Dislin.metafl ("xwin")
Dislin.scrmod ("revers")
Dislin.setpag ("da4p")
Dislin.disini ()
Dislin.hwfont ()
Dislin.pagera ()

Dislin.axspos (200, 2600)
Dislin.axslen (1800, 1800)

Dislin.name   ("X-axis", "X")
Dislin.name   ("Y-axis", "Y")
Dislin.name   ("Z-axis", "Z")

Dislin.titlin ("3-D Bars / BARS3D",3)
Dislin.labl3d ("hori")

Dislin.graf3d (0.,10.,0.,2.,0.,10.,0.,2.,0.,5.,0.,1.)
Dislin.grid3d (1,1, "bottom")

Dislin.bars3d (@xray(0), @yray(0), @z1ray(0), @z2ray(0), @xwray(0),   _ 
               @ywray(0), @icray(0), n + 1)

Dislin.legini (cbuf, 3, 20)
Dislin.legtit (" ")
Dislin.legpos (1350, 1150)
Dislin.leglin (cbuf, "First", 1)
Dislin.leglin (cbuf, "Second", 2)
Dislin.leglin (cbuf, "Third", 3)
Dislin.legend (cbuf, 3)

Dislin.height (50)
Dislin.title  ()
Dislin.disfin ()
END
