import std.math;
import Dislin;

extern (C) float zfun (float x, float y, int iopt)
{ float v;
  if (iopt == 1)
    v = cos(x) * (3. + cos(y));
  else if (iopt == 2)
    v = sin(x) * (3. + cos(y));
  else
    v = sin (y);

  return v;
}

void main (string[] args)
{ float p = 3.14159f, step;
    
  setpag ("da4p");
  metafl ("cons");
  disini ();
  hwfont ();
  pagera ();

  axspos (200, 2400);
  axslen (1800, 1800);
  intax ();

  titlin ("Surface Plot of the Parametric Function", 2);
  titlin ("[COS(t)+(3+COS(u)), SIN(t)*(3+COS(u)), SIN(u)]", 4);

  name ("X-axis", "x");
  name ("Y-axis", "y");
  name ("Z-axis", "z");

  vkytit (-300);
  zscale (-1.f, 1.f);
  graf3d (-4.f,4.f,-4.f,1.f,-4.f,4.f,-4.f,1.f,
	       -3.f,3.f,-3.f,1.f);
  height(40);
  title();

  surmsh ("on");
  step = 2 * 3.14159/30.;
  surfcp (&zfun,  0.f, 2*p, step, 0.f, 2*p, step);

  disfin ();
}


