import std.math;
import Dislin;

void main (string[] args)
{ int i, n = 300, m = 10;
  float [300] xray, yray;
  float [10] x2, y2;
  double step, fpi, a;

  step = 360.f / (n-1);
  fpi = 3.1415926/180;

  for (i = 0; i < n; i++)
  { a = i * step * fpi;
    yray[i] = a;
    xray[i] = sin (5 * a);
  }
    
  for (i = 0; i < m; i++)
  { x2[i] = i + 1;
    y2[i] = i + 1;
  }

  setpag ("da4p");
  metafl ("xwin");
  disini ();
  hwfont ();
  pagera ();

  axspos (450,1800);

  titlin ("Polar Plots", 2);
  ticks  (3, "Y");
  axends ("NOENDS", "X");
  labdig (-1, "Y");
  axslen (1000, 1000);
  axsorg (1050, 900);

  grafp  (1.f ,0.f, 0.2f, 0.f, 30.f);
  curve  (cast (float *) xray, cast (float *) yray, n);
  htitle (50);
  title  ();
  endgrf ();

  labdig (-1, "X");
  axsorg (1050, 2250);
  labtyp ("VERT", "Y");
  grafp  (10.f, 0.f, 2.f, 0.f, 30.f);
  barwth (-5.f);
  polcrv ("FBARS");
  curve  (cast (float *) x2, cast (float *) y2, m);
  disfin ();
}
