/****************************************************************/
/**                        Dislin.d                            **/
/**                                                            **/
/** Module file for DISLIN D programs.                         **/
/**                                                            **/
/** Date     : 31.07.2015                                      **/
/** Functions: 776                                             **/
/** Version  : 10.5                                            **/
/****************************************************************/

extern (C) {

void  abs3pt (float x, float y, float z, float *xp, float *yp);
void  addlab (char *cstr, float v, int itic, char *cax);
void  angle  (int ngrad);
void  arcell (int nx, int ny, int na, int nb, float a, float b, float t);
void  areaf  (int *nxray, int *nyray, int n);
void  autres (int ixdim, int iydim);
void  ax2grf ();
void  ax3len (int nxl, int nyl, int nzl);
void  axclrs (int nclr, char *copt, char *cax);
void  axends (char *cstr, char *cax);
void  axgit  ();
void  axis3d (float x3, float y3, float z3);
void  axsbgd (int nclr);
void  axsers (void);
void  axslen (int nxl, int nyl);
void  axsorg (int nxa, int nya);
void  axspos (int nxa, int nya);
void  axsscl (char *cscl, char *cax);
void  axstyp (char *copt);
void  barbor (int iclr);
void  barclr (int ic1, int ic2, int ic3);
void  bargrp (int ngrp, float gap);
void  barmod (char *cmod, char *copt);
void  baropt (float xf, float a);
void  barpos (char *copt);
void  bars   (float *xray, float *y1ray, float *y2ray, int n);
void  bars3d (float *xray, float *yray, float *z1ray, 
              float *z2ray, float *xwray, float *ywray,
              int *icray, int n);
void  bartyp (char *ctyp);
void  barwth (float factor);
void  basalf (char *calph);
void  basdat (int id, int im, int iy); 
void  bezier (float *xray, float *yray, int nray, 
              float *x, float *y, int n);
void  bfcclr (int ic);
void  bfcmsh (int ic);
short bitsi2 (int nbits, short mher, int iher, short mhin, int ihin);
int   bitsi4 (int nbits, int mher,int iher, int mhin, int ihin);
void  bmpfnt (char *copt);
void  bmpmod (int n, char *cval, char *copt);
void  box2d  ();
void  box3d  ();
void  bufmod (char *cmod, char *ckey);
void  center ();
void  cgmbgd (float xr, float xg, float xb);
void  cgmpic (char *cstr);
void  cgmver (int nclr);
void  chaang (float angle);
void  chacod (char *copt);
void  chaspc (float xspc);
void  chawth (float xwth);
void  chnatt ();
void  chncrv (char *copt);
void  chndot ();
void  chndsh ();
void  chnbar (char *copt);
void  chnpie (char *copt);
void  circ3p (float x1, float y1, float x2, float y2, float x3, float y3,
              float *xm, float *ym, float *r);
void  circle (int nx, int ny, int nr);
void  circsp (int nspc);
void  clip3d (char *ctyp);
int   closfl (int nu); 
void  clpbor (char *copt);
void  clpmod (char *copt);
void  clpwin (int nx, int ny, int nw, int nh);
void  clrcyc (int index, int iclr);
void  clrmod (char *cmode);
void  clswin (int id);
void  color  (char *col);
void  colran (int nca, int nce);
void  colray (float *zray, int *nray, int n);
void  complx ();
void  conclr (int *nray, int n);
void  concrv (float *xray, float *yray, int n, float zlev);
void  cone3d (float xm, float ym, float zm, float r, 
              float h1, float h2, int nsk1, int nsk2); 
void  confll (float *xray, float *yray, float *zray, int n, 
              int *i1ray, int *i2ray, int *i3ray, int ntri, 
              float *zlev, int nlev);
void  congap (float xfac);
void  conlab (char *clab);
void  conmat (float *zmat, int n, int m, float zlev);
void  conmod (float xfac, float xquot);
void  conn3d (float x, float y, float z);
void  connpt (float x, float y);
void  conpts (float *xray, int n, float *yray, int m, 
              float *zmat, float zlev, float *xpts, float *ypts, 
              int maxpts, int *nray, int maxray, int *nlins);
void  conshd (float *xray, int n, float *yray, int m,
              float *zmat, float *zlev, int nlev);
void  conshd3d (float *xray, int n, float *yray, int m, 
              float *zmat, float *zlev, int nlev);
void  contri (float *xray, float *yray, float *zray, int n, 
              int *i1ray, int *i2ray, int *i3ray, 
              int ntri, float zlev);
void  contur (float *xray, int n, float *yray, int m,
              float *zmat, float zlev);
void  cross  ();
void  crvmat (float *zmat, int n, int m, int ixpts, int iypts);
void  crvqdr (float *xray, float *yray, float *zray, int n); 
void  crvt3d (float *xray, float *yray, float *zray, 
              float *rray, int *icray, int n);
void  crvtri (float *xray, float *yray, float *zray, int n, 
              int *i1ray, int *i2ray, int *i3ray, int ntri);
int   csrkey ();
void  csrlin (int *ix1, int *iy1, int *ix2, int *iy2);
void  csrmod (char *cmod, char *ckey);
int   csrpos (int *ix, int *iy);
void  csrpt1 (int *ix, int *iy);
void  csrpts (int *ix, int *iy, int nmax, int *n, int *iret);
void  csrmov (int *ix, int *iy, int nmax, int *n, int *iret);
void  csrrec (int *ix1, int *iy1, int *ix2, int *iy2);
void  csrtyp (char *copt);
void  csruni (char *copt);
void  curv3d (float *xray, float *yray, float *zray, int n);
void  curv4d (float *xray, float *yray, float *zray, 
              float *wray, int n);
void  curve  (float *xray, float *yray, int n);
void  curve3 (float *xray, float *yray, float *zray, int n);
void  curvmp (float *xray, float *yray, int n);
void  curvx3 (float *xray, float y, float *zray, int n);
void  curvy3 (float x, float *yray, float *zray, int n);
void  cyli3d (float xm, float ym, float zm, float r, float h, 
              int nsk1, int nsk2); 
void  dash   ();
void  dashl  ();
void  dashm  ();
void  dbffin ();
int   dbfini ();
void  dbfmod (char *copt);
void  delglb ();
void  digits (int ndig, char *cax);
void  disalf ();
void  disenv (char *cenv);
void  disfin ();
void  disini ();
void  disk3d (float xm, float ym, float zm, float r1, float r2, 
              int nsk1, int nsk2); 
void  doevnt ();
void  dot    ();
void  dotl   ();
void  duplx  ();
int   dwgbut (char *cstr, int ival);
int   dwgerr ();
char *dwgfil (char *clab, char *cstr, char *cmask);
int   dwglis (char *clab, char *clis, int ilis);
void  dwgmsg (char *cstr);
char *dwgtxt (char *clab, char *cstr);
void  ellips (int nx, int ny, int na, int nb);
void  endgrf ();
void  erase  ();
void  errbar (float *x, float *y, 
              float *err1, float *err2, int n);
void  errdev (char *cdev);
void  errfil (char *cfil);
void  errmod (char *cstr, char *copt);
void  eushft (char *cnat, char *cshf);
void  expimg (char *cfil, char *copt);
void  expzlb (char *cstr);
void  fbars  (float *xray, float *y1ray, float *y2ray, 
              float *y3ray, float *y4ray, int n);
int   fcha   (float x, int ndig, char *cstr);
void  field  (float *xray, float *yray,
              float *uray, float *vray, int n, int ivec);
void  field3d (float *x1ray, float *y1ray, float *z1ray,
               float *x2ray, float *y2ray, float *z2ray,
              int n, int ivec);
void  filbox (int nx, int ny, int nw, int nh);
void  filclr (char *copt);
void  filmod (char *cmod);
void  filopt (char *copt, char *ckey);
int   filsiz (char *cfl, int *nw, int *nh);
int   filtyp (char *cfl);
void  filwin (int nx, int ny, int nw, int nh);
void  fixspc (float xfac);
void  flab3d ();
int   flen   (float x, int ndig);
void  frame  (int nfrm);
void  frmbar (int nfrm);
void  frmclr (int nclr);
void  frmess (int nfrm);
void  gapcrv (float xgap);
void  gapsiz (float gap, char *cax);
void  gaxpar (float a1, float a2, char *copt, char *cax,
              float *a, float *b, float *org, float *stp, int *ndig);
char *getalf ();
int   getang ();
int   getbpp ();
void  getclp (int *nx, int *ny, int *nw, int *nh);
int   getclr ();
void  getdig (int *nxdig, int *nydig, int *nzdig);
char *getdsp ();
char *getfil ();
void  getgrf (float *a, float *e, float *org, float *step, char *cax);
int   gethgt ();
int   gethnm ();
void  getind (int index, float *xr, float *xg, float *xb);
void  getlab (char *cx, char *cy, char *cz);
void  getlen (int *nxl, int *nyl, int *nzl);
int   getlev ();
int   getlin ();
int   getlit (float xp, float yp, float zp,
              float xn, float yn, float zn);
void  getmat (float *xray, float *yray, float *zray, int n,
              float *zmat, int nx, int ny, float zval, int *imat, float *wmat);
char *getmfl ();
char *getmix (char *copt);
void  getor  (int *nx0, int *ny0);
void  getpag (int *nxpag, int *nypag);
long  getpat ();
int   getplv ();
void  getpos (int *nxa, int *nya);
void  getran (int *nca, int *nce);
void  getres (int *npb, int *nph);
void  getrgb (float *xr, float *xg, float *xb);
void  getscl (int *nxscl, int *nyscl, int *nzscl);
void  getscm (int *ix, int *iy, int *iz);
void  getscr (int *nwidth, int *nheight);
char *getshf (char *copt);
void  getsp1 (int *nxdis, int *nydis, int *nzdis);
void  getsp2 (int *nxdis, int *nydis, int *nzdis);
void  getsym (int *nxsym, int *nysym);
void  gettcl (int *nmaj, int *nmin);
void  gettic (int *nxtic, int *nytic, int *nztic);
int   gettyp ();
void *getuni ();
float getver ();
void  getvk  (int *nv, int *nvfx, int *nvfy);
char *getvlt ();
int   getwid ();
void  getwin (int *ix, int *iy, int *nwidth, int *nheight);
int   getxid (char *copt);
void  gifmod (char *cmod, char *ckey);
int   gmxalf (char *copt, char *ca, char *cb);
void  gothic ();
void  grace  (int ngrace);
void  graf   (float xa, float xe, float xorg, float xstp,
              float ya, float ye, float yorg, float ystp);
void  graf3  (float xa, float xe, float xorg, float xstp,
              float ya, float ye, float yorg, float ystp,
              float za, float ze, float zorg, float zstp);
void  graf3d (float xa, float xe, float xorg, float xstp,
              float ya, float ye, float yorg, float ystp,
              float za, float ze, float zorg, float zstp);
void  grafmp (float xa, float xe, float xorg, float xstp,
              float ya, float ye, float yorg, float ystp);
void  grafp  (float xe, float xorg, float xstp, float yorg, float ystp);
void  grdpol (int ixgrid, int iygrid);
void  grffin ();
void  grfini (float x1, float y1, float z1,
              float x2, float y2, float z2, 
              float x3, float y3, float z3);
void  grid   (int ixgrid, int iygrid);
void  grid3d (int ixgrid, int iygrid, char *copt);
void  gridmp (int ixgrid, int iygrid);
int   gwgatt (int id, char *copt);
int   gwgbox (int id);
int   gwgbut (int id);
void  gwgfil (int id, char *cfile);
float gwgflt (int id);
int   gwggui (void);
int   gwgint (int id);
int   gwglis (int id);
float gwgscl (int id);
void  gwgsiz (int id, int *nw, int *nh);
float gwgtbf (int id, int i, int j);
int   gwgtbi (int id, int i, int j);
void  gwgtbl (int id, float *xray, int n, int idx, char *copt);
void  gwgtbs (int id, int i, int j, char *s);
void  gwgtxt (int id, char *ctext);
int   gwgxid (int id);
void  height (int nhchar);
void  helve  ();
void  helves ();
void  helvet ();
void  hidwin (int id, char *copt);
void  histog (float *xray, int n, float *x, float *y, int *m);
void  hname  (int nhchar);
void  hpgmod (char *cmod, char *ckey);
void  hsvrgb (float  xh, float  xs, float  xv, 
              float *xr, float *xg, float *xb);
void  hsym3d (float x);
void  hsymbl (int nhsym);
void  htitle (int nhtit);
void  hwfont ();
void  hwmode (char *copt, char *ckey);
void  hworig (int nx, int ny);
void  hwpage (int nw, int nh);
void  hwscal (float xfac);
void  imgbox (int nx, int ny, int nw, int nh);
void  imgclp (int nx, int ny, int nw, int nh);
void  imgfin ();
void  imgfmt (char *copt);
void  imgini ();
void  imgmod (char *copt);
void  imgsiz (int nw, int nh);
void  imgtpr (int n);
void  inccrv (int ncrv);
int   incdat (int id, int im, int iy);
void  incfil (char *cfil);
void  incmrk (int nmrk);
int   indrgb (float xr, float xg, float xb);
void  intax  ();
int   intcha (int nx, char *cstr);
int   intlen (int nx);
int   intrgb (float xr, float xg, float xb);
int   intutf (int *iray, int n, char *cstr, int nmax);
void  isopts (float *xray, int nx, float *yray, int ny, 
              float *zray, int nz, float *wmat, float wlev,
              float *xtri, float *ytri, float *ztri, int nmax, int *ntri);
void  itmcat (char *clis, char *cstr);
int   itmcnt (char *clis);
void  itmncat (char *clis, int nmax, char *cstr);
char *itmstr (char *clis, int nlis);
void  jusbar (char *copt);
void  labclr (int iclr, char *copt);
void  labdig (int ndig, char *cax);
void  labdis (int ndis, char *cax);
void  labels (char *clab, char *cax);
void  labjus (char *copt, char *cax);
void  labl3d (char *copt);
void  labmod (char *ckey, char *cval, char *cax);
void  labpos (char *cpos, char *cax);
void  labtyp (char *ctyp, char *cax);
int   ldimg  (char *cfil, short *iray, int nmax, int nc);
void  legbgd (int iclr);
void  legclr ();
void  legend (char *cbuf, int ncor);
void  legini (char *cbuf, int nlin, int nmaxln);
void  leglin (char *cbuf, char *cstr, int ilin);
void  legopt (float x1, float x2, float x3);
void  legpat (int ityp, int ithk, int isym, int iclr, long ipat, int ilin);
void  legpos (int nx, int ny);
void  legsel (int *nray, int n);
void  legtit (char *cstr);
void  legtyp (char *copt);
void  legval (float x, char *copt);
void  lfttit ();
void  licmod (char *cmod, char *ckey);
void  licpts (float *xv, float *yv, int nx, int ny, 
              int *itmat, int *iwmat, float *wmat); 
void  light  (char *copt);
void  linclr (int *nray, int n);
void  lincyc (int index, int ityp);
void  line   (int nx, int ny, int nu, int nv);
void  linesp (float xfac);
void  linmod (char *cmod, char *ckey);
void  lintyp (int ntyp);
void  linwid (int i);
void  litmod (int id, char *copt);
void  litop3 (int id, float xr, float xg, float xb, char *copt);
void  litopt (int id, float xval, char *copt);
void  litpos (int id, float x, float y, float z, char *copt);
void  lncap  (char *copt);
void  lnjoin (char *copt);
void  lnmlt  (float x);
void  logtic (char *cmod);
void  mapbas (char *cmod);
void  mapfil (char *cfil, char *copt);
void  mapimg (char *cfil, float x1, float x2, float x3, float x4,
              float x5, float x6);
void  maplab (char *copt, char *ckey);
void  maplev (char *cmod);
void  mapmod (char *cmod);
void  mappol (float xpol, float ypol);
void  mapopt (char *copt, char *ckey);
void  mapref (float ylower, float yupper);
void  mapsph (float xrad);
void  marker (int nsym);
void  matop3 (float xr, float xg, float xb, char *copt);
void  matopt (float xval, char *copt);
void  mdfmat (int nx, int ny, float weight);
void  messag (char *cstr, int nx, int ny);
void  metafl (char *cstr);
void  mixalf ();
void  mixleg ();
void  mpaepl (int i);
void  mplang (float x);
void  mplclr (int nbg, int nfg);
void  mplpos (int nx, int ny);
void  mplsiz (int nsize);
void  mpslogo (int nx, int ny, int nsize, char *copt);
void  mrkclr (int nclr);
void  msgbox (char *cstr);
void  mshclr (int ic);
void  mshcrv (int n);
void  mylab  (char *cstr, int itick, char *cax);
void  myline (int *nray, int n);
void  mypat  (int iang, int itype, int idens, int icross);
void  mysymb (float *xray, float *yray, int n, int isym, 
              int iflag);
void  myvlt  (float *xr, float *xg, float *xb, int n);
void  namdis (int ndis, char *cax);
void  name   (char *cstr, char *cax);
void  namjus (char *copt, char *cax);
void  nancrv (char *copt);
void  neglog (float eps);
void  newmix ();
void  newpag ();
int   nlmess (char *cstr);
int   nlnumb (float x, int ndig);
void  noarln ();
void  nobar  ();
void  nobgd  ();
void  nochek ();
void  noclip ();
void  nofill ();
void  nograf ();
void  nohide ();
void  noline (char *cax);
void  number (float x, int ndig, int nx, int ny);
void  numfmt (char *copt);
void  numode (char *cdec, char *cgrp, 
              char *cpos, char *cfix);
int   nwkday (int id, int im, int iy);
int   nxlegn (char *cbuf);
int   nxpixl (int ix, int iy);
int   nxposn (float x);
int   nylegn (char *cbuf);
int   nypixl (int ix, int iy);
int   nyposn (float y);
int   nzposn (float z);
int   openfl (char *cfil, int nu, int irw); 
void  opnwin (int id);
void  origin (int nx0, int ny0);
void  page   (int nw, int nh);
void  pagera ();
void  pagfll (int nclr);
void  paghdr (char *cstr1, char *cstr2, int iopt, int idir);
void  pagmod (char *cmod);
void  pagorg (char *cpos);
void  pagwin (int nw, int nh);
void  patcyc (int index, long ipat);
int   pdfbuf (char *cbuf, int nmax);
void  pdfmod (char *cmod, char *ckey);
void  pdfmrk (char *cstr, char *copt);
void  penwid (float x);
void  pie    (int nxm, int nym, int nr, float a, float b);
void  piebor (int iclr);
void  piecbk (void (*callbck) (int iseg, float xdat, float xper, int *nrad,
              int *noff, float *angle, int *nvx, int *nvy, int *idrw, 
              int *iann));
void  pieclr (int *ic1, int *ic2, int n);
void  pieexp ();
void  piegrf (char *cbuf, int nlin, float *xray, int nseg);
void  pielab (char *clab, char *cpos);
void  pieopt (float xf, float a);
void  pierot (float angle);
void  pietyp (char *ctyp);
void  pieval (float x, char *copt);
void  pievec (int ivec, char *copt);
void  pike3d (float x1, float y1, float z1, 
              float x2, float y2, float z2, float r, int nsk1, int nsk2); 
void  plat3d (float xm, float ym, float zm, float xl, char *copt); 
void  plyfin (char *cfl, char *cobj);
void  plyini (char *copt);
void  pngmod (char *cmod, char *ckey);
void  point  (int nx, int ny, int nb, int nh, int ncol);
void  polar  (float xe, float xorg, float xstp, float yorg, float ystp);
int   polclp (float *xray, float *yray, int n, 
              float *xout, float *yout, int nmax, float xv, 
              char *cedge);
void  polcrv (char *cpol);
void  polmod (char *cpos, char *cdir);
void  pos2pt (float x, float y, float *xp, float *yp);
void  pos3pt (float x, float y, float z, float *xp, float *yp, float *zp);
void  posbar (char *copt);
int   posifl (int nu, int nbyte); 
void  proj3d (char *copt);
void  projct (char *cproj);
void  psfont (char *cfont);
void  psmode (char *cmod);
void  pt2pos (float x, float y, float *xp, float *yp);
void  pyra3d (float xm, float ym, float zm, float xl, 
              float h1, float h2, int n); 
void  qplbar (float *yray, int n);
void  qplclr (float *zmat, int n, int m);
void  qplcrv (float *xray, float *yray, int n, char *copt);
void  qplcon (float *zmat, int n, int m, int nlv);
void  qplot  (float *xray, float *yray, int n);
void  qplpie (float *xray, int n);
void  qplsca (float *xray, float *yray, int n);
void  qplscl (float a, float e, float org, float stp, char *copt);
void  qplsur (float *zmat, int n, int m);
void  quad3d (float xm, float ym, float zm, float xl, float yl, float zl);
int   rbfpng (char *cbuf, int nmax);
void  rbmp   (char *cfil);
int   readfl (int nu, char *cbuf, int nbyte); 
void  reawgt ();
void  recfll (int nx, int ny, int nw, int nh, int ncol);
void  rectan (int nx, int ny, int nw, int nh);
void  rel3pt (float x, float y, float z, float *xp, float *yp);
void  resatt ();
void  reset  (char *cname);
void  revscr ();
void  rgbhsv (float xr, float xg, float xb, float *xh, float *xs, float *xv);
void  rgif   (char *cfil);
void  rgtlab ();
void  rimage (char *cfil);
void  rlarc  (float xm, float ym, float xa, float xb,
              float a,  float b,  float t);
void  rlarea (float *xray, float *yray, int n);
void  rlcirc (float xm, float ym, float r);
void  rlconn (float x, float y);
void  rlell  (float xm, float ym, float a, float b);
void  rline  (float x, float y, float u, float v);
void  rlmess (char *cstr, float x, float y);
void  rlnumb (float x, int ndig, float xp, float yp);
void  rlpie  (float xm, float ym, float r, float a, float b);
void  rlpoin (float x, float y, int nb, int nh, int ncol);
void  rlrec  (float x, float y, float xw, float xh);
void  rlrnd  (float x, float y, float xb, float xh, int irnd);
void  rlsec  (float xm, float ym, float r1, float r2,
              float a,  float b,  int ncol);
void  rlstrt (float x, float y);
void  rlsymb (int nsym, float x, float y);
void  rlvec  (float x1, float y1, float x2, float y2, int ivec);
void  rlwind (float xk, float x, float y, int nwidth, float a);
void  rndrec (int nx, int ny, int nb, int nh, int irnd);
void  rot3d  (float xa, float ya, float za); 
void  rpixel (int ix, int iy, int *iclr);
void  rpixls (char *iray, int ix, int iy, int nw, int nh);
void  rpng   (char *cfil);
void  rppm   (char *cfil);
void  rpxrow (char *iray, int ix, int iy, int n);
void  rtiff  (char *cfil);
void  rvynam ();
void  scale  (char *cscl, char *cax);
void  sclfac (float xfac);
void  sclmod (char *cmode);
void  scrmod (char *cmode);
void  sector (int nx, int ny, int nr1, int nr2, float a, float b, int ncol);
void  selwin (int id);
void  sendbf ();
void  sendmb ();
void  sendok ();
void  serif  ();
void  setbas (float xfac);
void  setcbk (void (*callbck) (float *x, float *y), char *copt);
void  setclr (int ncol);
void  setcsr (char *copt);
void  setexp (float fexp);
void  setfce (char *copt);
void  setfil (char *cfil);
void  setgrf (char *c1, char *c2, char *c3, char *c4);
void  setind (int index, float xr, float xg, float xb);
void  setmix (char *cstr, char *cmix);
void  setpag (char *cpag);
void  setres (int npb, int nph);
void  setrgb (float xr, float xg, float xb);
void  setscl (float *xray, int n, char *cax);
void  setvlt (char *cvlt);
void  setxid (int id, char *copt);
void  shdafr (int *inray, long *ipray, int *icray, int n);
void  shdasi (int *inray, long *ipray, int *icray, int n);
void  shdaus (int *inray, long *ipray, int *icray, int n);
void  shdcha ();
void  shdcrv (float *x1ray, float *y1ray, int n1,
              float *x2ray, float *y2ray, int n2);
void  shdeur (int *inray, long *ipray, int *icray, int n);
void  shdfac (float xfac);
void  shdmap (char *cmap);
void  shdmod (char *copt, char *ctyp);
void  shdnor (int *inray, long *ipray, int *icray, int n);
void  shdpat (long ipat);
void  shdsou (int *inray, long *ipray, int *icray, int n);
void  shdusa (int *inray, long *ipray, int *icray, int n);
void  shield (char *carea, char *cmode);
void  shlcir (int nx, int ny, int nr);
void  shldel (int id);
void  shlell (int nx, int ny, int na, int nb, float t);
int   shlind ();
void  shlpie (int nx, int ny, int nr, float a, float b);
void  shlpol (int *nxray, int *nyray, int n);
void  shlrct (int nx, int ny, int nw, int nh, float t);
void  shlrec (int nx, int ny, int nw, int nh);
void  shlres (int n);
void  shlsur ();
void  shlvis (int id, char *cmode);
void  simplx ();
int   skipfl (int nu, int nbyte); 
void  smxalf (char *calph, char *c1, char *c2, int n);
void  solid  ();
void  sortr1 (float *xray, int n, char *copt);
void  sortr2 (float *xray, float *yray, int n, char *copt);
void  spcbar (int n);
void  sphe3d (float xm, float ym, float zm, float r, int n, int m);
void  spline (float *xray, float *yray,  int n,
              float *xsray, float *ysray, int *nspl);
void  splmod (int ngrad, int npts);
void  stmmod (char *cmod, char *ckey);
void  stmopt (int n, char *copt);
void  stmpts (float *xmat, float *ymat, int nx, int ny, 
              float *xp, float *yp, float x0, float y0, 
              float *xray, float *yray, int nmax, int *nray);
void  stmpts3d (float *xv, float *yv, float *zv,
	      int nx, int ny, int nz, float *xp, float *yp, 
	      float *zp, float x0, float y0, float z0, 
              float *xray, float *yray, float *zray, int nmax, int *nray);
void  stmtri (float *xv, float *yv, float *xp, 
              float *yp, int n, int *i1ray, int *i2ray, 
              int *i3ray, int ntri, float *xs, 
              float *ys, int nray);
void  stmval (float x, char *copt);
void  stream (float *xmat, float *ymat, int nx, int ny, 
              float *xp, float *yp, 
              float *xs, float *ys, int n);
void  stream3d (float *xv, float *yv, float *zv,
	      int nx, int ny, int nz, float *xp, float *yp, 
              float *zp, float *xs, float *ys, 
              float *zs, int n);
void  strt3d (float x, float y, float z);
void  strtpt (float x, float y);
void  surclr (int ictop, int icbot);
void  surfce (float *xray, int n, float *yray, int m, 
              float *zmat);
void  surfcp (float (*zfun)(float x, float y, int i), 
                         float a1, float a2, float astp,
                         float b1, float b2, float bstp);
void  surfun (float (*zfun)(float x, float y), int ixpts, float xdel, 
                     int iypts, float ydel);
void  suriso (float *xray, int nx, float *yray, int ny, 
              float *zray, int nz, float *wmat, float wlev);
void  surmat (float *zmat, int nx, int ny, int ixpts, int iypts);
void  surmsh (char *copt);
void  suropt (char *copt);
void  surshc (float *xray, int n, float *yray, int m, 
              float *zmat, float *wmat);
void  surshd (float *xray, int n, float *yray, int m, 
              float *zmat);
void  sursze (float xmin, float xmax, float ymin, float ymax);
void  surtri (float *xray, float *yray, float *zray, int n, 
              int *i1ray, int *i2ray, int *i3ray, int ntri);
void  survis (char *cvis);
void  swapi2 (short *iray, int n);
void  swapi4 (int *iray, int n);
void  swgatt (int id, char *cval, char *copt);
void  swgbgd (int id, float xr, float xg, float xb);
void  swgbox (int ip, int ival);
void  swgbut (int ip, int ival);
void  swgcb  (int id, void (*callbck) (int i, int *ir), int *iray);
void  swgcb2 (int id, void (*callbck) (int id, int irow, int icol));
void  swgcb3 (int id, void (*callbck) (int id, int ival));
void  swgcbk (int id, void (*callbck) (int i));
void  swgclr (float xr, float xg, float xb, char *copt);
void  swgdrw (float x);
void  swgfgd (int id, float xr, float xg, float xb);
void  swgfil (int ip, char *cval);
void  swgflt (int ip, float xv, int ndig);
void  swgfnt (char *cfnt, int n);
void  swgfoc (int id);
void  swghlp (char *cstr);
void  swgint (int ip, int iv);
void  swgiop (int n, char *copt);
void  swgjus (char *ctyp, char *cwidg);
void  swglis (int ip, int ival);
void  swgmix (char *c, char *cstr);
void  swgmrg (int ival, char *cstr);
void  swgoff (int nx, int ny);
void  swgopt (char *cval, char *copt);
void  swgpop (char *copt);
void  swgpos (int nx, int ny);
void  swgray (float *xray, int nray, char *copt);
void  swgscl (int ip, float xval);
void  swgsiz (int nx, int ny);
void  swgspc (float xw, float xh);
void  swgstp (float step);
void  swgtbf (int id, float xval, int ndig, int irow, int icol, 
              char *copt);
void  swgtbi (int id, int ival, int irow, int icol, char *copt);
void  swgtbl (int id, float *xray, int nray, int ndig, int idx, 
              char *copt);
void  swgtbs (int id, char *cstr, int irow, int icol, char *copt);
void  swgtit (char *ctit);
void  swgtxt (int ip, char *cval);
void  swgtyp (char *ctyp, char *cwidg);
void  swgval (int ip, float xval);
void  swgwin (int nx, int ny, int nw, int nh);
void  swgwth (int nchar);
void  symb3d (int n, float xm, float ym, float zm); 
void  symbol (int nsym, int nx, int ny);
void  symfil (char *cdev, char *cstat);
void  symrot (float angle);
int   tellfl (int nu); 
void  texmod (char *copt);
void  texopt (char *copt, char *ctyp);
void  texval (float x, char *copt);
void  thkc3d (float x);
void  thkcrv (int nthk);
void  thrfin ();
void  thrini (int n);
void  ticks  (int itick, char *cax);
void  ticlen (int nmaj, int nmin);
void  ticmod (char *copt, char *cax);
void  ticpos (char *cpos, char *cax);
void  tifmod (int n, char *cval, char *copt);
void  tiforg (int nx, int ny);
void  tifwin (int nx, int ny, int nw, int nh);
void  timopt ();
void  titjus (char *copt);
void  title  ();
void  titlin (char *cstr, int n);
void  titpos (char *copt);
void  torus3d (float xm, float ym, float zm, float r1, float r2, float h,
              float a1, float a2, int n, int m);
void  tprfin ();
void  tprini ();
void  tprmod (char *cmod, char *ckey);
void  tprval (float x);
void  tr3axs (float x, float y, float z, float a);
void  tr3res ();
void  tr3rot (float a, float b, float c);
void  tr3scl (float x, float y, float z);
void  tr3shf (float x, float y, float z);
void  trfco1 (float *xray, int n, char *cfrom, char *cto); 
void  trfco2 (float *xray, float *yray, int n, 
              char *cfrom, char *cto); 
void  trfco3 (float *xray, float *yray, float *zray, int n, 
              char *cfrom, char *cto);
void  trfdat (int ndays, int *id, int *im, int *iy); 
void  trfmat (float *zmat, int nx, int ny, 
              float *zmat2, int nx2, int ny2);
void  trfrel (float *xray, float *yray, int n);
void  trfres ();
void  trfrot (float xang, int nx, int ny);
void  trfscl (float xscl, float yscl);
void  trfshf (int nx, int ny);
void  tria3d (float *xtri, float *ytri, float *ztri);
int   triang (float *xray, float *yray, int n, 
              int *i1ray, int *i2ray, int *i3ray, int nmax); 
void  triflc (float *xray, float *yray, int *iray, int n);
void  trifll (float *xray, float *yray);
void  triplx ();
void  tripts (float *xray, float *yray, float *zray, int n, 
              int *i1ray, int *i2ray, int *i3ray, int ntri,
              float zlev, float *xpts, float *ypts, int maxpts, 
              int *nptray, int maxray, int *nlins);
int   trmlen (char *cstr);
void  ttfont (char *cfnt);
void  tube3d (float x1, float y1, float z1, 
              float x2, float y2, float z2, float r, int nsk1, int nsk2); 
void  txtbgd (int n);
void  txtjus (char *copt);
void  txture (int *itmat, int nx, int ny); 
void  unit   (void *fp);
void  units  (char *copt);
void  upstr  (char *cstr);
int   utfint (char *cstr, int *iray, int n);
void  vang3d (float a);
void  vclp3d (float x1, float x2);
void  vecclr (int iclr);
void  vecf3d (float *xv, float *yv, float *zv, 
              float *xp, float *yp, float *zp,
              int n, int ivec);
void  vecfld (float *xv, float *yv, 
              float *xp, float *yp, int n, int ivec);
void  vecmat (float *xmat, float *ymat, int nx, int ny, 
              float *xp, float *yp, int ivec); 
void  vecmat3d (float *xv, float *yv, float *zv, 
		int nx, int ny, int nz, float *xp, float *yp,
                float *zp, int ivec); 
void  vecopt (float x, char *copt);
void  vector (int nx1, int ny1, int nx2, int ny2, int ivec);
void  vectr3 (float x1, float y1, float z1,
              float x2, float y2, float z2, int ivec);
void  vfoc3d (float x, float y, float z, char *cview);
void  view3d (float xvu, float yvu, float zvu, char *cvu);
void  vkxbar (int nvfx);
void  vkybar (int nvfy);
void  vkytit (int nvfy);
void  vltfil (char *cfl, char *copt);
void  vscl3d (float x);
void  vtx3d  (float *xray, float *yray, float *zray,
              int n, char *copt);
void  vtxc3d (float *xray, float *yray, float *zray,
              int *ic, int n, char *copt);
void  vtxn3d (float *xray, float *yray, float *zray, 
              float *xn, float *yn, float *zn, 
              int n, char *copt);
void  vup3d  (float a);
int   wgapp  (int ip, char *clab);
int   wgappb (int ip, char *iray, int nw, int nh);
int   wgbas  (int ip, char *ctyp);
int   wgbox  (int ip, char *cstr, int isel);
int   wgbut  (int ip, char *cstr, int ival);
int   wgcmd  (int ip, char *clab, char *cmd);
int   wgdlis (int ip, char *cstr, int isel);
int   wgdraw (int ip);
int   wgfil  (int ip, char *clab, char *cstr, char *cmask);
void  wgfin  ();
int   wgicon (int ip, char *clab, int nw, int nh, char *cfl);
int   wgimg  (int ip, char *clab, char *iray, 
              int nw, int nh);
int   wgini  (char *ctyp);
int   wglab  (int ip, char *cstr);
int   wglis  (int ip, char *cstr, int isel);
int   wgltxt (int ip, char *clab, char *ctext, int iper);
int   wgok   (int ip);
int   wgpbar (int ip, float x1, float x2, float xstp);
int   wgpbut (int ip, char *clab);
int   wgpicon (int ip, char *clab, int nw, int nh, char *cfl);
int   wgpimg (int ip, char *clab, char *iray, 
              int nw, int nh);
int   wgpop  (int ip, char *clab);
int   wgpopb (int ip, char *iray, int nw, int nh);
int   wgquit (int ip);
int   wgscl  (int ip, char *cstr, float x1, float x2, float xval, 
              int ndez);
int   wgsep  (int ip);
int   wgstxt (int ip, int nsize, int nmax);
int   wgtbl (int ip, int nrows, int ncols);
int   wgtxt  (int ip, char *cstr);
void  widbar (int nzb);
void  wimage (char *cfil);  
void  winapp (char *copt);  
void  wincbk (void (*callbck) (int id, int nx, int ny, int nw, int nh),
              char *copt);
void  windbr (float xk, int nx, int ny, int nwidth, float a);
void  window (int nx, int ny, int nw, int nh);
void  winfin (int iopt);
void  winfnt (char *cfont);
void  winico (char *copt);
int   winid  ();
void  winjus (char *copt);
void  winkey (char *copt);
void  winmod (char *copt);
void  winopt (int iopt, char *copt);
void  winsiz (int nw, int nh);
void  wintit (char *cstr);
void  wintyp (char *copt);
void  wmfmod (char *cmod, char *ckey);
void  world  ();
void  wpixel (int ix, int iy, int iclr);
void  wpixls (char *iray, int ix, int iy, int nw, int nh);
void  wpxrow (char *iray, int ix, int iy, int n);
int   writfl (int nu, char *cbuf, int nbyte); 
void  wtiff  (char *cfil);
void  x11fnt (char *cfont, char *copt);
void  x11mod (char *copt);
float x2dpos (float x, float y);
float x3dabs (float x, float y, float z);
float x3dpos (float x, float y, float z);
float x3drel (float x, float y, float z);
void  xaxgit ();
void  xaxis  (float xa, float xe, float xorg, float xstp, 
              int nl, char *cstr, int it, int nx, int ny);
void  xaxlg  (float xa, float xe, float xorg, float xstp,
              int nl, char *cstr, int it, int nx, int ny);
void  xaxmap (float xa, float xe, float xorg, float xstp,
              char *cstr, int it, int ny);
void  xcross ();
void  xdraw  (float x, float y);
float xinvrs (int n);
void  xmove  (float x, float y);
float xposn  (float x);
float y2dpos (float x, float y);
float y3dabs (float x, float y, float z);
float y3dpos (float x, float y, float z);
float y3drel (float x, float y, float z);
void  yaxgit ();
void  yaxis  (float ya, float ye, float yor, float ystp, 
              int nl, char *cstr, int it, int nx, int ny);
void  yaxlg  (float ya, float ye, float yor, float ystp,
              int nl, char *cstr, int it, int nx, int ny);
void  yaxmap (float ya, float ye, float yor, float ystp,
              char *cstr, int it, int ny);
void  ycross ();
float yinvrs (int n);
float yposn  (float y);
float z3dpos (float x, float y, float z);
void  zaxis  (float za, float ze, float zor, float zstp, 
              int nl, char *cstr, int it, int id, int nx, int ny);
void  zaxlg  (float za, float ze, float zor, float zstp, 
              int nl, char *cstr, int it, int id, int nx, int ny);
void  zbfers ();
void  zbffin ();
int   zbfini ();
void  zbflin (float x1, float y1, float z1, float x2, float y2, float z2);
void  zbfmod (char *copt);
void  zbfres ();
void  zbfscl (float x);
void  zbftri (float *x, float *y, float *z, int *ic);
void  zscale (float za, float ze);
  }
