import std.math;
import Dislin;

void main (string[] args)
{ int i, j, n = 50;
  float [50][50] zmat;
  float [50] xray, yray;
  float zlev;
  double step, fpi, x, y;

  step = 360.f / (n-1);
  fpi = 3.1415926/180;

  for (i = 0; i < n; i++)
  { xray[i] = i * step;
    yray[i] = i * step;
  }

  for (i = 0; i < n; i++)
  { x = xray[i] * fpi;
    for (j = 0; j < n; j++)
    { y = yray[j] * fpi;
      zmat[i][j] = 2 * sin (x) * sin (y);
    }
  }
    
  setpag ("da4p");
  metafl ("cons");
  disini ();
  hwfont ();
  pagera ();

  titlin ("Contour Plot", 1);
  titlin ("F(X,Y) = 2 * SIN(X) * SIN(Y)", 3);

  name ("X-axis", "x");
  name ("Y-axis", "y");

  intax ();
  axspos (450, 2670);
  graf (0.f, 360.f, 0.f, 90.f, 0.f, 360.f, 0.f, 90.f);

  height (30);
  for (i = 0; i < 9; i++)
  { zlev = -2. + i * 0.5;
    setclr ((i+1) * 25);
    if (i == 4)
      labels ("none", "contur"); 
    else
      labels ("float", "contur");

    contur (cast (float *) xray, n, cast (float *) yray, n, 
            cast (float *) zmat, zlev);
  }

  height(50);
  color("fore");
  title();
  disfin ();
}
