source ("dislin.R")

myfunc <- function (x, y, iopt)
{
  if (iopt == 1)
    xv <- cos (x) * (3 + cos (y))
  else if (iopt == 2)
    xv <- sin (x) * (3 + cos (y))
  else
    xv <- sin (y)
  return (xv)
}
 
pi  <- 3.1415927

Dislin.scrmod ("revers")
Dislin.metafl ("cons")
Dislin.setpag ("da4p")
Dislin.disini ()
Dislin.pagera ()
Dislin.complx ()

Dislin.titlin ("Surface Plot of the Parametric Function", 2)
Dislin.titlin ("[COS(t)*(3+COS(u)), SIN(t)*(3+COS(u)), SIN(u)]", 4)

Dislin.axspos (200, 2400)
Dislin.axslen (1800, 1800)

Dislin.name   ("X-axis", "X")
Dislin.name   ("Y-axis", "Y")
Dislin.name   ("Z-axis", "Z")
Dislin.intax  ()

Dislin.vkytit (-300)
Dislin.zscale (-1.0, 1.0)
Dislin.surmsh ("on")

Dislin.graf3d (-4.0 ,4.0, -4.0, 1.0, -4.0, 4.0, -4.0, 1.0, 
               -3.0, 3.0, -3.0, 1.0)
Dislin.height (40)
Dislin.title  ()

stp <- 2 * pi / 30.0
pi2 <- 2 * pi

Dislin.surfcp (myfunc, 0.0, pi2, stp, 0.0, pi2, stp)
Dislin.disfin ()



